/*
 * convergence_test.cpp
 *
 *  Created on: Dec 2, 2011
 *      Author: Tony
 */

// My Include
#include "convergence_test.h"

// Includes
#include <stdio.h>
#include <iostream>
#include <fstream>
#include <math.h>
#include "../algorithm/coalescence_algorithm.h"
#include "../dmo/admixture_model.h"
#include "../dmo/genealogy.h"
#include "../dmo/partition.h"
#include "../utilities/entropy_utilities.h"


//------------------------------------------------------------------
// Constructors

convergence_test::convergence_test() {
	// TODO Auto-generated constructor stub

}

convergence_test::~convergence_test() {
	// TODO Auto-generated destructor stub
}


//------------------------------------------------------------------
// Methods

void convergence_test::test_convergence(std::ofstream& output) {

	std::vector<int> pop_assign(300);
	for (int i = 0; i < 300; ++i) {
		if (i < 100) {
			pop_assign[i] = 0;
		} else if (i < 200) {
			pop_assign[i] = 1;
		} else {
			pop_assign[i] = 2;
		}
	}

	coalescence_algorithm coalescence(pop_assign, 3);

	admixture_parameters parameters;
	event ev1(0.1, 0.6, 0, 2, 1);
	event ev2(0.5, 1.0, 0, -1, 2);

	parameters.setTheta(8.0);
	parameters.addEvent(ev1);
	parameters.addEvent(ev2);

	std::vector<double> total(4);

	for (int i = 0; i < 10000; ++i) {
		std::vector<double> lambda(estimate_lambda(&coalescence, &parameters));
		printf("[%d] ", i);
		for (int j = 0; j < (int)lambda.size(); ++j) {
			total[j] += lambda[j];
			printf("%.2f ", lambda[j]);
			output << lambda[j];
		}
		output << std::endl;
		printf("average: ");
		for (int j = 0; j < (int)total.size(); ++j) {
			printf("%.2f ", total[j]/(double)(i+1));
		}

		printf("\n");
	}
}


// Enumerate through the genealogy and computes the weights for each
// model bipartitions
const std::vector<double> convergence_test::estimate_lambda(coalescence_algorithm* pCoalescence, admixture_parameters* pParams) {



	std::vector<double> weights_total(4, 0.0);

	int k = 3;
	int m = 300;
	int numGenealogies = 30;
	double penalty = log2(5);
	std::vector<partition*> models(3);
	std::vector<bool> bool1(300);
	std::vector<bool> bool2(300);
	std::vector<bool> bool3(300);
	for (int i = 0; i < 300; ++i) {
		if (i < 100) {
			bool1[i] = 1;
			bool2[i] = 0;
			bool3[i] = 0;
		} else if (i < 200) {
			bool1[i] = 0;
			bool2[i] = 1;
			bool3[i] = 0;
		} else {
			bool1[i] = 0;
			bool2[i] = 0;
			bool3[i] = 1;
		}
	}
	partition p1(bool1);
	partition p2(bool2);
	partition p3(bool3);
	models[0] = &p1;
	models[1] = &p2;
	models[2] = &p3;

	fflush(stdout);
	for (int i = 0; i < 30; ++i) {
		genealogy* pGenealogy = pCoalescence->generate_genalogy_fixed(pParams);

		// Assumes that the last branch is a root that we do not care about
		for (int i = 0; i < (pGenealogy->getBranchSize()-1); ++i) {
			genealogy_branch* pBranch = pGenealogy->getBranch(i);
			double bestScore = m*compute_entropy(pBranch->getPartition());
			double bestModelIdx = 3;

			for (int j = 0; j < (int)3; ++j) {
				double score = m*compute_conditional_entropy(pBranch->getPartition(), models[j]) + penalty;
				if (score < bestScore) {
					bestScore = score;
					bestModelIdx = j;
				}
			}
			double t = pBranch->getEndTime() - pBranch->getStartTime();
			if (t <= 0) {
				printf("%d %d (%f-%f) has negative or zero time\n", i, pBranch->getUID(), pBranch->getEndTime(), pBranch->getStartTime());
				fflush(stdout);
			}
			weights_total[bestModelIdx] += t;
		}

		delete pGenealogy;

//		for (int i = 0; i < (int)weights_total.size(); ++i) {
//			printf("%f ", weights_total[i]);
//		}
//		printf("\n");
	}

	std::vector<double> lambdas(k+1, 0.0);
	for (int i = 0; i < (int)weights_total.size(); ++i) {
		lambdas[i] = (weights_total[i] / (double)numGenealogies) * pParams->getTheta();
	}
	return lambdas;
}
