/*
 * model_construction_algorithm.h
 *
 *  Created on: Jan 23, 2012
 */

#ifndef MODEL_CONSTRUCTION_ALGORITHM_H_
#define MODEL_CONSTRUCTION_ALGORITHM_H_

#include <vector>

// Forward Declarations
class admixture_model;
class consensus_algorithm;
class masked_model_partition_set;

class model_construction_algorithm {
private:
	//------------------------------------------------------------------------------------
	// Members
	std::vector<masked_model_partition_set*> model_sets;

	int k;
	std::vector<int> popassign;

public:
	//------------------------------------------------------------------------------------
	// Constructors
	model_construction_algorithm(const std::vector<masked_model_partition_set*>& model_sets);
	model_construction_algorithm(const std::vector<masked_model_partition_set*>& model_sets, int k, std::vector<int> popassign);
	virtual ~model_construction_algorithm();

public:
	//------------------------------------------------------------------------------------
	// Methods

	// Return an admixture model by using the standard approach described in our paper and generate
	// model partition and associated weight with partial population masked
	admixture_model* simple_admixture_model(consensus_algorithm* pConsensus = NULL);
};

#endif /* MODEL_CONSTRUCTION_ALGORITHM_H_ */
