/*
 * model_construction_algorithm.cpp
 *
 */

// Standard Include
#include "../cleax.h"

// My Include
#include "model_construction_algorithm.h"

// Includes
#include <algorithm>
#include <stdio.h>
#include "../algorithm/consensus_algorithm.h"
#include "../dmo/admixture_model.h"
#include "../dmo/partition.h"
#include "../utilities/set_utilities.h"



//------------------------------------------------------------------------------------
// Constructors
model_construction_algorithm::model_construction_algorithm(const std::vector<masked_model_partition_set*>& model_sets) :
	model_sets(model_sets),
	k(-1)
{
}

model_construction_algorithm::model_construction_algorithm(const std::vector<masked_model_partition_set*>& model_sets, int k, std::vector<int> popassign) :
	model_sets(model_sets),
	k(k),
	popassign(popassign)
{
}

model_construction_algorithm::~model_construction_algorithm() {
}

//------------------------------------------------------------------------------------
// Methods

// Return an admixture model by using the standard approach described in our paper and generate
// model partition and associated weight with partial population masked
admixture_model* model_construction_algorithm::simple_admixture_model(consensus_algorithm* pConsensus) {

	std::vector<int> pop_assign;
	std::vector<int> pops;
	std::vector<admixture_model_event*> model_events;

	if (k < 0) {
		// Identify the set with no mask
		masked_model_partition_set* pSet = NULL;
		for (int i = 0; i < (int)model_sets.size(); ++i) {
			if (model_sets[i]->getMask().size() == 0) {
				pSet = model_sets[i];
				break;
			}
		}

		// Sort partition base on weights
		pSet->sort();

		// Get number of individuals in the dataset
		int m = pSet->getPartition(0)->size();


		// Once sorted, perform split operation from the complete set
		std::vector<std::vector<bool> > membership;
		membership.push_back(std::vector<bool>(m, 1));
		for (int i = 0; i < (int)pSet->size(); ++i) {
			partition* pPart = pSet->getPartition(i);
			bool doubleSplit = 0; // Indicator that tells us whether this split will split more than one set
			int splitPop = -1; // Indicator that tells us whether we are going to split or not
			for (int j = 0; j < (int)membership.size(); ++j) {
				int states = -1;
				for (int k = 0; k < m; ++k) {
					if (membership[j][k]) {
						if (states >= 0) {
							if (states != pPart->get(k)) {
								if (splitPop >= 0) {
									doubleSplit = 1;
								} else {
									splitPop = j;
								}
								break;
							}
						} else {
							states = pPart->get(k) ? 1 : 0;
						}
					}
				}
			}


			// If there are no double split, then we can proceed to subdivide the individuals
			// into subclusters
			if (!doubleSplit && splitPop >= 0) {
	//
	//			// Population candidates
	//			std::vector<int> pop1_candidates;
	//			std::vector<int> pop2_candidates;
	//			pop1_candidates.push_back(membership.size());
	//			pop1_candidates.push_back(splitPop);
	//			//if (membership.size() == 1) {
	//				pop2_candidates.push_back(-1);
	//			//}
	//			for (int j = 0; j < (int)membership.size(); ++j) {
	//				if (j != splitPop) {
	//					pop2_candidates.push_back(j);
	//				}
	//			}
	//
	//			// Add new model event
	//			admixture_model_event* pModelEvent = new admixture_model_event();
	//			if ((int)membership.size() == 1) {
	//				pModelEvent->p1_candidates.push_back(pop1_candidates[0]);
	//				pModelEvent->pa_candidates.push_back(pop1_candidates[1]);
	//			} else {
	//				pModelEvent->p1_candidates = pop1_candidates;
	//				pModelEvent->pa_candidates = pop1_candidates;
	//			}
	//			pModelEvent->p2_candidates = pop2_candidates;
	//			model_events.push_back(pModelEvent);

				// Identify individuals that belongs to the new population
				int states = -1;
				std::vector<bool> membervec(m, 0);
				for (int j = 0; j < m; ++j) {
					if (membership[splitPop][j]) {
						if (states >= 0) {
							if (pPart->get(j) != (bool)states) {
								membership[splitPop][j] = 0;
								membervec[j] = 1;
							}
						} else {
							states = pPart->get(j) ? 1 : 0;
						}
					}
				}
				membership.push_back(membervec);
			}

		}

		pops = std::vector<int>((int)membership.size(), 0);
		pop_assign = std::vector<int>(m, 0);
		for (int i = 1; i < (int)membership.size(); ++i) {
			pops[i] = i;
			for (int j = 0; j < m; ++j) {
				if (membership[i][j]) {
					pop_assign[j] = i;
				}
			}
		}
	} else {
		pops = std::vector<int>(k, 0);
		for (int i = 1; i < (int)k; ++i) {
			pops[i] = i;
		}
		pop_assign = this->popassign;
	}

	// Add into all possible model
	for (int i = 0; i < (int)pops.size()-1; ++i) {
		admixture_model_event* pModelEvent = new admixture_model_event();

		pModelEvent->p1_candidates = pops;
		pModelEvent->pa_candidates = pops;

		if (i == 0) {
			pModelEvent->p2_candidates.push_back(-1);
		} else {
			pModelEvent->p2_candidates = pops;
			pModelEvent->p2_candidates.push_back(-1);
		}
		model_events.push_back(pModelEvent);
	}

//	if (pConsensus != NULL) {
//		std::vector<std::vector<int> > pops(popid+1);
//		for (int i = 0; i <= popid; ++i) {
//			pops[i] = std::vector<int>();
//		}
//
//		for (int i = 0; i < (int)pop_assign.size(); ++i) {
//			pops[pop_assign[i]].push_back(i);
//		}
//
//		for (int i = 0; i <= popid; ++i) {
//			std::vector<bool> mask(m, 1);
//			for (int j = 0; j < (int)pops[i].size(); ++j) {
//				mask[pops[i][j]] = 0;
//			}
//			masked_model_partition_set* pSubSet = pConsensus->getModelPartitionSet(mask, 1);
//			this->model_sets.push_back(pSubSet);
//
//		}
//	}

	// Reconstruct model

	std::vector<int> prev_p1;
	std::vector<int> prev_pa;
	admixture_model* pModel = new admixture_model((int)pops.size(), pop_assign, this->model_sets);
	for (int i = (int)model_events.size()-1; i >= 0; --i) {
		prev_p1 = set_union(prev_p1, model_events[i]->p1_candidates);
		prev_pa = set_union(prev_pa, model_events[i]->pa_candidates);
		model_events[i]->p1_candidates = prev_p1;
		model_events[i]->pa_candidates = prev_pa;
		pModel->addModelEvent(model_events[i]);
	}

	return pModel;
}

