/*
 * consensus_algorithm.h
 *
 *  Created on: Aug 30, 2011
 *      Author: Tony
 */

#ifndef CONSENSUS_ALGORITHM_H_
#define CONSENSUS_ALGORITHM_H_

#include <vector>
#include <stdio.h>

// Forward declarations
class partition;
class masked_model_partition_set;

// Struct
typedef struct Score {

	// Members
	//std::vector<partition*> models; // Model partitions
	std::vector<std::vector<double> > entropies; // Entropy for each observed partition given model bipartition
	std::vector<int> assignments;
	double score;

	// Constructors
	Score() { };
	Score(int n, int k) : /*models(std::vector<partition*>(k)),*/ entropies(std::vector<std::vector<double> >(k)), assignments(std::vector<int>(n)) { for (int i = 0; i < k; ++i) entropies[i] = std::vector<double>(n, 0); }
	Score(const Score& score) { /*this->models = score.models;*/ this->entropies = score.entropies; this->assignments = score.assignments; this->score = score.score; }

	// Debug
	void print_entropies() { for (int i = 0; i < (int)entropies.size(); ++i) { for (int j = 0; j < (int)entropies[i].size(); ++j) { printf("%.3f ", entropies[i][j]); } printf("\n"); } }
	void print_assignments() { for (int i = 0; i < (int)assignments.size(); ++i) { printf("%d ", assignments[i]); } printf("\n"); }
} Score;

class consensus_algorithm {
private:
	//------------------------------------------------------------------
	// Members

	// Model Score
	Score score;

	// Models
	std::vector<partition*> models;

	// Partitions
	std::vector<partition*> partitions;

	// Maximum number of iterations (Simulated Annealing)
	int maxIters;

	// Maximum number of partitions
	int maxParts;

	// Penalty score
	double penalty;

	// Precomputed entropies for partitions
	std::vector<double> entropies;

	//
	int n, m;

public:
	//------------------------------------------------------------------
	// Constructors
	consensus_algorithm(const std::vector<partition*> parts, int maxParts, int maxIters, double penalty);
	consensus_algorithm(const std::vector<partition*> parts, const std::vector<partition*> models);
	virtual ~consensus_algorithm();

public:
	//------------------------------------------------------------------
	// Methods

	// Run the algorithm
	void run();

	// Obtain the model bipartitions
	masked_model_partition_set* getModelPartitionSet(const std::vector<bool>& maske= std::vector<bool>(0), bool filterNull = 0, bool addAdditionalPartition = 0);


	// Obtain the model score
	const double getModelScore();

private:
	//------------------------------------------------------------------
	// Helpers

	// Insert new model bipartition into the set
	std::pair<partition*, Score> insertModelPartition(std::vector<partition*>& parts, partition* pNewPart);

	// Replace an existing model bipartition in the set with a new bipartition
	std::pair<partition*, Score> replaceModelPartition(std::vector<partition*>& parts, partition* pNewPart, int idx);

	// Perform EM on the newly inserted bipartition to improve score
	void performEM(partition* pPartition, std::vector<partition*> models, Score& score, int idx);

	// Performs four gametes condition to ensure we do not have admixture tree
	void performGC(partition* pPartition, std::vector<partition*> models, Score& score, int idx);

	// Return a random index of the observed bipartition
	int sampleObserved(const Score& score);

	// Return a random index of a model bipartition based on the weights
	int sampleModel();

	// Compute the score
	void compute(const std::vector<partition*>& parts, Score& score, const std::vector<bool>& mask = std::vector<bool>(0), bool filterNull = 0);

	// Update score
	void update(Score& score, std::vector<partition*> parts, partition* pNewPart, int idx);

	// Add any additional partition into model
	void constructFullPartitionSet();
};

#endif /* CONSENSUS_ALGORITHM_H_ */
