/*
 * coalescence_algorithm.h
 *
 *  Created on: Sep 6, 2011
 *      Author: Tony
 */

#ifndef COALESCENCE_ALGORITHM_H_
#define COALESCENCE_ALGORITHM_H_

#include <vector>

// Forward delcaration
class admixture_parameters;
class genealogy;

class coalescence_algorithm {
private:
	//------------------------------------------------------------------
	// Members

	// Assigned population
	std::vector<int> pop_assign;

	// Number of population
	int num_pop;

public:
	//------------------------------------------------------------------
	// Constructors
	coalescence_algorithm(const std::vector<int>& pop_assign, int num_pop);
	virtual ~coalescence_algorithm();

public:
	//------------------------------------------------------------------
	// Methods

	genealogy* generate_genalogy_fixed(admixture_parameters* pParams);

private:
	//------------------------------------------------------------------
	// Helpers

	// Returns a set of expected coalescence time between t1 and t2;
	std::vector<double> coalesce_times_fixed(double t, int n);
};

#endif /* COALESCENCE_ALGORITHM_H_ */
