#!/usr/bin/env python

# Wiggle Circle Animator for Python v0.09
# Peter Barnum <pbarnum@cs.cmu.edu>
# 
# Copyright (c) 2010, Peter Barnum
# 
# Distributed under the MIT license:
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

# Low level textbox-like class for rendering text via Pygame.

import math

import pygame, sys, os
from pygame.locals import *

class TextBox():
    def __init__(self, sharedData, maxSizeRectangle, fontSize, borderWidth):
        self.sharedData = sharedData
        self.maxSizeRectangle = [maxSizeRectangle[0],
                                 maxSizeRectangle[1],
                                 maxSizeRectangle[2] - 2*borderWidth,
                                 maxSizeRectangle[3] - 2*borderWidth]
        self.font = pygame.font.SysFont('system', fontSize)
        self.lines = []
        self.borderWidth = borderWidth
        
        self.maxLineHeight, self.maxLines = self._determineMaxLinesOfText()
        
    def _determineMaxLinesOfText(self):
        width, maxLineHeight = self.font.size('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()?')
        maxLines = math.floor((self.maxSizeRectangle[3] - 2) / maxLineHeight)
        
        return maxLineHeight, maxLines

    def appendLine(self, textLine):
        #clip the textLine if it's too big
        textWidth = self._fontRenderWidth(textLine)
        while textWidth > self.maxSizeRectangle[2]:
            textLine = textLine[0:-1]
            textWidth = self._fontRenderWidth(textLine)
            
        self.lines.append(textLine)
        
        if len(self.lines) > self.maxLines:
            self.lines = self.lines[1:]
    
    def _fontRenderWidth(self, text):
        width, height = self.font.size(text)
        return width
    
    def resizeRectangle(self, newMaxSizeRectangle):
        pass
    
    def showOnlyLinesNewerThan(self, seconds):
        pass
    
    def getRenderedText(self):
        renderedSurface = pygame.Surface((self.maxSizeRectangle[2], self.maxSizeRectangle[3]))
        renderedSurface.fill(self.sharedData.invisibleColor)
        renderedSurface.set_colorkey(self.sharedData.invisibleColor)
        
        curY = self.borderWidth
        for line in self.lines:
            tmpRenderedText = self.font.render(line, True, (255,255,255), (0,0,0))
            renderedSurface.blit(tmpRenderedText, [self.borderWidth, curY])
            curY += self.maxLineHeight
        
        return renderedSurface
        
        
        