#!/usr/bin/env python

# Wiggle Circle Animator for Python v0.09
# Peter Barnum <pbarnum@cs.cmu.edu>
# 
# Copyright (c) 2010, Peter Barnum
# 
# Distributed under the MIT license:
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

# There are some parameters that various classes need to know. Also, this class
# let's semi-related classes access each other in a semi-principled way,
# without messing around with deep structure.

import hud
import snakes

class SharedData():
    def __init__(self):
        self.renderSimple = False
        self.pygameKeyRepeat = [25, 100]
        self.windowSize = [800, 600]
        self.frameNum = 0
        self.invisibleColor = [16,16,16]
        self.phase = 0
        self.paused = 1
        self.newCircleRadius = 10
        self.circleColor = [255, 0, 0]
        
        self.hud = hud.Hud(self)
        self.snakeManager = snakes.SnakeManager(self)

    