#!/usr/bin/env python

# Wiggle Circle Animator for Python v0.09
# Peter Barnum <pbarnum@cs.cmu.edu>
# 
# Copyright (c) 2010, Peter Barnum
# 
# Distributed under the MIT license:
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.


# This is the starting point of the Python WiggleCircleAnimator program.

import random
import math
import xml.etree.ElementTree as etree
import numpy
import pickle

import pygame, sys, os
from pygame.locals import *

import utilities
import sharedData

pygame.init()

sharedData = sharedData.SharedData()

#pygame initializers
pygame.key.set_repeat(sharedData.pygameKeyRepeat[0], sharedData.pygameKeyRepeat[1])
window = pygame.display.set_mode((sharedData.windowSize[0], sharedData.windowSize[1]))
pygame.display.set_caption('Circle Santa Drawer (unpaused, cannot draw)') 
screen = pygame.display.get_surface()
pygame.time.set_timer(USEREVENT+1, 33) #update graphics
clock = pygame.time.Clock();

while True:
    dMs = clock.tick(60)
    sharedData.frameNum += 1
    
    for event in pygame.event.get():
        if event.type == QUIT: 
            sys.exit(0)
        elif event.type == KEYDOWN:
            curSnake = sharedData.snakeManager.getCurSnake()
            
            keys = pygame.key.get_pressed()
            amountToChange = 1
            if keys[pygame.K_LSHIFT]:
                amountToChange *= 5
            if keys[pygame.K_LCTRL]:
                amountToChange *= 10
            
            if event.key == pygame.K_q:
                sharedData.snakeManager.setCurSnake(sharedData.snakeManager.whichSnake-1)
            elif event.key == pygame.K_w:
                sharedData.snakeManager.setCurSnake(sharedData.snakeManager.whichSnake+1)
            elif event.key == pygame.K_a:
                curSnake.spatialFrequency -= amountToChange
                if curSnake.spatialFrequency < 1:
                    curSnake.spatialFrequency = 1
            elif event.key == pygame.K_s:
                curSnake.spatialFrequency += amountToChange
                if curSnake.spatialFrequency > 1000:
                    curSnake.spatialFrequency = 1000
            elif event.key == pygame.K_d:
                curSnake.temporalFrequency -= amountToChange
                if curSnake.temporalFrequency < 0:
                    curSnake.temporalFrequency = 0
            elif event.key == pygame.K_f:
                curSnake.temporalFrequency += amountToChange
                if curSnake.temporalFrequency > 1000:
                    curSnake.temporalFrequency = 1000
            elif event.key == pygame.K_z:
                curSnake.phaseOffset -= amountToChange
                if curSnake.phaseOffset < 0:
                    curSnake.phaseOffset = 360
            elif event.key == pygame.K_x:
                curSnake.phaseOffset += amountToChange
                if curSnake.phaseOffset > 359:
                    curSnake.phaseOffset = 0
            elif event.key == pygame.K_c:
                curSnake.amplitude -= amountToChange
                if curSnake.amplitude < 0:
                    curSnake.amplitude = 0                
            elif event.key == pygame.K_v:
                curSnake.amplitude += amountToChange
                if curSnake.amplitude > 1000:
                    curSnake.amplitude = 1000
            elif event.key == pygame.K_p:
                sharedData.paused = 1-sharedData.paused
                if sharedData.paused == 1:
                    pygame.display.set_caption('Circle Santa Drawer (paused, draw away!)')
                else:
                    pygame.display.set_caption('Circle Santa Drawer (unpaused, cannot draw)')
                
            elif event.key ==K_MINUS:
                sharedData.newCircleRadius -= amountToChange
                if sharedData.newCircleRadius < 2:
                    sharedData.newCircleRadius = 2
            elif event.key ==K_EQUALS:
                sharedData.newCircleRadius += amountToChange
                if sharedData.newCircleRadius > 1000:
                    sharedData.newCircleRadius = 1000
            elif event.key ==K_r:
                sharedData.circleColor[0] -= amountToChange
                if sharedData.circleColor[0] < 0:
                    sharedData.circleColor[0] = 0
            elif event.key ==K_t:
                sharedData.circleColor[0] += amountToChange
                if sharedData.circleColor[0] > 255:
                    sharedData.circleColor[0] = 255
            elif event.key ==K_g:
                sharedData.circleColor[1] -= amountToChange
                if sharedData.circleColor[1] < 0:
                    sharedData.circleColor[1] = 0
            elif event.key ==K_h:
                sharedData.circleColor[1] += amountToChange
                if sharedData.circleColor[1] > 255:
                    sharedData.circleColor[1] = 255
            elif event.key ==K_b:
                sharedData.circleColor[2] -= amountToChange
                if sharedData.circleColor[2] < 0:
                    sharedData.circleColor[2] = 0
            elif event.key ==K_n:
                sharedData.circleColor[2] += amountToChange
                if sharedData.circleColor[2] > 255:
                    sharedData.circleColor[2] = 255
            elif event.key ==K_k:
                saveFilename = input('Enter Save Filename:')
                saveFilename = 'saves/' + saveFilename + '.scd'
                fileOut = open(saveFilename, 'wb')
                print('Saving to ' + saveFilename)
                pickle.dump(sharedData.snakeManager.snakes, fileOut)
                fileOut.close()
            elif event.key ==K_l:
                loadFilename = input('Enter Load Filename:')
                loadFilename = 'saves/' + loadFilename + '.scd'
                fileIn = open(loadFilename, 'rb')
                print('Loading from ' + loadFilename)
                sharedData.snakeManager.snakes = pickle.load(fileIn)
                fileIn.close()
                
        elif event.type == MOUSEMOTION:
            pass;
        
        elif event.type == MOUSEBUTTONDOWN:
            if sharedData.paused == 1:
                if event.button == 1:
                    sharedData.snakeManager.addCircle(event.pos)
                elif event.button == 3:
                    sharedData.snakeManager.removeCircle(event.pos)
        
        elif event.type == (USEREVENT+1):
            sharedData.phase += .01
            sharedData.phase %= 2*math.pi
            
            screen.fill([64, 64, 64])
            sharedData.snakeManager.drawSnakes(screen, sharedData.phase)
            sharedData.hud.drawHud(screen)
            pygame.display.flip()        
        
        

