#!/usr/bin/env python

# Wiggle Circle Animator for Python v0.09
# Peter Barnum <pbarnum@cs.cmu.edu>
# 
# Copyright (c) 2010, Peter Barnum
# 
# Distributed under the MIT license:
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

import math
import random

import pygame, sys, os
from pygame.locals import * 

import utilities

import text

class Hud():
    def __init__(self, sharedData):
        self.sharedData = sharedData
        self.textBox = text.TextBox(self.sharedData, [0,0,350,140], 18, 4)
    
    def renderText(self, surface):
        self.textBox.renderText(surface)
                
    def drawHud(self, surface):
        self.textBox.appendLine('Which Snake (q w): ' + str(self.sharedData.snakeManager.whichSnake))
        curSnake = self.sharedData.snakeManager.getCurSnake()
        self.textBox.appendLine('Spatial Freq (a s): ' + str(curSnake.spatialFrequency))
        self.textBox.appendLine('Temporal Freq (d f): ' + str(curSnake.temporalFrequency))
        self.textBox.appendLine('Phase Offset (z x): ' + str(curSnake.phaseOffset))
        self.textBox.appendLine('Amplitude: (c v)' + str(curSnake.amplitude))
        self.textBox.appendLine('# of Circles: ' + str(len(curSnake.circles)))
        self.textBox.appendLine('Circle Radius (- +): ' + str(self.sharedData.newCircleRadius))
        self.textBox.appendLine('[Red (r t), Green (g h), Blue (b n)]:       (' +\
                                       str(self.sharedData.circleColor[0]) +\
                                ', ' + str(self.sharedData.circleColor[1]) +\
                                ', ' + str(self.sharedData.circleColor[2]) + ')')
        self.textBox.appendLine('Pause/Resume (p)')
        self.textBox.appendLine('Save/Load (k l)')
        
        textBoxSurface = self.textBox.getRenderedText()
        surface.blit(textBoxSurface, [0,0])
        pygame.draw.rect(surface, self.sharedData.circleColor, [210,95,15,15], 0)
        
        mousePos = pygame.mouse.get_pos()
        curRadius = self.sharedData.newCircleRadius
        pygame.draw.circle(surface, [0,0,0], mousePos, curRadius-1, 1)
        pygame.draw.circle(surface, [255,255,255], mousePos, curRadius, 1)
        
    def __getstate__(self):
        odict = self.__dict__.copy()
        return odict

    def __setstate__(self, dict):
        self.__dict__.update(dict)