!include Library.nsh
OutFile 1394camera64.exe
InstallDir "$PROGRAMFILES\CMU\1394Camera"
XPStyle on

PageEx license
  LicenseText "License"
  LicenseData lgpl.txt
  LicenseForceSelection checkbox
PageExEnd

PageEx components
PageExEnd

PageEx directory
  DirVar $INSTDIR
PageExEnd

PageEx instfiles
PageExEnd

UninstPage uninstConfirm
UninstPage components
UninstPage instfiles

Section "-CMU 1394 Digital Camera Driver"
#!insertmacro InstallLib DLL NOTSHARED NOREBOOT_NOTPROTECTED 1394camera\Release\1394camera.dll $SYSDIR\1394camera.dll $SYSDIR
SetOutPath $SYSDIR
File "1394camera\Release\1394camera.dll"
SetOutPath $INSTDIR\Driver
File "1394Camera.inf"
File "1394cmdr\objfre_wnet_x86\i386\1394cmdr.sys"
SetOutPath $INSTDIR
File "1394camera\Release\1394CameraDemo.exe" 
File "doc\html\1394camera.chm" 
WriteUninstaller $INSTDIR\uninstall.exe
WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\CMU 1394 Digital Camera Driver" "DisplayName" "CMU 1394 Digital Camera Driver"
WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\CMU 1394 Digital Camera Driver" "InstallLocation" "$INSTDIR"
WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\CMU 1394 Digital Camera Driver" "DisplayIcon" "$INSTDIR\1394CamerDemo.exe,0"
WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\CMU 1394 Digital Camera Driver" "UninstallString" "$INSTDIR\uninstall.exe"
WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\CMU 1394 Digital Camera Driver" "Publisher" "Carnegie Mellon University"
WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\CMU 1394 Digital Camera Driver" "DisplayVersion" "6.3.6.20"
WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\CMU 1394 Digital Camera Driver" "NoModify" 1
WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\CMU 1394 Digital Camera Driver" "NoRepair" 1
SectionEnd

Section /o "Program Group and Desktop Shortcuts"
CreateDirectory "$SMPROGRAMS\CMU 1394Camera"
CreateShortCut "$SMPROGRAMS\CMU 1394Camera\1394Camera Demo.lnk" "$INSTDIR\1394CameraDemo.exe"
CreateShortCut "$SMPROGRAMS\CMU 1394Camera\1394Camera Documentation.lnk" "$INSTDIR\1394camera.chm"
CreateShortCut "$SMPROGRAMS\CMU 1394Camera\Uninstall.lnk" "$INSTDIR\uninstall.exe"
CreateShortCut "$DESKTOP\1394Camera Demo.lnk" "$INSTDIR\1394CameraDemo.exe"
SectionEnd

Section /o "Disable Default Windows Driver"
DetailPrint "Disabling default windows driver: $WINDIR\inf\image.[inf,pnf]"
IfFileExists $WINDIR\inf\image.inf 0 movedinf
  Rename $WINDIR\inf\image.inf $WINDIR\inf\image.ibk
movedinf:
IfFileExists $WINDIR\inf\image.pnf 0 movedpnf
  Rename $WINDIR\inf\image.pnf $WINDIR\inf\image.pbk
movedpnf:
SectionEnd

Section /o "Update Driver for Attached Devices"
    InstDrv::InitDriverSetup /NOUNLOAD {6BDD1FC6-810F-11D0-BEC7-08002BE2092F} "1394\a02d&100"
    Pop $0
    DetailPrint "Updating Driver for IIDC Version 1.04-Compliant Cameras"
    InstDrv::InstallDriver /NOUNLOAD "$INSTDIR\Driver\1394Camera.inf"
    Pop $0
    DetailPrint "Installation Status: $0"
    InstDrv::InitDriverSetup /NOUNLOAD {6BDD1FC6-810F-11D0-BEC7-08002BE2092F} "1394\a02d&101"
    Pop $0
    DetailPrint "Updating Driver for IIDC Version 1.20-Compliant Cameras"
    InstDrv::InstallDriver /NOUNLOAD "$INSTDIR\Driver\1394Camera.inf"
    Pop $0
    DetailPrint "Installation Status: $0"
    InstDrv::InitDriverSetup /NOUNLOAD {6BDD1FC6-810F-11D0-BEC7-08002BE2092F} "1394\a02d&102"
    Pop $0
    DetailPrint "Updating Driver for IIDC Version 1.30-Compliant Cameras"
    InstDrv::InstallDriver /NOUNLOAD "$INSTDIR\Driver\1394Camera.inf"
    Pop $0
    DetailPrint "Installation Status: $0"
    InstDrv::InitDriverSetup /NOUNLOAD {6BDD1FC6-810F-11D0-BEC7-08002BE2092F} "1394\a02d&103"
    DetailPrint "Updating Driver for IIDC Version 1.31-Compliant Cameras"
    InstDrv::InstallDriver /NOUNLOAD "$INSTDIR\Driver\1394Camera.inf"
    Pop $0
    DetailPrint "Installation Status: $0"
SectionEnd

SectionGroup "Development Files"
Section /o "Development Files"
SetOutPath $INSTDIR\lib
File "1394Camera\Release\1394Camera.lib"
SetOutPath $INSTDIR\include
File "1394camera\1394camapi.h"
File "1394camera\1394common.h"
File "1394camera\1394Camera.h"
File "1394camera\1394CameraControl.h"
File "1394camera\1394CameraControlSize.h"
File "1394camera\1394CameraControlStrobe.h"
File "1394camera\1394CameraControlTrigger.h"
SectionEnd

Section /o "Demo Application Source"
SetOutPath $INSTDIR\1394CameraDemo
File "1394CameraDemo\1394CameraDemo.dsw"
File "1394CameraDemo\1394CameraDemo.dsp"
File "1394CameraDemo\1394CameraDemo.cpp"
File "1394CameraDemo\1394CameraDemo.exe.manifest"
File "1394CameraDemo\1394camerademo.h"
File "1394CameraDemo\1394CameraDemo.rc"
File "1394CameraDemo\ChildView.cpp"
File "1394CameraDemo\ChildView.h"
File "1394CameraDemo\GetIntegerDialog.cpp"
File "1394CameraDemo\GetIntegerDialog.h"
File "1394CameraDemo\MainFrm.cpp"
File "1394CameraDemo\MainFrm.h"
File "1394CameraDemo\resource.h"
File "1394CameraDemo\StdAfx.cpp"
File "1394CameraDemo\StdAfx.h"
SetOutPath $INSTDIR\1394CameraDemo\res
File "1394CameraDemo\res\1394CameraDemo.ico"
File "1394CameraDemo\res\1394CameraDemo.rc2"
File "1394CameraDemo\res\toolbar1.bmp"
SectionEnd

Section /o "Debug Binaries"
#!insertmacro InstallLib DLL NOTSHARED NOREBOOT_NOTPROTECTED 1394Camera\Debug\1394camerad.dll $SYSDIR\1394camerad.dll $SYSDIR
SetOutPath $SYSDIR
File "1394camera\Debug\1394camerad.dll"
SetOutPath $INSTDIR\lib
File "1394camera\Debug\1394camerad.lib"
SetOutPath $INSTDIR
File "1394camera\Debug\1394CameraDemoD.exe" 
SectionEnd
SectionGroupEnd

Section "-un.Delete Installed Files"
    ReadRegStr $INSTDIR HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\CMU 1394 Digital Camera Driver" "InstallLocation"
    RMDir /r /REBOOTOK $INSTDIR
    RMDir /r /REBOOTOK "$SMPROGRAMS\CMU 1394Camera"
    Delete "$DESKTOP\1394Camera Demo.lnk"
    IfFileExists $SYSDIR\1394camerad.dll 0 nodebugdll
      Delete $SYSDIR\1394camerad.dll
    nodebugdll:
    Delete $SYSDIR\1394camera.dll   
    DeleteRegKEY HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\CMU 1394 Digital Camera Driver"
SectionEnd

Section /o "un.Restore Default Driver"
IfFileExists $WINDIR\inf\image.ibk 0 movedinf
  Rename $WINDIR\inf\image.ibk $WINDIR\inf\image.inf
movedinf:
IfFileExists $WINDIR\inf\image.pbk 0 movedpnf
  Rename $WINDIR\inf\image.pbk $WINDIR\inf\image.pnf
movedpnf:
    InstDrv::InitDriverSetup /NOUNLOAD {6BDD1FC6-810F-11D0-BEC7-08002BE2092F} "1394\a02d&100"
    Pop $0
    DetailPrint "Updating Driver for IIDC Version 1.04-Compliant Cameras"
    InstDrv::InstallDriver /NOUNLOAD "$WINDIR\inf\image.inf"
    Pop $0
    DetailPrint "Installation Status: $0"
    InstDrv::InitDriverSetup /NOUNLOAD {6BDD1FC6-810F-11D0-BEC7-08002BE2092F} "1394\a02d&101"
    Pop $0
    DetailPrint "Updating Driver for IIDC Version 1.20-Compliant Cameras"
    InstDrv::InstallDriver /NOUNLOAD "$WINDIR\inf\image.inf"
    Pop $0
    DetailPrint "Installation Status: $0"
    InstDrv::InitDriverSetup /NOUNLOAD {6BDD1FC6-810F-11D0-BEC7-08002BE2092F} "1394\a02d&102"
    Pop $0
    DetailPrint "Updating Driver for IIDC Version 1.30-Compliant Cameras"
    InstDrv::InstallDriver /NOUNLOAD "$WINDIR\inf\image.inf"
    Pop $0
    DetailPrint "Installation Status: $0"
    InstDrv::InitDriverSetup /NOUNLOAD {6BDD1FC6-810F-11D0-BEC7-08002BE2092F} "1394\a02d&103"
    DetailPrint "Updating Driver for IIDC Version 1.31-Compliant Cameras"
    InstDrv::InstallDriver /NOUNLOAD "$WINDIR\inf\image.inf"
    Pop $0
    DetailPrint "Installation Status: $0"
IfFileExists "$SYSDIR\Drivers\1394cmdr.sys" 0 nukedsys
  Delete "$SYSDIR\Drivers\1394cmdr.sys"
nukedsys:
  DetailPrint "Now... what to do about the oem inf files?"
SectionEnd