/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;
import java.util.Random;

public class GameState {
    public static final int PLAYER = 0;
    public static final int COMPUTER = 1;
    public static final int PREFLOP = 0;
    public static final int POSTFLOP = 1;
    public static final int POSTTURN = 2;
    public static final int CALL = 0;
    public static final int CHECK = 1;
    public static final int FOLD = 2;
    public static final int BET = 3;
    public static final int RAISE = 4;
    private static final int START = 0;
    private static final int K = 1;
    private static final int Kk = 2;
    private static final int Kb = 3;
    private static final int KbC = 4;
    private static final int KbR = 5;
    private static final int KbRc = 6;
    private static final int KbRr = 7;
    private static final int KbRrC = 8;
    private static final int KbRrF = 9;
    private static final int KbRf = 10;
    private static final int KbF = 11;
    private static final int B = 12;
    private static final int Bc = 13;
    private static final int Br = 14;
    private static final int BrC = 15;
    private static final int BrR = 16;
    private static final int BrRc = 17;
    private static final int BrRf = 18;
    private static final int BrF = 19;
    private static final int Bf = 20;
    public int round;
    public int player_turn;
    private int dealer;
    public int pot;
    private int bh1;
    private int bh2;
    private int bh3;
    public int opp_chips;
    public int player_chips;
    public int flop_card;
    public int turn_card;
    public int opp_card;
    public int player_card;
    public boolean can_call;
    public boolean can_check;
    public boolean can_fold;
    public boolean can_bet;
    public boolean can_raise;
    public boolean do_flop;
    public boolean do_turn;
    public boolean game_over;
    public String winner;
    public boolean dealt;
    Random random;
    Player player;
    private double[] beliefs1;
    private double[] beliefs2;
    private BeliefTable player_table;
    private BeliefTable opponent_table;

    public GameState(BeliefTable beliefTable, BeliefTable beliefTable2) {
        this.player_table = beliefTable;
        this.opponent_table = beliefTable2;
        this.random = new Random();
        this.winner = new String();
        this.player = new Player();
        this.beliefs1 = new double[52];
        this.beliefs2 = new double[52];
        this.reset();
    }

    public void reset() {
        this.player_chips = 1000;
        this.opp_chips = 1000;
        this.pot = 0;
        this.dealer = 1;
        this.round = 0;
        this.bh3 = 0;
        this.bh2 = 0;
        this.bh1 = 0;
        this.game_over = true;
        this.winner = "";
        this.flop_card = 0;
        this.turn_card = 0;
        this.opp_card = 0;
        this.player_card = 0;
        this.dealt = false;
    }

    public void new_game() {
        this.dealer = 1 - this.dealer;
        this.player_turn = 1 - this.dealer;
        this.pot = 10;
        this.opp_chips -= 5;
        this.player_chips -= 5;
        this.round = 0;
        this.bh3 = 0;
        this.bh2 = 0;
        this.bh1 = 0;
        this.can_raise = true;
        this.can_fold = true;
        this.can_call = true;
        this.can_bet = false;
        this.can_check = false;
        this.do_turn = false;
        this.do_flop = false;
        this.game_over = false;
        this.shuffle();
        this.compute_beliefs();
    }

    public void do_action(int n) {
        switch (n) {
            case 0: {
                block7 : switch (this.round) {
                    case 0: {
                        this.pot += 10;
                        if (this.player_turn == 0) {
                            this.player_chips -= 10;
                        } else {
                            this.opp_chips -= 10;
                        }
                        switch (this.bh1) {
                            case 3: {
                                this.bh1 = 4;
                                break block7;
                            }
                            case 5: {
                                this.bh1 = 6;
                                break block7;
                            }
                            case 7: {
                                this.bh1 = 8;
                                break block7;
                            }
                            case 12: {
                                this.bh1 = 13;
                                break block7;
                            }
                            case 14: {
                                this.bh1 = 15;
                                break block7;
                            }
                            case 16: {
                                this.bh1 = 17;
                                break block7;
                            }
                        }
                        System.out.println("default reached");
                        break;
                    }
                    case 1: {
                        this.pot += 20;
                        if (this.player_turn == 0) {
                            this.player_chips -= 20;
                        } else {
                            this.opp_chips -= 20;
                        }
                        switch (this.bh2) {
                            case 3: {
                                this.bh2 = 4;
                                break block7;
                            }
                            case 5: {
                                this.bh2 = 6;
                                break block7;
                            }
                            case 7: {
                                this.bh2 = 8;
                                break block7;
                            }
                            case 12: {
                                this.bh2 = 13;
                                break block7;
                            }
                            case 14: {
                                this.bh2 = 15;
                                break block7;
                            }
                            case 16: {
                                this.bh2 = 17;
                                break block7;
                            }
                        }
                        System.out.println("default reached");
                        break;
                    }
                    case 2: {
                        this.pot += 20;
                        if (this.player_turn == 0) {
                            this.player_chips -= 20;
                        } else {
                            this.opp_chips -= 20;
                        }
                        switch (this.bh3) {
                            case 3: {
                                this.bh3 = 4;
                                break block7;
                            }
                            case 5: {
                                this.bh3 = 6;
                                break block7;
                            }
                            case 7: {
                                this.bh3 = 8;
                                break block7;
                            }
                            case 12: {
                                this.bh3 = 13;
                                break block7;
                            }
                            case 14: {
                                this.bh3 = 15;
                                break block7;
                            }
                            case 16: {
                                this.bh3 = 17;
                                break block7;
                            }
                        }
                        System.out.println("default reached");
                    }
                }
                this.advance_round();
                break;
            }
            case 1: {
                block36 : switch (this.round) {
                    case 0: {
                        switch (this.bh1) {
                            case 0: {
                                this.bh1 = 1;
                                this.player_turn = 1 - this.player_turn;
                                break block36;
                            }
                            case 1: {
                                this.bh1 = 2;
                                this.advance_round();
                                break block36;
                            }
                        }
                        System.out.println("default reached");
                        break;
                    }
                    case 1: {
                        switch (this.bh2) {
                            case 0: {
                                this.bh2 = 1;
                                this.player_turn = 1 - this.player_turn;
                                break block36;
                            }
                            case 1: {
                                this.bh2 = 2;
                                this.advance_round();
                                break block36;
                            }
                        }
                        System.out.println("default reached");
                        break;
                    }
                    case 2: {
                        switch (this.bh3) {
                            case 0: {
                                this.bh3 = 1;
                                this.player_turn = 1 - this.player_turn;
                                break block36;
                            }
                            case 1: {
                                this.bh3 = 2;
                                this.advance_round();
                                break block36;
                            }
                        }
                        System.out.println("default reached");
                    }
                }
                break;
            }
            case 2: {
                block53 : switch (this.round) {
                    case 0: {
                        switch (this.bh1) {
                            case 7: {
                                this.bh1 = 9;
                                break block53;
                            }
                            case 5: {
                                this.bh1 = 10;
                                break block53;
                            }
                            case 3: {
                                this.bh1 = 11;
                                break block53;
                            }
                            case 16: {
                                this.bh1 = 18;
                                break block53;
                            }
                            case 14: {
                                this.bh1 = 19;
                                break block53;
                            }
                            case 12: {
                                this.bh1 = 20;
                                break block53;
                            }
                        }
                        System.out.println("default reached");
                        break;
                    }
                    case 1: {
                        switch (this.bh2) {
                            case 7: {
                                this.bh2 = 9;
                                break block53;
                            }
                            case 5: {
                                this.bh2 = 10;
                                break block53;
                            }
                            case 3: {
                                this.bh2 = 11;
                                break block53;
                            }
                            case 16: {
                                this.bh2 = 18;
                                break block53;
                            }
                            case 14: {
                                this.bh2 = 19;
                                break block53;
                            }
                            case 12: {
                                this.bh2 = 20;
                                break block53;
                            }
                        }
                        System.out.println("default reached");
                        break;
                    }
                    case 2: {
                        switch (this.bh3) {
                            case 7: {
                                this.bh3 = 9;
                                break block53;
                            }
                            case 5: {
                                this.bh3 = 10;
                                break block53;
                            }
                            case 3: {
                                this.bh3 = 11;
                                break block53;
                            }
                            case 16: {
                                this.bh3 = 18;
                                break block53;
                            }
                            case 14: {
                                this.bh3 = 19;
                                break block53;
                            }
                            case 12: {
                                this.bh3 = 20;
                                break block53;
                            }
                        }
                        System.out.println("default reached");
                    }
                }
                if (this.player_turn == 0) {
                    this.opp_chips += this.pot;
                    this.winner = "Computer wins " + this.pot + " chips from the pot.\n";
                } else {
                    this.player_chips += this.pot;
                    this.winner = "Player wins " + this.pot + " chips from the pot.\n";
                }
                this.game_over = true;
                break;
            }
            case 3: {
                block82 : switch (this.round) {
                    case 0: {
                        this.pot += 10;
                        if (this.player_turn == 0) {
                            this.player_chips -= 10;
                        } else {
                            this.opp_chips -= 10;
                        }
                        switch (this.bh1) {
                            case 0: {
                                this.bh1 = 12;
                                break block82;
                            }
                            case 1: {
                                this.bh1 = 3;
                                break block82;
                            }
                        }
                        System.out.println("default reached");
                        break;
                    }
                    case 1: {
                        this.pot += 20;
                        if (this.player_turn == 0) {
                            this.player_chips -= 20;
                        } else {
                            this.opp_chips -= 20;
                        }
                        switch (this.bh2) {
                            case 0: {
                                this.bh2 = 12;
                                break block82;
                            }
                            case 1: {
                                this.bh2 = 3;
                                break block82;
                            }
                        }
                        System.out.println("default reached");
                        break;
                    }
                    case 2: {
                        this.pot += 20;
                        if (this.player_turn == 0) {
                            this.player_chips -= 20;
                        } else {
                            this.opp_chips -= 20;
                        }
                        switch (this.bh3) {
                            case 0: {
                                this.bh3 = 12;
                                break block82;
                            }
                            case 1: {
                                this.bh3 = 3;
                                break block82;
                            }
                        }
                        System.out.println("default reached");
                    }
                }
                this.player_turn = 1 - this.player_turn;
                break;
            }
            case 4: {
                block99 : switch (this.round) {
                    case 0: {
                        this.pot += 20;
                        if (this.player_turn == 0) {
                            this.player_chips -= 20;
                        } else {
                            this.opp_chips -= 20;
                        }
                        switch (this.bh1) {
                            case 3: {
                                this.bh1 = 5;
                                break block99;
                            }
                            case 5: {
                                this.bh1 = 7;
                                break block99;
                            }
                            case 12: {
                                this.bh1 = 14;
                                break block99;
                            }
                            case 14: {
                                this.bh1 = 16;
                                break block99;
                            }
                        }
                        System.out.println("default reached");
                        break;
                    }
                    case 1: {
                        this.pot += 40;
                        if (this.player_turn == 0) {
                            this.player_chips -= 40;
                        } else {
                            this.opp_chips -= 40;
                        }
                        switch (this.bh2) {
                            case 3: {
                                this.bh2 = 5;
                                break block99;
                            }
                            case 5: {
                                this.bh2 = 7;
                                break block99;
                            }
                            case 12: {
                                this.bh2 = 14;
                                break block99;
                            }
                            case 14: {
                                this.bh2 = 16;
                                break block99;
                            }
                        }
                        System.out.println("default reached");
                        break;
                    }
                    case 2: {
                        this.pot += 40;
                        if (this.player_turn == 0) {
                            this.player_chips -= 40;
                        } else {
                            this.opp_chips -= 40;
                        }
                        switch (this.bh3) {
                            case 3: {
                                this.bh3 = 5;
                                break block99;
                            }
                            case 5: {
                                this.bh3 = 7;
                                break block99;
                            }
                            case 12: {
                                this.bh3 = 14;
                                break block99;
                            }
                            case 14: {
                                this.bh3 = 16;
                                break block99;
                            }
                        }
                        System.out.println("default reached");
                    }
                }
                this.player_turn = 1 - this.player_turn;
                break;
            }
            default: {
                System.out.println("default reached");
            }
        }
        this.compute_beliefs();
    }

    public void compute_beliefs() {
        HashMap hashMap;
        HashMap hashMap2;
        int n;
        int n2;
        int n3;
        if (this.dealer == 0) {
            n3 = this.opp_card;
            n2 = this.player_card;
        } else {
            n3 = this.player_card;
            n2 = this.opp_card;
        }
        block0 : switch (this.round) {
            case 0: {
                int n4;
                switch (this.bh1) {
                    case 0: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 ? 0.0 : 0.0196078431372549;
                            this.beliefs2[n4] = n4 == n2 ? 0.0 : 0.0196078431372549;
                        }
                        break block0;
                    }
                    case 1: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 ? 0.0 : 0.0196078431372549;
                            this.beliefs2[n4] = n4 == n2 ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, 0);
                        }
                        break block0;
                    }
                    case 3: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 ? 0.0 : this.player.get_prob_of_card_player1(n3, n4, 1);
                            this.beliefs2[n4] = n4 == n2 ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, 0);
                        }
                        break block0;
                    }
                    case 5: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 ? 0.0 : this.player.get_prob_of_card_player1(n3, n4, 1);
                            this.beliefs2[n4] = n4 == n2 ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, 2);
                        }
                        break block0;
                    }
                    case 7: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 ? 0.0 : this.player.get_prob_of_card_player1(n3, n4, 3);
                            this.beliefs2[n4] = n4 == n2 ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, 2);
                        }
                        break block0;
                    }
                    case 12: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 ? 0.0 : 0.0196078431372549;
                            this.beliefs2[n4] = n4 == n2 ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, 1);
                        }
                        break block0;
                    }
                    case 14: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 ? 0.0 : this.player.get_prob_of_card_player1(n3, n4, 2);
                            this.beliefs2[n4] = n4 == n2 ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, 1);
                        }
                        break block0;
                    }
                    case 16: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 ? 0.0 : this.player.get_prob_of_card_player1(n3, n4, 2);
                            this.beliefs2[n4] = n4 == n2 ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, 3);
                        }
                        break block0;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 18: 
                    case 19: 
                    case 20: {
                        break block0;
                    }
                }
                System.out.println("History not yet supported");
                break;
            }
            case 1: {
                int n4;
                int n5 = 0;
                switch (this.bh1) {
                    case 2: {
                        n5 = 0;
                        break;
                    }
                    case 4: {
                        n5 = 1;
                        break;
                    }
                    case 6: {
                        n5 = 2;
                        break;
                    }
                    case 8: {
                        n5 = 3;
                        break;
                    }
                    case 13: {
                        n5 = 4;
                        break;
                    }
                    case 15: {
                        n5 = 5;
                        break;
                    }
                    case 17: {
                        n5 = 6;
                        break;
                    }
                    default: {
                        System.out.println("default reached");
                    }
                }
                switch (this.bh2) {
                    case 0: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 || n4 == this.flop_card ? 0.0 : this.player.get_prob_of_sequence(n3, n4, n5);
                            this.beliefs2[n4] = n4 == n2 || n4 == this.flop_card ? 0.0 : this.player.get_prob_of_sequence(n4, n2, n5);
                        }
                        break block0;
                    }
                    case 1: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 || n4 == this.flop_card ? 0.0 : this.player.get_prob_of_sequence(n3, n4, n5);
                            this.beliefs2[n4] = n4 == n2 || n4 == this.flop_card ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, n5, this.flop_card, 0);
                        }
                        break block0;
                    }
                    case 3: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 || n4 == this.flop_card ? 0.0 : this.player.get_prob_of_card_player1(n3, n4, n5, this.flop_card, 1);
                            this.beliefs2[n4] = n4 == n2 || n4 == this.flop_card ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, n5, this.flop_card, 0);
                        }
                        break block0;
                    }
                    case 5: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 || n4 == this.flop_card ? 0.0 : this.player.get_prob_of_card_player1(n3, n4, n5, this.flop_card, 1);
                            this.beliefs2[n4] = n4 == n2 || n4 == this.flop_card ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, n5, this.flop_card, 2);
                        }
                        break block0;
                    }
                    case 7: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 || n4 == this.flop_card ? 0.0 : this.player.get_prob_of_card_player1(n3, n4, n5, this.flop_card, 3);
                            this.beliefs2[n4] = n4 == n2 || n4 == this.flop_card ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, n5, this.flop_card, 2);
                        }
                        break block0;
                    }
                    case 12: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 || n4 == this.flop_card ? 0.0 : this.player.get_prob_of_sequence(n3, n4, n5);
                            this.beliefs2[n4] = n4 == n2 || n4 == this.flop_card ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, n5, this.flop_card, 1);
                        }
                        break block0;
                    }
                    case 14: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 || n4 == this.flop_card ? 0.0 : this.player.get_prob_of_card_player1(n3, n4, n5, this.flop_card, 2);
                            this.beliefs2[n4] = n4 == n2 || n4 == this.flop_card ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, n5, this.flop_card, 1);
                        }
                        break block0;
                    }
                    case 16: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 || n4 == this.flop_card ? 0.0 : this.player.get_prob_of_card_player1(n3, n4, n5, this.flop_card, 2);
                            this.beliefs2[n4] = n4 == n2 || n4 == this.flop_card ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, n5, this.flop_card, 3);
                        }
                        break block0;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 18: 
                    case 19: 
                    case 20: {
                        break block0;
                    }
                }
                System.out.println("History not yet supported");
                break;
            }
            case 2: {
                int n4;
                int n5 = 0;
                switch (this.bh1) {
                    case 2: {
                        n5 = 0;
                        break;
                    }
                    case 4: {
                        n5 = 1;
                        break;
                    }
                    case 6: {
                        n5 = 2;
                        break;
                    }
                    case 8: {
                        n5 = 3;
                        break;
                    }
                    case 13: {
                        n5 = 4;
                        break;
                    }
                    case 15: {
                        n5 = 5;
                        break;
                    }
                    case 17: {
                        n5 = 6;
                        break;
                    }
                    default: {
                        System.out.println("default reached");
                    }
                }
                int n6 = 0;
                switch (this.bh2) {
                    case 2: {
                        n6 = 0;
                        break;
                    }
                    case 4: {
                        n6 = 1;
                        break;
                    }
                    case 6: {
                        n6 = 2;
                        break;
                    }
                    case 8: {
                        n6 = 3;
                        break;
                    }
                    case 13: {
                        n6 = 4;
                        break;
                    }
                    case 15: {
                        n6 = 5;
                        break;
                    }
                    case 17: {
                        n6 = 6;
                        break;
                    }
                    default: {
                        System.out.println("default reached");
                    }
                }
                switch (this.bh3) {
                    case 0: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 || n4 == this.flop_card || n4 == this.turn_card ? 0.0 : this.player.get_prob_of_sequence(n3, n4, n5, this.flop_card, n6);
                            this.beliefs2[n4] = n4 == n2 || n4 == this.flop_card || n4 == this.turn_card ? 0.0 : this.player.get_prob_of_sequence(n4, n2, n5, this.flop_card, n6);
                        }
                        break block0;
                    }
                    case 1: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 || n4 == this.flop_card || n4 == this.turn_card ? 0.0 : this.player.get_prob_of_sequence(n3, n4, n5, this.flop_card, n6);
                            this.beliefs2[n4] = n4 == n2 || n4 == this.flop_card || n4 == this.turn_card ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, n5, this.flop_card, n6, this.turn_card, 0);
                        }
                        break block0;
                    }
                    case 3: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 || n4 == this.flop_card || n4 == this.turn_card ? 0.0 : this.player.get_prob_of_card_player1(n3, n4, n5, this.flop_card, n6, this.turn_card, 1);
                            this.beliefs2[n4] = n4 == n2 || n4 == this.flop_card || n4 == this.turn_card ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, n5, this.flop_card, n6, this.turn_card, 0);
                        }
                        break block0;
                    }
                    case 5: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 || n4 == this.flop_card || n4 == this.turn_card ? 0.0 : this.player.get_prob_of_card_player1(n3, n4, n5, this.flop_card, n6, this.turn_card, 1);
                            this.beliefs2[n4] = n4 == n2 || n4 == this.flop_card || n4 == this.turn_card ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, n5, this.flop_card, n6, this.turn_card, 2);
                        }
                        break block0;
                    }
                    case 7: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 || n4 == this.flop_card || n4 == this.turn_card ? 0.0 : this.player.get_prob_of_card_player1(n3, n4, n5, this.flop_card, n6, this.turn_card, 3);
                            this.beliefs2[n4] = n4 == n2 || n4 == this.flop_card || n4 == this.turn_card ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, n5, this.flop_card, n6, this.turn_card, 2);
                        }
                        break block0;
                    }
                    case 12: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 || n4 == this.flop_card || n4 == this.turn_card ? 0.0 : this.player.get_prob_of_sequence(n3, n4, n5, this.flop_card, n6);
                            this.beliefs2[n4] = n4 == n2 || n4 == this.flop_card || n4 == this.turn_card ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, n5, this.flop_card, n6, this.turn_card, 1);
                        }
                        break block0;
                    }
                    case 14: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 || n4 == this.flop_card || n4 == this.turn_card ? 0.0 : this.player.get_prob_of_card_player1(n3, n4, n5, this.flop_card, n6, this.turn_card, 2);
                            this.beliefs2[n4] = n4 == n2 || n4 == this.flop_card || n4 == this.turn_card ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, n5, this.flop_card, n6, this.turn_card, 1);
                        }
                        break block0;
                    }
                    case 16: {
                        for (n4 = 0; n4 < 52; ++n4) {
                            this.beliefs1[n4] = n4 == n3 || n4 == this.flop_card || n4 == this.turn_card ? 0.0 : this.player.get_prob_of_card_player1(n3, n4, n5, this.flop_card, n6, this.turn_card, 2);
                            this.beliefs2[n4] = n4 == n2 || n4 == this.flop_card || n4 == this.turn_card ? 0.0 : this.player.get_prob_of_card_player2(n4, n2, n5, this.flop_card, n6, this.turn_card, 3);
                        }
                        break block0;
                    }
                    case 2: 
                    case 4: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: {
                        break block0;
                    }
                }
                System.out.println("History not yet supported: " + this.bh3);
            }
        }
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = true;
        boolean bl2 = true;
        for (n = 0; n < 52; ++n) {
            d += this.beliefs1[n];
            d2 += this.beliefs2[n];
        }
        if (d == 0.0) {
            for (n = 0; n < 52; ++n) {
                this.beliefs1[n] = 0.0;
            }
            d = 1.0;
            bl = false;
        }
        if (d2 == 0.0) {
            for (n = 0; n < 52; ++n) {
                this.beliefs2[n] = 0.0;
            }
            d2 = 1.0;
            bl2 = false;
        }
        n = 0;
        while (n < 52) {
            int n7 = n;
            this.beliefs1[n7] = this.beliefs1[n7] / d;
            int n8 = n++;
            this.beliefs2[n8] = this.beliefs2[n8] / d2;
        }
        switch (this.round) {
            case 0: {
                hashMap2 = this.player.get_partition(this.player_card);
                hashMap = this.player.get_partition(this.opp_card);
                break;
            }
            case 1: {
                hashMap2 = this.player.get_partition(this.player_card, this.flop_card);
                hashMap = this.player.get_partition(this.opp_card, this.flop_card);
                break;
            }
            default: {
                hashMap2 = this.player.get_partition(this.player_card, this.flop_card, this.turn_card);
                hashMap = this.player.get_partition(this.opp_card, this.flop_card, this.turn_card);
            }
        }
        if (this.dealer == 0) {
            this.player_table.update_beliefs(this.beliefs2, bl2, hashMap2);
            this.opponent_table.update_beliefs(this.beliefs1, bl, hashMap);
        } else {
            this.player_table.update_beliefs(this.beliefs1, bl, hashMap2);
            this.opponent_table.update_beliefs(this.beliefs2, bl2, hashMap);
        }
    }

    public void update_button_visibility() {
        if (!this.dealt || this.game_over) {
            this.can_raise = false;
            this.can_bet = false;
            this.can_fold = false;
            this.can_check = false;
            this.can_call = false;
            return;
        }
        int n = 0;
        switch (this.round) {
            case 0: {
                n = this.bh1;
                break;
            }
            case 1: {
                n = this.bh2;
                break;
            }
            case 2: {
                n = this.bh3;
            }
        }
        switch (n) {
            case 0: 
            case 1: {
                this.can_bet = true;
                this.can_check = true;
                this.can_raise = false;
                this.can_fold = false;
                this.can_call = false;
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 14: {
                this.can_raise = true;
                this.can_fold = true;
                this.can_call = true;
                this.can_bet = false;
                this.can_check = false;
                break;
            }
            case 7: 
            case 16: {
                this.can_fold = true;
                this.can_call = true;
                this.can_raise = false;
                this.can_bet = false;
                this.can_check = false;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                this.can_raise = false;
                this.can_fold = false;
                this.can_call = false;
                this.can_bet = false;
                this.can_check = false;
            }
        }
    }

    private void advance_round() {
        if (this.round == 2) {
            this.do_showdown();
        } else {
            this.can_raise = false;
            this.can_call = false;
            this.can_bet = true;
            this.can_fold = true;
            this.can_check = true;
            ++this.round;
            if (this.round == 1) {
                this.do_flop = true;
            } else if (this.round == 2) {
                this.do_turn = true;
            }
            this.player_turn = 1 - this.dealer;
        }
    }

    public void do_showdown() {
        this.game_over = true;
        int n = Compare.compare_hands(this.player_card, this.opp_card, this.flop_card, this.turn_card);
        this.winner = "Player shows " + Compare.player1 + "\n" + "Computer shows " + Compare.player2 + "\n";
        if (n == 1) {
            this.winner = this.winner + "Player wins " + this.pot + " chips from the pot.\n";
            this.player_chips += this.pot;
        } else if (n == -1) {
            this.winner = this.winner + "Computer wins " + this.pot + " chips from the pot.\n";
            this.opp_chips += this.pot;
        } else {
            this.winner = this.winner + "Players split the pot.\n";
            this.player_chips += this.pot / 2;
            this.opp_chips += this.pot / 2;
        }
    }

    public String opponent_move() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block0 : switch (this.round) {
            case 0: {
                switch (this.bh1) {
                    case 0: {
                        n = this.player.get_strategy1(this.opp_card, 0);
                        break block0;
                    }
                    case 3: {
                        n = this.player.get_strategy1(this.opp_card, 1);
                        break block0;
                    }
                    case 14: {
                        n = this.player.get_strategy1(this.opp_card, 2);
                        break block0;
                    }
                    case 7: {
                        n = this.player.get_strategy1(this.opp_card, 3);
                        break block0;
                    }
                    case 1: {
                        n = this.player.get_strategy2(this.opp_card, 0);
                        break block0;
                    }
                    case 12: {
                        n = this.player.get_strategy2(this.opp_card, 1);
                        break block0;
                    }
                    case 5: {
                        n = this.player.get_strategy2(this.opp_card, 2);
                        break block0;
                    }
                    case 16: {
                        n = this.player.get_strategy2(this.opp_card, 3);
                        break block0;
                    }
                }
                System.out.println("default reached");
                break;
            }
            case 1: {
                switch (this.bh1) {
                    case 2: {
                        n3 = 0;
                        break;
                    }
                    case 4: {
                        n3 = 1;
                        break;
                    }
                    case 6: {
                        n3 = 2;
                        break;
                    }
                    case 8: {
                        n3 = 3;
                        break;
                    }
                    case 13: {
                        n3 = 4;
                        break;
                    }
                    case 15: {
                        n3 = 5;
                        break;
                    }
                    case 17: {
                        n3 = 6;
                        break;
                    }
                    default: {
                        System.out.println("default reached");
                    }
                }
                switch (this.bh2) {
                    case 0: {
                        n = this.player.get_strategy1(this.opp_card, n3, this.flop_card, 0);
                        break block0;
                    }
                    case 3: {
                        n = this.player.get_strategy1(this.opp_card, n3, this.flop_card, 1);
                        break block0;
                    }
                    case 14: {
                        n = this.player.get_strategy1(this.opp_card, n3, this.flop_card, 2);
                        break block0;
                    }
                    case 7: {
                        n = this.player.get_strategy1(this.opp_card, n3, this.flop_card, 3);
                        break block0;
                    }
                    case 1: {
                        n = this.player.get_strategy2(this.opp_card, n3, this.flop_card, 0);
                        break block0;
                    }
                    case 12: {
                        n = this.player.get_strategy2(this.opp_card, n3, this.flop_card, 1);
                        break block0;
                    }
                    case 5: {
                        n = this.player.get_strategy2(this.opp_card, n3, this.flop_card, 2);
                        break block0;
                    }
                    case 16: {
                        n = this.player.get_strategy2(this.opp_card, n3, this.flop_card, 3);
                        break block0;
                    }
                }
                System.out.println("default reached");
                break;
            }
            case 2: {
                switch (this.bh1) {
                    case 2: {
                        n3 = 0;
                        break;
                    }
                    case 4: {
                        n3 = 1;
                        break;
                    }
                    case 6: {
                        n3 = 2;
                        break;
                    }
                    case 8: {
                        n3 = 3;
                        break;
                    }
                    case 13: {
                        n3 = 4;
                        break;
                    }
                    case 15: {
                        n3 = 5;
                        break;
                    }
                    case 17: {
                        n3 = 6;
                        break;
                    }
                    default: {
                        System.out.println("default reached");
                    }
                }
                switch (this.bh2) {
                    case 2: {
                        n4 = 0;
                        break;
                    }
                    case 4: {
                        n4 = 1;
                        break;
                    }
                    case 6: {
                        n4 = 2;
                        break;
                    }
                    case 8: {
                        n4 = 3;
                        break;
                    }
                    case 13: {
                        n4 = 4;
                        break;
                    }
                    case 15: {
                        n4 = 5;
                        break;
                    }
                    case 17: {
                        n4 = 6;
                        break;
                    }
                    default: {
                        System.out.println("default reached");
                    }
                }
                switch (this.bh3) {
                    case 0: {
                        n = this.player.get_strategy1(this.opp_card, n3, this.flop_card, n4, this.turn_card, 0);
                        break block0;
                    }
                    case 3: {
                        n = this.player.get_strategy1(this.opp_card, n3, this.flop_card, n4, this.turn_card, 1);
                        break block0;
                    }
                    case 14: {
                        n = this.player.get_strategy1(this.opp_card, n3, this.flop_card, n4, this.turn_card, 2);
                        break block0;
                    }
                    case 7: {
                        n = this.player.get_strategy1(this.opp_card, n3, this.flop_card, n4, this.turn_card, 3);
                        break block0;
                    }
                    case 1: {
                        n = this.player.get_strategy2(this.opp_card, n3, this.flop_card, n4, this.turn_card, 0);
                        break block0;
                    }
                    case 12: {
                        n = this.player.get_strategy2(this.opp_card, n3, this.flop_card, n4, this.turn_card, 1);
                        break block0;
                    }
                    case 5: {
                        n = this.player.get_strategy2(this.opp_card, n3, this.flop_card, n4, this.turn_card, 2);
                        break block0;
                    }
                    case 16: {
                        n = this.player.get_strategy2(this.opp_card, n3, this.flop_card, n4, this.turn_card, 3);
                        break block0;
                    }
                }
                System.out.println("default reached");
            }
        }
        int n5 = 0;
        switch (this.round) {
            case 0: {
                n5 = this.bh1;
                break;
            }
            case 1: {
                n5 = this.bh2;
                break;
            }
            case 2: {
                n5 = this.bh3;
                break;
            }
            default: {
                System.out.println("default reached");
            }
        }
        block67 : switch (n5) {
            case 0: 
            case 1: {
                switch (n) {
                    case 0: {
                        n2 = 1;
                        break block67;
                    }
                    case 1: {
                        n2 = 3;
                        break block67;
                    }
                }
                System.out.println("doh");
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 14: {
                switch (n) {
                    case 0: {
                        n2 = 2;
                        break block67;
                    }
                    case 1: {
                        n2 = 0;
                        break block67;
                    }
                    case 2: {
                        n2 = 4;
                        break block67;
                    }
                }
                System.out.println("doh");
                break;
            }
            case 7: 
            case 16: {
                switch (n) {
                    case 0: {
                        n2 = 2;
                        break block67;
                    }
                    case 1: {
                        n2 = 0;
                        break block67;
                    }
                }
                System.out.println("doh");
                break;
            }
            default: {
                System.out.println("doh");
            }
        }
        this.do_action(n2);
        switch (n2) {
            case 0: {
                return new String("Computer calls\n");
            }
            case 2: {
                return new String("Computer folds\n");
            }
            case 4: {
                return new String("Computer raises\n");
            }
            case 3: {
                return new String("Computer bets\n");
            }
            case 1: {
                return new String("Computer checks\n");
            }
        }
        return new String("internal error");
    }

    private void shuffle() {
        this.flop_card = this.random.nextInt(52);
        do {
            this.turn_card = this.random.nextInt(52);
        } while (this.turn_card == this.flop_card);
        do {
            this.opp_card = this.random.nextInt(52);
        } while (this.opp_card == this.flop_card || this.opp_card == this.turn_card);
        do {
            this.player_card = this.random.nextInt(52);
        } while (this.player_card == this.flop_card || this.player_card == this.turn_card || this.player_card == this.opp_card);
        this.dealt = true;
    }
}

