/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class GSI
implements ActionListener {
    JPanel mainPanel;
    JPanel communityPanel;
    JPanel oppPanel;
    JPanel playerPanel;
    JPanel controlPanel;
    JPanel dialogPanel;
    JPanel potPanel;
    ImageIcon backImage;
    ImageIcon[] cardImages = new ImageIcon[52];
    ImageIcon[] smallCardImages = new ImageIcon[52];
    JLabel flopImageLabel;
    JLabel turnImageLabel;
    JLabel oppImageLabel;
    JLabel playerImageLabel;
    boolean opp_visible;
    JLabel oppChips;
    JLabel playerChips;
    JLabel potLabel;
    JButton checkButton;
    JButton foldButton;
    JButton callButton;
    JButton betButton;
    JButton raiseButton;
    JButton dealButton;
    JButton resetButton;
    JTextArea dialogText;
    BeliefTable player_beliefs;
    BeliefTable opponent_beliefs;
    JFrame player_frame;
    JFrame opponent_frame;
    GameState game;
    static /* synthetic */ Class class$GSI;

    public GSI() {
        this.load_card_images();
        this.create_community_panel();
        this.create_opp_panel();
        this.create_player_panel();
        this.create_control_panel();
        this.create_dialog_panel();
        this.create_pot_panel();
        this.create_main_panel();
        this.create_beliefs_windows();
        this.game = new GameState(this.player_beliefs, this.opponent_beliefs);
        this.reset();
    }

    private void reset() {
        this.dialogText.setText("");
        this.dialogText.append("Welcome to GSI.\nSend comments to Andrew Gilpin (gilpin@cs.cmu.edu)\nCard images by John Fitzgibbon (http://www.jfitz.com/cards/)\nGood luck!\n");
        this.playerImageLabel.setIcon(this.backImage);
        this.oppImageLabel.setIcon(this.backImage);
        this.opp_visible = false;
        this.flopImageLabel.setIcon(this.backImage);
        this.turnImageLabel.setIcon(this.backImage);
        this.dealButton.setEnabled(true);
        this.game.reset();
        this.refresh();
    }

    private void refresh() {
        this.oppChips.setText("Chips: " + this.game.opp_chips);
        this.playerChips.setText("Chips: " + this.game.player_chips);
        this.potLabel.setText("Chips: " + this.game.pot);
        this.game.update_button_visibility();
        this.checkButton.setEnabled(this.game.can_check);
        this.foldButton.setEnabled(this.game.can_fold);
        this.callButton.setEnabled(this.game.can_call);
        this.betButton.setEnabled(this.game.can_bet);
        this.raiseButton.setEnabled(this.game.can_raise);
    }

    private void deal() {
        this.dealButton.setEnabled(false);
        this.game.new_game();
        this.turn_over(this.playerImageLabel, this.game.player_card);
        this.oppImageLabel.setIcon(this.backImage);
        this.opp_visible = false;
        this.flopImageLabel.setIcon(this.backImage);
        this.turnImageLabel.setIcon(this.backImage);
        this.dialogText.append("Dealing hole cards\n");
        this.refresh();
    }

    private void turn_over(JLabel jLabel, int n) {
        jLabel.setIcon(this.cardImages[n]);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("deal".equals(actionEvent.getActionCommand())) {
            this.deal();
        } else if ("reset".equals(actionEvent.getActionCommand())) {
            this.reset();
        } else if ("fold".equals(actionEvent.getActionCommand())) {
            this.game.do_action(2);
            this.dialogText.append("Player folds\n");
        } else if ("check".equals(actionEvent.getActionCommand())) {
            this.game.do_action(1);
            this.dialogText.append("Player checks\n");
        } else if ("call".equals(actionEvent.getActionCommand())) {
            this.game.do_action(0);
            this.dialogText.append("Player calls\n");
        } else if ("bet".equals(actionEvent.getActionCommand())) {
            this.game.do_action(3);
            this.dialogText.append("Player bets\n");
        } else if ("raise".equals(actionEvent.getActionCommand())) {
            this.game.do_action(4);
            this.dialogText.append("Player raises\n");
        } else {
            System.out.println("Unexpected action!");
        }
        while (true) {
            if (this.game.player_turn != 1 || this.game.game_over) break;
            if (this.game.do_flop) {
                this.turn_over(this.flopImageLabel, this.game.flop_card);
                this.dialogText.append("Showing flop card\n");
                this.game.do_flop = false;
            }
            if (this.game.do_turn) {
                this.turn_over(this.turnImageLabel, this.game.turn_card);
                this.dialogText.append("Showing turn card\n");
                this.game.do_turn = false;
            }
            if (this.game.game_over && this.game.dealt) {
                this.turn_over(this.oppImageLabel, this.game.opp_card);
                this.opp_visible = true;
            }
            this.opponent_move();
        }
        if (this.game.do_flop) {
            this.turn_over(this.flopImageLabel, this.game.flop_card);
            this.dialogText.append("Showing flop card\n");
            this.game.do_flop = false;
        }
        if (this.game.do_turn) {
            this.turn_over(this.turnImageLabel, this.game.turn_card);
            this.dialogText.append("Showing turn card\n");
            this.game.do_turn = false;
        }
        if (this.game.game_over && this.game.dealt) {
            this.turn_over(this.oppImageLabel, this.game.opp_card);
            this.opp_visible = true;
        }
        if (this.game.game_over) {
            this.game.update_button_visibility();
            this.dealButton.setEnabled(true);
            this.dialogText.append(this.game.winner + "\n");
        }
        this.refresh();
    }

    public void opponent_move() {
        this.dialogText.append(this.game.opponent_move());
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = (class$GSI == null ? (class$GSI = GSI.class$("GSI")) : class$GSI).getResource(string);
        if (uRL == null) {
            System.err.println("Resource not found: " + string);
            return null;
        }
        return new ImageIcon(uRL);
    }

    private void load_card_images() {
        this.backImage = GSI.createImageIcon("images/b1fv.gif");
        String string = "";
        String string2 = "";
        for (int i = 0; i < 52; ++i) {
            switch (i / 13) {
                case 0: {
                    string = "s";
                    break;
                }
                case 1: {
                    string = "c";
                    break;
                }
                case 2: {
                    string = "h";
                    break;
                }
                case 3: {
                    string = "d";
                }
            }
            switch (i % 13) {
                case 0: {
                    string2 = "2";
                    break;
                }
                case 1: {
                    string2 = "3";
                    break;
                }
                case 2: {
                    string2 = "4";
                    break;
                }
                case 3: {
                    string2 = "5";
                    break;
                }
                case 4: {
                    string2 = "6";
                    break;
                }
                case 5: {
                    string2 = "7";
                    break;
                }
                case 6: {
                    string2 = "8";
                    break;
                }
                case 7: {
                    string2 = "9";
                    break;
                }
                case 8: {
                    string2 = "10";
                    break;
                }
                case 9: {
                    string2 = "j";
                    break;
                }
                case 10: {
                    string2 = "q";
                    break;
                }
                case 11: {
                    string2 = "k";
                    break;
                }
                case 12: {
                    string2 = "1";
                }
            }
            this.cardImages[i] = GSI.createImageIcon("images/" + string + string2 + ".gif");
            this.smallCardImages[i] = GSI.createImageIcon("images/" + string + string2 + "_s.gif");
        }
    }

    private void create_community_panel() {
        this.communityPanel = new JPanel();
        this.communityPanel.setBackground(new Color(0, 192, 0));
        this.communityPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Community cards"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.flopImageLabel = new JLabel();
        this.flopImageLabel.setHorizontalAlignment(0);
        this.flopImageLabel.setVerticalAlignment(0);
        this.flopImageLabel.setVerticalTextPosition(0);
        this.flopImageLabel.setHorizontalTextPosition(0);
        this.flopImageLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.flopImageLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0), this.flopImageLabel.getBorder()));
        this.flopImageLabel.setIcon(this.backImage);
        this.flopImageLabel.setText("");
        this.communityPanel.add(this.flopImageLabel);
        this.turnImageLabel = new JLabel();
        this.turnImageLabel.setHorizontalAlignment(0);
        this.turnImageLabel.setVerticalAlignment(0);
        this.turnImageLabel.setVerticalTextPosition(0);
        this.turnImageLabel.setHorizontalTextPosition(0);
        this.turnImageLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.turnImageLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0), this.turnImageLabel.getBorder()));
        this.turnImageLabel.setIcon(this.backImage);
        this.turnImageLabel.setText("");
        this.communityPanel.add(this.turnImageLabel);
    }

    private void create_opp_panel() {
        this.oppPanel = new JPanel();
        this.oppPanel.setBackground(new Color(0, 192, 0));
        this.oppPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Computer"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.oppImageLabel = new JLabel();
        this.oppImageLabel.setHorizontalAlignment(0);
        this.oppImageLabel.setVerticalAlignment(0);
        this.oppImageLabel.setVerticalTextPosition(0);
        this.oppImageLabel.setHorizontalTextPosition(0);
        this.oppImageLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.oppImageLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0), this.oppImageLabel.getBorder()));
        this.oppImageLabel.setIcon(this.backImage);
        this.opp_visible = false;
        this.oppImageLabel.setText("");
        this.oppImageLabel.addMouseListener(new PeekListener(this));
        this.oppPanel.add(this.oppImageLabel);
        this.oppChips = new JLabel();
        this.oppChips.setHorizontalAlignment(0);
        this.oppChips.setVerticalAlignment(0);
        this.oppChips.setVerticalTextPosition(0);
        this.oppChips.setHorizontalTextPosition(0);
        this.oppChips.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.oppChips.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0), this.oppChips.getBorder()));
        this.oppPanel.add(this.oppChips);
    }

    private void create_player_panel() {
        this.playerPanel = new JPanel();
        this.playerPanel.setBackground(new Color(0, 192, 0));
        this.playerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Player"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.playerImageLabel = new JLabel();
        this.playerImageLabel.setHorizontalAlignment(0);
        this.playerImageLabel.setVerticalAlignment(0);
        this.playerImageLabel.setVerticalTextPosition(0);
        this.playerImageLabel.setHorizontalTextPosition(0);
        this.playerImageLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.playerImageLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0), this.playerImageLabel.getBorder()));
        this.playerImageLabel.setIcon(this.backImage);
        this.playerImageLabel.setText("");
        this.playerPanel.add(this.playerImageLabel);
        this.playerChips = new JLabel();
        this.playerChips.setHorizontalAlignment(0);
        this.playerChips.setVerticalAlignment(0);
        this.playerChips.setVerticalTextPosition(0);
        this.playerChips.setHorizontalTextPosition(0);
        this.playerChips.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.playerChips.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0), this.playerChips.getBorder()));
        this.playerPanel.add(this.playerChips);
    }

    private void create_control_panel() {
        this.controlPanel = new JPanel();
        this.controlPanel.setBackground(new Color(0, 192, 0));
        this.controlPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Actions"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.foldButton = new JButton("Fold");
        this.foldButton.setMnemonic(70);
        this.foldButton.setActionCommand("fold");
        this.foldButton.addActionListener(this);
        this.foldButton.setEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.controlPanel.add((Component)this.foldButton, gridBagConstraints);
        this.checkButton = new JButton("Check");
        this.checkButton.setMnemonic(75);
        this.checkButton.setActionCommand("check");
        this.checkButton.addActionListener(this);
        this.checkButton.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.controlPanel.add((Component)this.checkButton, gridBagConstraints);
        this.callButton = new JButton("Call");
        this.callButton.setMnemonic(67);
        this.callButton.setActionCommand("call");
        this.callButton.addActionListener(this);
        this.callButton.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.controlPanel.add((Component)this.callButton, gridBagConstraints);
        this.betButton = new JButton("Bet");
        this.betButton.setMnemonic(66);
        this.betButton.setActionCommand("bet");
        this.betButton.addActionListener(this);
        this.betButton.setEnabled(false);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.controlPanel.add((Component)this.betButton, gridBagConstraints);
        this.raiseButton = new JButton("Raise");
        this.raiseButton.setMnemonic(82);
        this.raiseButton.setActionCommand("raise");
        this.raiseButton.addActionListener(this);
        this.raiseButton.setEnabled(false);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.controlPanel.add((Component)this.raiseButton, gridBagConstraints);
        this.dealButton = new JButton("Deal");
        this.dealButton.setMnemonic(68);
        this.dealButton.setActionCommand("deal");
        this.dealButton.addActionListener(this);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.controlPanel.add((Component)this.dealButton, gridBagConstraints);
        this.resetButton = new JButton("Reset");
        this.resetButton.setMnemonic(83);
        this.resetButton.setActionCommand("reset");
        this.resetButton.addActionListener(this);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.controlPanel.add((Component)this.resetButton, gridBagConstraints);
    }

    private void create_dialog_panel() {
        this.dialogPanel = new JPanel();
        this.dialogPanel.setBackground(new Color(0, 192, 0));
        this.dialogPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Dealer"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.dialogText = new JTextArea(8, 30);
        JScrollPane jScrollPane = new JScrollPane(this.dialogText);
        this.dialogText.setEditable(false);
        this.dialogText.setLineWrap(true);
        this.dialogText.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.dialogPanel.add(jScrollPane);
    }

    private void create_pot_panel() {
        this.potPanel = new JPanel();
        this.potPanel.setBackground(new Color(0, 192, 0));
        this.potPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Pot"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.potLabel = new JLabel();
        this.potLabel.setHorizontalAlignment(0);
        this.potLabel.setVerticalAlignment(0);
        this.potLabel.setVerticalTextPosition(0);
        this.potLabel.setHorizontalTextPosition(0);
        this.potLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.potLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0), this.potLabel.getBorder()));
        this.potPanel.add(this.potLabel);
    }

    private void create_main_panel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setBackground(new Color(0, 192, 0));
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mainPanel.add((Component)this.communityPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.mainPanel.add((Component)this.potPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.mainPanel.add((Component)this.oppPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.mainPanel.add((Component)this.playerPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.mainPanel.add((Component)this.controlPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        this.mainPanel.add((Component)this.dialogPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
    }

    private void create_beliefs_windows() {
        this.player_frame = new JFrame("Player beliefs");
        this.player_beliefs = new BeliefTable(this.smallCardImages);
        this.player_beliefs.setOpaque(true);
        this.player_frame.setContentPane(this.player_beliefs);
        this.player_frame.pack();
        this.opponent_frame = new JFrame("Opponent beliefs");
        this.opponent_beliefs = new BeliefTable(this.smallCardImages);
        this.opponent_beliefs.setOpaque(true);
        this.opponent_frame.setContentPane(this.opponent_beliefs);
        this.opponent_frame.pack();
    }

    public void show_belief_windows(JFrame jFrame) {
        this.player_frame.setLocation(jFrame.getSize().width, 0);
        this.player_frame.setSize(this.player_frame.getSize().width, jFrame.getSize().height);
        this.player_frame.setVisible(true);
        this.opponent_frame.setLocation(jFrame.getSize().width + this.player_frame.getSize().width, 0);
        this.opponent_frame.setSize(this.opponent_frame.getSize().width, jFrame.getSize().height);
        this.opponent_frame.setVisible(true);
    }

    private static void createAndShowGUI() {
        GSI gSI = new GSI();
        JFrame jFrame = new JFrame("GSI: GameShrink Interactive Rhode Island Hold 'Em");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(gSI.mainPanel);
        jFrame.setResizable(false);
        jFrame.setLocation(0, 0);
        jFrame.pack();
        jFrame.setVisible(true);
        gSI.show_belief_windows(jFrame);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GSI.createAndShowGUI();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PeekListener
    extends MouseAdapter {
        Object gsi;

        public PeekListener(Object object) {
            this.gsi = object;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            GSI gSI = (GSI)this.gsi;
            if (gSI.opp_visible) {
                gSI.oppImageLabel.setIcon(gSI.backImage);
                gSI.opp_visible = false;
            } else {
                gSI.turn_over(gSI.oppImageLabel, gSI.game.opp_card);
                gSI.opp_visible = true;
            }
        }
    }
}

