-- name: LOAD
-- description: specifies the latch load input LOAD is TRUE then
-- eventually the value (the negation of the value) of the current
-- data input D will eventually propagate to the output Q (QB).
specification LOAD of LATCH.LATCH(D) is

-- name: POS1
-- description: 
--   if LOAD is TRUE, then if D is TRUE, then eventually
--   Q will be TRUE and QB will be FALSE.
  commit POS1: AG(LOAD => (D => (AF(Q) and AF(not QB))));

-- name: POS2
-- description: 
--   same as POS1, but uses less temporal operators.
  commit POS2: AG(LOAD => (D => (AF(Q and not QB))));

-- name: POS3
-- description: 
--   if LOAD is TRUE, then if D is TRUE, then eventually
--   Q will be TRUE and QB will be FALSE or the signal 
--   RESET will be raised.
  commit POS3: AG(LOAD => (D => (AF(RESET or (Q and not QB)))));

-- name: POS4
-- description: 
--   on the rising edge of LOAD, then if D is TRUE, then 
--   eventually Q will be TRUE and QB will be FALSE or
--   the signal RESET will be raised.
  commit POS4: AG(not LOAD => AX(LOAD => (D => (AF(RESET or (Q and not QB))))));

-- name: NEG1
--   if LOAD is TRUE, then if D is FALSE, then eventually
--   Q will be FALSE and QB will be TRUE.
  commit NEG1: AG(LOAD => (not D => (AF(not Q) and AF(QB))));

-- name: NEG2
-- description: 
--   same as NEG1, but uses less temporal operators.
  commit NEG2: AG(LOAD => (not D => (AF(not Q and QB))));

-- name: NEG3
-- description: 
--   if LOAD is TRUE, then if D is TRUE, then eventually
--   Q will be TRUE and QB will be FALSE or the signal 
--   RESET will be raised.
  commit NEG3: AG(LOAD => (not D => (AF(RESET or (not Q and QB)))));

-- name: NEG4
-- description: 
--   on the rising edge of LOAD, then if D is FALSE, then 
--   eventually Q will be FALSE and QB will be TRUE or
--   the signal RESET will be raised.
  commit NEG4: AG(not LOAD => AX(LOAD => (D => (AF(RESET or (Q and not QB))))));

end specification RESET;

