entity TB is
end TB;

architecture G0 of TB is
  signal CLK : BIT := '0';
  signal REQ0 : BOOLEAN := TRUE;
  signal REQ1 : BOOLEAN := FALSE;
  signal ACK0, ACK1: BOOLEAN;
  component DME2 
    port(CLK: in BIT; REQ0, REQ1: in BOOLEAN; ACK0, ACK1: out BOOLEAN);
  end component;
  for all : DME2 use entity work.mutex2(a2);
begin
  FINITE: process
  begin
    wait for 1 ns;
    CLK <= '1'; REQ0 <= FALSE; REQ1 <= TRUE;
    wait for 1 ns;
    CLK <= '0'; REQ0 <= FALSE; REQ1 <= FALSE;
    wait for 1 ns;
    CLK <= '1'; REQ0 <= TRUE; REQ1 <= TRUE;
    wait for 1 ns;
    CLK <= '0'; REQ0 <= TRUE; REQ1 <= TRUE;
    wait;
  end process;

  INFINITE: process
  begin
    wait for 1 ns;
    CLK <= '1'; REQ0 <= FALSE; REQ1 <= TRUE;
    wait for 1 ns;
    CLK <= '0'; REQ0 <= FALSE; REQ1 <= FALSE;
    wait for 1 ns;
    while TRUE loop
      CLK <= '1'; REQ0 <= TRUE; REQ1 <= TRUE;
      wait for 1 ns;
      CLK <= '0'; REQ0 <= TRUE; REQ1 <= TRUE;
      wait for 1 ns;
    end loop;
  end process;

  TESTED: DME2 port map(CLK, REQ0, REQ1, ACK0, ACK1);

end G0;

