
entity TESTBENCH is
end;

architecture mutex2_a1_safety of TESTBENCH is
  signal clk : bit := '0';
  signal req0 : boolean := false;
  signal req1 : boolean := false;
  signal ack0 : boolean := false;
  signal ack1 : boolean := false;

  component mutex2
    port(clk: in bit; req0: in boolean; req1: in boolean; ack0: out boolean; ack1: out boolean);
  end component;
  for all: mutex2 use entity work.mutex2(a1);
begin
  TEST: mutex2 port map(clk, req0, req1, ack0, ack1);

  stimulus: process
  begin
    clk <= '0';
    req0 <= false;
    req1 <= true;
    wait for 10 ns;

    clk <= '1';
    req0 <= true;
    req1 <= true;
    wait for 10 ns;

    clk <= '0';
    req0 <= false;
    req1 <= true;
    wait for 10 ns;

    clk <= '1';
    req0 <= true;
    req1 <= false;
    wait for 10 ns;

    wait;
  end process;
end;
