entity MUTEX2 is
       ------
  port(       CLK : in BIT ;
       REQ0, REQ1 : in BOOLEAN ;
       ACK0, ACK1 : out BOOLEAN) ;
end MUTEX2 ;

architecture A1 of MUTEX2 is
             --    ------

     signal G0, G1 : BOOLEAN ; 
         signal NO : BOOLEAN ;
     signal O0, O1 : BOOLEAN ;
         signal ZR : BOOLEAN := FALSE ;
          signal T0: BOOLEAN := FALSE ;
          signal T1: BOOLEAN := TRUE ;

   signal PERSIST0 : BOOLEAN ;
   signal REQ_INT0 : BOOLEAN ;
   signal ACK_INT0 : BOOLEAN ;

   signal PERSIST1 : BOOLEAN ;
   signal REQ_INT1 : BOOLEAN ;
   signal ACK_INT1 : BOOLEAN ;

begin

   -- ELEMENT 0 
   CYCLE0 : process
   begin
     wait until (CLK = '1') ; 
     REQ_INT0 <= REQ0 ;
     PERSIST0 <= REQ0 and (PERSIST0 or T1) ;
     T0 <= T1 ;
   end process CYCLE0 ;

   ACK_0 : process
   begin
      wait until (CLK = '0') ; 
      ACK0 <= ACK_INT0 ;
   end process ACK_0 ;

   UPDATE0 : process
   begin
     ACK_INT0 <= REQ_INT0 and ((PERSIST0 and T1) or NO) ;
     G0 <= (not REQ_INT0) or NO ;
     O0 <= O1 or (PERSIST0 and T1) ;
     wait on REQ_INT0, PERSIST0, T1, O1, NO ;  
   end process UPDATE0 ;

   -- ELEMENT 1 
   CYCLE1 : process
   begin
     wait until (CLK = '1') ; 
     REQ_INT1 <= REQ1 ;
     PERSIST1 <= REQ1 and (PERSIST1 or T0) ;
     T1 <= T0 ;
   end process CYCLE1 ;

   ACK_1 : process
   begin
     wait until (CLK = '0') ;  
     ACK1 <= ACK_INT1 ;
   end process ACK_1 ;

   UPDATE1 : process
   begin
     ACK_INT1 <= REQ_INT1 and ((PERSIST1 and T0) or G0) ;
     G1 <= (not REQ_INT1) and G0 ;
     O1 <= ZR or (PERSIST1 and T0) ;
     wait on REQ_INT1, PERSIST1, T0, ZR, G0 ;  
   end process UPDATE1 ;

   -- 
   NEGATION: process
   begin
      NO <= not O0 ;
      wait on O0 ;  
   end process NEGATION ;

end ;

