/** CFile **************************************************************

  FileName    [ model.c ]

  PackageName [ model ]

  Synopsis    [ Required ]

  Description [ Optional ]

  SeeAlso     [ Optional ]

  Author      [ David Deharbe ]

  Copyright   [ Copyright (C) 1996, Carnegie Mellon University.
                All rights reserved. ]

  Revision    [ $Id$ ]

***********************************************************************/

#include "modelInt.h"

static char rcsid [] = "$Id$";

/*--------------------------------------------------------------------*/
/* Structure declarations                                             */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Type declarations                                                  */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Variable declarations                                              */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Macro declarations                                                 */
/*--------------------------------------------------------------------*/

/**AutomaticStart******************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd********************************************************/

/*--------------------------------------------------------------------*/
/* Definition of exported functions                                   */
/*--------------------------------------------------------------------*/

/** Function **
  Synopsis    [ Initializes package use ]
  Description [ This routine initializes various data structures
  and must be called first when the package is used. ]
  SideEffects [ Allocates memory via mem(3). ]
  SeeAlso     [ Model_Final ]
 */
void
model_Init
(void)
{
  ModelCheckRecMgr = mem_new_rec_mgr(sizeof(struct ModelCheckComputation_t_));
  ModelConfigRecMgr = mem_new_rec_mgr(sizeof(struct ModelConfigStruct_t_));
  ModelPathRecMgr = mem_new_rec_mgr(sizeof(struct ModelPathStruct_t_));
}

/** Function **
  Synopsis    [ Finalizes package use ]
  Description [ This routine returns memory used by various data
  structures manipulated by the package. Next package routine
  to be called should be model_Init. ]
  SideEffects [ Disallocates memory. ]
  SeeAlso     [ Model_Init ]
 */
void
model_Final
(void)
{
  mem_free_rec_mgr(ModelCheckRecMgr);
  mem_free_rec_mgr(ModelConfigRecMgr);
  mem_free_rec_mgr(ModelPathRecMgr);
}

/*--------------------------------------------------------------------*/
/* Definition of internal functions                                   */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Definition of static functions                                     */
/*--------------------------------------------------------------------*/

