/**CHeaderFile**

  FileName    [ imgInt.h ]

  PackageName [ img ]

  Synopsis    [ Library internal declarations ]

  Author      [ David Deharbe ]

  Copyright   [ Copyright (C) 1996, Carnegie Mellon University.
                All rights reserved. ]

  Revision    [ 1.1 ]

**/

#ifndef _IMGINTH
#define _IMGINTH

#include <memuser.h>
#include <bdd_up.h>
#include <vbdd.h>
#include <cache.h>
#include <fn.h>

#include "img.h"

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/

typedef struct AtomRec_ {
  struct AtomRec_ * link;
  bdd v;
  bdd f;
} AtomRec, * Atom;

typedef struct RangeVectorRec_ {
  Atom contents;
  bdd info;
} RangeVectorRec, * RangeVector;

typedef struct RangeClassRec_ {
  struct RangeClassRec_ * link;
  struct RangeClassRec_ * prelink;
  Atom contents; /* ordered by (striclty) increasing address of f */
  bdd range;
  long hash;
} RangeClassRec, * RangeClass;

typedef struct img_manager_rec_ {
  bdd_manager bddm;  /* associated bdd manager */
  Atom transitions;  /* transition functions */
  bdd * function_of_var; /* maps variable to function */
  long function_of_var_size;
  rec_mgr AtomMgr;   /* memory managers */
  rec_mgr RangeVectorMgr;
  rec_mgr RangeClassMgr;
  cache1_mgr cache; /* cache where ranges are stored */
  RangeClass * var_id_to_class; /* stores intermediate results */
  long var_id_to_class_size;
  long var_id_to_class_maxsize;
  bdd * support;
} img_manager_rec;

/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

extern bdd imgGetFunction(img_manager t, bdd v);
extern Atom imgSortAtomList(Atom l, fn_compare lt, pointer env);
extern Atom imgInsertAtomList(Atom a, Atom l, fn_compare lt, pointer env);
extern void imgFreeAtomList(img_manager t, Atom l);
extern void imgBuildFunctionOfVar(img_manager t);
extern bdd imgFunctionOfVar(img_manager t, long id);
extern bdd imgRangeRestrict(bdd_manager bddm, bdd f, bdd g);
extern bdd imgRange(img_manager t, RangeVector vector);
extern long imgRangeClassHash(RangeClass c, img_manager t);
extern int imgRangeClassEq(RangeClass c1, RangeClass c2, img_manager t);
extern RangeClass imgRangeClassNew(img_manager t);
extern void imgRangeClassFree(RangeClass c, img_manager t);
extern RangeClass imgRangeClassAdd(img_manager t, RangeClass c, bdd v, bdd f);
extern RangeClass imgRangeClassMerge(img_manager t, RangeClass c1, RangeClass c2);
extern RangeVector imgRangeVectorNew(img_manager t);
extern void imgRangeVectorFree(img_manager t, RangeVector vec);
extern RangeVector imgRangeVectorAdd(img_manager t, RangeVector vec, bdd v, bdd f);
extern bdd imgRangeVectorReachable(img_manager t, RangeVector vec, bdd init);
extern bdd RangeVectorImage(img_manager t, RangeVector v, bdd from);

/**AutomaticEnd***************************************************************/

#endif /* _IMGINTH */
