#include <stdio.h>
#include "cvInt.h"

static void wList (cvn, FILE *);
static void wEntityDeclaration (cvn, FILE *);
static void wArchitectureBody (cvn, FILE *);
static void wPackageDeclaration (cvn, FILE *);
static void wPackageBody (cvn, FILE *);
static void wIntegerType (cvn, FILE *);
static void wEnumerationType (cvn, FILE *);
static void wSubtype (cvn, FILE *);
static void wTypeDeclaration (cvn, FILE *);
static void wSubtypeDeclaration (cvn, FILE *);
static void wSignalDeclaration (cvn, FILE *);
static void wVariableDeclaration (cvn, FILE *);
static void wConstantDeclaration (cvn, FILE *);
static void wUnary (cvn, FILE *);
static void wBinary (cvn, FILE *);
static void wIntegerValue (cvn, FILE *);
static void wRange (cvn, FILE *);
static void wIfStatement (cvn, FILE *);
static void wBranch (cvn, FILE *);
static void wCaseStatement (cvn, FILE *);
static void wWhileStatement (cvn, FILE *);
static void wForStatement (cvn, FILE *);
static void wAlternative (cvn, FILE *);
static void wWaitStatement (cvn, FILE *);
static void wVariableAssignmentStatement (cvn, FILE *);
static void wNullStatement (cvn, FILE *);
static void wWaveform (cvn, FILE *);
static void wSignalAssignmentStatement (cvn, FILE *);
static void wBlockStatement (cvn, FILE *);
static void wProcessStatement (cvn, FILE *);
static void wConditionalWaveform (cvn, FILE *);
static void wConditionalSignalAssignmentStatement (cvn, FILE *);
static void wSelectedSignalAssignmentStatement (cvn, FILE *);
static void wUseClause (cvn, FILE *);
static void wIdentifier (cvn, FILE *);
static void wCharacterLiteral (cvn, FILE *);
static void wEnumeratedLiteral (cvn, FILE *);

typedef void (* write_fn) (cvn, FILE *);
static const write_fn write_fn_tab [] = {
  & wList,
  & wEntityDeclaration,
  & wArchitectureBody,
  & wPackageDeclaration,
  & wPackageBody,
  & wIntegerType,
  & wEnumerationType,
  & wSubtype,
  & wTypeDeclaration,
  & wSubtypeDeclaration,
  & wSignalDeclaration,
  & wVariableDeclaration,
  & wConstantDeclaration,
  & wUnary,
  & wBinary,
  & wIntegerValue,
  & wRange,
  & wIfStatement,
  & wBranch,
  & wCaseStatement,
  & wWhileStatement,
  & wForStatement,
  & wAlternative,
  & wWaitStatement,
  & wVariableAssignmentStatement,
  & wNullStatement,
  & wWaveform,
  & wSignalAssignmentStatement,
  & wBlockStatement,
  & wProcessStatement,
  & wConditionalWaveform,
  & wConditionalSignalAssignmentStatement,
  & wSelectedSignalAssignmentStatement,
  & wUseClause,
  & wIdentifier,
  & wCharacterLiteral,
  & wEnumeratedLiteral};

void
write_cvn
(cvn n, FILE * outstream)
{
  tKind kind = n->header.aKind;
  /* opening delimiter */
  fprintf(outstream, "<%i ", (int) kind);
  /* variable information */
  (* write_fn_tab[(int) kind])(n, outstream);
  /* closing delimiter */
  fprintf(outstream, ">\n");
}

static void
wList
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u %u "
          "%u %u "
          "%u %u ",
          n->List.nNext.unit, n->List.nNext.offset,
          n->List.nPrevious.unit, n->List.nPrevious.offset,
          n->List.nValue.unit, n->List.nValue.offset);
}

static void
wEntityDeclaration
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u "
          "%u %u ",
          n->EntityDeclaration.aLine,
          n->EntityDeclaration.nNext.unit, n->EntityDeclaration.nNext.offset,
          n->EntityDeclaration.nPrevious.unit, n->EntityDeclaration.nPrevious.offset,
          strlen(n->EntityDeclaration.aName), n->EntityDeclaration.aName,
          n->EntityDeclaration.nPorts.unit, n->EntityDeclaration.nPorts.offset,
          n->EntityDeclaration.nDeclarations.unit, n->EntityDeclaration.nDeclarations.offset);
}

static void
wArchitectureBody
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u "
          "%u %u "
          "%u %u ",
          n->ArchitectureBody.aLine,
          n->ArchitectureBody.nNext.unit, n->ArchitectureBody.nNext.offset,
          n->ArchitectureBody.nPrevious.unit, n->ArchitectureBody.nPrevious.offset,
          strlen(n->ArchitectureBody.aName), n->ArchitectureBody.aName,
          n->ArchitectureBody.nDeclarations.unit, n->ArchitectureBody.nDeclarations.offset,
          n->ArchitectureBody.nStatements.unit, n->ArchitectureBody.nStatements.offset,
          n->ArchitectureBody.nPrimary.unit, n->ArchitectureBody.nPrimary.offset);
}

static void
wPackageDeclaration
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u ",
          n->PackageDeclaration.aLine,
          n->PackageDeclaration.nNext.unit, n->PackageDeclaration.nNext.offset,
          n->PackageDeclaration.nPrevious.unit, n->PackageDeclaration.nPrevious.offset,
          strlen(n->PackageDeclaration.aName), n->PackageDeclaration.aName,
          n->PackageDeclaration.nDeclarations.unit, n->PackageDeclaration.nDeclarations.offset);
}

static void
wPackageBody
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u "
          "%u %u ",
          n->PackageBody.aLine,
          n->PackageBody.nNext.unit, n->PackageBody.nNext.offset,
          n->PackageBody.nPrevious.unit, n->PackageBody.nPrevious.offset,
          strlen(n->PackageBody.aName), n->PackageBody.aName,
          n->PackageBody.nDeclarations.unit, n->PackageBody.nDeclarations.offset,
          n->PackageBody.nPrimary.unit, n->PackageBody.nPrimary.offset);
}

static void
wIntegerType
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u %u "
          "%u %u ",
          n->IntegerType.nDeclaration.unit, n->IntegerType.nDeclaration.offset, 
          n->IntegerType.nRange.unit, n->IntegerType.nRange.offset);
}

static void
wEnumerationType
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u %u "
          "%u %u " ,
          n->EnumerationType.nDeclaration.unit, n->EnumerationType.nDeclaration.offset, 
          n->EnumerationType.nElements.unit, n->EnumerationType.nElements.offset);
}

static void
wSubtype
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u %u "
          "%u %u "
          "%u %u ",
          n->Subtype.nDeclaration.unit, n->Subtype.nDeclaration.offset,
          n->Subtype.nBaseType.unit, n->Subtype.nBaseType.offset,
          n->Subtype.nConstraint.unit, n->Subtype.nConstraint.offset);
}

static void
wTypeDeclaration
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u ",
          n->TypeDeclaration.aLine,
          n->TypeDeclaration.nNext.unit, n->TypeDeclaration.nNext.offset,
          n->TypeDeclaration.nPrevious.unit, n->TypeDeclaration.nPrevious.offset,
          strlen(n->TypeDeclaration.aName), n->TypeDeclaration.aName,
          n->TypeDeclaration.nSubtype.unit, n->TypeDeclaration.nSubtype.offset);
}

static void
wSubtypeDeclaration
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u ",
          n->SubtypeDeclaration.aLine,
          n->SubtypeDeclaration.nNext.unit, n->SubtypeDeclaration.nNext.offset,
          n->SubtypeDeclaration.nPrevious.unit, n->SubtypeDeclaration.nPrevious.offset,
          strlen(n->SubtypeDeclaration.aName), n->SubtypeDeclaration.aName,
          n->SubtypeDeclaration.nSubtype.unit, n->SubtypeDeclaration.nSubtype.offset);
}

static void
wSignalDeclaration
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u "
          "%u "
          "%u %u ",
          n->SignalDeclaration.aLine,
          n->SignalDeclaration.nNext.unit, n->SignalDeclaration.nNext.offset,
          n->SignalDeclaration.nPrevious.unit, n->SignalDeclaration.nPrevious.offset,
          strlen(n->SignalDeclaration.aName), n->SignalDeclaration.aName,
          n->SignalDeclaration.nSubtype.unit, n->SignalDeclaration.nSubtype.offset,
          n->SignalDeclaration.aMode,
          n->SignalDeclaration.nDefaultValue.unit, n->SignalDeclaration.nDefaultValue.offset);
}

static void
wVariableDeclaration
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u "
          "%u "
          "%u %u ",
          n->VariableDeclaration.aLine,
          n->VariableDeclaration.nNext.unit, n->VariableDeclaration.nNext.offset,
          n->VariableDeclaration.nPrevious.unit, n->VariableDeclaration.nPrevious.offset,
          strlen(n->VariableDeclaration.aName), n->VariableDeclaration.aName,
          n->VariableDeclaration.nSubtype.unit, n->VariableDeclaration.nSubtype.offset,
          n->VariableDeclaration.aMode,
          n->VariableDeclaration.nInitialValue.unit, n->VariableDeclaration.nInitialValue.offset);
}

static void
wConstantDeclaration
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u "
          "%u %u ",
          n->ConstantDeclaration.aLine,
          n->ConstantDeclaration.nNext.unit, n->ConstantDeclaration.nNext.offset,
          n->ConstantDeclaration.nPrevious.unit, n->ConstantDeclaration.nPrevious.offset,
          strlen(n->ConstantDeclaration.aName), n->ConstantDeclaration.aName,
          n->ConstantDeclaration.nSubtype.unit, n->ConstantDeclaration.nSubtype.offset,
          n->ConstantDeclaration.nValue.unit, n->ConstantDeclaration.nValue.offset);
}

static void
wUnary
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u %u "
          "%u "
          "%u %u ",
          n->Unary.nSubtype.unit, n->Unary.nSubtype.offset,
          n->Unary.aOperator,
          n->Unary.nOperand.unit, n->Unary.nOperand.offset);
}

static void
wBinary
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u %u "
          "%u "
          "%u %u "
          "%u %u ",
          n->Binary.nSubtype.unit, n->Binary.nSubtype.offset,
          n->Binary.aOperator,
          n->Binary.nLeft.unit, n->Binary.nLeft.offset,
          n->Binary.nRight.unit, n->Binary.nRight.offset);
}

static void
wIntegerValue
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u %u "
          "%i ",
          n->IntegerValue.nSubtype.unit, n->IntegerValue.nSubtype.offset,
          n->IntegerValue.aIntegerValue);
}

static void
wRange
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u ",
          n->Range.aDirection,
          n->Range.nLeft.unit, n->Range.nLeft.offset,
          n->Range.nRight.unit, n->Range.nRight.offset);
}

static void
wIfStatement
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u ",
          n->IfStatement.aLine,
          n->IfStatement.nNext.unit, n->IfStatement.nNext.offset,
          n->IfStatement.nPrevious.unit, n->IfStatement.nPrevious.offset,
          strlen(n->IfStatement.aName), n->IfStatement.aName,
          n->IfStatement.nBranches.unit, n->IfStatement.nBranches.offset);
}

static void
wBranch
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u %u "
          "%u %u "
          "%u %u "
          "%u %u ",
          n->Branch.nNext.unit, n->Branch.nNext.offset,
          n->Branch.nPrevious.unit, n->Branch.nPrevious.offset,
          n->Branch.nCondition.unit, n->Branch.nCondition.offset,
          n->Branch.nStatements.unit, n->Branch.nStatements.offset);
}
static void
wCaseStatement
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u "
          "%u %u ",
          n->CaseStatement.aLine,
          n->CaseStatement.nNext.unit, n->CaseStatement.nNext.offset,
          n->CaseStatement.nPrevious.unit, n->CaseStatement.nPrevious.offset,
          strlen(n->CaseStatement.aName), n->CaseStatement.aName,
          n->CaseStatement.nSelector.unit, n->CaseStatement.nSelector.offset,
          n->CaseStatement.nAlternatives.unit, n->CaseStatement.nAlternatives.offset);
}

static void
wWhileStatement
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u "
          "%u %u ",
          n->WhileStatement.aLine,
          n->WhileStatement.nNext.unit, n->WhileStatement.nNext.offset,
          n->WhileStatement.nPrevious.unit, n->WhileStatement.nPrevious.offset,
          strlen(n->WhileStatement.aName), n->WhileStatement.aName,
          n->WhileStatement.nStatements.unit, n->WhileStatement.nStatements.offset,
          n->WhileStatement.nCondition.unit, n->WhileStatement.nCondition.offset);
}

static void
wForStatement
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u "
          "%u %u "
          "%u %u ",
          n->ForStatement.aLine,
          n->ForStatement.nNext.unit, n->ForStatement.nNext.offset,
          n->ForStatement.nPrevious.unit, n->ForStatement.nPrevious.offset,
          strlen(n->ForStatement.aName), n->ForStatement.aName,
          n->ForStatement.nStatements.unit, n->ForStatement.nStatements.offset,
          n->ForStatement.nParameter.unit, n->ForStatement.nParameter.offset,
          n->ForStatement.nRange.unit, n->ForStatement.nRange.offset);
}

static void
wAlternative
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u %u "
          "%u %u "
          "%u %u "
          "%u %u ",
          n->Alternative.nNext.unit, n->Alternative.nNext.offset,
          n->Alternative.nPrevious.unit, n->Alternative.nPrevious.offset,
          n->Alternative.nChoices.unit, n->Alternative.nChoices.offset,
          n->Alternative.nStatements.unit, n->Alternative.nStatements.offset);
}

static void
wWaitStatement
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u "
          "%u %u ",
          n->WaitStatement.aLine,
          n->WaitStatement.nNext.unit, n->WaitStatement.nNext.offset,
          n->WaitStatement.nPrevious.unit, n->WaitStatement.nPrevious.offset,
          strlen(n->WaitStatement.aName), n->WaitStatement.aName,
          n->WaitStatement.nCondition.unit, n->WaitStatement.nCondition.offset,
          n->WaitStatement.nSignals.unit, n->WaitStatement.nSignals.offset);
}

static void
wVariableAssignmentStatement
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u "
          "%u %u ",
          n->VariableAssignmentStatement.aLine,
          n->VariableAssignmentStatement.nNext.unit, n->VariableAssignmentStatement.nNext.offset,
          n->VariableAssignmentStatement.nPrevious.unit, n->VariableAssignmentStatement.nPrevious.offset,
          strlen(n->VariableAssignmentStatement.aName), n->VariableAssignmentStatement.aName,
          n->VariableAssignmentStatement.nTarget.unit, n->VariableAssignmentStatement.nTarget.offset,
          n->VariableAssignmentStatement.nSource.unit, n->VariableAssignmentStatement.nSource.offset);
}

static void
wNullStatement
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s ",
          n->NullStatement.aLine,
          n->NullStatement.nNext.unit, n->NullStatement.nNext.offset,
          n->NullStatement.nPrevious.unit, n->NullStatement.nPrevious.offset,
          strlen(n->NullStatement.aName), n->NullStatement.aName);
}

static void
wWaveform
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u %u ",
          n->Waveform.nValue.unit, n->Waveform.nValue.offset);
}

static void
wSignalAssignmentStatement
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u "
          "%u %u ",
          n->SignalAssignmentStatement.aLine,
          n->SignalAssignmentStatement.nNext.unit, n->SignalAssignmentStatement.nNext.offset,
          n->SignalAssignmentStatement.nPrevious.unit, n->SignalAssignmentStatement.nPrevious.offset,
          strlen(n->SignalAssignmentStatement.aName), n->SignalAssignmentStatement.aName,
          n->SignalAssignmentStatement.nTarget.unit, n->SignalAssignmentStatement.nTarget.offset,
          n->SignalAssignmentStatement.nSource.unit, n->SignalAssignmentStatement.nSource.offset);
}

static void
wBlockStatement
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u "
          "%u %u ",
          n->BlockStatement.aLine,
          n->BlockStatement.nNext.unit, n->BlockStatement.nNext.offset,
          n->BlockStatement.nPrevious.unit, n->BlockStatement.nPrevious.offset,
          strlen(n->BlockStatement.aName), n->BlockStatement.aName,
          n->BlockStatement.nDeclarations.unit, n->BlockStatement.nDeclarations.offset,
          n->BlockStatement.nStatements.unit, n->BlockStatement.nStatements.offset);
}

static void
wProcessStatement
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u "
          "%u %u "
          "%u %u ",
          n->ProcessStatement.aLine,
          n->ProcessStatement.nNext.unit, n->ProcessStatement.nNext.offset,
          n->ProcessStatement.nPrevious.unit, n->ProcessStatement.nPrevious.offset,
          strlen(n->ProcessStatement.aName), n->ProcessStatement.aName,
          n->ProcessStatement.nSensitivityList.unit, n->ProcessStatement.nSensitivityList.offset,
          n->ProcessStatement.nDeclarations.unit, n->ProcessStatement.nDeclarations.offset,
          n->ProcessStatement.nStatements.unit, n->ProcessStatement.nStatements.offset);
}

static void
wConditionalWaveform
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u %u "
          "%u %u "
          "%u %u "
          "%u %u ",
          n->ConditionalWaveform.nNext.unit, n->ConditionalWaveform.nNext.offset,
          n->ConditionalWaveform.nPrevious.unit, n->ConditionalWaveform.nPrevious.offset,
          n->ConditionalWaveform.nCondition.unit, n->ConditionalWaveform.nCondition.offset,
          n->ConditionalWaveform.nValue.unit, n->ConditionalWaveform.nValue.offset);
}

static void
wConditionalSignalAssignmentStatement
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u "
          "%u %u ",
          n->ConditionalSignalAssignmentStatement.aLine,
          n->ConditionalSignalAssignmentStatement.nNext.unit, n->ConditionalSignalAssignmentStatement.nNext.offset,
          n->ConditionalSignalAssignmentStatement.nPrevious.unit, n->ConditionalSignalAssignmentStatement.nPrevious.offset,
          strlen(n->ConditionalSignalAssignmentStatement.aName), n->ConditionalSignalAssignmentStatement.aName,
          n->ConditionalSignalAssignmentStatement.nTarget.unit, n->ConditionalSignalAssignmentStatement.nTarget.offset,
          n->ConditionalSignalAssignmentStatement.nSource.unit, n->ConditionalSignalAssignmentStatement.nSource.offset);
}

static void
wSelectedSignalAssignmentStatement
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u "
          "%u %u "
          "%u %u "
          "%lu %s "
          "%u %u "
          "%u %u "
          "%u %u ",
          n->SelectedSignalAssignmentStatement.aLine,
          n->SelectedSignalAssignmentStatement.nNext.unit, n->SelectedSignalAssignmentStatement.nNext.offset,
          n->SelectedSignalAssignmentStatement.nPrevious.unit, n->SelectedSignalAssignmentStatement.nPrevious.offset,
          strlen(n->SelectedSignalAssignmentStatement.aName), n->SelectedSignalAssignmentStatement.aName,
          n->SelectedSignalAssignmentStatement.nTarget.unit, n->SelectedSignalAssignmentStatement.nTarget.offset,
          n->SelectedSignalAssignmentStatement.nSelector.unit, n->SelectedSignalAssignmentStatement.nSelector.offset,
          n->SelectedSignalAssignmentStatement.nAlternatives.unit, n->SelectedSignalAssignmentStatement.nAlternatives.offset);
}

static void
wUseClause
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%u %u "
          "%u %u "
          "%u %u ",
          n->UseClause.nNext.unit, n->UseClause.nNext.offset,
          n->UseClause.nPrevious.unit, n->UseClause.nPrevious.offset,
          n->UseClause.nSelectedNames.unit, n->UseClause.nSelectedNames.offset);
}

static void
wIdentifier
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%lu %s "
          "%u %u ",
          strlen(n->Identifier.aName), n->Identifier.aName,
          n->Identifier.nDeclaration.unit, n->Identifier.nDeclaration.offset);
}

static void
wCharacterLiteral
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%lu %s "
          "%u "
          "%u %u ",
          strlen(n->CharacterLiteral.aName), n->CharacterLiteral.aName,
          n->CharacterLiteral.aOrdinalValue,
          n->CharacterLiteral.nDeclaration.unit, n->CharacterLiteral.nDeclaration.offset);
}

static void
wEnumeratedLiteral
(cvn n, FILE * outstream)
{
  fprintf(outstream,
          "%lu %s "
          "%u "
          "%u %u ",
          strlen(n->EnumeratedLiteral.aName), n->EnumeratedLiteral.aName,
          n->EnumeratedLiteral.aOrdinalValue,
          n->EnumeratedLiteral.nDeclaration.unit, n->EnumeratedLiteral.nDeclaration.offset);
}

