/** CFile **************************************************************

  FileName    [ wait.c ]

  PackageName [ cv ]

  Synopsis    [ Utilities for the wait statement ]

  Description [ ]

  SeeAlso     [ cvu.h ]

  Author      [ David Deharbe ]

  Copyright   [ Copyright (C) 1996, Carnegie Mellon University.
                All rights reserved. ]

  Revision    [ $Id$ ]

***********************************************************************/

#include "cvInt.h"
#include <Errors.h>

static char rcsid [] = "$Id$";

/*--------------------------------------------------------------------*/
/* Structure declarations                                             */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Type declarations                                                  */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Variable declarations                                              */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Macro declarations                                                 */
/*--------------------------------------------------------------------*/

/**AutomaticStart******************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd********************************************************/

/*--------------------------------------------------------------------*/
/* Definition of exported functions                                   */
/*--------------------------------------------------------------------*/

/** Function **
  Synopsis    [ Computes the sensitivity list of a wait statement ]
  Description [ The argument kind must be kWaitStatement, otherwise
  an error message is printed to stdout, and 0 is returned.
  The routine builds a list of identifiers corresponding the set
  of signals this statement is sensitive to. ]
  SideEffects [ Sends output to stdout if an error occurs ]
  Allocates memory to store the result. ]
  SeeAlso     [ optional ]
 */

cvn
cv_wait_sensitivity_list
(const cvn stm)
{
  cvn sensitivity;
  if (qKind(stm) != kWaitStatement) {
    Message("cv_wait_sensitivity_list: parameter is not a wait statement",
            xxError, NoPosition);
    return 0;
  }
  sensitivity = qSignals(stm) ;
  if (NullNode(sensitivity)) {
    sensitivity = cv_signal_support(qCondition(stm));
  }
  return sensitivity;
}

/*--------------------------------------------------------------------*/
/* Definition of internal functions                                   */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Definition of static functions                                     */
/*--------------------------------------------------------------------*/

