#include <memuser.h>
#include "cvInt.h"

static void translate_ref (ref * r, unsigned * a);

static void tList (cvn, unsigned *);
static void tEntityDeclaration (cvn, unsigned *);
static void tArchitectureBody (cvn, unsigned *);
static void tPackageDeclaration (cvn, unsigned *);
static void tPackageBody (cvn, unsigned *);
static void tIntegerType (cvn, unsigned *);
static void tEnumerationType (cvn, unsigned *);
static void tSubtype (cvn, unsigned *);
static void tTypeDeclaration (cvn, unsigned *);
static void tSubtypeDeclaration (cvn, unsigned *);
static void tSignalDeclaration (cvn, unsigned *);
static void tVariableDeclaration (cvn, unsigned *);
static void tConstantDeclaration (cvn, unsigned *);
static void tUnary (cvn, unsigned *);
static void tBinary (cvn, unsigned *);
static void tIntegerValue (cvn, unsigned *);
static void tRange (cvn, unsigned *);
static void tIfStatement (cvn, unsigned *);
static void tBranch (cvn, unsigned *);
static void tCaseStatement (cvn, unsigned *);
static void tWhileStatement (cvn, unsigned *);
static void tForStatement (cvn, unsigned *);
static void tAlternative (cvn, unsigned *);
static void tWaitStatement (cvn, unsigned *);
static void tVariableAssignmentStatement (cvn, unsigned *);
static void tNullStatement (cvn, unsigned *);
static void tWaveform (cvn, unsigned *);
static void tSignalAssignmentStatement (cvn, unsigned *);
static void tBlockStatement (cvn, unsigned *);
static void tProcessStatement (cvn, unsigned *);
static void tConditionalWaveform (cvn, unsigned *);
static void tConditionalSignalAssignmentStatement (cvn, unsigned *);
static void tSelectedSignalAssignmentStatement (cvn, unsigned *);
static void tUseClause (cvn, unsigned *);
static void tIdentifier (cvn, unsigned *);
static void tCharacterLiteral (cvn, unsigned *);
static void tEnumeratedLiteral (cvn, unsigned *);

typedef void (* translate_fn) (cvn, unsigned *);

translate_fn translate_fn_tab[] = {
tList,
tEntityDeclaration,
tArchitectureBody,
tPackageDeclaration,
tPackageBody,
tIntegerType,
tEnumerationType,
tSubtype,
tTypeDeclaration,
tSubtypeDeclaration,
tSignalDeclaration,
tVariableDeclaration,
tConstantDeclaration,
tUnary,
tBinary,
tIntegerValue,
tRange,
tIfStatement,
tBranch,
tCaseStatement,
tWhileStatement,
tForStatement,
tAlternative,
tWaitStatement,
tVariableAssignmentStatement,
tNullStatement,
tWaveform,
tSignalAssignmentStatement,
tBlockStatement,
tProcessStatement,
tConditionalWaveform,
tConditionalSignalAssignmentStatement,
tSelectedSignalAssignmentStatement,
tUseClause,
tIdentifier,
tCharacterLiteral,
tEnumeratedLiteral
};

void
translate_cvn
(cvn n,
 unsigned * a)
{
  (* translate_fn_tab[qKind(n)])(n, a);
}

void
translate_ref
(ref * r,
 unsigned * a)
{
  if (r->unit != no_unit) {
    r->unit = a[r->unit];
  }
}

void
tList
(cvn n, unsigned * a)
{
  translate_ref(& n->List.nNext, a);
  translate_ref(& n->List.nPrevious, a);
  translate_ref(& n->List.nValue, a);
}

void
tEntityDeclaration
(cvn n, unsigned * a)
{
  translate_ref(& n->EntityDeclaration.nNext, a);
  translate_ref(& n->EntityDeclaration.nPrevious, a);
  translate_ref(& n->EntityDeclaration.nPorts, a);
  translate_ref(& n->EntityDeclaration.nDeclarations, a);
}

void
tArchitectureBody
(cvn n, unsigned * a)
{
  translate_ref(& n->ArchitectureBody.nNext, a);
  translate_ref(& n->ArchitectureBody.nPrevious, a);
  translate_ref(& n->ArchitectureBody.nDeclarations, a);
  translate_ref(& n->ArchitectureBody.nStatements, a);
  translate_ref(& n->ArchitectureBody.nPrimary, a);
}

void
tPackageDeclaration
(cvn n, unsigned * a)
{
  translate_ref(& n->PackageDeclaration.nNext, a);
  translate_ref(& n->PackageDeclaration.nPrevious, a);
  translate_ref(& n->PackageDeclaration.nDeclarations, a);
}

void
tPackageBody
(cvn n, unsigned * a)
{
  translate_ref(& n->PackageBody.nNext, a);
  translate_ref(& n->PackageBody.nPrevious, a);
  translate_ref(& n->PackageBody.nDeclarations, a);
  translate_ref(& n->PackageBody.nPrimary, a);
}

void
tIntegerType
(cvn n, unsigned * a)
{
  translate_ref(& n->IntegerType.nDeclaration, a);
  translate_ref(& n->IntegerType.nRange, a);
}

void
tEnumerationType
(cvn n, unsigned * a)
{
  translate_ref(& n->EnumerationType.nDeclaration, a);
  translate_ref(& n->EnumerationType.nElements, a);
}

void
tSubtype
(cvn n, unsigned * a)
{
  translate_ref(& n->Subtype.nDeclaration, a);
  translate_ref(& n->Subtype.nBaseType, a);
  translate_ref(& n->Subtype.nConstraint, a);
}

void
tTypeDeclaration
(cvn n, unsigned * a)
{
  translate_ref(& n->TypeDeclaration.nNext, a);
  translate_ref(& n->TypeDeclaration.nPrevious, a);
  translate_ref(& n->TypeDeclaration.nSubtype, a);
}

void
tSubtypeDeclaration
(cvn n, unsigned * a)
{
  translate_ref(& n->SubtypeDeclaration.nNext, a);
  translate_ref(& n->SubtypeDeclaration.nPrevious, a);
  translate_ref(& n->SubtypeDeclaration.nSubtype, a);
}

void
tSignalDeclaration
(cvn n, unsigned * a)
{
  translate_ref(& n->SignalDeclaration.nNext, a);
  translate_ref(& n->SignalDeclaration.nPrevious, a);
  translate_ref(& n->SignalDeclaration.nSubtype, a);
  translate_ref(& n->SignalDeclaration.nDefaultValue, a);
}

void
tVariableDeclaration
(cvn n, unsigned * a)
{
  translate_ref(& n->VariableDeclaration.nNext, a);
  translate_ref(& n->VariableDeclaration.nPrevious, a);
  translate_ref(& n->VariableDeclaration.nSubtype, a);
  translate_ref(& n->VariableDeclaration.nInitialValue, a);
}

void
tConstantDeclaration
(cvn n, unsigned * a)
{
 translate_ref(& n->ConstantDeclaration.nNext, a);
 translate_ref(& n->ConstantDeclaration.nPrevious, a);
 translate_ref(& n->ConstantDeclaration.nSubtype, a);
 translate_ref(& n->ConstantDeclaration.nValue, a);
}

void
tUnary
(cvn n, unsigned * a)
{
 translate_ref(& n->Unary.nSubtype, a);
 translate_ref(& n->Unary.nOperand, a);
}

void
tBinary
(cvn n, unsigned * a)
{
 translate_ref(& n->Binary.nSubtype, a);
 translate_ref(& n->Binary.nLeft, a);
 translate_ref(& n->Binary.nRight, a);
}

void
tIntegerValue
(cvn n, unsigned * a)
{
 translate_ref(& n->IntegerValue.nSubtype, a);
}

void
tRange
(cvn n, unsigned * a)
{
 translate_ref(& n->Range.nLeft, a);
 translate_ref(& n->Range.nRight, a);
}

void
tIfStatement
(cvn n, unsigned * a)
{
 translate_ref(& n->IfStatement.nNext, a);
 translate_ref(& n->IfStatement.nPrevious, a);
 translate_ref(& n->IfStatement.nBranches, a);
}

void
tBranch
(cvn n, unsigned * a)
{
 translate_ref(& n->Branch.nNext, a);
 translate_ref(& n->Branch.nPrevious, a);
 translate_ref(& n->Branch.nCondition, a);
 translate_ref(& n->Branch.nStatements, a);
}

void
tCaseStatement
(cvn n, unsigned * a)
{
 translate_ref(& n->CaseStatement.nNext, a);
 translate_ref(& n->CaseStatement.nPrevious, a);
 translate_ref(& n->CaseStatement.nSelector, a);
 translate_ref(& n->CaseStatement.nAlternatives, a);
}

void
tWhileStatement
(cvn n, unsigned * a)
{
 translate_ref(& n->WhileStatement.nNext, a);
 translate_ref(& n->WhileStatement.nPrevious, a);
 translate_ref(& n->WhileStatement.nStatements, a);
 translate_ref(& n->WhileStatement.nCondition, a);
}

void
tForStatement
(cvn n, unsigned * a)
{
 translate_ref(& n->ForStatement.nNext, a);
 translate_ref(& n->ForStatement.nPrevious, a);
 translate_ref(& n->ForStatement.nStatements, a);
 translate_ref(& n->ForStatement.nParameter, a);
 translate_ref(& n->ForStatement.nRange, a);
}

void
tAlternative
(cvn n, unsigned * a)
{
 translate_ref(& n->Alternative.nNext, a);
 translate_ref(& n->Alternative.nPrevious, a);
 translate_ref(& n->Alternative.nChoices, a);
 translate_ref(& n->Alternative.nStatements, a);
}

void
tWaitStatement
(cvn n, unsigned * a)
{
 translate_ref(& n->WaitStatement.nNext, a);
 translate_ref(& n->WaitStatement.nPrevious, a);
 translate_ref(& n->WaitStatement.nCondition, a);
 translate_ref(& n->WaitStatement.nSignals, a);
}

void
tVariableAssignmentStatement
(cvn n, unsigned * a)
{
 translate_ref(& n->VariableAssignmentStatement.nNext, a);
 translate_ref(& n->VariableAssignmentStatement.nPrevious, a);
 translate_ref(& n->VariableAssignmentStatement.nTarget, a);
 translate_ref(& n->VariableAssignmentStatement.nSource, a);
}

void
tNullStatement
(cvn n, unsigned * a)
{
 translate_ref(& n->NullStatement.nNext, a);
 translate_ref(& n->NullStatement.nPrevious, a);
}

void
tWaveform
(cvn n, unsigned * a)
{
 translate_ref(& n->Waveform.nValue, a);
}

void
tSignalAssignmentStatement
(cvn n, unsigned * a)
{
 translate_ref(& n->SignalAssignmentStatement.nNext, a);
 translate_ref(& n->SignalAssignmentStatement.nPrevious, a);
 translate_ref(& n->SignalAssignmentStatement.nTarget, a);
 translate_ref(& n->SignalAssignmentStatement.nSource, a);
}

void
tBlockStatement
(cvn n, unsigned * a)
{
 translate_ref(& n->BlockStatement.nNext, a);
 translate_ref(& n->BlockStatement.nPrevious, a);
 translate_ref(& n->BlockStatement.nDeclarations, a);
 translate_ref(& n->BlockStatement.nStatements, a);
}

void
tProcessStatement
(cvn n, unsigned * a)
{
 translate_ref(& n->ProcessStatement.nNext, a);
 translate_ref(& n->ProcessStatement.nPrevious, a);
 translate_ref(& n->ProcessStatement.nSensitivityList, a);
 translate_ref(& n->ProcessStatement.nDeclarations, a);
 translate_ref(& n->ProcessStatement.nStatements, a);
}

void
tConditionalWaveform
(cvn n, unsigned * a)
{
 translate_ref(& n->ConditionalWaveform.nNext, a);
 translate_ref(& n->ConditionalWaveform.nPrevious, a);
 translate_ref(& n->ConditionalWaveform.nValue, a);
 translate_ref(& n->ConditionalWaveform.nCondition, a);
}

void
tConditionalSignalAssignmentStatement
(cvn n, unsigned * a)
{
 translate_ref(& n->ConditionalSignalAssignmentStatement.nNext, a);
 translate_ref(& n->ConditionalSignalAssignmentStatement.nPrevious, a);
 translate_ref(& n->ConditionalSignalAssignmentStatement.nTarget, a);
 translate_ref(& n->ConditionalSignalAssignmentStatement.nSource, a);
}

void
tSelectedSignalAssignmentStatement
(cvn n, unsigned * a)
{
 translate_ref(& n->SelectedSignalAssignmentStatement.nNext, a);
 translate_ref(& n->SelectedSignalAssignmentStatement.nPrevious, a);
 translate_ref(& n->SelectedSignalAssignmentStatement.nTarget, a);
 translate_ref(& n->SelectedSignalAssignmentStatement.nSelector, a);
 translate_ref(& n->SelectedSignalAssignmentStatement.nAlternatives, a);
}

void
tUseClause
(cvn n, unsigned * a)
{
 translate_ref(& n->UseClause.nNext, a);
 translate_ref(& n->UseClause.nPrevious, a);
 translate_ref(& n->UseClause.nSelectedNames, a);
}

void
tIdentifier
(cvn n, unsigned * a)
{
 translate_ref(& n->Identifier.nDeclaration, a);
}

void
tCharacterLiteral
(cvn n, unsigned * a)
{
 translate_ref(& n->CharacterLiteral.nDeclaration, a);
}

void
tEnumeratedLiteral
(cvn n, unsigned * a)
{
 translate_ref(& n->EnumeratedLiteral.nDeclaration, a);
}

