#include "Errors.h"
#include "cvInt.h"

void
sNext
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return ;
  switch (qKind(t)) {
    case kList :
      ptr = & t->List.nNext;
      break;
    case kEntityDeclaration :
      ptr = & t->EntityDeclaration.nNext;
      break;
    case kArchitectureBody :
      ptr = & t->ArchitectureBody.nNext;
      break;
    case kPackageDeclaration :
      ptr = & t->PackageDeclaration.nNext;
      break;
    case kPackageBody :
      ptr = & t->PackageBody.nNext;
      break;
    case kSignalDeclaration :
      ptr = & t->SignalDeclaration.nNext;
      break;
    case kVariableDeclaration :
      ptr = & t->VariableDeclaration.nNext;
      break;
    case kConstantDeclaration :
      ptr = & t->ConstantDeclaration.nNext;
      break;
    case kTypeDeclaration :
      ptr = & t->TypeDeclaration.nNext;
      break;
    case kSubtypeDeclaration :
      ptr = & t->SubtypeDeclaration.nNext;
      break;
    case kProcessStatement :
      ptr = & t->ProcessStatement.nNext;
      break;
    case kBlockStatement :
      ptr = & t->BlockStatement.nNext;
      break;
    case kIfStatement :
      ptr = & t->IfStatement.nNext;
      break;
    case kCaseStatement :
      ptr = & t->CaseStatement.nNext;
      break;
    case kNullStatement :
      ptr = & t->CaseStatement.nNext;
      break;
    case kBranch :
      ptr = & t->Branch.nNext;
      break;
    case kWaitStatement :
      ptr = & t->WaitStatement.nNext;
      break;
    case kVariableAssignmentStatement :
      ptr = & t->VariableAssignmentStatement.nNext;
      break;
    case kSignalAssignmentStatement :
      ptr = & t->SignalAssignmentStatement.nNext;
      break;
    case kConditionalSignalAssignmentStatement :
      ptr = & t->ConditionalSignalAssignmentStatement.nNext;
      break;
    case kSelectedSignalAssignmentStatement :
      ptr = & t->SelectedSignalAssignmentStatement.nNext;
      break;
    case kAlternative :
      ptr = & t->Alternative.nNext;
      break;
    case kConditionalWaveform :
      ptr = & t->ConditionalWaveform.nNext;
      break;
    case kUseClause :
      ptr = & t->UseClause.nNext;
      break;
    default :
      Message("(libcv.a) sNext - no nNext value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

void
sPrevious
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kList :
      ptr = & t->List.nPrevious;
      break;
    case kEntityDeclaration :
      ptr = & t->EntityDeclaration.nPrevious;
      break;
    case kArchitectureBody :
      ptr = & t->ArchitectureBody.nPrevious;
      break;
    case kPackageDeclaration :
      ptr = & t->PackageDeclaration.nPrevious;
      break;
    case kPackageBody :
      ptr = & t->PackageBody.nPrevious;
      break;
    case kSignalDeclaration :
      ptr = & t->SignalDeclaration.nPrevious;
      break;
    case kVariableDeclaration :
      ptr = & t->VariableDeclaration.nPrevious;
      break;
    case kConstantDeclaration :
      ptr = & t->ConstantDeclaration.nPrevious;
      break;
    case kTypeDeclaration :
      ptr = & t->TypeDeclaration.nPrevious;
      break;
    case kSubtypeDeclaration :
      ptr = & t->SubtypeDeclaration.nPrevious;
      break;
    case kProcessStatement :
      ptr = & t->ProcessStatement.nPrevious;
      break;
    case kBlockStatement :
      ptr = & t->BlockStatement.nPrevious;
      break;
    case kIfStatement :
      ptr = & t->IfStatement.nPrevious;
      break;
    case kCaseStatement :
      ptr = & t->CaseStatement.nPrevious;
      break;
    case kNullStatement :
      ptr = & t->CaseStatement.nPrevious;
      break;
    case kBranch :
      ptr = & t->Branch.nPrevious;
      break;
    case kWaitStatement :
      ptr = & t->WaitStatement.nPrevious;
      break;
    case kVariableAssignmentStatement :
      ptr = & t->VariableAssignmentStatement.nPrevious;
      break;
    case kSignalAssignmentStatement :
      ptr = & t->SignalAssignmentStatement.nPrevious;
      break;
    case kConditionalSignalAssignmentStatement :
      ptr = & t->ConditionalSignalAssignmentStatement.nPrevious;
      break;
    case kAlternative :
      ptr = & t->Alternative.nPrevious;
      break;
    case kConditionalWaveform :
      ptr = & t->ConditionalWaveform.nPrevious;
      break;
    case kUseClause :
      ptr = & t->UseClause.nPrevious;
      break;
    default :
      Message("(libcv.a) sPrevious - no nPrevious value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

void
sValue
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kList :
      ptr = & t->List.nValue;
      break;
    case kWaveform :
      ptr = & t->Waveform.nValue;
      break;
    case kConditionalWaveform :
      ptr = & t->ConditionalWaveform.nValue;
      break;
    case kConstantDeclaration :
      ptr = & t->ConstantDeclaration.nValue;
      break;
    default :
      Message("(libcv.a) sValue - no nValue value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sSensitivityList
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kProcessStatement :
      ptr = & t->ProcessStatement.nSensitivityList;
      break;
    default :
      Message("(libcv.a) sSensitivityList - no nSensitivityList value",
              xxRepair, NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sDeclarations
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kEntityDeclaration :
      ptr = & t->EntityDeclaration.nDeclarations;
      break;
    case kArchitectureBody :
      ptr = & t->ArchitectureBody.nDeclarations;
      break;
    case kPackageDeclaration :
      ptr = & t->PackageDeclaration.nDeclarations;
      break;
    case kPackageBody :
      ptr = & t->PackageBody.nDeclarations;
      break;
    case kProcessStatement :
      ptr = & t->ProcessStatement.nDeclarations;
      break;
    case kBlockStatement :
      ptr = & t->BlockStatement.nDeclarations;
      break;
    default :
      Message("(libcv.a) sDeclarations - no nDeclarations value", 
              xxRepair, NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sStatements
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
   switch (qKind(t)) {
    case kArchitectureBody :
      ptr = & t->ArchitectureBody.nStatements;
      break;
    case kProcessStatement :
      ptr = & t->ProcessStatement.nStatements;
      break;
    case kBlockStatement :
      ptr = & t->BlockStatement.nStatements;
      break;
    case kWhileStatement :
      ptr = & t->WhileStatement.nStatements;
      break;
    case kForStatement :
      ptr = & t->ForStatement.nStatements;
      break;
    case kBranch :
      ptr = & t->Branch.nStatements;
      break;
    case kAlternative :
      ptr = & t->Alternative.nStatements;
      break;
    default :
      Message("(libcv.a) sStatements - no nStatements value", 
              xxRepair, NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}


/* ------------------------------------------------------------------------ */
void
sPorts
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kEntityDeclaration :
      ptr = & t->EntityDeclaration.nPorts;
      break;
    default :
      Message("(libcv.a) sPorts - no nPorts value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sPrimary
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kArchitectureBody :
      ptr = & t->ArchitectureBody.nPrimary;
      break;
    case kPackageBody :
      ptr = & t->PackageBody.nPrimary;
      break;
    default :
      Message("(libcv.a) sPrimary - no nPrimary value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sDeclaration
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kIdentifier :
      ptr = & t->Identifier.nDeclaration;
      break;
    case kCharacterLiteral :
      ptr = & t->CharacterLiteral.nDeclaration;
      break;
    case kEnumeratedLiteral :
      ptr = & t->EnumeratedLiteral.nDeclaration;
      break;
    case kEnumerationType :
      ptr = & t->EnumerationType.nDeclaration;
      break;
    case kIntegerType :
      ptr = & t->IntegerType.nDeclaration;
      break;
    case kSubtype :
      ptr = & t->Subtype.nDeclaration;
      break;
    default :
      Message("(libcv.a) sDeclaration - no nDeclaration value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sLeft
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kBinary :
      ptr = & t->Binary.nLeft;
      break;
    case kRange :
      ptr = & t->Range.nLeft;
      break;
    default :
      Message("(libcv.a) sLeft - no nLeft value", xxRepair, NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sRight
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kBinary :
      ptr = & t->Binary.nRight;
      break;
    case kRange :
      ptr = & t->Range.nRight;
      break;
    default :
      Message("(libcv.a) sRight - no nRight value", xxRepair, NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sRange
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kIntegerType :
      ptr = & t->IntegerType.nRange;
      break;
    default :
      Message("(libcv.a) sRange - no nRange value", xxRepair,
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sElements
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kEnumerationType :
      ptr = & t->EnumerationType.nElements;
      break;
    default :
      Message("(libcv.a) sElements - no nElements value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sSubtype
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kSignalDeclaration :
      ptr = & t->SignalDeclaration.nSubtype;
      break;
    case kVariableDeclaration :
      ptr = & t->VariableDeclaration.nSubtype;
      break;
    case kConstantDeclaration :
      ptr = & t->ConstantDeclaration.nSubtype;
      break;
    case kTypeDeclaration :
      ptr = & t->TypeDeclaration.nSubtype;
      break;
    case kSubtypeDeclaration :
      ptr = & t->SubtypeDeclaration.nSubtype;
      break;
    case kIntegerValue :
      ptr = & t->IntegerValue.nSubtype;
      break;
    case kUnary :
      ptr = & t->Unary.nSubtype;
      break;
    case kBinary :
      ptr = & t->Binary.nSubtype;
      break;
    case kCharacterLiteral :
    case kEnumeratedLiteral :
      sSubtype(qDeclaration(t), c);
      return;
    case kIdentifier : { 
      cvn decl = qDeclaration(t);
      if (IsA(decl, kSignalDeclaration) ||
          IsA(decl, kVariableDeclaration) ||
          IsA(decl, kConstantDeclaration))
	  sSubtype(decl, c);
          return;
    /* else error: goes through on purpose */
    }
    default :
      Message("(libcv.a) sSubtype - no nSubtype value", xxRepair, NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sBaseType
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kSubtype :
      ptr = & t->Subtype.nBaseType;
      break;
    default :
      Message("(libcv.a) sBaseType - no nBaseType value", xxRepair, NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sConstraint
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kSubtype :
      ptr = & t->Subtype.nConstraint;
      break;
    default :
      Message("(libcv.a) sConstraint - no nConstraint value", xxRepair, NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sSelectedNames
(const cvn t, const cvn s)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kUseClause :
      ptr = & t->UseClause.nSelectedNames;
      break;
    default :
      Message("(libcv.a) sSelectedNames - no nSelectedNames value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, s);
}

/* ------------------------------------------------------------------------ */
void
sDefaultValue
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kSignalDeclaration :
      ptr = & t->SignalDeclaration.nDefaultValue;
      break;
    default :
      Message("(libcv.a) sDefaultValue - no nDefaultValue value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sInitialValue
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kVariableDeclaration :
      ptr = & t->VariableDeclaration.nInitialValue;
      break;
    default :
      Message("(libcv.a) sInitialValue - no nInitialValue value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sOperand
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
   switch (qKind(t)) {
    case kUnary :
      ptr = & t->Unary.nOperand;
      break;
    default :
      Message("(libcv.a) sOperand - no nOperand value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sBranches
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kIfStatement :
      ptr = & t->IfStatement.nBranches;
      break;
    default :
      Message("(libcv.a) sBranches - no nBranches value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sCondition
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kWaitStatement :
      ptr = & t->WaitStatement.nCondition;
      break;
    case kConditionalWaveform :
      ptr = & t->ConditionalWaveform.nCondition;
      break;
    case kBranch :
      ptr = & t->Branch.nCondition;
      break;
    default :
      Message("(libcv.a) sCondition - no nCondition value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sSelector
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kCaseStatement :
      ptr = & t->CaseStatement.nSelector;
      break;
    case kSelectedSignalAssignmentStatement :
      ptr = & t->SelectedSignalAssignmentStatement.nSelector;
      break;
    default :
      Message("(libcv.a) sSelector - no nSelector value", xxRepair, 
	      NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sAlternatives
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kCaseStatement :
      ptr = & t->CaseStatement.nAlternatives;
      break;
    case kSelectedSignalAssignmentStatement :
      ptr = & t->SelectedSignalAssignmentStatement.nAlternatives;
      break;
    default :
      Message("(libcv.a) sSelector - no nSelector value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sChoices
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
   switch (qKind(t)) {
    case kAlternative :
      ptr = & t->Alternative.nChoices;
      break;
    default :
      Message("(libcv.a) sChoices - no nChoices value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sSignals
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kWaitStatement :
      ptr = & t->WaitStatement.nSignals;
      break;
    default :
      Message("(libcv.a) sSignals - no nSignals value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sTarget
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kSignalAssignmentStatement :
      ptr = & t->SignalAssignmentStatement.nTarget;
      break;
    case kConditionalSignalAssignmentStatement :
      ptr = & t->ConditionalSignalAssignmentStatement.nTarget;
      break;
    case kSelectedSignalAssignmentStatement :
      ptr = & t->SelectedSignalAssignmentStatement.nTarget;
      break;
    case kVariableAssignmentStatement :
      ptr = & t->VariableAssignmentStatement.nTarget;
      break;
    default :
      Message("(libcv.a) sTarget - no nTarget value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}

/* ------------------------------------------------------------------------ */
void
sSource
(const cvn t, const cvn c)
{
  ref * ptr;
  if (t == 0) return;
  switch (qKind(t)) {
    case kSignalAssignmentStatement :
      ptr = & t->SignalAssignmentStatement.nSource;
      break;
    case kConditionalSignalAssignmentStatement :
      ptr = & t->ConditionalSignalAssignmentStatement.nSource;
      break;
    case kVariableAssignmentStatement :
      ptr = & t->VariableAssignmentStatement.nSource;
      break;
    default :
      Message("(libcv.a) sSource - no nSource value", xxRepair, 
              NoPosition);
      return;
  }
  cvn_to_ref(ptr, c);
}
/* ------------------------------------------------------------------------ */

void
sToolInfo
(const cvn t, void * i)
{
  if (t == 0) return;
  t->header.aToolInfo = i;
}

void
sOrdinalValue
(const cvn t, unsigned o)
{
  if (t == 0) return;
   switch (qKind(t)) {
    case kEnumeratedLiteral :
      t->EnumeratedLiteral.aOrdinalValue = o;
      break;
    case kCharacterLiteral :
      t->CharacterLiteral.aOrdinalValue = o;
      break;
    default :
      Message("(libcv.a) sOrdinalValue - no aOrdinalValue attribute", 
              xxRepair, NoPosition);
      return;
  }
}

void
sLine
(const cvn t, unsigned l)
{
  if (t == 0) return;
   switch (qKind(t)) {
    case kEntityDeclaration :
      t->EntityDeclaration.aLine = l;
      break;
    case kArchitectureBody :
      t->ArchitectureBody.aLine = l;
      break;
    case kPackageDeclaration :
      t->PackageDeclaration.aLine = l;
      break;
    case kPackageBody :
      t->PackageBody.aLine = l;
      break;
    case kSignalDeclaration :
      t->SignalDeclaration.aLine = l;
      break;
    case kVariableDeclaration :
      t->VariableDeclaration.aLine = l;
      break;
    case kConstantDeclaration :
      t->ConstantDeclaration.aLine = l;
      break;
    case kTypeDeclaration :
      t->TypeDeclaration.aLine = l;
      break;
    case kSubtypeDeclaration :
      t->SubtypeDeclaration.aLine = l;
      break;
    case kProcessStatement :
      t->ProcessStatement.aLine = l;
      break;
    case kBlockStatement :
      t->BlockStatement.aLine = l;
      break;
    case kIfStatement :
      t->IfStatement.aLine = l;
      break;
    case kCaseStatement :
      t->CaseStatement.aLine = l;
      break;
    case kNullStatement :
      t->NullStatement.aLine = l;
      break;
    case kWaitStatement :
      t->WaitStatement.aLine = l;
      break;
    case kSignalAssignmentStatement :
      t->SignalAssignmentStatement.aLine = l;
      break;
    case kConditionalSignalAssignmentStatement :
      t->ConditionalSignalAssignmentStatement.aLine = l;
      break;
    case kSelectedSignalAssignmentStatement :
      t->SelectedSignalAssignmentStatement.aLine = l;
      break;
    case kVariableAssignmentStatement :
      t->VariableAssignmentStatement.aLine = l;
      break;
    default :
      Message("(libcv.a) sLine - no aLine attribute", xxRepair, NoPosition);
      return;
  }
}

void
sName
(const cvn t, char * n)
{
  if (t == 0) return;
  switch (qKind(t)) {
    case kEntityDeclaration :
      t->EntityDeclaration.aName = n;
      break;
    case kArchitectureBody :
      t->ArchitectureBody.aName = n;
      break;
    case kPackageDeclaration :
      t->PackageDeclaration.aName = n;
      break;
    case kPackageBody :
      t->PackageBody.aName = n;
      break;
    case kSignalDeclaration :
      t->SignalDeclaration.aName = n;
      break;
    case kVariableDeclaration :
      t->VariableDeclaration.aName = n;
      break;
    case kConstantDeclaration :
      t->ConstantDeclaration.aName = n;
      break;
    case kTypeDeclaration :
      t->TypeDeclaration.aName = n;
      break;
    case kSubtypeDeclaration :
      t->SubtypeDeclaration.aName = n;
      break;
    case kProcessStatement :
      t->ProcessStatement.aName = n;
      break;
    case kBlockStatement :
      t->BlockStatement.aName = n;
      break;
    case kIfStatement :
      t->IfStatement.aName = n;
      break;
    case kCaseStatement :
      t->CaseStatement.aName = n;
      break;
    case kNullStatement :
      t->NullStatement.aName = n;
      break;
    case kSignalAssignmentStatement :
      t->SignalAssignmentStatement.aName = n;
      break;
    case kConditionalSignalAssignmentStatement :
      t->ConditionalSignalAssignmentStatement.aName = n;
      break;
    case kSelectedSignalAssignmentStatement :
      t->SelectedSignalAssignmentStatement.aName = n;
      break;
    case kVariableAssignmentStatement :
      t->VariableAssignmentStatement.aName = n;
      break;
    case kWaitStatement :
      t->WaitStatement.aName = n;
      break;
    case kIdentifier :
      t->Identifier.aName = n;
      break;
    case kEnumeratedLiteral :
      t->EnumeratedLiteral.aName = n;
      break;
    case kCharacterLiteral :
      t->CharacterLiteral.aName = n;
      break;
    default :
      Message("(libcv.a) sName - no aName attribute", xxRepair, 
              NoPosition);
      return;
  }
}

/* ------------------------------------------------------------------------ */
void
sMode
(const cvn t, tMode m)
{
  if (t == 0) return;
  switch (qKind(t)) {
    case kSignalDeclaration :
      t->SignalDeclaration.aMode = m;
      break;
    case kVariableDeclaration :
      t->VariableDeclaration.aMode = m;
      break;
    default :
      Message("(libcv.a) sMode - no aMode attribute", xxRepair, NoPosition);
      return;
  }
}

/* ------------------------------------------------------------------------ */
void
sDirection
(const cvn t, tDirection d)
{
  if (t == 0) return;
  switch (qKind(t)) {
    case kRange :
      t->Range.aDirection = d;
      break;
    default :
      Message("(libcv.a) sDirection - no aDirection attribute", xxRepair, 
              NoPosition);
      return;
  }
}

/* ------------------------------------------------------------------------ */
void
sOperator
(const cvn t, tOperator o)
{
  if (t == 0) return;
  switch (qKind(t)) {
    case kUnary :
      t->Unary.aOperator = o;
      break;
    case kBinary :
      t->Binary.aOperator = o;
      break;
    default :
      Message("(libcv.a) sOperator - no aOperator attribute", xxRepair, NoPosition);
      return;
  }
}

/* ------------------------------------------------------------------------ */
void
sIntegerValue
(const cvn t, int i)
{
  if (t == 0) return;
  switch (qKind(t)) {
    case kIntegerValue :
      t->IntegerValue.aIntegerValue = i;
      break;
    default :
      Message("(libcv.a) sIntegerValue - no aIntegerValue attribute", xxRepair, 
              NoPosition);
      return;
  }
}

