/**CFile***********************************************************************

  FileName    [ ctlMisc.c ]

  PackageName [ ctl ]

  Synopsis    [ Miscellaneous routines on CTL terms ]

  Author      [ David Deharbe ]

  Copyright   [ Copyright (C) 1996, Carnegie Mellon University.
                All rights reserved. ]

  Revision    [ $Log$ ]

******************************************************************************/

#include "ctlInt.h" 

static char rcsid[] = "$Id: $";


/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/

/**Function**
  Synopsis           [ Free variables of a CTL term ]
  SideEffects        [ Allocates memory to represent the result ]
 **/
int
ctl_MiscSupport
(ctl_term t,
 ctl_TerminalSupportFn_t support_fn,
 ctl_SupportUnionFn_t union_fn,
 void * env,
 void ** result)
{
  switch(t->type) {
    case ctl_AtomicTerm:
      * result = (* union_fn)(* result, (* support_fn)(t->cell.atom, env), env);
      return 1;
    case ctl_UnaryTerm:
      return ctl_MiscSupport(t->cell.un.arg, support_fn, union_fn, env, result);
    case ctl_BinaryTerm:
      if (ctl_MiscSupport(t->cell.bin.arg1, support_fn, 
                          union_fn, env, result)) {
        return ctl_MiscSupport(t->cell.bin.arg2, support_fn, 
                               union_fn, env, result);
      } else {
        return 0;
      }
    default:
      return 0;
  }
}

/**Function**
  Synopsis           [required]
  Description        [optional]
  SideEffects        [required]
  SeeAlso            [optional]
**/
int
ctl_MiscIsInvariant
(ctl_term t)
{
  return t->type == ctl_AtomicTerm;
}

/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Definition of static functions                                            */
/*---------------------------------------------------------------------------*/



