/** CFile **************************************************************

  FileName    [ ctlDisplay.c ]

  PackageName [ ctl ]

  Synopsis    [ Human readable display of CTL formulas ]

  Description [ ]

  SeeAlso     [ ctl.h ]

  Author      [ David Deharbe ]

  Copyright   [ Copyright (C) 1996, Carnegie Mellon University.
                All rights reserved. ]

  Revision    [ $Log$ ]

***********************************************************************/

#include "ctlInt.h"

#include <stdio.h>

static char rcsid [] = "$Log$";
/*--------------------------------------------------------------------*/
/* Structure declarations                                             */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Type declarations                                                  */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Variable declarations                                              */
/*--------------------------------------------------------------------*/
static const char * _operator_strings [] = {
"EX", "AX", "EF", "AF", "EG", "AG", "EU", "AU", "EW", "AW", "=>",
"not", "and", "or", "xor", "xnor", "nand", "nor", "@stable"
} ;

/*--------------------------------------------------------------------*/
/* Macro declarations                                                 */
/*--------------------------------------------------------------------*/

/**AutomaticStart******************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd********************************************************/

/*--------------------------------------------------------------------*/
/* Definition of exported functions                                   */
/*--------------------------------------------------------------------*/

/** Function **
  Synopsis    [ Displays a text of the formula ]
  Description [ Displays a CTL formula in a human-readable format on 
  outstream. fn is a function that is used to print atomic propositions,
  it takes as input a writable file pointer and a pointer. ]
  SideEffects [ Sends output to stream ]
 */
void
ctl_DisplayText
(FILE * outstream,
 ctl_term t,
 ctl_TerminalDisplayFn_t fn)
{
  switch (ctl_BasicQType(t)) {
  case ctl_AtomicTerm:
    (* fn)(outstream, ctl_BasicQAtomicTerm(t));
  break;
  case ctl_UnaryTerm:
    fprintf(outstream, "%s ", _operator_strings[(int) ctl_BasicQOperator(t)]);
    ctl_DisplayText(outstream, ctl_BasicQArgument(t), fn);
    break;
  case ctl_BinaryTerm: {
    ctl_Operator_t op;
    switch (op = ctl_BasicQOperator(t)) {
    case ctl_EU : case ctl_AU : case ctl_EW : case ctl_AW :
      if ((op == ctl_EU) || (op == ctl_EW)) {
        fprintf(outstream, "E");
      } else {
        fprintf(outstream, "A");
      }
      fprintf(outstream, "[");
      ctl_DisplayText(outstream, ctl_BasicQArgument(t), fn);
      if ((op == ctl_EU) || (op == ctl_AU)) {
        fprintf(outstream, " U ");
      } else {
        fprintf(outstream, " W ");
      }
      ctl_DisplayText(outstream, ctl_BasicQArgument2(t), fn);
      fprintf(outstream, "]");
      break;
    default:
      fprintf(outstream, "(");
      ctl_DisplayText(outstream, ctl_BasicQArgument(t), fn);
      fprintf(outstream, " %s ",
              _operator_strings[(int) op]);
      ctl_DisplayText(outstream, ctl_BasicQArgument2(t), fn);
      fprintf(outstream, ")");
      break;
    }
  }
    break;
  case ctl_MacroTerm:
    fprintf(outstream, " %s ", _operator_strings[(int) ctl_BasicQMacro(t)]);
    break;
  }
}

/*--------------------------------------------------------------------*/
/* Definition of internal functions                                   */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Definition of static functions                                     */
/*--------------------------------------------------------------------*/

