/* BDD size and profile routines */


#include "bddint.h"

static void
#if defined(__STDC__)
bdd_mark_bdd(bdd_manager bddm, bdd f)
#else
bdd_mark_bdd(bddm, f)
     bdd_manager bddm;
     bdd f;
#endif
{
  BDD_SETUP(f);

  if(f == BDD_ONE(bddm) || f == BDD_ZERO(bddm)) {
    return;
  }
  BDD_MARK(f) = 0;
  bdd_mark_bdd(bddm, BDD_ELSE(f));
  bdd_mark_bdd(bddm, BDD_THEN(f));
}

static void
#if defined(__STDC__)
bdd_select_subgraph_step(bdd_manager bddm, bdd f, hash_table hsize, hash_table hshare, bdd* max_node, unsigned long *max_w)
#else
bdd_select_subgraph_step(bddm, f, hsize, hshare, max_node, max_w)
     bdd_manager bddm;
     bdd f;
     hash_table hsize;
     hash_table hshare;
     bdd *max_node;
     unsigned *max_w;
#endif
{
  long * weight, size, share, measure;

  BDD_SETUP(f);

  if ((f == BDD_ONE(bddm)) || (f == BDD_ZERO(bddm))) {
    return ;
  }

  if (BDD_MARK(f) == 0) {
    bdd_select_subgraph_step(bddm, BDD_POINTER(BDD_ELSE(f)), hsize, hshare, max_node, max_w);
    bdd_select_subgraph_step(bddm, BDD_POINTER(BDD_THEN(f)), hsize, hshare, max_node, max_w);
/*
    size = * (long *) bdd_lookup_in_hash_table(hsize, BDD_POINTER(BDD_THEN(f))) +
           * (long *) bdd_lookup_in_hash_table(hsize, BDD_POINTER(BDD_ELSE(f))) + 1;
*/
    share = 0l;
/*
    bdd_insert_in_hash_table(hsize, BDD_POINTER(f), (pointer) & size);
*/
    bdd_insert_in_hash_table(hshare, BDD_POINTER(f), (pointer) & share);
    BDD_MARK(f) = 1;
  } else {
/*
    size = * (long *) bdd_lookup_in_hash_table(hsize, BDD_POINTER(f));
*/
  }
  weight = (unsigned long *) bdd_lookup_in_hash_table(hshare, BDD_POINTER(f));
  ++*weight;
  measure = * weight;
/*
  measure = * weight * size;
*/
  if (measure > * max_w) {
    * max_w = measure;
    * max_node = f;
  }
}

/* bdd_select_subgraph returns the subgraph of f that maximizes the sum */
/* of two factors: its actual size, and the number of links to its */
/* root in f. */

bdd
#if defined(__STDC__)
bdd_select_subgraph(bdd_manager bddm, bdd f)
#else
bdd_select_subgraph(bddm, f)
     bdd_manager bddm;
     bdd f;
#endif
{
  long max, sizec;
  bdd g, result;
  hash_table hsize, hshare;
  
  BDD_SETUP(result);

  g=BDD_ONE(bddm);
  {
    BDD_SETUP(g);
    BDD_MARK(g)=0;
  }
  sizec = 0l;
  max=0l;
  result = f;
/*
  hsize = bdd_new_hash_table(bddm, sizeof(long));
  bdd_insert_in_hash_table(hsize, BDD_POINTER(BDD_ONE(bddm)), (pointer) & sizec);
*/
  hshare = bdd_new_hash_table(bddm, sizeof(unsigned long));
  bdd_mark_bdd(bddm, f);
  bdd_select_subgraph_step(bddm, f, hsize, hshare, & result, & max);
/*
  bdd_free_hash_table(hsize);
*/
  bdd_free_hash_table(hshare);
  BDD_INCREFS(result);
  return (result);
}

/* bdd_select_subgraph_multiple is like bdd_select_subgraph, but */
/* takes a null-terminated array of BDDs. */

bdd 
#if defined(__STDC__)
bdd_select_subgraph_multiple(bdd_manager bddm, bdd* fs)
#else
bdd_select_subgraph_multiple(bddm, fs)
     bdd_manager bddm;
     bdd *fs;
#endif
{
  long max, sizec;
  bdd *f;
  bdd g, result;
  hash_table hsize, hshare;
  
  BDD_SETUP(result);

  bdd_check_array(fs);
  g=BDD_ONE(bddm);
  {
    BDD_SETUP(g);
    BDD_MARK(g)=0;
  }
  hsize = bdd_new_hash_table(bddm, sizeof(long));
  sizec = 0l;
  bdd_insert_in_hash_table(hsize, BDD_ZERO(bddm), (pointer) & sizec);
  bdd_insert_in_hash_table(hsize, BDD_ONE(bddm), (pointer) & sizec);
  hshare = bdd_new_hash_table(bddm, sizeof(unsigned long));
  result = *fs;
  max = 0l;
  for (f=fs; *f; ++f)
    bdd_mark_bdd(bddm, *f);
  for (f=fs; *f; ++f)
    bdd_select_subgraph_step(bddm, *f, hsize, hshare, & result, & max);
  bdd_free_hash_table(hsize);
  bdd_free_hash_table(hshare);
  RETURN_BDD(result);
}
