/* Resizing BDD manager routines */

#include "bddint.h"

#if defined(__STDC__)
#define ARGS(s) s
#else
#define ARGS(s) ()
#endif

#define DEBUG

#ifdef DEBUG
#include <stdio.h>
#endif

void
#if defined(__STDC__)
bdd_resize_manager
(bdd_manager bddm)
#else
bdd_resize_manager (bddm)
  bdd_manager bddm;
#endif
{
  long before, after, node_limit;
  void (* backup) ARGS((bdd_manager));
  node_limit = bddm->unique_table.node_limit;
  before = bdd_total_size(bddm);
  backup = bddm->reorder_fn;
  bdd_dynamic_reordering(bddm, bddm->resize_reorder_fn);
  bdd_reorder(bddm);
  after = bdd_total_size(bddm);
#ifdef DEBUG
fprintf(stdout, 
        "-- bdd_resize_manager:\n"
        "-- node limit: %lu\n"
        "-- total size before reordering: %lu\n"
        "-- total size after reordering: %lu\n",
        node_limit,
        before,
        after);
#endif
  if ((after > ((long) (bddm->resize_threshold * node_limit))) ||
      (after == bddm->resize_previous_size)) {
    long new_node_limit;
    new_node_limit = (long) node_limit * bddm->resize_factor ;
#ifdef DEBUG
fprintf(stdout, 
        "-- resize to new node limit: %lu",
        new_node_limit);
#endif
    bdd_node_limit(bddm, new_node_limit);
  }
  bddm->resize_previous_size = after;
  bdd_dynamic_reordering(bddm, backup);
}

/* bdd_resize_data(bddm, reorder_fn, factor) sets the dynamic reordering */
/* method invoked before resizing to that specified by reorder_fn, the */
/* resize threshold to the maximum of 1.0 and the value specified by */
/* threshold, and the resize factor to the minimum of 1.0 and the value */
/* specified by factor. */

void
#if defined(__STDC__)
bdd_resize_data(bdd_manager bddm, 
                void (*reorder_fn)(bdd_manager),
                float threshold,
                float factor)
#else
bdd_resize_data(bddm, reorder_fn, threshold, factor)
     bdd_manager bddm;
     void (*reorder_fn)();
     float threshold;
     float factor;
#endif
{
  bddm->resize_reorder_fn=reorder_fn;
  bddm->resize_threshold=(threshold<1.0)?threshold:1.0;
  bddm->resize_factor=(factor>1.0)?factor:1.0;
}

