/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    vbdd_print.h                                              */
/*                                                              */
/* Description:                                                 */
/*    Declarations of extra routines that manipulate vectors of */
/*    BDDs.      						*/
/*                                                              */
/* Project:                                                     */
/*    A symbolic model checker for VHDL                         */
/* Subproject:                                                  */
/*    A program that elaborates abstract machines from VHDL     */
/*    descriptions in the internal format.                      */
/*                                                              */
/* Author:                                                      */
/*    David Deharbe                                             */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

/* ------------------------------------------------------------ */
/* File management information:                                 */
/* $Revision$ */
/* $Date$ */
/* $Locker$ */
/* $Log$ */
/* ------------------------------------------------------------ */
#if !defined(_VBDD_PRINTH)
#   define _VBDD_PRINTH

#   include "vbdd.h"

#   if defined(__STDC__)
#      define ARGS(args) args
#   else
#      define ARGS(args) ()
#   endif

/* ------------------------------------------------------------ */

extern void vbdd_print
   ARGS((bdd_manager bddm, 
	 vbdd v));
extern void vbdd_print_bdd
   ARGS((bdd_manager bddm, 
	 vbdd v,
	 char * (* f) ARGS((bdd_manager, bdd, pointer)),
	 pointer env));
extern void vbdd_print_sop
   ARGS((bdd_manager bddm, 
	 vbdd v,
	 char * (* f) ARGS((bdd_manager, bdd, pointer)),
	 pointer env));

#endif _VBDD_PRINTH
