/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    vbdd_logic.h                                              */
/*                                                              */
/* Description:                                                 */
/*    Declarations of extra routines that manipulate vectors of */
/*    BDDs.      						*/
/*                                                              */
/* Project:                                                     */
/*    A symbolic model checker for VHDL                         */
/* Subproject:                                                  */
/*    A program that elaborates abstract machines from VHDL     */
/*    descriptions in the internal format.                      */
/*                                                              */
/* Author:                                                      */
/*    David Deharbe                                             */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

/* ------------------------------------------------------------ */
/* File management information:                                 */
/* $Revision$ */
/* $Date$ */
/* $Locker$ */
/* $Log$ */
/* ------------------------------------------------------------ */
#if !defined(_VBDD_LOGICH)
#   define _VBDD_LOGICH

#   include "vbdd.h"

#   if defined(__STDC__)
#      define ARGS(args) args
#   else
#      define ARGS(args) ()
#   endif

/* ------------------------------------------------------------ */

/* Logic constants: create a vector of a given number of boolean 
   constants. */
extern vbdd vbdd_one
   ARGS((bdd_manager, int)) ;
extern vbdd vbdd_zero
   ARGS((bdd_manager, int)) ;

/* Logical operators: the length of the result is equal to the
   length of the arguments */
extern vbdd vbdd_ite
   ARGS((bdd_manager bddm, bdd i, vbdd t, vbdd e)) ;
extern vbdd vbdd_not
   ARGS((bdd_manager, vbdd)) ;
extern vbdd vbdd_not_up
   ARGS((bdd_manager, vbdd)) ;
extern vbdd vbdd_and
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_and_up
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_nand
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_nand_up
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_or
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_or_up
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_nor
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_nor_up
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_xor
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_xor_up
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_xnor
   ARGS((bdd_manager, vbdd, vbdd)) ;
extern vbdd vbdd_xnor_up
   ARGS((bdd_manager, vbdd, vbdd)) ;

#endif _VBDD_LOGICH
