/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    vbdd_logic.c                                              */
/*                                                              */
/* Description:                                                 */
/*    Extra routines that manipulate BDDs.                      */
/*                                                              */
/* Project:                                                     */
/*    A symbolic model checker for VHDL                         */
/* Subproject:                                                  */
/*    A program that elaborates abstract machines from VHDL     */
/*    descriptions in the internal format.                      */
/*                                                              */
/* Author:                                                      */
/*    David Deharbe                                             */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

/* ------------------------------------------------------------ */
/* File management information:                                 */
/* $Revision$ */
/* $Date$ */
/* $Locker$ */
/* $Log$ */
/* ------------------------------------------------------------ */
#include "vbdd_logic.h"

vbdd vbdd_not_up
#if defined(__STDC__)
   (bdd_manager bddm, vbdd a)
#else
   (bddm, a)
   bdd_manager bddm ;
   vbdd a ;
#endif
{
   return(vbdd_apply1_up(bdd_not, bddm, a)) ;
}

vbdd vbdd_not
#if defined(__STDC__)
   (bdd_manager bddm, vbdd a)
#else
   (bddm, a)
   bdd_manager bddm ;
   vbdd a ;
#endif
{
   return(vbdd_apply1(bdd_not, bddm, a)) ;
}

vbdd vbdd_and_up
#if defined(__STDC__)
   (bdd_manager bddm, vbdd a1, vbdd a2)
#else
   (bddm, a1, a2)
   bdd_manager bddm ;
   vbdd a1 ;
   vbdd a2 ;
#endif
{
   return(vbdd_apply2_up(bdd_and, bddm, a1, a2)) ;
}

vbdd vbdd_and
#if defined(__STDC__)
   (bdd_manager bddm, vbdd a1, vbdd a2)
#else
   (bddm, a1, a2)
   bdd_manager bddm ;
   vbdd a1 ;
   vbdd a2 ;
#endif
{
   return(vbdd_apply2(bdd_and, bddm, a1, a2)) ;
}

vbdd vbdd_nand_up
#if defined(__STDC__)
   (bdd_manager bddm, vbdd a1, vbdd a2)
#else
   (bddm, a1, a2)
   bdd_manager bddm ;
   vbdd a1 ;
   vbdd a2 ;
#endif
{
   return(vbdd_apply2_up(bdd_nand, bddm, a1, a2)) ;
}

vbdd vbdd_nand
#if defined(__STDC__)
   (bdd_manager bddm, vbdd a1, vbdd a2)
#else
   (bddm, a1, a2)
   bdd_manager bddm ;
   vbdd a1 ;
   vbdd a2 ;
#endif
{
   return(vbdd_apply2(bdd_nand, bddm, a1, a2)) ;
}

vbdd vbdd_or_up
#if defined(__STDC__)
   (bdd_manager bddm, vbdd a1, vbdd a2)
#else
   (bddm, a1, a2)
   bdd_manager bddm ;
   vbdd a1 ;
   vbdd a2 ;
#endif
{
   return(vbdd_apply2_up(bdd_or, bddm, a1, a2)) ;
}

vbdd vbdd_or
#if defined(__STDC__)
   (bdd_manager bddm, vbdd a1, vbdd a2)
#else
   (bddm, a1, a2)
   bdd_manager bddm ;
   vbdd a1 ;
   vbdd a2 ;
#endif
{
   return(vbdd_apply2(bdd_or, bddm, a1, a2)) ;
}

vbdd vbdd_nor_up
#if defined(__STDC__)
   (bdd_manager bddm, vbdd a1, vbdd a2)
#else
   (bddm, a1, a2)
   bdd_manager bddm ;
   vbdd a1 ;
   vbdd a2 ;
#endif
{
   return(vbdd_apply2_up(bdd_nor, bddm, a1, a2)) ;
}

vbdd vbdd_nor
#if defined(__STDC__)
   (bdd_manager bddm, vbdd a1, vbdd a2)
#else
   (bddm, a1, a2)
   bdd_manager bddm ;
   vbdd a1 ;
   vbdd a2 ;
#endif
{
   return(vbdd_apply2(bdd_nor, bddm, a1, a2)) ;
}

vbdd vbdd_xor_up
#if defined(__STDC__)
   (bdd_manager bddm, vbdd a1, vbdd a2)
#else
   (bddm, a1, a2)
   bdd_manager bddm ;
   vbdd a1 ;
   vbdd a2 ;
#endif
{
   return(vbdd_apply2_up(bdd_xor, bddm, a1, a2)) ;
}

vbdd vbdd_xor
#if defined(__STDC__)
   (bdd_manager bddm, vbdd a1, vbdd a2)
#else
   (bddm, a1, a2)
   bdd_manager bddm ;
   vbdd a1 ;
   vbdd a2 ;
#endif
{
   return(vbdd_apply2(bdd_xor, bddm, a1, a2)) ;
}

vbdd vbdd_xnor
#if defined(__STDC__)
   (bdd_manager bddm, vbdd a1, vbdd a2)
#else
   (bddm, a1, a2)
   bdd_manager bddm ;
   vbdd a1 ;
   vbdd a2 ;
#endif
{
   return(vbdd_apply2(bdd_xnor, bddm, a1, a2)) ;
}

vbdd vbdd_xnor_up
#if defined(__STDC__)
   (bdd_manager bddm, vbdd a1, vbdd a2)
#else
   (bddm, a1, a2)
   bdd_manager bddm ;
   vbdd a1 ;
   vbdd a2 ;
#endif
{
   return(vbdd_apply2_up(bdd_xnor, bddm, a1, a2)) ;
}

vbdd vbdd_ite
#if defined(__STDC__)
   (bdd_manager bddm, bdd i, vbdd t, vbdd e)
#else
   (bddm, i, t, e)
   bdd (* Fn)() ;
   bdd_manager bddm ;
   bdd i ;
   vbdd t ;
   vbdd e ;
#endif
{
   vbdd result ;
   register bdd * ptr, *ptr2 ;

   result = vbdd_copy(bddm, t) ;
   ptr = vbdd_elements(result) ;
   ptr2 = vbdd_elements(e) ;

   while (* ptr) * ptr++ = bdd_ite(bddm, i, * ptr, * ptr2++) ;

   return(result) ;
}

vbdd vbdd_one
#if defined(__STDC__)
   (bdd_manager bddm, int length)
#else
   (bddm, length)
   bdd_manager bddm ;
   int length ;
#endif
{
   vbdd result = vbdd_newn(length) ;
   while (length--) (void) vbdd_set(bddm, result, length, bdd_one(bddm)) ;
   return(result) ;
}

vbdd vbdd_zero
#if defined(__STDC__)
   (bdd_manager bddm, int length)
#else
   (bddm, length)
   bdd_manager bddm ;
   int length ;
#endif
{
   vbdd result = vbdd_newn(length) ;
   while (length--) (void) vbdd_set(bddm, result, length, bdd_zero(bddm)) ;
   return(result) ;
}

