#include "vbdd_code.h"
#include "bdd_up.h"

int vbdd_code_length
#if defined(__STDC__)
(int size)
#else
(size)
int size;
#endif
{
  int res;
  for (res=1, size-=1; size >= 2; ++res, size >>= 1);
  return res;
}

static bdd vbdd_code_valid_
ARGS((bdd_manager bddm, bdd* vars, int nb_vars, int size));

bdd vbdd_code_valid
#if defined(__STDC__)
(bdd_manager bddm, vbdd code, int size)
#else
(bddm, code, size);
bdd_manager bddm;
vbdd code;
int size ;
#endif
{
  return vbdd_code_valid_(bddm, vbdd_elements(code), vbdd_length(code), size);
}

bdd vbdd_code_valid_
#if defined(__STDC__)
(bdd_manager bddm, bdd* vars, int nb_vars, int size)
#else
(bddm, vars, nb_vars, size);
bdd_manager bddm;
bdd* vars;
int nb_vars;
int size ;
#endif
{
  /* if size is equal to 2 to the power of the number of
     variables, then the representation is complete, and
     the condition is TRUE. */
  if (size == 1 << nb_vars) {
    return bdd_identity(bddm, bdd_one(bddm)); 
  }
  /* if size is smaller than 2 to the power of the number
     of variables minus 1, then the possible valuations
     are all captured into the first half of the BDD; this
     condition should not be true in the first call of
     the function. */
  if (size <= 1 << (nb_vars - 1)) {
    return bdd_andup(bddm, bdd_not(bddm, vars[0]),
		     vbdd_code_valid_(bddm, vars+1, nb_vars - 1, size));
  }
  /* otherwise, 2 to the power of the number of variables
     minus 1 variables are represented by the first half
     of the BDD, and the rest is represented by a sub-BDD
     of the second half of the BDD. */
  return bdd_orup(bddm, 
		  bdd_not(bddm, vars[0]),
		  bdd_andup2(bddm, 
			     vars[0],
			     vbdd_code_valid_(bddm, vars+1, nb_vars - 1,
					      (size - (1 << (nb_vars - 1)))
					 ))); 
} 

vbdd vbdd_code_ordinal
#if defined(__STDC__)
(bdd_manager bddm, int nb_variables, int ord)
#else
(bddm, nb_variables, ord)
bdd_manager bddm;
int nb_variables ;
int ord ;
#endif
{
  vbdd res = vbdd_newn(nb_variables);
  int cpt ;

  for (cpt = nb_variables - 1; cpt >= 0 ; --cpt) {
    if ((ord & 1) == 0) vbdd_set(bddm, res, (int) cpt, bdd_zero(bddm)) ;
    else vbdd_set(bddm, res, (int) cpt, bdd_one(bddm)) ;
    ord >>= 1 ;
  }
  return(res) ;
}

int vbdd_decode_ordinal
#if defined(__STDC__)
(bdd_manager bddm, bdd code, vbdd coding)
#else
(bddm, code, coding)
bdd_manager bddm;
bdd code;
vbdd coding;
#endif
{
  int idx, length, result;
  bdd * ptr;
  length = vbdd_length(coding);
  result = 0;
  for (idx = 0 , result = 0, ptr = vbdd_elements(coding); 
       idx < length ; 
       ++idx, ++ptr) {
    bdd tmp;
    /* variables may not appear in the same order in coding and in BDD */
    if ((tmp = bdd_imply(bddm, code, * ptr)) == bdd_one(bddm)) {
      result += 1 << (length - idx - 1);
    }
    bdd_free(bddm, tmp);
  }
  return result;
}

