/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    bdd_up.h                                                  */
/*                                                              */
/* Description:                                                 */
/*    Declarations of extra routines that manipulate BDDs.      */
/*                                                              */
/* Project:                                                     */
/*    A symbolic model checker for VHDL                         */
/* Subproject:                                                  */
/*    A program that elaborates abstract machines from VHDL     */
/*    descriptions in the internal format.                      */
/*                                                              */
/* Author:                                                      */
/*    David Deharbe                                             */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

/* ------------------------------------------------------------ */
/* File management information:                                 */
/* $Revision$ */
/* $Date$ */
/* $Locker$ */
/* $Log$ */
/* ------------------------------------------------------------ */
#if !defined(_BDD_UPH)
#   define _BDD_UPH

#   include <bdduser.h>

#   if !defined(ARGS)
#      if defined(__STDC__)
#         define ARGS(args) args
#      else
#         define ARGS(args) ()
#      endif
#   endif

extern bdd bdd_imply
   ARGS((bdd_manager, bdd, bdd));
extern bdd bdd_implyup
   ARGS((bdd_manager, bdd, bdd));
extern bdd bdd_implyup1
   ARGS((bdd_manager, bdd, bdd));
extern bdd bdd_implyup2
   ARGS((bdd_manager, bdd, bdd));
extern bdd bdd_nopnot
   ARGS((bdd_manager, bdd)) ;
extern bdd bdd_notup
   ARGS((bdd_manager, bdd)) ;
extern bdd bdd_andup
   ARGS((bdd_manager, bdd, bdd)) ;
extern bdd bdd_andup2
   ARGS((bdd_manager, bdd, bdd)) ;
extern bdd bdd_nandup
   ARGS((bdd_manager, bdd, bdd)) ;
extern bdd bdd_orup
   ARGS((bdd_manager, bdd, bdd)) ;
extern bdd bdd_orup2
   ARGS((bdd_manager, bdd, bdd)) ;
extern bdd bdd_norup
   ARGS((bdd_manager, bdd, bdd)) ;
extern bdd bdd_xorup
   ARGS((bdd_manager, bdd, bdd)) ;
extern bdd bdd_xnorup
   ARGS((bdd_manager, bdd, bdd)) ;
extern bdd bdd_substituteup
   ARGS((bdd_manager, bdd)) ;
#endif _BDD_UPH
