/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    bdd_up.c                                                  */
/*                                                              */
/* Description:                                                 */
/*    Extra routines that manipulate BDDs with built in         */
/* unprotection.                                                */
/*                                                              */
/* Project:                                                     */
/*    A symbolic model checker for VHDL                         */
/* Subproject:                                                  */
/*    A program that elaborates abstract machines from VHDL     */
/*    descriptions in the internal format.                      */
/*                                                              */
/* Author:                                                      */
/*    David Deharbe                                             */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

/* ------------------------------------------------------------ */
/* File management information:                                 */
/* $Revision$ */
/* $Date$ */
/* $Locker$ */
/* $Log$ */
/* ------------------------------------------------------------ */
#include "bdd_up.h"

#define BDDSIZE sizeof(bdd) 

#if !defined(ARGS)
#   if defined(__STDC__)
#      define ARGS(args) args
#   else
#      define ARGS(args) ()
#   endif
#endif

/* ------------------------------------------------------------ */
bdd bdd_imply
#if defined(__STDC__)
(bdd_manager mgr, bdd a, bdd b)
#else
(mgr, a, b)
bdd_manager mgr;
bdd a;
bdd b;
#endif
{
  return bdd_orup2(mgr, b, bdd_not(mgr, a));
}

bdd bdd_implyup
#if defined(__STDC__)
(bdd_manager mgr, bdd a, bdd b)
#else
(mgr, a, b)
bdd_manager mgr;
bdd a;
bdd b;
#endif
{
  bdd tmp;
  tmp = bdd_orup2(mgr, b, bdd_not(mgr, a));
  bdd_free(mgr, a);
  bdd_free(mgr, b);
  return tmp;
}

bdd bdd_implyup1
#if defined(__STDC__)
(bdd_manager mgr, bdd a, bdd b)
#else
(mgr, a, b)
bdd_manager mgr;
bdd a;
bdd b;
#endif
{
  bdd tmp;
  tmp = bdd_orup2(mgr, b, bdd_not(mgr, a));
  bdd_free(mgr, a);
  return tmp;
}

bdd bdd_implyup2
#if defined(__STDC__)
(bdd_manager mgr, bdd a, bdd b)
#else
(mgr, a, b)
bdd_manager mgr;
bdd a;
bdd b;
#endif
{
  bdd tmp;
  tmp = bdd_orup2(mgr, b, bdd_not(mgr, a));
  bdd_free(mgr, b);
  return tmp;
}

/* ------------------------------------------------------------ */
bdd bdd_nopnot
#if defined(__STDC__)
   (bdd_manager M, bdd B)
#else
   (M, B)
   bdd_manager M ;
   bdd B ;
#endif
{
   register bdd Result ;
   Result = bdd_not(M, B) ;
   bdd_free(M, Result) ;
   return Result;
}

/* ------------------------------------------------------------ */
bdd bdd_notup
#if defined(__STDC__)
   (bdd_manager M, bdd B)
#else
   (M, B)
   bdd_manager M ;
   bdd B ;
#endif
{
   register bdd Result ;
   Result = bdd_not(M, B) ;
   bdd_free(M, B) ;
   return(Result) ;
}

/* ------------------------------------------------------------ */
bdd bdd_andup
#if defined(__STDC__)
   (bdd_manager M, bdd B1, bdd B2)
#else
   (M, B1, B2)
   bdd_manager M ;
   bdd B1 ;
   bdd B2 ;
#endif
{
   register bdd Result ;
   Result = bdd_and(M, B1, B2) ;
   bdd_free(M, B1) ;
   bdd_free(M, B2) ;
   return(Result) ;
}

bdd bdd_andup2
#if defined(__STDC__)
   (bdd_manager M, bdd B1, bdd B2)
#else
   (M, B1, B2)
   bdd_manager M ;
   bdd B1 ;
   bdd B2 ;
#endif
{
   register bdd Result ;
   Result = bdd_and(M, B1, B2) ;
   bdd_free(M, B2) ;
   return(Result) ;
}

bdd bdd_nandup
#if defined(__STDC__)
   (bdd_manager M, bdd B1, bdd B2)
#else
   (M, B1, B2)
   bdd_manager M ;
   bdd B1 ;
   bdd B2 ;
#endif
{
   register bdd Result ;
   Result = bdd_nand(M, B1, B2) ;
   bdd_free(M, B1) ;
   bdd_free(M, B2) ;
   return(Result) ;
}

bdd bdd_orup
#if defined(__STDC__)
   (bdd_manager M, bdd B1, bdd B2)
#else
   (M, B1, B2)
   bdd_manager M ;
   bdd B1 ;
   bdd B2 ;
#endif
{
   register bdd Result ;
   Result = bdd_or(M, B1, B2) ;
   bdd_free(M, B1) ;
   bdd_free(M, B2) ;
   return(Result) ;
}

bdd bdd_orup2
#if defined(__STDC__)
   (bdd_manager M, bdd B1, bdd B2)
#else
   (M, B1, B2)
   bdd_manager M ;
   bdd B1 ;
   bdd B2 ;
#endif
{
   register bdd Result ;
   Result = bdd_or(M, B1, B2) ;
   bdd_free(M, B2) ;
   return(Result) ;
}

bdd bdd_norup
#if defined(__STDC__)
   (bdd_manager M, bdd B1, bdd B2)
#else
   (M, B1, B2)
   bdd_manager M ;
   bdd B1 ;
   bdd B2 ;
#endif
{
   register bdd Result ;
   Result = bdd_nor(M, B1, B2) ;
   bdd_free(M, B1) ;
   bdd_free(M, B2) ;
   return(Result) ;
}

bdd bdd_xorup
#if defined(__STDC__)
   (bdd_manager M, bdd B1, bdd B2)
#else
   (M, B1, B2)
   bdd_manager M ;
   bdd B1 ;
   bdd B2 ;
#endif
{
   register bdd Result ;
   Result = bdd_xor(M, B1, B2) ;
   bdd_free(M, B1) ;
   bdd_free(M, B2) ;
   return(Result) ;
}

bdd bdd_xnorup
#if defined(__STDC__)
   (bdd_manager M, bdd B1, bdd B2)
#else
   (M, B1, B2)
   bdd_manager M ;
   bdd B1 ;
   bdd B2 ;
#endif
{
   register bdd Result ;
   Result = bdd_xnor(M, B1, B2) ;
   bdd_free(M, B1) ;
   bdd_free(M, B2) ;
   return(Result) ;
}

bdd bdd_substituteup
#if defined(__STDC__)
   (bdd_manager M, bdd B)
#else
   (M, B)
   bdd_manager M ;
   bdd B ;
#endif
{
   register bdd Result ;
   Result = bdd_substitute(M, B) ;
   bdd_free(M, B) ;
   return(Result) ;
}

