	/*  			VHDL Model Checker 			*/
	/*		Additional scanner routines			*/
	/* 		Marius Minea, March 2, 1994			*/

#include <ctype.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include "Memory.h"

#include "scansupp.h"

#define TOUPPER(c)	((c) & (~0x20))
#define	OVERFLOW(v,d)	(((v) > INT_MAX / 10) || \
			 ((v) == INT_MAX / 10) && ((d) > INT_MAX % 10))
#define SETBIT(s,b)	(s[(b)/8] |= 1 << ((b)%8))

int ScanError (char *s)
{
  fprintf (stderr, "%s\n", s);
  return -1;  
}

/* reads integer from s until end, sets p to first unmatched char */
int ScanInt(char *s, char *end, char **p)
{
  int d, val = 0;

  *p = s;				/* end of char sequence */
  do {
    d = **p -'0';
    if ( OVERFLOW(val, d) ) return ScanError ("integer out of range");
    val = 10 * val + d;
    if ( ++*p == end ) return val;
  } while ( isdigit(**p) );
  return val;
}

/* scales val with exponent read from s until end */
int ScaleExp ( char *s, char *end, int val )
{
  int exp;

  s++;					/* skip 'E' */
  if ( *s == '+' ) ++s;
  if ( (exp = ScanInt (s, end, &s)) == -1 ) return -1;
  while ( exp-- ) {
    if ( OVERFLOW(val, 0) ) return ScanError ("integer out of range");
    val *= 10;
  }
  return val;
}

/* returns value of based integer literal; s: matched string; l: length */
int ScanBasedLit (char *s, int l)
{
  char *end = s + l, *p;
  int base, d, val = 0;

  if ( (base = ScanInt (s, end, &p)) == -1 ) return -1;
  if ( ( base < 2 ) || ( base > 16 ) )
    return ScanError ("illegal base value");
  p++;					/* delimiter */
  do {
    if ( *p <= '9' ) d = *p - '0';
    else d = TOUPPER(*p) - 'A' + 10;
    if ( d >= base ) return ScanError ("illegal extended digit");
    val = base * val + d;
    if ( *++p == '_' ) ++p;
  } while ( isalnum(*p) );		/* delimiter */
  p++;
  if ( p == end ) return val;
  return ScaleExp ( p, end, val );
}

/* returns value of decimal integer literal; s: matched string; l: length */
int ScanDecimalLit (char *s, int l)
{
  char *end = s + l, *p;		/* part of char sequence scanned */
  int exp, val;

  if ( (val = ScanInt (s, end, &p)) == -1 ) return -1;
  if ( p == end ) return val;
  return ScaleExp ( p, end, val );
}


/* same as strdup + strlwr, but for non-null-terminated string */
char *StrnDupLwr (char *src, int len)
{
  char *dest;
  char *p;

  dest = Alloc ( (len + 1) * sizeof(char) );
  for ( p = dest; len--; src++, p++ )
    *p = isupper(*src) ? tolower(*src) : *src;
  *p = '\0';
  return dest;
}

/* strdup for string delimited by and possibly containing quotes */
char *QuoteStrnDup (char *src, int len)
{
  char *dest;
  char *p;
  unsigned char	quote;

  quote = *src;
  len -= 2;	/* quotes */
  dest = Alloc ( len + 1 );	/* at most */
  for ( p = dest; len--; src++, p++) {
    if ( *src ==  quote ) src++;	/* quoted quote */
    *p = isupper(*src) ? tolower(*src) : *src;
  }
  *p = '\0';
  return dest;
}
