/* ------------------------------------------------------------ */
/* File name:                                                   */
/*    cva.h                                                     */
/*                                                              */
/* Description:                                                 */
/*    Declaration of global variables and routines.             */
/*                                                              */
/* Project:                                                     */
/*    A symbolic model checker for VHDL                         */
/* Subproject:                                                  */
/*    A program that compiles VHDL text descriptions into CV    */
/*    intermediate format.                                      */
/*                                                              */
/* Author:                                                      */
/*    David Deharbe                                             */
/* Affiliation:                                                 */
/*    Carnegie Mellon University (Dept Computer Science)        */
/*                                                              */
/* ------------------------------------------------------------ */

#if !defined(_CVAH)
#   define _CVAH

#   if !defined(ARGS)
#      if defined(__STDC__)
#         define ARGS(args) args
#      else
#         define ARGS(args) ()
#      endif
#   endif

/* ------------------------------------------------------------ */
extern char * IfDir ;

extern short opt_silent ;
extern short opt_noif ;

/* ------------------------------------------------------------ */
/* Program exit codes */
#define OK_CVA 0
#define ERR_CVA -1

/* ------------------------------------------------------------ */
extern int main ARGS((int argc, char ** argv)) ;

/* ------------------------------------------------------------ */
#endif _CVAH
/* ------------------------------------------------------------ */
