# ifndef yyScanner
# define yyScanner

/* $Id: Scanner.h,v 2.6 1992/08/07 15:29:41 grosch rel $ */

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

/* line 1 "vhdl.rex" */


#include <Errors.h>
#include <Positions.h>

#include <cv.h>

#include "scansupp.h"
#include "actions.h"

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

typedef struct { tPosition yyPos; tString Id; } yyidentifier;
typedef struct { tPosition yyPos; int Val; } yydecimal_literal;
typedef struct { tPosition yyPos; int Val; } yybased_literal;
typedef struct { tPosition yyPos; char Val; } yycharacter_literal;
typedef struct { tPosition yyPos; tString Str; } yystring_literal;
typedef struct { tPosition yyPos; tBitString Val; } yybit_string_literal;

typedef union {
 tPosition Position;
 yyidentifier identifier;
 yydecimal_literal decimal_literal;
 yybased_literal based_literal;
 yycharacter_literal character_literal;
 yystring_literal string_literal;
 yybit_string_literal bit_string_literal;
} tScanAttribute;

extern void ErrorAttribute ARGS((int Token, tScanAttribute * pAttribute));



 
# define EofToken	0
 
# ifdef lex_interface
#    define GetToken	yylex
#    define TokenLength	yyleng
# endif

extern	char *		TokenPtr	;
extern	short		TokenLength	;
extern	tScanAttribute	Attribute	;
extern	void		(* Scanner_Exit) ()	;
 
extern	void		BeginScanner	();
extern	void		BeginFile	ARGS ((char * yyFileName));
extern	int		GetToken	();
extern	int		GetWord		ARGS ((char * yyWord));
extern	int		GetLower	ARGS ((char * yyWord));
extern	int		GetUpper	ARGS ((char * yyWord));
extern	void		CloseFile	();
extern	void		CloseScanner	();

# endif
