/* $Id: Parser.c,v 2.9 1992/08/07 15:28:42 grosch rel $ */

# define bool		char
# define true		1
# define false		0

# include "Parser.h"
# include "Errors.h"

# ifdef __cplusplus
extern "C" {
#    include "Memory.h"
#    include "DynArray.h"
#    include "Sets.h"
#    ifndef BCOPY
#       include <memory.h>
#    endif
}
# else
#    include "Memory.h"
#    include "DynArray.h"
#    include "Sets.h"
#    ifndef BCOPY
#       include <memory.h>
#    endif
# endif

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifdef lex_interface
#    define GetToken	yylex
     extern int yylex ();
#    ifndef AttributeDef
#	include "Positions.h"
        typedef struct { tPosition Position; } tScanAttribute;
        static	tScanAttribute	Attribute = {{ 0, 0 }};
#    endif
#    ifndef ErrorAttributeDef
#	define ErrorAttribute(Token, RepairAttribute)
#    endif
#    ifndef yyGetAttribute
#	define yyGetAttribute(yyAttrStackPtr, Attribute) * yyAttrStackPtr = yylval
#    endif
# else
#    include "Scanner.h"
#    ifndef yyGetAttribute
#	define yyGetAttribute(yyAttrStackPtr, Attribute) (yyAttrStackPtr)->Scan = Attribute
#    endif
# endif

/* line 7 "Parser.lalr" */


#include <Positions.h>
#include <cv.h>

#include "actions.h"

cvn	CurrentRegion;		/* used to initialize Parent field */
cvn	CurrentLibUnit;		/* used to initialize LibraryUnit field */


typedef struct { cvn Tree; } yyentity_declaration;
typedef struct { tPosition Position; tString Id; } yyopt_identifier;
typedef struct { cvn Tree; } yyopt_port_clause;
typedef struct { cvn Tree; } yyport_clause;
typedef struct { cvn Tree; } yyarchitecture_body;
typedef struct { cvn Tree; } yyblock_declarative_part;
typedef struct { cvn Tree; } yyblock_declarative_item;
typedef struct { cvn Tree; } yypackage_declaration;
typedef struct { cvn Tree; } yyopt_package;
typedef struct { cvn Tree; } yypackage_declarative_part;
typedef struct { cvn Tree; } yypackage_declarative_item;
typedef struct { cvn Tree; } yypackage_body;
typedef struct { cvn Tree; } yypackage_body_declarative_part;
typedef struct { cvn Tree; } yypackage_body_declarative_item;
typedef struct { cvn Tree; } yytype_definition;
typedef struct { cvn Tree; } yyrange_constraint;
typedef struct { cvn Tree; } yyrange;
typedef struct { tDirection Dir; } yydirection;
typedef struct { cvn Tree; } yyenumeration_list;
typedef struct { int type; tString Id; char Val; } yyenumeration_literal;
typedef struct { cvn Tree; } yydiscrete_range;
typedef struct { identifier_list value; } yyidentifier_list;
typedef struct { cvn Tree; } yytype_declaration;
typedef struct { cvn Tree; } yysubtype_declaration;
typedef struct { cvn Tree; } yysubtype_indication;
typedef struct { cvn Tree; } yyopt_range_constraint;
typedef struct { cvn Tree; } yyconstant_declaration;
typedef struct { cvn Tree; } yyopt_initial_value;
typedef struct { cvn Tree; } yysignal_declaration;
typedef struct { cvn Tree; } yyvariable_declaration;
typedef struct { cvn Tree; } yyinterface_list;
typedef struct { tClass Class; } yyclass;
typedef struct { tMode Mode; } yymode;
typedef struct { cvn Tree; tPosition Position; } yyname;
typedef struct { cvn Tree; tPosition Position; } yypure_selected_name;
typedef struct { tPosition Position; } yyother_name;
typedef struct { cvn Tree; tPosition Position; } yysimple_name;
typedef struct { tPosition Position; } yyparenthesis_name;
typedef struct { tPosition Position; } yyattribute_name;
typedef struct { cvn Tree; tPosition Position; } yyexpression;
typedef struct { cvn Tree; tPosition Position; } yyrelation;
typedef struct { cvn Tree; tPosition Position; } yyterm;
typedef struct { cvn Tree; tPosition Position; } yyfactor;
typedef struct { cvn Tree; tPosition Position; } yyprimary;
typedef struct { tOperator Op; } yybinary_logical_operator;
typedef struct { tOperator Op; } yymultiplying_logical_operator;
typedef struct { tOperator Op; } yyrelational_operator;
typedef struct { tOperator Op; } yyadding_operator;
typedef struct { tOperator Op; } yysign;
typedef struct { tOperator Op; } yymultiplying_operator;
typedef struct { tOperator Op; } yyunary_operator;
typedef struct { cvn Tree; } yysequential_statements;
typedef struct { cvn Tree; } yysequential_statement;
typedef struct { cvn Tree; } yyname_sequential_statement;
typedef struct { cvn Tree; } yyno_name_sequential_statement;
typedef struct { cvn Tree; } yyopt_sensitivity_clause;
typedef struct { cvn Tree; } yysensitivity_list;
typedef struct { cvn Tree; } yyopt_condition_clause;
typedef struct { cvn Tree; tPosition Position; } yycondition;
typedef struct { cvn Tree; } yywaveform;
typedef struct { cvn Tree; } yywaveform_element;
typedef struct { cvn Tree; } yythen_part;
typedef struct { cvn Tree; } yyelsif_parts;
typedef struct { cvn Tree; } yyelse_part;
typedef struct { cvn Tree; } yycase_alternatives;
typedef struct { cvn Tree; } yycase_alternative;
typedef struct { cvn Tree; } yychoices;
typedef struct { cvn Tree; } yychoice;
typedef struct { cvn Tree; } yyiteration_scheme;
typedef struct { cvn Tree; } yyparameter_specification;
typedef struct { cvn Tree; } yyconcurrent_statements;
typedef struct { cvn Tree; } yyconcurrent_statement;
typedef struct { cvn Tree; } yyname_concurrent_statement;
typedef struct { cvn Tree; } yylabeled_concurrent_statement;
typedef struct { cvn Tree; } yylabeled_opt_concurrent_statement;
typedef struct { cvn Tree; } yylabeled_req_concurrent_statement;
typedef struct { cvn Tree; } yyopt_sensitivity_list;
typedef struct { cvn Tree; } yyprocess_declarative_part;
typedef struct { cvn Tree; } yyprocess_declarative_item;
typedef struct { cvn Tree; } yyconditional_waveform;
typedef struct { cvn Tree; } yyconditional_waveform_parts;
typedef struct { cvn Tree; } yyselected_waveforms;
typedef struct { cvn Tree; } yyselected_waveform;
typedef struct { cvn Tree; } yyuse_clause;
typedef struct { cvn Tree; } yyuse_selected_name_list;
typedef struct { cvn Tree; } yyuse_selected_name;
typedef struct { tString Id; unsigned All; } yyuse_suffix;
typedef struct { cvn Tree; } yydesign_file;
typedef struct { cvn Tree; } yydesign_unit;
typedef struct { cvn Tree; } yylibrary_unit;
typedef struct { cvn Tree; } yycontext_clause;
typedef struct { cvn Tree; } yycontext_item;
typedef struct { cvn Tree; tPosition Position; } yyabstract_literal;

typedef union {
 tScanAttribute Scan;
 yyentity_declaration entity_declaration;
 yyopt_identifier opt_identifier;
 yyopt_port_clause opt_port_clause;
 yyport_clause port_clause;
 yyarchitecture_body architecture_body;
 yyblock_declarative_part block_declarative_part;
 yyblock_declarative_item block_declarative_item;
 yypackage_declaration package_declaration;
 yyopt_package opt_package;
 yypackage_declarative_part package_declarative_part;
 yypackage_declarative_item package_declarative_item;
 yypackage_body package_body;
 yypackage_body_declarative_part package_body_declarative_part;
 yypackage_body_declarative_item package_body_declarative_item;
 yytype_definition type_definition;
 yyrange_constraint range_constraint;
 yyrange range;
 yydirection direction;
 yyenumeration_list enumeration_list;
 yyenumeration_literal enumeration_literal;
 yydiscrete_range discrete_range;
 yyidentifier_list identifier_list;
 yytype_declaration type_declaration;
 yysubtype_declaration subtype_declaration;
 yysubtype_indication subtype_indication;
 yyopt_range_constraint opt_range_constraint;
 yyconstant_declaration constant_declaration;
 yyopt_initial_value opt_initial_value;
 yysignal_declaration signal_declaration;
 yyvariable_declaration variable_declaration;
 yyinterface_list interface_list;
 yyclass class;
 yymode mode;
 yyname name;
 yypure_selected_name pure_selected_name;
 yyother_name other_name;
 yysimple_name simple_name;
 yyparenthesis_name parenthesis_name;
 yyattribute_name attribute_name;
 yyexpression expression;
 yyrelation relation;
 yyterm term;
 yyfactor factor;
 yyprimary primary;
 yybinary_logical_operator binary_logical_operator;
 yymultiplying_logical_operator multiplying_logical_operator;
 yyrelational_operator relational_operator;
 yyadding_operator adding_operator;
 yysign sign;
 yymultiplying_operator multiplying_operator;
 yyunary_operator unary_operator;
 yysequential_statements sequential_statements;
 yysequential_statement sequential_statement;
 yyname_sequential_statement name_sequential_statement;
 yyno_name_sequential_statement no_name_sequential_statement;
 yyopt_sensitivity_clause opt_sensitivity_clause;
 yysensitivity_list sensitivity_list;
 yyopt_condition_clause opt_condition_clause;
 yycondition condition;
 yywaveform waveform;
 yywaveform_element waveform_element;
 yythen_part then_part;
 yyelsif_parts elsif_parts;
 yyelse_part else_part;
 yycase_alternatives case_alternatives;
 yycase_alternative case_alternative;
 yychoices choices;
 yychoice choice;
 yyiteration_scheme iteration_scheme;
 yyparameter_specification parameter_specification;
 yyconcurrent_statements concurrent_statements;
 yyconcurrent_statement concurrent_statement;
 yyname_concurrent_statement name_concurrent_statement;
 yylabeled_concurrent_statement labeled_concurrent_statement;
 yylabeled_opt_concurrent_statement labeled_opt_concurrent_statement;
 yylabeled_req_concurrent_statement labeled_req_concurrent_statement;
 yyopt_sensitivity_list opt_sensitivity_list;
 yyprocess_declarative_part process_declarative_part;
 yyprocess_declarative_item process_declarative_item;
 yyconditional_waveform conditional_waveform;
 yyconditional_waveform_parts conditional_waveform_parts;
 yyselected_waveforms selected_waveforms;
 yyselected_waveform selected_waveform;
 yyuse_clause use_clause;
 yyuse_selected_name_list use_selected_name_list;
 yyuse_selected_name use_selected_name;
 yyuse_suffix use_suffix;
 yydesign_file design_file;
 yydesign_unit design_unit;
 yylibrary_unit library_unit;
 yycontext_clause context_clause;
 yycontext_item context_item;
 yyabstract_literal abstract_literal;
} tParsAttribute;


# if defined lex_interface & ! defined yylvalDef
     tParsAttribute yylval;
# endif

# ifndef yyInitStackSize
#    define yyInitStackSize	100
# endif
# define yyNoState		0

# define yyFirstTerminal	0
# define yyLastTerminal		108
# define yyTableMax		1734
# define yyNTableMax		2661
# define yyFirstReadState	1
# define yyLastReadState	501
# define yyFirstReadTermState	502
# define yyLastReadTermState	663
# define yyLastReadNontermState	856
# define yyFirstReduceState	857
# define yyLastReduceState	1340
# define yyStartState		1
# define yyStopState		857

# define yyFirstFinalState	yyFirstReadTermState

typedef unsigned short	yyStateRange	;
typedef unsigned short	yySymbolRange	;
typedef struct	{ yyStateRange Check, Next; } yyTCombType ;

	char *		Parser_TokenName	[yyLastTerminal + 1] = {
"_EndOfFile",
"identifier",
"decimal_literal",
"based_literal",
"character_literal",
"string_literal",
"bit_string_literal",
"LIBRARY",
",",
";",
"USE",
".",
"ALL",
"ENTITY",
"IS",
"GENERIC",
"(",
"CONSTANT",
"VARIABLE",
"SIGNAL",
":",
"IN",
"OUT",
"INOUT",
"RANGE",
"'",
")",
"OTHERS",
"discrete_range_no_name",
"|",
"!",
"=>",
"**",
"ABS",
"NOT",
"*",
"/",
"MOD",
"REM",
"+",
"-",
"&",
"=",
"/=",
"<",
"<=",
">",
">=",
"NAND",
"NOR",
"AND",
"OR",
"XOR",
"XNOR",
"TO",
"DOWNTO",
":=",
"PORT",
"PROCEDURE",
"FUNCTION",
"RETURN",
"TYPE",
"UNITS",
"END",
"ARRAY",
"<>",
"OF",
"RECORD",
"SUBTYPE",
"ALIAS",
"ATTRIBUTE",
"ARCHITECTURE",
"PACKAGE",
"LABEL",
"BEGIN",
"TRANSPORT",
"REJECT",
"INERTIAL",
"AFTER",
"WAIT",
"ON",
"UNTIL",
"FOR",
"ASSERT",
"REPORT",
"SEVERITY",
"IF",
"THEN",
"ELSIF",
"ELSE",
"CASE",
"WHEN",
"WHILE",
"LOOP",
"NEXT",
"EXIT",
"NULL",
"concurrent_procedure_call",
"PROCESS",
"CONFIGURATION",
"OPEN",
"MAP",
"COMPONENT",
"WITH",
"SELECT",
"GUARDED",
"BLOCK",
"GENERATE",
"BODY",
};
static	yyTCombType	yyTComb		[yyTableMax + 1] = {
{501, 857},
{6, 502},
{8, 503},
{9, 10},
{3, 858},
{11, 12},
{16, 17},
{1, 859},
{26, 509},
{2, 1323},
{1, 859},
{3, 1325},
{2, 1323},
{1, 859},
{3, 1325},
{2, 1323},
{5, 6},
{3, 1325},
{10, 11},
{5, 9},
{7, 8},
{7, 504},
{5, 16},
{12, 1320},
{12, 1320},
{13, 505},
{12, 13},
{14, 15},
{14, 507},
{17, 18},
{20, 21},
{22, 105},
{25, 27},
{32, 1240},
{32, 1240},
{32, 1240},
{13, 506},
{39, 40},
{18, 861},
{38, 520},
{38, 521},
{41, 995},
{48, 49},
{18, 861},
{59, 60},
{18, 861},
{41, 995},
{18, 861},
{64, 540},
{49, 531},
{82, 83},
{42, 522},
{42, 523},
{42, 524},
{84, 1184},
{54, 510},
{19, 867},
{49, 533},
{54, 513},
{54, 514},
{54, 515},
{68, 518},
{68, 519},
{19, 867},
{78, 79},
{19, 867},
{42, 534},
{42, 535},
{74, 534},
{74, 535},
{54, 31},
{1, 859},
{1, 859},
{2, 1323},
{2, 1323},
{3, 1325},
{3, 1325},
{44, 996},
{44, 996},
{86, 87},
{5, 322},
{5, 453},
{78, 547},
{44, 996},
{90, 517},
{18, 861},
{18, 861},
{18, 861},
{41, 995},
{18, 861},
{93, 94},
{18, 861},
{81, 1053},
{96, 551},
{41, 995},
{44, 996},
{18, 861},
{18, 861},
{18, 861},
{1, 859},
{105, 558},
{2, 1323},
{18, 861},
{3, 1325},
{19, 867},
{19, 867},
{107, 108},
{19, 867},
{5, 473},
{95, 1052},
{81, 548},
{34, 1151},
{34, 1151},
{110, 1033},
{19, 867},
{19, 867},
{19, 867},
{34, 1151},
{89, 549},
{89, 550},
{19, 867},
{70, 543},
{70, 544},
{70, 545},
{70, 546},
{44, 996},
{112, 113},
{95, 1182},
{114, 115},
{34, 1151},
{115, 559},
{44, 996},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{119, 120},
{122, 560},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{34, 1151},
{124, 125},
{127, 561},
{44, 996},
{134, 135},
{133, 130},
{34, 1151},
{61, 522},
{61, 523},
{61, 524},
{61, 525},
{61, 526},
{61, 527},
{61, 528},
{61, 529},
{61, 530},
{137, 138},
{44, 996},
{101, 1115},
{88, 1236},
{88, 1236},
{34, 1151},
{34, 1151},
{101, 38},
{92, 1237},
{92, 1237},
{34, 1151},
{138, 139},
{34, 1151},
{34, 1151},
{132, 562},
{34, 1151},
{101, 47},
{34, 1151},
{132, 532},
{34, 1151},
{104, 1040},
{34, 1151},
{35, 1009},
{35, 1009},
{88, 1238},
{88, 1238},
{88, 1236},
{139, 140},
{35, 1009},
{92, 1239},
{92, 1239},
{92, 1237},
{34, 1151},
{133, 937},
{129, 937},
{34, 1151},
{104, 555},
{104, 556},
{104, 557},
{129, 937},
{35, 1009},
{129, 130},
{117, 123},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{144, 145},
{149, 567},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{35, 1009},
{150, 151},
{136, 1031},
{131, 23},
{136, 36},
{139, 144},
{35, 1009},
{136, 1031},
{139, 161},
{154, 568},
{140, 1003},
{159, 160},
{76, 997},
{140, 1003},
{141, 142},
{161, 508},
{117, 862},
{157, 40},
{37, 1108},
{37, 1108},
{131, 563},
{35, 1009},
{35, 1009},
{117, 193},
{37, 1108},
{148, 36},
{35, 1009},
{117, 862},
{35, 1009},
{35, 1009},
{76, 997},
{35, 1009},
{141, 566},
{35, 1009},
{162, 163},
{35, 1009},
{37, 1108},
{35, 1009},
{148, 149},
{37, 1108},
{37, 1108},
{37, 1108},
{163, 570},
{76, 522},
{76, 523},
{76, 524},
{91, 1240},
{91, 1240},
{35, 1009},
{164, 165},
{166, 571},
{35, 1009},
{37, 1108},
{37, 1108},
{37, 1108},
{37, 1108},
{37, 1108},
{37, 1108},
{37, 1108},
{37, 1108},
{37, 1108},
{37, 1108},
{37, 1108},
{37, 1108},
{130, 1041},
{146, 147},
{37, 1108},
{91, 1240},
{91, 1240},
{91, 1240},
{143, 564},
{167, 168},
{37, 1108},
{143, 565},
{169, 572},
{155, 156},
{170, 573},
{91, 522},
{91, 523},
{91, 524},
{130, 1041},
{130, 1041},
{130, 1041},
{146, 150},
{46, 1109},
{46, 1109},
{157, 1029},
{37, 1108},
{37, 1108},
{103, 1045},
{46, 1109},
{46, 1109},
{37, 1108},
{155, 569},
{37, 1108},
{37, 1108},
{46, 1109},
{37, 1108},
{172, 173},
{37, 1108},
{157, 1029},
{37, 1108},
{46, 1109},
{37, 1108},
{173, 574},
{46, 1109},
{46, 1109},
{46, 1109},
{176, 177},
{103, 552},
{103, 553},
{103, 554},
{178, 575},
{174, 1006},
{37, 1108},
{171, 989},
{175, 176},
{37, 1108},
{46, 1109},
{46, 1109},
{46, 1109},
{46, 1109},
{46, 1109},
{46, 1109},
{46, 1109},
{46, 1109},
{46, 1109},
{46, 1109},
{46, 1109},
{46, 1109},
{177, 511},
{177, 512},
{46, 1109},
{46, 1109},
{97, 1029},
{180, 181},
{97, 36},
{182, 183},
{46, 1109},
{97, 1029},
{183, 184},
{97, 38},
{185, 577},
{186, 578},
{189, 190},
{191, 580},
{186, 579},
{193, 194},
{194, 195},
{97, 40},
{97, 98},
{97, 1029},
{108, 1046},
{46, 1109},
{46, 1109},
{196, 581},
{187, 1055},
{46, 1109},
{46, 1109},
{153, 510},
{46, 1109},
{46, 1109},
{187, 188},
{46, 1109},
{197, 198},
{46, 1109},
{153, 1029},
{46, 1109},
{171, 172},
{46, 1109},
{50, 1144},
{50, 1144},
{108, 1046},
{108, 1046},
{108, 1046},
{174, 1006},
{50, 1144},
{199, 200},
{175, 180},
{201, 585},
{46, 1109},
{97, 1029},
{153, 154},
{46, 1109},
{153, 1029},
{198, 583},
{202, 203},
{204, 1083},
{50, 1144},
{205, 206},
{216, 596},
{50, 1144},
{50, 1144},
{50, 1144},
{194, 1116},
{206, 582},
{206, 532},
{207, 1084},
{228, 600},
{204, 1079},
{198, 584},
{50, 1144},
{50, 1144},
{50, 1144},
{219, 220},
{227, 1033},
{229, 230},
{209, 887},
{208, 885},
{207, 1080},
{50, 1144},
{50, 1144},
{50, 1144},
{50, 1144},
{50, 1144},
{50, 1144},
{50, 1144},
{50, 1144},
{50, 1144},
{208, 209},
{99, 1029},
{99, 1029},
{219, 598},
{99, 36},
{50, 1144},
{210, 886},
{99, 1029},
{209, 887},
{99, 38},
{231, 182},
{231, 186},
{225, 26},
{233, 236},
{234, 1249},
{235, 602},
{231, 232},
{237, 943},
{99, 98},
{99, 1029},
{50, 1144},
{50, 1144},
{209, 887},
{209, 887},
{225, 226},
{50, 1144},
{210, 211},
{50, 1144},
{50, 1144},
{238, 605},
{50, 1144},
{244, 1216},
{50, 1144},
{227, 30},
{50, 1144},
{246, 606},
{50, 1144},
{52, 1147},
{52, 1147},
{111, 870},
{210, 597},
{210, 217},
{248, 249},
{52, 1147},
{253, 607},
{256, 608},
{111, 870},
{50, 1144},
{111, 870},
{99, 1029},
{50, 1144},
{242, 1213},
{258, 259},
{251, 1218},
{262, 263},
{52, 1147},
{263, 264},
{265, 266},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 53},
{266, 1185},
{255, 1220},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{52, 1147},
{99, 1029},
{111, 870},
{111, 870},
{272, 610},
{111, 870},
{52, 1147},
{273, 1251},
{275, 611},
{276, 612},
{241, 220},
{241, 1210},
{111, 870},
{111, 870},
{111, 870},
{99, 1029},
{277, 613},
{274, 1247},
{111, 870},
{244, 245},
{279, 280},
{52, 1147},
{52, 1147},
{281, 282},
{55, 1142},
{55, 1142},
{52, 1147},
{277, 278},
{52, 1147},
{52, 1147},
{55, 1142},
{52, 1147},
{236, 940},
{52, 1147},
{260, 1227},
{52, 1147},
{236, 940},
{52, 1147},
{242, 243},
{242, 1213},
{236, 940},
{282, 283},
{55, 1142},
{251, 213},
{251, 1218},
{55, 1142},
{55, 1142},
{55, 1142},
{52, 1147},
{284, 614},
{293, 617},
{52, 1147},
{277, 285},
{239, 1209},
{255, 215},
{55, 1142},
{55, 1142},
{55, 1142},
{267, 1234},
{260, 1227},
{260, 1227},
{291, 292},
{291, 616},
{277, 294},
{55, 1142},
{55, 1142},
{55, 1142},
{55, 1142},
{55, 1142},
{55, 1142},
{55, 1142},
{55, 1142},
{55, 1142},
{295, 618},
{100, 1028},
{100, 1028},
{296, 297},
{100, 1113},
{55, 1142},
{297, 298},
{100, 1028},
{299, 619},
{100, 1113},
{241, 1210},
{241, 1210},
{303, 304},
{267, 1234},
{307, 1231},
{300, 1228},
{236, 603},
{236, 604},
{100, 1113},
{100, 1028},
{55, 1142},
{55, 1142},
{304, 1185},
{304, 1185},
{308, 309},
{55, 1142},
{274, 271},
{55, 1142},
{55, 1142},
{309, 310},
{55, 1142},
{310, 1251},
{55, 1142},
{311, 620},
{55, 1142},
{312, 313},
{55, 1142},
{57, 1143},
{57, 1143},
{116, 873},
{300, 1228},
{300, 1228},
{314, 315},
{57, 1143},
{315, 316},
{317, 621},
{116, 873},
{55, 1142},
{116, 873},
{100, 1028},
{55, 1142},
{239, 240},
{239, 1209},
{239, 1209},
{318, 319},
{57, 1143},
{288, 1225},
{288, 1225},
{57, 1143},
{57, 1143},
{57, 1143},
{321, 623},
{322, 323},
{319, 863},
{57, 536},
{57, 537},
{57, 538},
{57, 539},
{57, 1143},
{57, 1143},
{57, 1143},
{319, 863},
{323, 324},
{325, 326},
{329, 609},
{319, 622},
{301, 1230},
{57, 1143},
{57, 1143},
{57, 1143},
{57, 1143},
{57, 1143},
{57, 1143},
{57, 1143},
{57, 1143},
{57, 1143},
{100, 1028},
{116, 873},
{116, 873},
{330, 331},
{116, 873},
{57, 1143},
{116, 873},
{289, 1224},
{289, 1224},
{331, 332},
{332, 333},
{116, 873},
{116, 873},
{116, 873},
{100, 1028},
{301, 302},
{301, 306},
{116, 873},
{305, 1229},
{334, 626},
{57, 1143},
{57, 1143},
{336, 337},
{63, 1141},
{63, 1141},
{57, 1143},
{337, 338},
{57, 1143},
{57, 1143},
{63, 1141},
{57, 1143},
{58, 36},
{57, 1143},
{338, 627},
{57, 1143},
{339, 340},
{57, 1143},
{341, 628},
{342, 1106},
{343, 344},
{288, 1225},
{63, 1141},
{344, 345},
{305, 1229},
{305, 1229},
{58, 59},
{346, 630},
{57, 1143},
{348, 349},
{349, 350},
{57, 1143},
{350, 516},
{58, 1108},
{288, 1225},
{352, 632},
{58, 1108},
{58, 1108},
{58, 1108},
{58, 1108},
{58, 1108},
{58, 1108},
{58, 1108},
{351, 85},
{63, 1141},
{63, 1141},
{63, 1141},
{63, 1141},
{63, 1141},
{63, 1141},
{353, 354},
{65, 1134},
{65, 1134},
{335, 1095},
{357, 609},
{58, 1108},
{58, 1108},
{65, 1134},
{289, 290},
{335, 1095},
{335, 1097},
{351, 631},
{358, 359},
{356, 357},
{362, 363},
{355, 1086},
{355, 36},
{363, 364},
{364, 633},
{65, 1134},
{77, 1108},
{289, 1224},
{365, 366},
{63, 1141},
{63, 1141},
{356, 1087},
{331, 339},
{331, 629},
{63, 1141},
{367, 368},
{63, 1141},
{63, 1141},
{370, 635},
{63, 1141},
{361, 112},
{63, 1141},
{77, 1031},
{63, 1141},
{77, 1108},
{63, 1141},
{361, 870},
{65, 541},
{65, 542},
{65, 1136},
{65, 1136},
{65, 1136},
{65, 1136},
{375, 376},
{377, 378},
{378, 379},
{63, 1141},
{335, 1095},
{380, 636},
{63, 1141},
{77, 1108},
{77, 1108},
{77, 1108},
{77, 1108},
{77, 1108},
{77, 1108},
{77, 1108},
{77, 1108},
{77, 1108},
{77, 1108},
{77, 1108},
{77, 1108},
{382, 383},
{384, 385},
{355, 1086},
{395, 396},
{65, 1134},
{65, 1134},
{397, 398},
{67, 1138},
{67, 1138},
{65, 1134},
{398, 640},
{65, 1134},
{65, 1134},
{67, 1138},
{65, 1134},
{387, 292},
{65, 1134},
{333, 1100},
{65, 1134},
{333, 334},
{65, 1134},
{355, 1086},
{401, 641},
{333, 1100},
{333, 1100},
{67, 1138},
{359, 599},
{359, 1062},
{67, 1142},
{67, 1142},
{67, 1142},
{65, 1134},
{389, 390},
{389, 638},
{65, 1134},
{404, 405},
{407, 642},
{408, 409},
{67, 1142},
{67, 1142},
{67, 1142},
{67, 1142},
{67, 1142},
{67, 1142},
{67, 1142},
{67, 1142},
{67, 1142},
{67, 1138},
{67, 1138},
{67, 1138},
{67, 1138},
{67, 1138},
{67, 1138},
{67, 1142},
{67, 1142},
{409, 1104},
{192, 1108},
{192, 1108},
{411, 643},
{414, 644},
{392, 639},
{416, 1104},
{192, 1108},
{192, 1108},
{192, 38},
{333, 1100},
{417, 645},
{416, 348},
{192, 1108},
{359, 1062},
{368, 895},
{392, 393},
{419, 1275},
{192, 98},
{192, 1108},
{359, 1062},
{67, 1138},
{67, 1138},
{368, 895},
{69, 1139},
{69, 1139},
{67, 1138},
{420, 421},
{67, 1138},
{67, 1138},
{69, 1139},
{67, 1138},
{422, 423},
{67, 1138},
{340, 1102},
{67, 1138},
{340, 341},
{67, 1138},
{192, 1108},
{360, 20},
{340, 1102},
{392, 448},
{69, 1139},
{387, 388},
{423, 424},
{69, 1143},
{69, 1143},
{69, 1143},
{67, 1138},
{192, 1108},
{192, 1108},
{67, 1138},
{425, 646},
{428, 647},
{429, 430},
{69, 1143},
{69, 1143},
{69, 1143},
{69, 1143},
{69, 1143},
{69, 1143},
{69, 1143},
{69, 1143},
{69, 1143},
{69, 1139},
{69, 1139},
{69, 1139},
{69, 1139},
{69, 1139},
{69, 1139},
{69, 1143},
{69, 1143},
{72, 1135},
{72, 1135},
{192, 1108},
{192, 1108},
{432, 1282},
{433, 648},
{72, 1135},
{435, 1306},
{437, 649},
{360, 867},
{340, 1102},
{438, 1106},
{439, 650},
{368, 634},
{440, 441},
{360, 867},
{442, 651},
{396, 1312},
{72, 1135},
{445, 446},
{447, 652},
{69, 1139},
{69, 1139},
{396, 1312},
{396, 397},
{451, 1261},
{69, 1139},
{444, 445},
{69, 1139},
{69, 1139},
{452, 653},
{69, 1139},
{454, 455},
{69, 1139},
{458, 601},
{69, 1139},
{453, 454},
{69, 1139},
{459, 460},
{462, 655},
{464, 465},
{468, 469},
{72, 1137},
{72, 1137},
{72, 1137},
{72, 1137},
{470, 656},
{444, 211},
{69, 1139},
{158, 1109},
{472, 657},
{69, 1139},
{158, 1109},
{158, 1109},
{158, 1109},
{158, 1109},
{158, 1109},
{158, 1109},
{158, 1109},
{438, 343},
{473, 474},
{457, 123},
{444, 371},
{474, 475},
{475, 510},
{396, 1312},
{476, 477},
{444, 381},
{480, 481},
{72, 1135},
{72, 1135},
{158, 1109},
{158, 1109},
{482, 658},
{72, 1135},
{485, 486},
{72, 1135},
{72, 1135},
{486, 487},
{72, 1135},
{460, 960},
{72, 1135},
{487, 659},
{72, 1135},
{492, 493},
{72, 1135},
{80, 1140},
{80, 1140},
{460, 960},
{435, 436},
{230, 945},
{490, 1093},
{80, 1140},
{493, 494},
{485, 488},
{469, 977},
{72, 1135},
{230, 945},
{230, 945},
{72, 1135},
{481, 921},
{481, 482},
{494, 660},
{469, 977},
{80, 1140},
{457, 959},
{481, 38},
{80, 1144},
{80, 1144},
{80, 1144},
{490, 1093},
{495, 661},
{457, 193},
{80, 536},
{80, 537},
{80, 538},
{80, 539},
{80, 1144},
{80, 1144},
{80, 1144},
{80, 1144},
{80, 1144},
{80, 1144},
{80, 1144},
{80, 1144},
{80, 1144},
{80, 1140},
{80, 1140},
{80, 1140},
{80, 1140},
{80, 1140},
{80, 1140},
{80, 1144},
{80, 1144},
{483, 924},
{496, 497},
{499, 663},
{0, 0},
{230, 945},
{230, 945},
{491, 918},
{230, 945},
{477, 914},
{453, 463},
{457, 358},
{478, 9},
{102, 1027},
{102, 1027},
{230, 945},
{230, 945},
{230, 945},
{460, 654},
{102, 1027},
{481, 921},
{230, 945},
{80, 1140},
{80, 1140},
{0, 0},
{0, 0},
{491, 480},
{80, 1140},
{0, 0},
{80, 1140},
{80, 1140},
{102, 1027},
{80, 1140},
{469, 470},
{80, 1140},
{0, 0},
{80, 1140},
{102, 1113},
{80, 1140},
{481, 921},
{102, 1113},
{102, 1113},
{102, 1113},
{102, 1113},
{102, 1113},
{102, 1113},
{102, 1113},
{152, 995},
{498, 576},
{80, 1140},
{152, 1112},
{441, 1285},
{80, 1140},
{0, 0},
{483, 924},
{152, 1112},
{498, 865},
{0, 0},
{489, 1314},
{102, 1113},
{102, 1113},
{102, 1027},
{203, 586},
{0, 0},
{152, 1112},
{152, 995},
{203, 587},
{203, 588},
{203, 589},
{477, 914},
{489, 1314},
{152, 1112},
{478, 479},
{483, 924},
{152, 1112},
{152, 1112},
{152, 1112},
{152, 1112},
{152, 1112},
{152, 1112},
{152, 1112},
{477, 914},
{0, 0},
{0, 0},
{478, 480},
{0, 0},
{450, 1307},
{450, 1307},
{450, 1307},
{450, 1307},
{450, 1307},
{450, 1307},
{0, 0},
{152, 1112},
{152, 1112},
{0, 0},
{326, 893},
{484, 9},
{102, 1027},
{0, 0},
{0, 0},
{450, 1307},
{0, 0},
{326, 893},
{278, 234},
{326, 893},
{497, 912},
{203, 590},
{203, 591},
{0, 0},
{203, 592},
{0, 0},
{102, 1027},
{441, 1285},
{497, 912},
{0, 0},
{443, 1253},
{0, 0},
{450, 1307},
{450, 1307},
{203, 593},
{203, 594},
{203, 595},
{278, 239},
{450, 1307},
{450, 1307},
{278, 247},
{278, 250},
{278, 254},
{328, 118},
{278, 257},
{328, 123},
{152, 995},
{441, 1285},
{278, 261},
{0, 0},
{278, 268},
{0, 0},
{278, 269},
{278, 273},
{278, 276},
{488, 489},
{0, 0},
{0, 0},
{326, 893},
{326, 893},
{152, 995},
{326, 893},
{441, 1285},
{0, 0},
{484, 926},
{373, 1296},
{488, 624},
{441, 1285},
{326, 893},
{326, 893},
{326, 893},
{371, 1294},
{373, 1296},
{373, 1296},
{326, 893},
{371, 1294},
{0, 0},
{371, 218},
{371, 1294},
{371, 1294},
{0, 0},
{488, 625},
{326, 893},
{484, 926},
{328, 128},
{328, 132},
{0, 0},
{328, 137},
{376, 1185},
{0, 0},
{0, 0},
{374, 9},
{443, 1253},
{0, 0},
{328, 182},
{328, 186},
{328, 193},
{372, 1062},
{374, 118},
{374, 224},
{328, 894},
{372, 599},
{326, 893},
{0, 0},
{372, 1062},
{372, 1062},
{0, 0},
{0, 0},
{328, 329},
{393, 1258},
{0, 0},
{0, 0},
{443, 1253},
{373, 1296},
{373, 1296},
{0, 0},
{373, 1296},
{0, 0},
{497, 662},
{371, 1294},
{371, 1294},
{393, 1258},
{371, 1294},
{0, 0},
{0, 0},
{373, 1296},
{0, 0},
{443, 1253},
{328, 358},
{373, 1296},
{0, 0},
{371, 1294},
{443, 1253},
{0, 0},
{0, 0},
{371, 1294},
{0, 0},
{0, 0},
{500, 1335},
{374, 128},
{374, 132},
{500, 1335},
{374, 137},
{0, 0},
{500, 1335},
{372, 1062},
{372, 1062},
{376, 1185},
{372, 1062},
{0, 0},
{376, 1185},
{374, 193},
{0, 0},
{0, 0},
{0, 0},
{374, 1269},
{394, 395},
{372, 1062},
{0, 0},
{0, 0},
{0, 0},
{372, 1062},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{376, 1185},
{0, 0},
{0, 0},
{376, 1185},
{376, 1185},
{376, 1185},
{0, 0},
{376, 1185},
{0, 0},
{0, 0},
{0, 0},
{376, 1185},
{0, 0},
{376, 1185},
{0, 0},
{376, 1185},
{376, 1185},
{376, 1185},
{391, 1193},
{391, 1193},
{391, 1193},
{391, 1193},
{391, 1193},
{391, 1193},
{393, 1258},
{393, 1258},
{0, 0},
{0, 0},
{393, 1258},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{391, 1193},
{0, 0},
{0, 0},
{500, 1335},
{500, 1335},
{0, 0},
{0, 0},
{393, 1258},
{393, 1258},
{0, 0},
{0, 0},
{393, 1258},
{393, 1258},
{0, 0},
{0, 0},
{393, 1258},
{0, 0},
{391, 1193},
{391, 1193},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{391, 1193},
{391, 1193},
{0, 0},
{394, 402},
{394, 211},
{412, 1287},
{0, 0},
{394, 403},
{500, 1335},
{0, 0},
{412, 1287},
{412, 413},
{412, 1287},
{0, 0},
{412, 1287},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{394, 371},
{394, 404},
{0, 0},
{0, 0},
{394, 408},
{394, 381},
{0, 0},
{0, 0},
{394, 412},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{415, 1290},
{0, 0},
{391, 615},
{391, 286},
{391, 1196},
{415, 20},
{0, 0},
{415, 1290},
{0, 0},
{415, 1290},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{418, 897},
{412, 1287},
{412, 1287},
{412, 1287},
{0, 0},
{412, 1287},
{0, 0},
{418, 897},
{0, 0},
{418, 897},
{0, 0},
{0, 0},
{412, 1287},
{412, 1287},
{412, 1287},
{0, 0},
{0, 0},
{0, 0},
{412, 1287},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{412, 1287},
{0, 0},
{0, 0},
{426, 1292},
{415, 1290},
{415, 1290},
{415, 1290},
{0, 0},
{415, 1290},
{0, 0},
{426, 1292},
{0, 0},
{426, 1292},
{0, 0},
{0, 0},
{415, 1290},
{415, 1290},
{415, 1290},
{0, 0},
{0, 0},
{412, 1287},
{415, 1290},
{418, 897},
{418, 897},
{0, 0},
{418, 897},
{0, 0},
{0, 0},
{0, 0},
{415, 1290},
{0, 0},
{0, 0},
{418, 897},
{418, 897},
{418, 897},
{0, 0},
{0, 0},
{0, 0},
{418, 897},
{0, 0},
{448, 1260},
{448, 1260},
{448, 1260},
{448, 1260},
{448, 1260},
{448, 1260},
{418, 897},
{0, 0},
{0, 0},
{415, 1290},
{426, 112},
{426, 1292},
{426, 1292},
{0, 0},
{426, 1292},
{448, 1260},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{426, 1292},
{426, 1292},
{426, 1292},
{0, 0},
{0, 0},
{418, 897},
{426, 1292},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{448, 1260},
{448, 1260},
{0, 0},
{426, 1292},
{0, 0},
{0, 0},
{448, 1260},
{448, 1260},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{449, 1264},
{449, 1264},
{449, 1264},
{449, 1264},
{449, 1264},
{449, 1264},
{0, 0},
{455, 958},
{0, 0},
{0, 0},
{426, 1292},
{0, 0},
{0, 0},
{0, 0},
{455, 958},
{449, 1264},
{455, 958},
{0, 0},
{0, 0},
{0, 0},
{465, 975},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{465, 975},
{0, 0},
{448, 1260},
{448, 1260},
{448, 1260},
{449, 1264},
{449, 1264},
{456, 962},
{0, 0},
{0, 0},
{0, 0},
{449, 1264},
{449, 1264},
{0, 0},
{456, 962},
{0, 0},
{456, 962},
{0, 0},
{0, 0},
{0, 0},
{466, 979},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{466, 979},
{455, 958},
{455, 958},
{0, 0},
{455, 958},
{448, 1260},
{455, 958},
{0, 0},
{0, 0},
{467, 9},
{0, 0},
{455, 958},
{455, 958},
{455, 958},
{465, 975},
{465, 975},
{467, 118},
{465, 975},
{0, 0},
{465, 975},
{449, 1264},
{449, 1264},
{449, 1264},
{0, 0},
{465, 975},
{465, 975},
{0, 0},
{0, 0},
{456, 962},
{456, 962},
{0, 0},
{456, 962},
{0, 0},
{456, 962},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{456, 962},
{456, 962},
{456, 962},
{466, 979},
{466, 979},
{0, 0},
{466, 979},
{455, 958},
{466, 979},
{0, 0},
{0, 0},
{0, 0},
{449, 637},
{466, 979},
{466, 979},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{467, 128},
{467, 132},
{0, 0},
{467, 137},
{0, 0},
{467, 976},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{467, 182},
{467, 186},
{0, 0},
{0, 0},
{0, 0},
{456, 962},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
{0, 0},
};
static	unsigned short	yyNComb		[yyNTableMax - yyLastTerminal] = {
2,
3,
501,
19,
111,
116,
117,
0,
318,
320,
720,
847,
787,
22,
786,
317,
321,
370,
380,
361,
362,
425,
447,
462,
114,
848,
210,
787,
472,
786,
839,
771,
772,
773,
327,
328,
849,
131,
367,
369,
419,
422,
444,
850,
478,
498,
483,
484,
499,
688,
838,
0,
680,
485,
688,
129,
707,
134,
708,
133,
673,
670,
708,
231,
233,
673,
237,
260,
267,
851,
281,
669,
669,
674,
678,
678,
852,
197,
674,
305,
689,
670,
170,
171,
29,
702,
159,
174,
671,
175,
307,
314,
377,
75,
721,
43,
456,
97,
35,
710,
143,
25,
669,
670,
102,
701,
107,
106,
703,
24,
104,
705,
104,
28,
109,
706,
103,
103,
106,
671,
61,
104,
669,
119,
122,
124,
672,
34,
37,
127,
722,
106,
189,
101,
104,
677,
675,
700,
48,
671,
32,
681,
679,
687,
669,
66,
672,
34,
37,
33,
62,
45,
51,
71,
726,
677,
222,
81,
709,
669,
225,
671,
228,
82,
46,
93,
214,
670,
672,
34,
37,
65,
669,
70,
141,
67,
68,
677,
774,
685,
216,
52,
54,
90,
46,
148,
712,
187,
711,
143,
162,
65,
242,
70,
670,
67,
68,
670,
136,
685,
221,
52,
54,
96,
699,
167,
46,
223,
669,
244,
14,
668,
666,
500,
664,
4,
5,
853,
7,
854,
855,
665,
667,
683,
39,
671,
164,
719,
178,
179,
88,
89,
672,
34,
37,
669,
196,
740,
669,
246,
708,
677,
252,
253,
238,
256,
248,
746,
272,
296,
669,
746,
671,
275,
289,
671,
74,
757,
690,
672,
34,
37,
672,
34,
77,
670,
669,
746,
677,
756,
46,
677,
287,
691,
293,
670,
136,
746,
301,
110,
724,
80,
308,
671,
746,
685,
352,
52,
54,
342,
270,
335,
97,
725,
274,
670,
336,
46,
788,
102,
46,
347,
789,
78,
694,
693,
669,
65,
790,
70,
284,
67,
68,
360,
684,
685,
669,
52,
54,
669,
299,
372,
676,
41,
42,
373,
374,
311,
101,
818,
672,
34,
58,
671,
44,
394,
669,
669,
669,
677,
672,
34,
37,
207,
386,
355,
805,
391,
293,
677,
121,
126,
399,
671,
671,
671,
670,
744,
400,
401,
672,
34,
37,
97,
97,
406,
670,
248,
73,
677,
102,
102,
688,
407,
410,
669,
191,
411,
46,
55,
56,
415,
417,
685,
427,
52,
54,
670,
713,
55,
56,
428,
671,
685,
669,
52,
54,
669,
46,
101,
101,
97,
416,
702,
438,
433,
439,
669,
102,
50,
442,
671,
449,
685,
671,
52,
54,
669,
432,
452,
99,
672,
34,
37,
671,
457,
704,
100,
669,
451,
677,
672,
34,
37,
671,
431,
434,
101,
391,
450,
677,
330,
391,
192,
461,
671,
61,
434,
464,
466,
677,
670,
672,
34,
37,
467,
101,
471,
841,
46,
840,
677,
0,
64,
492,
670,
0,
842,
843,
46,
670,
844,
845,
856,
682,
5,
52,
54,
806,
46,
57,
0,
724,
483,
685,
491,
52,
54,
496,
490,
46,
846,
669,
670,
0,
725,
0,
65,
0,
70,
0,
67,
68,
0,
0,
685,
669,
52,
54,
671,
63,
669,
0,
353,
356,
791,
672,
34,
37,
0,
0,
0,
0,
671,
61,
677,
0,
0,
671,
0,
672,
34,
37,
0,
669,
672,
34,
37,
0,
677,
0,
0,
199,
202,
677,
204,
205,
0,
0,
0,
0,
671,
61,
0,
46,
495,
0,
670,
672,
34,
37,
353,
356,
791,
0,
55,
56,
677,
46,
685,
0,
52,
54,
46,
0,
686,
814,
670,
0,
67,
68,
443,
0,
685,
69,
52,
54,
0,
685,
418,
52,
54,
0,
0,
0,
426,
46,
0,
669,
731,
0,
0,
0,
72,
39,
0,
0,
67,
68,
0,
0,
685,
0,
52,
54,
671,
76,
0,
669,
0,
0,
0,
672,
34,
37,
0,
0,
0,
0,
0,
0,
677,
669,
0,
0,
671,
74,
0,
690,
0,
669,
670,
672,
34,
77,
718,
0,
0,
0,
671,
669,
677,
0,
691,
0,
670,
0,
671,
97,
0,
46,
0,
0,
166,
0,
102,
192,
671,
730,
730,
0,
55,
56,
677,
0,
685,
97,
52,
54,
0,
46,
0,
669,
102,
692,
693,
0,
65,
0,
70,
0,
67,
68,
0,
101,
685,
669,
52,
54,
671,
32,
0,
46,
0,
0,
0,
672,
34,
37,
669,
669,
0,
101,
671,
32,
677,
0,
695,
0,
670,
672,
34,
37,
696,
84,
86,
671,
671,
0,
677,
0,
695,
0,
0,
0,
192,
192,
697,
0,
86,
0,
670,
677,
677,
46,
0,
0,
0,
0,
0,
0,
65,
0,
70,
0,
67,
68,
0,
46,
685,
669,
52,
54,
0,
0,
65,
0,
70,
0,
67,
68,
46,
46,
685,
0,
52,
54,
671,
61,
0,
0,
0,
669,
0,
672,
34,
37,
0,
0,
0,
88,
89,
0,
677,
0,
698,
0,
0,
0,
671,
91,
0,
0,
0,
88,
89,
672,
34,
37,
670,
669,
0,
0,
219,
241,
677,
0,
0,
0,
0,
0,
0,
46,
169,
0,
669,
0,
671,
0,
65,
0,
70,
0,
67,
68,
0,
97,
685,
185,
52,
54,
0,
671,
102,
46,
0,
0,
669,
0,
0,
669,
97,
0,
0,
0,
55,
56,
0,
102,
685,
723,
52,
54,
0,
671,
0,
0,
671,
61,
0,
0,
0,
101,
97,
672,
34,
37,
0,
0,
670,
102,
0,
0,
677,
208,
95,
0,
101,
0,
0,
92,
0,
775,
776,
777,
778,
779,
780,
781,
782,
783,
784,
785,
0,
0,
0,
670,
0,
0,
101,
0,
0,
46,
0,
0,
0,
325,
0,
0,
65,
669,
70,
0,
67,
68,
0,
669,
685,
277,
52,
54,
229,
146,
714,
0,
0,
715,
152,
42,
227,
0,
0,
0,
671,
672,
34,
153,
669,
155,
717,
0,
0,
97,
102,
0,
0,
0,
669,
0,
102,
714,
0,
0,
715,
152,
42,
0,
0,
0,
669,
670,
672,
34,
157,
671,
0,
716,
0,
0,
0,
102,
0,
158,
192,
670,
0,
671,
0,
101,
0,
677,
0,
0,
55,
56,
192,
0,
685,
670,
52,
54,
0,
677,
0,
0,
0,
0,
0,
0,
158,
0,
669,
0,
0,
0,
0,
0,
0,
0,
46,
55,
56,
0,
0,
685,
669,
52,
54,
671,
61,
0,
46,
0,
0,
0,
672,
34,
37,
0,
669,
0,
0,
671,
61,
677,
0,
201,
0,
384,
672,
34,
37,
751,
749,
750,
0,
671,
61,
677,
0,
727,
0,
670,
672,
34,
37,
0,
0,
0,
279,
0,
0,
677,
46,
728,
0,
0,
0,
0,
0,
65,
0,
70,
0,
67,
68,
0,
46,
685,
669,
52,
54,
0,
0,
65,
0,
70,
0,
67,
68,
0,
46,
685,
669,
52,
54,
671,
0,
65,
0,
70,
0,
67,
68,
0,
192,
685,
212,
52,
54,
671,
61,
677,
0,
0,
0,
0,
672,
34,
37,
0,
0,
670,
732,
733,
734,
677,
735,
729,
0,
736,
737,
738,
0,
0,
670,
758,
759,
760,
761,
762,
46,
763,
764,
765,
766,
0,
0,
0,
476,
0,
0,
0,
0,
0,
46,
0,
0,
0,
0,
0,
229,
65,
669,
70,
0,
67,
68,
0,
0,
685,
769,
52,
54,
229,
0,
669,
392,
0,
0,
671,
61,
0,
767,
768,
0,
0,
672,
34,
37,
669,
0,
0,
671,
61,
0,
677,
0,
739,
0,
672,
34,
37,
0,
0,
670,
0,
671,
0,
677,
0,
727,
0,
0,
0,
0,
192,
0,
669,
670,
0,
0,
0,
677,
0,
46,
0,
0,
0,
0,
0,
0,
65,
670,
70,
671,
67,
68,
46,
0,
685,
0,
52,
54,
192,
65,
669,
70,
0,
67,
68,
677,
46,
685,
0,
52,
54,
0,
0,
0,
669,
0,
0,
671,
61,
235,
0,
0,
741,
0,
672,
34,
37,
714,
669,
0,
715,
152,
42,
677,
46,
742,
0,
0,
672,
34,
157,
0,
0,
743,
0,
671,
61,
102,
0,
0,
0,
670,
672,
34,
37,
0,
0,
312,
0,
0,
0,
677,
46,
727,
0,
670,
0,
0,
770,
65,
0,
70,
0,
67,
68,
811,
158,
685,
0,
52,
54,
0,
0,
0,
812,
0,
813,
55,
56,
0,
46,
685,
669,
52,
54,
0,
0,
65,
0,
70,
0,
67,
68,
0,
0,
685,
669,
52,
54,
671,
61,
0,
0,
0,
0,
0,
672,
34,
37,
0,
251,
0,
0,
671,
61,
677,
0,
255,
0,
670,
672,
34,
37,
0,
0,
277,
0,
0,
0,
677,
0,
727,
0,
0,
732,
733,
734,
0,
735,
670,
0,
736,
737,
738,
46,
0,
0,
0,
0,
0,
0,
65,
0,
70,
0,
67,
68,
0,
46,
685,
669,
52,
54,
0,
0,
65,
669,
70,
0,
67,
68,
0,
229,
685,
0,
52,
54,
671,
61,
0,
669,
0,
769,
671,
672,
34,
37,
0,
258,
0,
0,
300,
192,
677,
0,
262,
0,
671,
91,
677,
0,
0,
0,
670,
672,
34,
37,
0,
0,
0,
0,
0,
0,
677,
0,
0,
0,
670,
0,
0,
0,
0,
46,
265,
0,
0,
0,
0,
46,
65,
0,
70,
0,
67,
68,
0,
0,
685,
0,
52,
54,
0,
46,
0,
669,
0,
0,
0,
0,
748,
749,
750,
0,
55,
56,
0,
0,
685,
669,
52,
54,
671,
61,
0,
0,
0,
279,
0,
672,
34,
37,
0,
0,
0,
0,
671,
61,
677,
0,
727,
0,
670,
672,
34,
37,
0,
0,
0,
88,
89,
0,
677,
0,
727,
0,
830,
831,
832,
833,
834,
670,
835,
0,
0,
836,
0,
46,
0,
0,
0,
0,
0,
0,
65,
375,
70,
0,
67,
68,
0,
46,
685,
669,
52,
54,
770,
0,
65,
0,
70,
0,
67,
68,
229,
0,
685,
745,
52,
54,
671,
61,
669,
0,
0,
0,
0,
672,
34,
37,
0,
747,
0,
0,
468,
0,
677,
837,
752,
671,
61,
0,
0,
0,
0,
670,
672,
34,
37,
0,
0,
0,
0,
0,
0,
677,
0,
288,
0,
670,
0,
0,
0,
0,
0,
46,
0,
0,
0,
0,
0,
0,
65,
670,
70,
0,
67,
68,
0,
0,
685,
0,
52,
54,
46,
0,
669,
0,
0,
0,
0,
65,
0,
70,
0,
67,
68,
0,
0,
685,
669,
52,
54,
671,
61,
0,
0,
0,
0,
291,
672,
34,
37,
0,
669,
0,
0,
671,
61,
677,
0,
753,
0,
0,
672,
34,
37,
755,
0,
0,
0,
671,
61,
677,
0,
288,
0,
670,
672,
34,
37,
0,
0,
0,
0,
0,
0,
677,
46,
295,
0,
0,
0,
0,
0,
65,
0,
70,
0,
67,
68,
0,
46,
685,
0,
52,
54,
0,
0,
65,
0,
70,
0,
67,
68,
0,
46,
685,
669,
52,
54,
0,
0,
65,
0,
70,
0,
67,
68,
0,
0,
685,
0,
52,
54,
671,
61,
0,
0,
0,
0,
670,
672,
34,
37,
754,
0,
0,
0,
0,
0,
677,
0,
727,
0,
792,
793,
794,
795,
796,
797,
798,
799,
800,
801,
0,
0,
0,
0,
0,
0,
0,
365,
0,
0,
0,
808,
809,
810,
0,
46,
0,
669,
0,
0,
0,
0,
65,
0,
70,
0,
67,
68,
229,
0,
685,
0,
52,
54,
671,
32,
0,
0,
0,
0,
670,
672,
34,
37,
0,
303,
0,
0,
0,
0,
677,
0,
695,
0,
670,
0,
0,
0,
696,
346,
86,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
46,
0,
669,
0,
0,
0,
0,
65,
0,
70,
0,
67,
68,
0,
0,
685,
669,
52,
54,
671,
32,
0,
0,
0,
0,
0,
672,
34,
37,
0,
0,
0,
0,
671,
61,
677,
0,
695,
0,
670,
672,
34,
37,
696,
351,
86,
88,
89,
0,
677,
0,
382,
0,
0,
0,
0,
0,
0,
0,
670,
0,
0,
0,
0,
46,
0,
0,
0,
0,
0,
0,
65,
0,
70,
0,
67,
68,
0,
46,
685,
669,
52,
54,
0,
0,
65,
0,
70,
0,
67,
68,
0,
0,
685,
0,
52,
54,
671,
61,
0,
669,
0,
0,
0,
672,
34,
37,
0,
0,
0,
88,
89,
0,
677,
0,
288,
0,
671,
91,
0,
429,
0,
0,
670,
672,
34,
37,
0,
0,
0,
0,
0,
0,
677,
0,
0,
0,
0,
0,
0,
0,
0,
46,
802,
0,
670,
0,
0,
0,
65,
0,
70,
0,
67,
68,
0,
0,
685,
0,
52,
54,
669,
46,
0,
669,
0,
0,
387,
0,
0,
0,
0,
0,
55,
56,
0,
0,
685,
671,
52,
54,
671,
61,
0,
0,
755,
669,
192,
672,
34,
37,
0,
0,
0,
677,
0,
0,
677,
0,
288,
0,
0,
0,
671,
61,
0,
389,
0,
88,
89,
672,
34,
37,
0,
0,
670,
0,
0,
804,
677,
0,
727,
0,
46,
0,
0,
46,
0,
0,
0,
0,
0,
0,
65,
0,
70,
0,
67,
68,
0,
0,
685,
0,
52,
54,
0,
0,
0,
46,
0,
0,
387,
0,
0,
0,
65,
669,
70,
0,
67,
68,
0,
0,
685,
811,
52,
54,
0,
0,
755,
0,
0,
0,
671,
61,
815,
0,
816,
807,
0,
672,
34,
37,
817,
0,
0,
0,
0,
0,
677,
0,
727,
440,
0,
0,
0,
0,
0,
0,
0,
0,
0,
803,
0,
0,
0,
670,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
46,
0,
0,
0,
0,
0,
0,
65,
670,
70,
0,
67,
68,
0,
0,
685,
0,
52,
54,
792,
793,
794,
795,
796,
797,
798,
799,
800,
801,
669,
414,
0,
0,
0,
0,
0,
0,
0,
0,
0,
808,
809,
810,
0,
0,
0,
671,
61,
0,
669,
0,
0,
0,
672,
34,
37,
0,
229,
0,
0,
0,
0,
677,
0,
288,
0,
671,
61,
0,
0,
0,
0,
0,
672,
34,
37,
0,
0,
0,
0,
0,
0,
677,
0,
727,
0,
0,
0,
0,
0,
0,
46,
0,
0,
0,
0,
0,
0,
65,
0,
70,
0,
67,
68,
0,
0,
685,
0,
52,
54,
0,
46,
0,
0,
0,
0,
435,
0,
65,
0,
70,
0,
67,
68,
0,
0,
685,
0,
52,
54,
0,
0,
0,
0,
755,
0,
0,
0,
0,
0,
819,
437,
820,
821,
822,
823,
824,
825,
826,
827,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
828,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
458,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
459,
0,
0,
829,
0,
0,
0,
0,
0,
0,
0,
0,
420,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
};
static	yyTCombType *	yyTBasePtr	[yyLastReadState + 1] = {
& yyTComb [0],
& yyTComb [0],
& yyTComb [2],
& yyTComb [4],
& yyTComb [0],
& yyTComb [9],
& yyTComb [0],
& yyTComb [12],
& yyTComb [1],
& yyTComb [2],
& yyTComb [7],
& yyTComb [4],
& yyTComb [15],
& yyTComb [24],
& yyTComb [19],
& yyTComb [0],
& yyTComb [5],
& yyTComb [15],
& yyTComb [28],
& yyTComb [46],
& yyTComb [14],
& yyTComb [0],
& yyTComb [5],
& yyTComb [0],
& yyTComb [0],
& yyTComb [12],
& yyTComb [7],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [4],
& yyTComb [0],
& yyTComb [103],
& yyTComb [189],
& yyTComb [0],
& yyTComb [255],
& yyTComb [0],
& yyTComb [13],
& yyTComb [0],
& yyTComb [32],
& yyTComb [12],
& yyTComb [0],
& yyTComb [69],
& yyTComb [0],
& yyTComb [321],
& yyTComb [0],
& yyTComb [31],
& yyTComb [45],
& yyTComb [407],
& yyTComb [0],
& yyTComb [493],
& yyTComb [0],
& yyTComb [54],
& yyTComb [565],
& yyTComb [0],
& yyTComb [651],
& yyTComb [728],
& yyTComb [28],
& yyTComb [0],
& yyTComb [127],
& yyTComb [0],
& yyTComb [723],
& yyTComb [22],
& yyTComb [770],
& yyTComb [0],
& yyTComb [842],
& yyTComb [28],
& yyTComb [914],
& yyTComb [71],
& yyTComb [0],
& yyTComb [962],
& yyTComb [0],
& yyTComb [14],
& yyTComb [0],
& yyTComb [249],
& yyTComb [789],
& yyTComb [56],
& yyTComb [0],
& yyTComb [1048],
& yyTComb [84],
& yyTComb [42],
& yyTComb [0],
& yyTComb [28],
& yyTComb [0],
& yyTComb [48],
& yyTComb [0],
& yyTComb [170],
& yyTComb [89],
& yyTComb [56],
& yyTComb [283],
& yyTComb [175],
& yyTComb [59],
& yyTComb [0],
& yyTComb [101],
& yyTComb [67],
& yyTComb [370],
& yyTComb [0],
& yyTComb [457],
& yyTComb [615],
& yyTComb [166],
& yyTComb [1108],
& yyTComb [333],
& yyTComb [194],
& yyTComb [91],
& yyTComb [0],
& yyTComb [86],
& yyTComb [396],
& yyTComb [0],
& yyTComb [87],
& yyTComb [493],
& yyTComb [110],
& yyTComb [0],
& yyTComb [102],
& yyTComb [121],
& yyTComb [651],
& yyTComb [198],
& yyTComb [0],
& yyTComb [116],
& yyTComb [0],
& yyTComb [0],
& yyTComb [128],
& yyTComb [0],
& yyTComb [140],
& yyTComb [0],
& yyTComb [0],
& yyTComb [152],
& yyTComb [0],
& yyTComb [200],
& yyTComb [308],
& yyTComb [239],
& yyTComb [188],
& yyTComb [148],
& yyTComb [103],
& yyTComb [0],
& yyTComb [238],
& yyTComb [174],
& yyTComb [172],
& yyTComb [186],
& yyTComb [254],
& yyTComb [251],
& yyTComb [0],
& yyTComb [314],
& yyTComb [206],
& yyTComb [0],
& yyTComb [302],
& yyTComb [0],
& yyTComb [259],
& yyTComb [158],
& yyTComb [180],
& yyTComb [0],
& yyTComb [1142],
& yyTComb [403],
& yyTComb [189],
& yyTComb [312],
& yyTComb [0],
& yyTComb [238],
& yyTComb [987],
& yyTComb [190],
& yyTComb [0],
& yyTComb [259],
& yyTComb [216],
& yyTComb [220],
& yyTComb [274],
& yyTComb [0],
& yyTComb [286],
& yyTComb [296],
& yyTComb [0],
& yyTComb [310],
& yyTComb [312],
& yyTComb [351],
& yyTComb [342],
& yyTComb [340],
& yyTComb [357],
& yyTComb [360],
& yyTComb [311],
& yyTComb [373],
& yyTComb [348],
& yyTComb [0],
& yyTComb [318],
& yyTComb [0],
& yyTComb [381],
& yyTComb [371],
& yyTComb [0],
& yyTComb [378],
& yyTComb [387],
& yyTComb [387],
& yyTComb [0],
& yyTComb [375],
& yyTComb [0],
& yyTComb [381],
& yyTComb [891],
& yyTComb [391],
& yyTComb [373],
& yyTComb [0],
& yyTComb [391],
& yyTComb [343],
& yyTComb [418],
& yyTComb [408],
& yyTComb [0],
& yyTComb [415],
& yyTComb [411],
& yyTComb [1152],
& yyTComb [424],
& yyTComb [426],
& yyTComb [436],
& yyTComb [434],
& yyTComb [390],
& yyTComb [389],
& yyTComb [407],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [426],
& yyTComb [0],
& yyTComb [0],
& yyTComb [441],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [468],
& yyTComb [0],
& yyTComb [441],
& yyTComb [434],
& yyTComb [437],
& yyTComb [1050],
& yyTComb [406],
& yyTComb [0],
& yyTComb [414],
& yyTComb [469],
& yyTComb [470],
& yyTComb [580],
& yyTComb [472],
& yyTComb [484],
& yyTComb [593],
& yyTComb [0],
& yyTComb [551],
& yyTComb [506],
& yyTComb [0],
& yyTComb [486],
& yyTComb [0],
& yyTComb [490],
& yyTComb [0],
& yyTComb [485],
& yyTComb [0],
& yyTComb [0],
& yyTComb [508],
& yyTComb [0],
& yyTComb [499],
& yyTComb [0],
& yyTComb [518],
& yyTComb [500],
& yyTComb [0],
& yyTComb [429],
& yyTComb [0],
& yyTComb [520],
& yyTComb [0],
& yyTComb [504],
& yyTComb [429],
& yyTComb [0],
& yyTComb [490],
& yyTComb [435],
& yyTComb [544],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [544],
& yyTComb [465],
& yyTComb [557],
& yyTComb [548],
& yyTComb [549],
& yyTComb [556],
& yyTComb [1147],
& yyTComb [476],
& yyTComb [0],
& yyTComb [509],
& yyTComb [497],
& yyTComb [0],
& yyTComb [589],
& yyTComb [0],
& yyTComb [0],
& yyTComb [0],
& yyTComb [670],
& yyTComb [707],
& yyTComb [0],
& yyTComb [602],
& yyTComb [0],
& yyTComb [522],
& yyTComb [0],
& yyTComb [613],
& yyTComb [562],
& yyTComb [538],
& yyTComb [0],
& yyTComb [621],
& yyTComb [574],
& yyTComb [635],
& yyTComb [0],
& yyTComb [547],
& yyTComb [556],
& yyTComb [663],
& yyTComb [0],
& yyTComb [573],
& yyTComb [583],
& yyTComb [565],
& yyTComb [644],
& yyTComb [646],
& yyTComb [583],
& yyTComb [0],
& yyTComb [601],
& yyTComb [568],
& yyTComb [0],
& yyTComb [658],
& yyTComb [613],
& yyTComb [684],
& yyTComb [0],
& yyTComb [674],
& yyTComb [683],
& yyTComb [628],
& yyTComb [0],
& yyTComb [681],
& yyTComb [1189],
& yyTComb [0],
& yyTComb [1215],
& yyTComb [695],
& yyTComb [701],
& yyTComb [704],
& yyTComb [717],
& yyTComb [851],
& yyTComb [726],
& yyTComb [771],
& yyTComb [714],
& yyTComb [733],
& yyTComb [715],
& yyTComb [742],
& yyTComb [923],
& yyTComb [744],
& yyTComb [731],
& yyTComb [646],
& yyTComb [734],
& yyTComb [0],
& yyTComb [728],
& yyTComb [0],
& yyTComb [655],
& yyTComb [741],
& yyTComb [732],
& yyTComb [762],
& yyTComb [753],
& yyTComb [757],
& yyTComb [0],
& yyTComb [782],
& yyTComb [782],
& yyTComb [780],
& yyTComb [788],
& yyTComb [855],
& yyTComb [922],
& yyTComb [754],
& yyTComb [728],
& yyTComb [692],
& yyTComb [786],
& yyTComb [725],
& yyTComb [0],
& yyTComb [743],
& yyTComb [912],
& yyTComb [0],
& yyTComb [800],
& yyTComb [1250],
& yyTComb [1276],
& yyTComb [1244],
& yyTComb [1270],
& yyTComb [750],
& yyTComb [1276],
& yyTComb [762],
& yyTComb [728],
& yyTComb [0],
& yyTComb [820],
& yyTComb [0],
& yyTComb [739],
& yyTComb [0],
& yyTComb [799],
& yyTComb [0],
& yyTComb [0],
& yyTComb [850],
& yyTComb [0],
& yyTComb [867],
& yyTComb [0],
& yyTComb [1372],
& yyTComb [894],
& yyTComb [1297],
& yyTComb [1332],
& yyTComb [845],
& yyTComb [978],
& yyTComb [848],
& yyTComb [827],
& yyTComb [0],
& yyTComb [0],
& yyTComb [856],
& yyTComb [0],
& yyTComb [0],
& yyTComb [877],
& yyTComb [0],
& yyTComb [0],
& yyTComb [870],
& yyTComb [879],
& yyTComb [841],
& yyTComb [0],
& yyTComb [892],
& yyTComb [1406],
& yyTComb [0],
& yyTComb [876],
& yyTComb [1435],
& yyTComb [895],
& yyTComb [900],
& yyTComb [1452],
& yyTComb [841],
& yyTComb [851],
& yyTComb [0],
& yyTComb [867],
& yyTComb [836],
& yyTComb [0],
& yyTComb [941],
& yyTComb [1481],
& yyTComb [0],
& yyTComb [942],
& yyTComb [907],
& yyTComb [0],
& yyTComb [0],
& yyTComb [965],
& yyTComb [966],
& yyTComb [0],
& yyTComb [968],
& yyTComb [0],
& yyTComb [889],
& yyTComb [972],
& yyTComb [973],
& yyTComb [877],
& yyTComb [1153],
& yyTComb [912],
& yyTComb [1218],
& yyTComb [934],
& yyTComb [882],
& yyTComb [0],
& yyTComb [981],
& yyTComb [1527],
& yyTComb [1572],
& yyTComb [1188],
& yyTComb [986],
& yyTComb [991],
& yyTComb [1005],
& yyTComb [988],
& yyTComb [1570],
& yyTComb [1597],
& yyTComb [1012],
& yyTComb [995],
& yyTComb [945],
& yyTComb [1049],
& yyTComb [0],
& yyTComb [1000],
& yyTComb [0],
& yyTComb [996],
& yyTComb [1583],
& yyTComb [1610],
& yyTComb [1626],
& yyTComb [948],
& yyTComb [1064],
& yyTComb [908],
& yyTComb [0],
& yyTComb [1011],
& yyTComb [1029],
& yyTComb [967],
& yyTComb [1033],
& yyTComb [1022],
& yyTComb [1102],
& yyTComb [1105],
& yyTComb [0],
& yyTComb [1037],
& yyTComb [1060],
& yyTComb [1042],
& yyTComb [1094],
& yyTComb [1190],
& yyTComb [982],
& yyTComb [966],
& yyTComb [1043],
& yyTComb [1243],
& yyTComb [1153],
& yyTComb [998],
& yyTComb [1047],
& yyTComb [991],
& yyTComb [981],
& yyTComb [1063],
& yyTComb [1072],
& yyTComb [1042],
& yyTComb [1208],
& yyTComb [1150],
& yyTComb [1097],
& yyTComb [1320],
& yyTComb [0],
};
static	unsigned short*	yyNBasePtr	[yyLastReadState + 1] = {
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-100],
& yyNComb [-109],
& yyNComb [-98],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-107],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-104],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-78],
& yyNComb [-58],
& yyNComb [-106],
& yyNComb [28],
& yyNComb [-108],
& yyNComb [-109],
& yyNComb [-107],
& yyNComb [-109],
& yyNComb [58],
& yyNComb [-109],
& yyNComb [126],
& yyNComb [-109],
& yyNComb [-104],
& yyNComb [136],
& yyNComb [-104],
& yyNComb [156],
& yyNComb [-106],
& yyNComb [-106],
& yyNComb [-109],
& yyNComb [-102],
& yyNComb [-106],
& yyNComb [217],
& yyNComb [-109],
& yyNComb [-36],
& yyNComb [55],
& yyNComb [-106],
& yyNComb [227],
& yyNComb [-106],
& yyNComb [-109],
& yyNComb [-105],
& yyNComb [248],
& yyNComb [-106],
& yyNComb [312],
& yyNComb [-104],
& yyNComb [-109],
& yyNComb [-105],
& yyNComb [326],
& yyNComb [-106],
& yyNComb [331],
& yyNComb [-106],
& yyNComb [-99],
& yyNComb [354],
& yyNComb [-109],
& yyNComb [-106],
& yyNComb [-106],
& yyNComb [418],
& yyNComb [-104],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [438],
& yyNComb [-106],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [502],
& yyNComb [-109],
& yyNComb [516],
& yyNComb [-109],
& yyNComb [580],
& yyNComb [-109],
& yyNComb [-107],
& yyNComb [602],
& yyNComb [-104],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [670],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [214],
& yyNComb [-105],
& yyNComb [-104],
& yyNComb [-109],
& yyNComb [-106],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-104],
& yyNComb [-109],
& yyNComb [-103],
& yyNComb [86],
& yyNComb [-99],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-98],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [768],
& yyNComb [-87],
& yyNComb [-109],
& yyNComb [157],
& yyNComb [-90],
& yyNComb [-109],
& yyNComb [-85],
& yyNComb [-109],
& yyNComb [158],
& yyNComb [-85],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-85],
& yyNComb [-109],
& yyNComb [-105],
& yyNComb [-108],
& yyNComb [-109],
& yyNComb [-8],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-106],
& yyNComb [-13],
& yyNComb [-109],
& yyNComb [-102],
& yyNComb [-109],
& yyNComb [-108],
& yyNComb [740],
& yyNComb [-109],
& yyNComb [-21],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [195],
& yyNComb [-109],
& yyNComb [214],
& yyNComb [126],
& yyNComb [-109],
& yyNComb [767],
& yyNComb [214],
& yyNComb [-106],
& yyNComb [-109],
& yyNComb [452],
& yyNComb [-5],
& yyNComb [16],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [470],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [630],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-103],
& yyNComb [-109],
& yyNComb [-102],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [24],
& yyNComb [-109],
& yyNComb [-108],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [645],
& yyNComb [-109],
& yyNComb [-37],
& yyNComb [-93],
& yyNComb [667],
& yyNComb [-109],
& yyNComb [237],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-103],
& yyNComb [-109],
& yyNComb [70],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [315],
& yyNComb [-109],
& yyNComb [831],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-75],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [113],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-105],
& yyNComb [845],
& yyNComb [-107],
& yyNComb [859],
& yyNComb [-94],
& yyNComb [923],
& yyNComb [-109],
& yyNComb [-103],
& yyNComb [529],
& yyNComb [-109],
& yyNComb [460],
& yyNComb [-70],
& yyNComb [-97],
& yyNComb [1008],
& yyNComb [-50],
& yyNComb [-109],
& yyNComb [746],
& yyNComb [-52],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-105],
& yyNComb [1021],
& yyNComb [-105],
& yyNComb [789],
& yyNComb [993],
& yyNComb [-109],
& yyNComb [-104],
& yyNComb [73],
& yyNComb [-109],
& yyNComb [-77],
& yyNComb [530],
& yyNComb [-109],
& yyNComb [-61],
& yyNComb [1006],
& yyNComb [-32],
& yyNComb [1076],
& yyNComb [-109],
& yyNComb [66],
& yyNComb [-109],
& yyNComb [1090],
& yyNComb [1104],
& yyNComb [-31],
& yyNComb [-31],
& yyNComb [-109],
& yyNComb [1168],
& yyNComb [-29],
& yyNComb [-109],
& yyNComb [1182],
& yyNComb [-109],
& yyNComb [-102],
& yyNComb [789],
& yyNComb [1246],
& yyNComb [-109],
& yyNComb [-30],
& yyNComb [1266],
& yyNComb [-109],
& yyNComb [-101],
& yyNComb [789],
& yyNComb [1330],
& yyNComb [12],
& yyNComb [-33],
& yyNComb [1344],
& yyNComb [-109],
& yyNComb [16],
& yyNComb [-28],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [1252],
& yyNComb [-109],
& yyNComb [-99],
& yyNComb [789],
& yyNComb [-109],
& yyNComb [32],
& yyNComb [-109],
& yyNComb [6],
& yyNComb [1408],
& yyNComb [1427],
& yyNComb [-32],
& yyNComb [-109],
& yyNComb [1491],
& yyNComb [-109],
& yyNComb [1505],
& yyNComb [-109],
& yyNComb [1519],
& yyNComb [-109],
& yyNComb [-18],
& yyNComb [-109],
& yyNComb [42],
& yyNComb [-109],
& yyNComb [2],
& yyNComb [5],
& yyNComb [1583],
& yyNComb [-109],
& yyNComb [-90],
& yyNComb [789],
& yyNComb [-79],
& yyNComb [789],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [49],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-78],
& yyNComb [789],
& yyNComb [-109],
& yyNComb [-104],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-103],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [777],
& yyNComb [-109],
& yyNComb [-106],
& yyNComb [-106],
& yyNComb [1675],
& yyNComb [280],
& yyNComb [54],
& yyNComb [53],
& yyNComb [52],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [56],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [57],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [64],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [1647],
& yyNComb [-109],
& yyNComb [64],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [1711],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [139],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [73],
& yyNComb [-109],
& yyNComb [87],
& yyNComb [-94],
& yyNComb [-94],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-105],
& yyNComb [1048],
& yyNComb [-105],
& yyNComb [-102],
& yyNComb [-109],
& yyNComb [18],
& yyNComb [99],
& yyNComb [22],
& yyNComb [1275],
& yyNComb [-109],
& yyNComb [-77],
& yyNComb [789],
& yyNComb [-109],
& yyNComb [-101],
& yyNComb [-109],
& yyNComb [1725],
& yyNComb [-109],
& yyNComb [909],
& yyNComb [-109],
& yyNComb [46],
& yyNComb [1789],
& yyNComb [-109],
& yyNComb [1809],
& yyNComb [-109],
& yyNComb [1873],
& yyNComb [80],
& yyNComb [36],
& yyNComb [40],
& yyNComb [1870],
& yyNComb [-109],
& yyNComb [42],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [120],
& yyNComb [122],
& yyNComb [-109],
& yyNComb [187],
& yyNComb [1895],
& yyNComb [-109],
& yyNComb [127],
& yyNComb [136],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [136],
& yyNComb [140],
& yyNComb [-109],
& yyNComb [74],
& yyNComb [1965],
& yyNComb [-109],
& yyNComb [281],
& yyNComb [144],
& yyNComb [-109],
& yyNComb [-101],
& yyNComb [2101],
& yyNComb [-109],
& yyNComb [-102],
& yyNComb [1048],
& yyNComb [-109],
& yyNComb [-98],
& yyNComb [-109],
& yyNComb [261],
& yyNComb [154],
& yyNComb [-109],
& yyNComb [166],
& yyNComb [137],
& yyNComb [119],
& yyNComb [92],
& yyNComb [-109],
& yyNComb [2056],
& yyNComb [-109],
& yyNComb [2076],
& yyNComb [-109],
& yyNComb [169],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [269],
& yyNComb [1675],
& yyNComb [-101],
& yyNComb [1048],
& yyNComb [-109],
& yyNComb [-97],
& yyNComb [-109],
& yyNComb [115],
& yyNComb [141],
& yyNComb [130],
& yyNComb [119],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-78],
& yyNComb [250],
& yyNComb [2222],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [267],
& yyNComb [-96],
& yyNComb [-109],
& yyNComb [268],
& yyNComb [-109],
& yyNComb [268],
& yyNComb [273],
& yyNComb [1436],
& yyNComb [-109],
& yyNComb [273],
& yyNComb [-109],
& yyNComb [-91],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [1020],
& yyNComb [-109],
& yyNComb [-105],
& yyNComb [338],
& yyNComb [-103],
& yyNComb [-109],
& yyNComb [-108],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-104],
& yyNComb [308],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [328],
& yyNComb [-108],
& yyNComb [323],
& yyNComb [310],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-109],
& yyNComb [-106],
& yyNComb [-71],
& yyNComb [-109],
& yyNComb [150],
& yyNComb [-109],
};
static	unsigned short	yyDefault	[yyLastReadState + 1] = {
0,
0,
0,
0,
500,
0,
0,
0,
0,
0,
0,
13,
0,
0,
0,
9,
0,
0,
0,
360,
0,
130,
131,
130,
161,
225,
0,
108,
475,
110,
38,
350,
61,
68,
475,
136,
49,
58,
68,
0,
38,
152,
0,
38,
76,
68,
158,
475,
0,
206,
57,
68,
0,
54,
177,
57,
68,
0,
101,
475,
38,
0,
38,
76,
0,
0,
38,
80,
54,
80,
0,
38,
0,
158,
61,
38,
0,
58,
0,
38,
0,
0,
0,
350,
351,
350,
0,
38,
0,
0,
38,
0,
0,
0,
38,
0,
0,
475,
475,
39,
0,
0,
100,
0,
0,
0,
161,
225,
0,
475,
227,
361,
0,
130,
131,
0,
0,
467,
161,
225,
475,
227,
0,
161,
225,
475,
227,
0,
132,
0,
0,
0,
0,
0,
0,
475,
0,
0,
0,
39,
0,
0,
140,
0,
0,
38,
0,
475,
0,
0,
0,
475,
0,
58,
38,
0,
38,
153,
101,
0,
475,
0,
161,
0,
225,
475,
0,
225,
475,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
475,
0,
498,
0,
0,
475,
0,
132,
0,
475,
0,
475,
0,
136,
0,
0,
475,
0,
0,
206,
0,
38,
0,
0,
0,
0,
0,
475,
0,
0,
0,
0,
38,
251,
38,
255,
38,
0,
371,
475,
0,
475,
372,
373,
374,
161,
0,
475,
0,
0,
458,
0,
374,
376,
278,
38,
0,
0,
132,
0,
0,
475,
0,
0,
38,
0,
38,
0,
475,
0,
38,
38,
0,
255,
0,
38,
0,
0,
38,
0,
304,
278,
38,
0,
0,
350,
0,
376,
278,
38,
273,
274,
38,
0,
310,
0,
0,
0,
0,
475,
0,
376,
278,
0,
310,
0,
391,
38,
38,
0,
0,
38,
0,
38,
0,
38,
0,
263,
0,
310,
0,
0,
0,
38,
0,
376,
278,
376,
278,
0,
0,
357,
0,
0,
376,
278,
0,
498,
0,
0,
0,
498,
0,
0,
0,
475,
0,
0,
418,
478,
488,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
438,
0,
0,
350,
351,
416,
0,
0,
90,
0,
0,
0,
475,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
443,
444,
0,
498,
0,
0,
0,
0,
0,
0,
0,
278,
0,
498,
0,
38,
0,
475,
0,
449,
38,
0,
350,
0,
38,
0,
0,
0,
475,
0,
0,
0,
0,
409,
438,
0,
475,
38,
0,
409,
438,
0,
0,
416,
438,
0,
0,
38,
0,
0,
0,
0,
0,
328,
0,
443,
444,
0,
498,
0,
0,
438,
0,
409,
449,
450,
0,
0,
38,
291,
38,
0,
0,
0,
0,
418,
328,
0,
475,
0,
498,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
467,
0,
0,
0,
498,
0,
475,
0,
0,
0,
0,
0,
0,
0,
498,
0,
0,
0,
0,
0,
0,
0,
475,
0,
0,
0,
0,
0,
0,
0,
0,
0,
481,
330,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
};
static	unsigned char	yyLength	[yyLastReduceState - yyFirstReduceState + 1] = {
2,
2,
0,
13,
0,
0,
0,
1,
0,
1,
0,
1,
5,
0,
1,
5,
0,
2,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
2,
0,
2,
1,
1,
1,
14,
0,
0,
0,
1,
0,
2,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
11,
0,
1,
0,
2,
1,
1,
0,
1,
7,
1,
3,
2,
0,
2,
0,
2,
1,
1,
7,
2,
3,
5,
1,
1,
1,
0,
3,
9,
0,
1,
1,
0,
1,
0,
2,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
10,
0,
0,
0,
1,
0,
2,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
11,
0,
0,
0,
2,
0,
2,
1,
1,
1,
1,
1,
1,
1,
3,
1,
7,
6,
4,
4,
2,
1,
3,
3,
1,
1,
1,
3,
2,
0,
2,
2,
0,
2,
4,
2,
3,
3,
3,
3,
1,
3,
1,
1,
4,
2,
4,
1,
3,
5,
5,
2,
3,
1,
2,
0,
1,
1,
6,
0,
2,
6,
6,
6,
3,
6,
1,
0,
2,
2,
2,
1,
0,
2,
2,
2,
1,
3,
3,
1,
6,
0,
2,
1,
1,
1,
5,
8,
0,
1,
7,
3,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
3,
1,
1,
1,
3,
4,
3,
1,
1,
1,
1,
3,
4,
0,
2,
2,
6,
0,
2,
1,
1,
3,
1,
3,
0,
5,
0,
5,
1,
1,
1,
3,
1,
1,
4,
0,
1,
1,
1,
1,
1,
2,
2,
3,
1,
3,
1,
1,
2,
1,
3,
3,
1,
3,
1,
3,
1,
3,
1,
2,
3,
3,
1,
2,
3,
1,
3,
1,
3,
2,
1,
1,
1,
1,
1,
1,
5,
3,
3,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
3,
1,
3,
0,
2,
1,
1,
3,
5,
4,
2,
0,
1,
2,
0,
2,
5,
5,
4,
8,
8,
7,
4,
4,
3,
2,
5,
0,
2,
1,
3,
0,
2,
1,
0,
2,
0,
2,
0,
2,
1,
3,
2,
0,
4,
3,
0,
5,
0,
2,
1,
2,
4,
1,
1,
3,
1,
3,
1,
1,
1,
1,
2,
2,
3,
0,
2,
0,
1,
0,
1,
0,
2,
2,
1,
3,
0,
6,
0,
0,
1,
2,
0,
1,
1,
1,
11,
0,
1,
8,
11,
1,
11,
0,
4,
5,
6,
5,
8,
6,
0,
2,
2,
0,
2,
0,
3,
2,
0,
3,
0,
3,
0,
3,
0,
2,
1,
1,
1,
1,
1,
1,
1,
1,
2,
0,
5,
1,
3,
3,
0,
3,
1,
3,
1,
3,
3,
5,
1,
1,
2,
0,
3,
0,
2,
1,
1,
1,
1,
1,
3,
1,
3,
0,
2,
1,
1,
1,
1,
};
static	yySymbolRange	yyLeftHandSide	[yyLastReduceState - yyFirstReduceState + 1] = {
330,
111,
109,
120,
112,
116,
118,
118,
119,
119,
113,
113,
121,
114,
114,
123,
115,
115,
124,
124,
124,
124,
124,
124,
124,
124,
124,
124,
117,
117,
135,
135,
136,
136,
136,
145,
140,
142,
144,
144,
141,
141,
146,
146,
146,
146,
146,
146,
146,
146,
146,
146,
146,
146,
152,
151,
151,
149,
149,
153,
153,
154,
154,
150,
155,
155,
155,
156,
156,
157,
157,
159,
159,
160,
125,
163,
163,
164,
164,
167,
165,
165,
126,
170,
170,
170,
171,
171,
168,
168,
172,
172,
172,
172,
172,
172,
172,
172,
172,
172,
178,
174,
176,
177,
177,
175,
175,
179,
179,
179,
179,
179,
179,
179,
179,
179,
179,
185,
181,
183,
184,
184,
182,
182,
186,
186,
186,
186,
186,
186,
186,
188,
188,
188,
188,
188,
188,
189,
196,
196,
200,
199,
199,
187,
187,
201,
202,
201,
190,
191,
191,
203,
204,
192,
192,
207,
194,
208,
208,
209,
209,
195,
195,
211,
210,
210,
127,
128,
193,
193,
193,
193,
212,
212,
166,
129,
214,
214,
130,
173,
122,
122,
218,
216,
219,
216,
216,
216,
217,
220,
217,
217,
217,
222,
222,
221,
221,
131,
225,
225,
224,
224,
224,
132,
147,
226,
226,
133,
227,
229,
229,
229,
229,
229,
229,
229,
229,
229,
229,
230,
230,
230,
228,
228,
228,
228,
231,
231,
148,
161,
233,
233,
233,
234,
234,
232,
162,
162,
236,
236,
240,
236,
236,
239,
239,
241,
241,
238,
238,
237,
237,
139,
139,
206,
206,
242,
242,
242,
244,
180,
243,
243,
243,
243,
213,
213,
158,
245,
245,
246,
246,
247,
247,
197,
197,
248,
215,
215,
215,
251,
251,
249,
249,
249,
249,
198,
198,
198,
253,
253,
257,
257,
257,
259,
259,
259,
259,
259,
259,
259,
259,
259,
250,
250,
252,
252,
252,
252,
256,
256,
256,
256,
256,
256,
255,
255,
255,
254,
254,
258,
258,
258,
258,
260,
260,
261,
261,
262,
169,
169,
263,
263,
264,
264,
264,
264,
266,
266,
266,
268,
268,
265,
265,
265,
265,
265,
265,
265,
265,
265,
265,
283,
269,
269,
284,
284,
270,
270,
272,
271,
271,
273,
273,
274,
274,
267,
267,
285,
286,
285,
275,
276,
276,
277,
277,
279,
279,
287,
223,
223,
223,
289,
289,
288,
288,
290,
290,
280,
280,
291,
281,
281,
282,
282,
278,
278,
143,
143,
292,
292,
293,
295,
293,
297,
300,
293,
298,
301,
301,
296,
296,
294,
305,
294,
294,
138,
137,
302,
309,
302,
302,
302,
302,
302,
302,
313,
311,
311,
312,
312,
307,
307,
308,
314,
314,
315,
315,
303,
303,
304,
304,
316,
316,
316,
316,
316,
316,
316,
316,
299,
317,
317,
306,
306,
318,
310,
310,
235,
134,
319,
319,
320,
320,
321,
321,
110,
322,
110,
324,
323,
326,
326,
326,
326,
326,
328,
327,
327,
325,
325,
329,
329,
205,
205,
};
static	yySymbolRange	yyContinuation	[yyLastReadState + 1] = {
0,
7,
7,
0,
7,
13,
1,
9,
1,
1,
11,
1,
8,
1,
9,
1,
1,
14,
10,
10,
16,
1,
26,
1,
1,
20,
1,
1,
1,
9,
1,
1,
39,
1,
8,
8,
1,
8,
1,
24,
1,
8,
54,
1,
8,
1,
8,
1,
11,
1,
8,
1,
8,
1,
1,
8,
1,
8,
25,
1,
1,
39,
1,
8,
26,
8,
1,
8,
1,
8,
50,
1,
8,
25,
39,
1,
8,
8,
26,
1,
8,
26,
8,
1,
26,
1,
31,
1,
8,
29,
1,
8,
8,
31,
1,
26,
26,
9,
1,
8,
8,
16,
8,
1,
1,
9,
1,
20,
1,
1,
9,
10,
16,
1,
26,
9,
10,
63,
1,
20,
1,
9,
9,
1,
20,
1,
9,
9,
1,
9,
1,
26,
1,
60,
60,
1,
9,
1,
14,
16,
1,
26,
1,
1,
16,
1,
26,
1,
24,
65,
66,
1,
11,
8,
1,
26,
1,
8,
16,
66,
1,
1,
63,
67,
20,
1,
9,
20,
1,
9,
9,
9,
1,
9,
1,
63,
42,
2,
9,
1,
62,
9,
1,
14,
1,
9,
1,
14,
1,
14,
1,
9,
8,
1,
20,
1,
9,
66,
1,
14,
1,
9,
20,
13,
20,
8,
1,
20,
63,
63,
63,
1,
9,
1,
9,
1,
9,
10,
1,
26,
1,
10,
10,
74,
1,
20,
1,
9,
9,
9,
10,
74,
1,
63,
9,
9,
1,
9,
9,
9,
1,
9,
9,
1,
9,
1,
9,
1,
21,
1,
1,
9,
9,
9,
1,
9,
9,
1,
87,
1,
63,
1,
14,
91,
27,
31,
1,
63,
1,
9,
9,
1,
9,
9,
9,
9,
9,
9,
1,
93,
1,
63,
93,
9,
9,
1,
1,
1,
8,
8,
1,
9,
1,
77,
1,
9,
63,
90,
9,
9,
63,
63,
1,
87,
1,
63,
1,
63,
63,
86,
9,
9,
74,
1,
63,
98,
9,
9,
63,
1,
9,
9,
1,
66,
1,
14,
10,
10,
74,
1,
10,
100,
1,
9,
1,
9,
16,
1,
26,
1,
9,
1,
9,
101,
16,
1,
26,
9,
101,
16,
1,
26,
9,
20,
1,
10,
20,
1,
1,
15,
57,
63,
63,
102,
9,
74,
1,
63,
1,
9,
9,
10,
10,
10,
74,
74,
1,
63,
98,
9,
9,
1,
104,
1,
45,
1,
1,
91,
27,
9,
1,
1,
9,
1,
1,
1,
9,
1,
26,
9,
9,
9,
1,
1,
1,
9,
9,
9,
1,
9,
9,
9,
10,
1,
26,
10,
9,
9,
10,
74,
74,
1,
63,
106,
9,
9,
10,
9,
9,
9,
1,
1,
9,
9,
1,
9,
1,
89,
9,
9,
107,
1,
74,
1,
63,
107,
9,
9,
1,
1,
1,
9,
9,
1,
14,
10,
10,
63,
9,
63,
1,
9,
9,
1,
14,
10,
10,
63,
63,
1,
108,
9,
9,
1,
66,
1,
14,
10,
82,
1,
1,
10,
1,
10,
63,
63,
82,
9,
1,
10,
63,
63,
63,
82,
9,
9,
63,
1,
9,
9,
7,
0,
};
static	unsigned short	yyFinalToProd	[yyLastReadNontermState - yyFirstReadTermState + 1] = {
1333,
1334,
1332,
1320,
1321,
1315,
1021,
1022,
1116,
1339,
1340,
1153,
1154,
1155,
1235,
1241,
1180,
1181,
1174,
1175,
1171,
1172,
1173,
1165,
1166,
1167,
1168,
1169,
1170,
1118,
936,
1120,
998,
999,
1176,
1177,
1178,
1179,
1156,
1159,
1160,
1161,
1162,
1163,
1164,
1123,
1157,
1242,
1243,
1158,
1047,
1048,
1049,
1042,
1043,
1044,
869,
872,
1032,
1035,
934,
938,
1002,
1004,
988,
1012,
1010,
1013,
993,
1020,
1018,
1023,
1005,
1008,
866,
1024,
1057,
1058,
1054,
1060,
1078,
1082,
1081,
1064,
1066,
1072,
1074,
1073,
1068,
1069,
1071,
1067,
1070,
1075,
1208,
890,
1295,
1063,
1036,
931,
1206,
941,
942,
939,
1198,
1199,
1200,
1314,
1204,
1205,
1207,
1192,
1203,
1194,
1190,
1195,
1191,
1202,
1201,
1272,
864,
860,
1089,
1088,
1101,
1096,
1103,
1099,
1107,
1105,
1085,
1061,
896,
892,
1268,
1265,
1271,
1262,
1313,
1278,
1279,
1277,
1288,
1291,
1274,
1293,
1281,
1308,
1276,
1286,
1280,
1259,
961,
957,
978,
974,
922,
920,
930,
1094,
913,
911,
1324,
1319,
1318,
1317,
1316,
1110,
1150,
1112,
1152,
1119,
1117,
1111,
994,
1113,
1132,
1131,
1122,
1114,
1146,
1148,
1149,
1145,
1133,
1130,
1121,
1128,
1129,
1126,
1125,
1127,
1124,
1053,
1050,
1051,
1052,
1183,
1034,
1039,
1030,
1026,
1025,
1038,
1037,
932,
935,
933,
1001,
1000,
1011,
991,
1016,
1017,
1015,
1014,
992,
1019,
990,
1007,
1059,
1056,
1077,
1076,
1065,
1215,
1219,
1221,
1211,
1212,
1298,
1299,
1300,
1301,
1303,
1304,
1305,
1250,
944,
1214,
1217,
1246,
1245,
1244,
1252,
1248,
1189,
1187,
1188,
1186,
1197,
1226,
1223,
1222,
1233,
1232,
947,
948,
949,
950,
951,
953,
954,
955,
956,
946,
952,
1302,
1297,
888,
889,
891,
1273,
874,
875,
876,
877,
878,
879,
880,
881,
882,
883,
884,
871,
868,
1098,
1092,
1091,
1090,
899,
900,
901,
902,
903,
904,
905,
907,
908,
910,
1311,
1310,
1309,
1263,
1283,
1284,
898,
906,
909,
1270,
1254,
1256,
1289,
1266,
1257,
1267,
1255,
969,
964,
965,
966,
967,
968,
971,
972,
973,
970,
963,
981,
982,
983,
984,
985,
986,
987,
980,
923,
925,
919,
928,
927,
929,
916,
917,
915,
1327,
1338,
1330,
1328,
1329,
1331,
1326,
1337,
1336,
1322,
};

static	void	yyErrorRecovery		ARGS((yySymbolRange * yyTerminal, yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr));
static	void	yyComputeContinuation	ARGS((yyStateRange * yyStack, unsigned long yyStackSize, short yyStackPtr, tSet * yyContinueSet));
static	bool	yyIsContinuation	ARGS((yySymbolRange yyTerminal, yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr));
static	void	yyComputeRestartPoints	ARGS((yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr, tSet * yyRestartSet));
static	yyStateRange yyNext		ARGS((yyStateRange yyState, yySymbolRange yySymbol));
static	void	BeginParser		();

int Parser ()
   {
      register	yyStateRange	yyState		;
      register	long		yyTerminal	;
      register	yyStateRange *	yyStateStackPtr ;
      register	tParsAttribute *yyAttrStackPtr	;
      register	bool		yyIsRepairing	;
		unsigned long	yyStateStackSize= yyInitStackSize;
		unsigned long	yyAttrStackSize = yyInitStackSize;
		yyStateRange *	yyStateStack	;
		tParsAttribute* yyAttributeStack;
		tParsAttribute	yySynAttribute	;	/* synthesized attribute */
      register	yyStateRange *	yyEndOfStack	;
		int		yyErrorCount	= 0;
   
/* line 208 "Parser.lalr" */



      BeginParser ();
      yyState		= yyStartState;
      yyTerminal	= GetToken ();
      MakeArray ((char * *) & yyStateStack, & yyStateStackSize, sizeof (yyStateRange));
      MakeArray ((char * *) & yyAttributeStack, & yyAttrStackSize, sizeof (tParsAttribute));
      yyEndOfStack	= & yyStateStack [yyStateStackSize];
      yyStateStackPtr	= yyStateStack;
      yyAttrStackPtr	= yyAttributeStack;
      yyIsRepairing	= false;

   ParseLoop:
      for (;;) {
	 if (yyStateStackPtr >= yyEndOfStack) {
	    int yyyStateStackPtr= yyStateStackPtr - yyStateStack;
	    int yyyAttrStackPtr	= yyAttrStackPtr - yyAttributeStack;
	    ExtendArray ((char * *) & yyStateStack, & yyStateStackSize, sizeof (yyStateRange));
	    ExtendArray ((char * *) & yyAttributeStack, & yyAttrStackSize, sizeof (tParsAttribute));
	    yyStateStackPtr	= yyStateStack + yyyStateStackPtr;
	    yyAttrStackPtr	= yyAttributeStack + yyyAttrStackPtr;
	    yyEndOfStack	= & yyStateStack [yyStateStackSize];
	 }
	 * yyStateStackPtr = yyState;

   TermTrans:
	 for (;;) {	/* SPEC State = Next (State, Terminal); terminal transition */
	    register short * yyTCombPtr;

	    yyTCombPtr = (short *) (yyTBasePtr [yyState] + yyTerminal);
	    if (* yyTCombPtr ++ == yyState) { yyState = * yyTCombPtr; break; }
	    if ((yyState = yyDefault [yyState]) != yyNoState) goto TermTrans;

							/* syntax error */
	    if (! yyIsRepairing) {			/* report and recover */
	       yySymbolRange yyyTerminal = yyTerminal;

	       yyErrorCount ++;
	       yyErrorRecovery (& yyyTerminal, yyStateStack, yyStateStackSize, yyStateStackPtr - yyStateStack);
	       yyTerminal = yyyTerminal;
	       yyIsRepairing = true;
	    }
	    yyState = * yyStateStackPtr;
	    for (;;) {
	       if (yyNext (yyState, (yySymbolRange) yyTerminal) == yyNoState) { /* repair */
		  yySymbolRange		yyRepairToken;
		  tScanAttribute	yyRepairAttribute;
	    
		  yyRepairToken = yyContinuation [yyState];
		  yyState = yyNext (yyState, yyRepairToken);
		  if (yyState <= yyLastReadTermState) { /* read or read terminal reduce ? */
		     ErrorAttribute ((int) yyRepairToken, & yyRepairAttribute);
		     ErrorMessageI (xxTokenInserted, xxRepair, Attribute.Position,
			xxString, Parser_TokenName [yyRepairToken]);
		     if (yyState >= yyFirstFinalState) {	/* avoid second push */
			yyState = yyFinalToProd [yyState - yyFirstReadTermState];
		     }
		     yyGetAttribute (yyAttrStackPtr ++, yyRepairAttribute);
		     * ++ yyStateStackPtr = yyState;
		  }
		  if (yyState >= yyFirstFinalState) goto Final; /* final state ? */
	       } else {
		  yyState = yyNext (yyState, (yySymbolRange) yyTerminal);
		  goto Final;
	       }
	    }
	 }

   Final:
	 if (yyState >= yyFirstFinalState) {		/* final state ? */
	    if (yyState <= yyLastReadTermState) {	/* read terminal reduce ? */
	       yyStateStackPtr ++;
	       yyGetAttribute (yyAttrStackPtr ++, Attribute);
	       yyTerminal = GetToken ();
	       yyIsRepairing = false;
	    }

	    for (;;) {
	       /* register long yyNonterminal;		/* left-hand side */
# define yyNonterminal yyState

switch (yyState) {
case 857: /* _0000_ : root _EndOfFile .*/
  ReleaseArray ((char * *) & yyStateStack, & yyStateStackSize, sizeof (yyStateRange));
  ReleaseArray ((char * *) & yyAttributeStack, & yyAttrStackSize, sizeof (tParsAttribute));
  return yyErrorCount;

case 858: /* root : xx1 design_file .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 111; {

} break;
case 859: /* xx1 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 109; {
/* line 334 "Parser.lalr" */
 ;
{ 
	     cv_initialize();
	     reset_has_sensitivity_list();
	     declaration_init(0);
           }
	;

} break;
case 860:
case 623: /* entity_declaration : 'ENTITY' identifier 'IS' xx2 opt_generic_clause opt_port_clause entity_declarative_part xx3 opt_entity_statement_part 'END' opt_entity opt_identifier ';' .*/
  yyStateStackPtr -=13; yyAttrStackPtr -=13; yyNonterminal = 120; {
/* line 342 "Parser.lalr" */
 yySynAttribute.entity_declaration = yyAttrStackPtr [8-1].entity_declaration;
 
           ;
{  remove_declarative_part();
                check_end_id(yyAttrStackPtr [2-1].Scan.identifier.Id, yyAttrStackPtr [12-1].opt_identifier.Id, 
			     & yyErrorCount, yyAttrStackPtr [12-1].opt_identifier.Position); 
	       }
           yySynAttribute.entity_declaration.Tree = 
	      entity_declaration(yyAttrStackPtr [2-1].Scan.identifier.Id, yyAttrStackPtr [6-1].opt_port_clause.Tree,
				 & yyErrorCount, yyAttrStackPtr [2-1].Scan.Position) ;

	;

} break;
case 861: /* xx2 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 112; {
/* line 355 "Parser.lalr" */

	  ;
{ 
	    default_context_clause(kEntityDeclaration, yyAttrStackPtr [-1-1].Scan.identifier.Id,
                                   & yyErrorCount, yyAttrStackPtr [-1-1].Scan.Position);
	   }
	;

} break;
case 862: /* xx3 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 116; {
/* line 363 "Parser.lalr" */
 yySynAttribute.entity_declaration = yyAttrStackPtr [-3-1].entity_declaration;

	   ;
{ 
              add_declarative_part(yyAttrStackPtr [-1-1].opt_port_clause.Tree) ;
            }
	;

} break;
case 863: /* opt_entity : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 118; {

} break;
case 864:
case 622: /* opt_entity : 'ENTITY' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 118; {

} break;
case 865: /* opt_identifier : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 119; {
/* line 373 "Parser.lalr" */
yySynAttribute.opt_identifier.Id = (tString) NULL;
 yySynAttribute.opt_identifier.Position = NoPosition;
 ;

} break;
case 866:
case 576: /* opt_identifier : identifier .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 119; {
/* line 377 "Parser.lalr" */
yySynAttribute.opt_identifier.Id = yyAttrStackPtr [1-1].Scan.identifier.Id;
yySynAttribute.opt_identifier.Position = yyAttrStackPtr [1-1].Scan.Position;

} break;
case 867: /* opt_generic_clause : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 113; {

} break;
case 868:
case 787: /* opt_generic_clause : generic_clause .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 113; {
/* line 382 "Parser.lalr" */
 ;
{  production_not_implemented("opt_generic_clause", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 869:
case 558: /* generic_clause : 'GENERIC' '(' interface_list ')' ';' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 121; {

} break;
case 870: /* opt_port_clause : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 114; {
/* line 387 "Parser.lalr" */
 yySynAttribute.opt_port_clause.Tree = 0;
 ;

} break;
case 871:
case 786: /* opt_port_clause : port_clause .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 114; {
/* line 390 "Parser.lalr" */
 yySynAttribute.opt_port_clause.Tree  =  yyAttrStackPtr [1-1].port_clause.Tree;
 ;

} break;
case 872:
case 559: /* port_clause : 'PORT' '(' interface_list ')' ';' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 123; {
/* line 393 "Parser.lalr" */
 
	   yySynAttribute.port_clause.Tree  =  yyAttrStackPtr [3-1].interface_list.Tree;
 
	;

} break;
case 873: /* entity_declarative_part : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 115; {

} break;
case 874:
case 775: /* entity_declarative_part : entity_declarative_part entity_declarative_item .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 115; {
/* line 400 "Parser.lalr" */
 ;
{  production_not_implemented("entity_declarative_part", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 875:
case 776: /* entity_declarative_item : subprogram_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 124; {

} break;
case 876:
case 777: /* entity_declarative_item : subprogram_body .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 124; {

} break;
case 877:
case 778: /* entity_declarative_item : type_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 124; {

} break;
case 878:
case 779: /* entity_declarative_item : subtype_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 124; {

} break;
case 879:
case 780: /* entity_declarative_item : constant_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 124; {

} break;
case 880:
case 781: /* entity_declarative_item : signal_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 124; {

} break;
case 881:
case 782: /* entity_declarative_item : alias_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 124; {

} break;
case 882:
case 783: /* entity_declarative_item : attribute_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 124; {

} break;
case 883:
case 784: /* entity_declarative_item : attribute_specification .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 124; {

} break;
case 884:
case 785: /* entity_declarative_item : use_clause .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 124; {

} break;
case 885: /* opt_entity_statement_part : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 117; {

} break;
case 886: /* opt_entity_statement_part : 'BEGIN' entity_statement_list .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 117; {

} break;
case 887: /* entity_statement_list : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 135; {

} break;
case 888:
case 771: /* entity_statement_list : entity_statement_list entity_statement .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 135; {
/* line 418 "Parser.lalr" */
 ;
{  production_not_implemented("entity_statement_list", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 889:
case 772: /* entity_statement : concurrent_assertion_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 136; {

} break;
case 890:
case 597: /* entity_statement : concurrent_procedure_call .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 136; {

} break;
case 891:
case 773: /* entity_statement : process_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 136; {

} break;
case 892:
case 635: /* architecture_body : 'ARCHITECTURE' identifier 'OF' name 'IS' xx12 block_declarative_part xx13 'BEGIN' concurrent_statements 'END' opt_architecture opt_identifier ';' .*/
  yyStateStackPtr -=14; yyAttrStackPtr -=14; yyNonterminal = 145; {
/* line 425 "Parser.lalr" */
 yySynAttribute.architecture_body = yyAttrStackPtr [8-1].architecture_body;

	   ;
{  remove_declarative_part() ;
                check_end_id(yyAttrStackPtr [2-1].Scan.identifier.Id, yyAttrStackPtr [13-1].opt_identifier.Id,
                             & yyErrorCount, yyAttrStackPtr [13-1].opt_identifier.Position) ;  }
	   yySynAttribute.architecture_body.Tree = 
              architecture_body(yyAttrStackPtr [2-1].Scan.identifier.Id,
	                    	yyAttrStackPtr [7-1].block_declarative_part.Tree,
	                        yyAttrStackPtr [10-1].concurrent_statements.Tree,
	                        yyAttrStackPtr [4-1].name.Tree,
                                & yyErrorCount,
		                yyAttrStackPtr [2-1].Scan.Position) ;

        ;

} break;
case 893: /* xx12 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 140; {
/* line 441 "Parser.lalr" */
  
	   ;
{ 
              default_context_clause(kArchitectureBody, qName(yyAttrStackPtr [-1-1].name.Tree), 
                                     & yyErrorCount, yyAttrStackPtr [-3-1].Scan.Position);
              set_primary(yyAttrStackPtr [-1-1].name.Tree, yyAttrStackPtr [-3-1].Scan.identifier.Id,
                          & yyErrorCount, yyAttrStackPtr [-3-1].Scan.Position) ;
            }
	;

} break;
case 894: /* xx13 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 142; {
/* line 451 "Parser.lalr" */
 yySynAttribute.architecture_body = yyAttrStackPtr [-1-1].architecture_body;

	   ;
{ 
	      end_declarative_part();
              add_declarative_part(yyAttrStackPtr [0-1].block_declarative_part.Tree) ;
            }
	;

} break;
case 895: /* opt_architecture : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 144; {

} break;
case 896:
case 634: /* opt_architecture : 'ARCHITECTURE' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 144; {

} break;
case 897: /* block_declarative_part : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 141; {
/* line 462 "Parser.lalr" */

		   ;
{ 
                      begin_declarative_part() ;
                    }
		   yySynAttribute.block_declarative_part.Tree = 0;

		;

} break;
case 898:
case 808: /* block_declarative_part : block_declarative_part block_declarative_item .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 141; {
/* line 471 "Parser.lalr" */
  
                   yySynAttribute.block_declarative_part.Tree = add_declarative_item(yyAttrStackPtr [2-1].block_declarative_item.Tree, & yyErrorCount,
                                                yyAttrStackPtr [2-1].Scan.Position);

		;

} break;
case 899:
case 792: /* block_declarative_item : subprogram_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 146; {
/* line 479 "Parser.lalr" */

		   ;
{  production_not_implemented("subprogram_declaration", 
					           & yyErrorCount, 
					           yySynAttribute.Scan.Position) ;  }
                   yySynAttribute.block_declarative_item.Tree = 0 ;

		;

} break;
case 900:
case 793: /* block_declarative_item : subprogram_body .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 146; {
/* line 488 "Parser.lalr" */

		   ;
{  production_not_implemented("subprogram_body", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
                   yySynAttribute.block_declarative_item.Tree = 0 ;

		;

} break;
case 901:
case 794: /* block_declarative_item : type_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 146; {
/* line 495 "Parser.lalr" */

                   yySynAttribute.block_declarative_item.Tree  =  yyAttrStackPtr [1-1].type_declaration.Tree ;

		;

} break;
case 902:
case 795: /* block_declarative_item : subtype_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 146; {
/* line 500 "Parser.lalr" */

                   yySynAttribute.block_declarative_item.Tree  =  yyAttrStackPtr [1-1].subtype_declaration.Tree ;

		;

} break;
case 903:
case 796: /* block_declarative_item : constant_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 146; {
/* line 505 "Parser.lalr" */

                   yySynAttribute.block_declarative_item.Tree  =  yyAttrStackPtr [1-1].constant_declaration.Tree ;

		;

} break;
case 904:
case 797: /* block_declarative_item : signal_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 146; {
/* line 510 "Parser.lalr" */

		   yySynAttribute.block_declarative_item.Tree  =  yyAttrStackPtr [1-1].signal_declaration.Tree ;

		;

} break;
case 905:
case 798: /* block_declarative_item : alias_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 146; {
/* line 517 "Parser.lalr" */

		   ;
{  production_not_implemented("alias_declaration", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
                   yySynAttribute.block_declarative_item.Tree = 0 ;

		;

} break;
case 906:
case 809: /* block_declarative_item : component_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 146; {
/* line 526 "Parser.lalr" */

		   ;
{  production_not_implemented("component_declaration", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
                   yySynAttribute.block_declarative_item.Tree = 0 ;

		;

} break;
case 907:
case 799: /* block_declarative_item : attribute_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 146; {
/* line 535 "Parser.lalr" */

		   ;
{  production_not_implemented("attribute_declaration", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
                   yySynAttribute.block_declarative_item.Tree = 0 ;

		;

} break;
case 908:
case 800: /* block_declarative_item : attribute_specification .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 146; {
/* line 544 "Parser.lalr" */

		   ;
{  production_not_implemented("attribute_specification", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
                   yySynAttribute.block_declarative_item.Tree = 0 ;

		;

} break;
case 909:
case 810: /* block_declarative_item : configuration_specification .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 146; {
/* line 553 "Parser.lalr" */

		   ;
{  production_not_implemented("configuration_specification", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
                   yySynAttribute.block_declarative_item.Tree = 0 ;

		;

} break;
case 910:
case 801: /* block_declarative_item : use_clause .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 146; {
/* line 560 "Parser.lalr" */

		   yySynAttribute.block_declarative_item.Tree = 0;

		;

} break;
case 911:
case 663: /* configuration_declaration : 'CONFIGURATION' identifier 'OF' name 'IS' configuration_declarative_part block_configuration 'END' opt_configuration opt_identifier ';' .*/
  yyStateStackPtr -=11; yyAttrStackPtr -=11; yyNonterminal = 152; {
/* line 566 "Parser.lalr" */
 ;
{  production_not_implemented("configuration_declaration", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 912: /* opt_configuration : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 151; {

} break;
case 913:
case 662: /* opt_configuration : 'CONFIGURATION' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 151; {

} break;
case 914: /* configuration_declarative_part : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 149; {

} break;
case 915:
case 846: /* configuration_declarative_part : configuration_declarative_part configuration_declarative_item .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 149; {

} break;
case 916:
case 844: /* configuration_declarative_item : attribute_specification .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 153; {

} break;
case 917:
case 845: /* configuration_declarative_item : use_clause .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 153; {

} break;
case 918: /* opt_block_configuration : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 154; {

} break;
case 919:
case 840: /* opt_block_configuration : block_configuration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 154; {

} break;
case 920:
case 659: /* block_configuration : 'FOR' block_specification opt_list_use_clause opt_list_configuration_item 'END' 'FOR' ';' .*/
  yyStateStackPtr -=7; yyAttrStackPtr -=7; yyNonterminal = 150; {

} break;
case 921: /* block_specification : identifier .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 155; {

} break;
case 922:
case 658: /* block_specification : identifier '.' identifier .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 155; {

} break;
case 923:
case 838: /* block_specification : identifier parenthesis_part .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 155; {

} break;
case 924: /* opt_list_use_clause : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 156; {

} break;
case 925:
case 839: /* opt_list_use_clause : opt_list_use_clause use_clause .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 156; {

} break;
case 926: /* opt_list_configuration_item : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 157; {

} break;
case 927:
case 842: /* opt_list_configuration_item : opt_list_configuration_item configuration_item .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 157; {

} break;
case 928:
case 841: /* configuration_item : block_configuration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 159; {

} break;
case 929:
case 843: /* configuration_item : component_configuration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 159; {

} break;
case 930:
case 660: /* component_configuration : 'FOR' component_specification opt_binding_indication opt_block_configuration 'END' 'FOR' ';' .*/
  yyStateStackPtr -=7; yyAttrStackPtr -=7; yyNonterminal = 160; {

} break;
case 931:
case 601: /* subprogram_declaration : subprogram_specification ';' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 125; {
/* line 590 "Parser.lalr" */
 ;
{  production_not_implemented("subprogram_declaration", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 932:
case 707: /* subprogram_specification : 'PROCEDURE' designator formal_parameter_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 163; {

} break;
case 933:
case 709: /* subprogram_specification : 'FUNCTION' designator formal_parameter_list 'RETURN' type_mark .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 163; {

} break;
case 934:
case 562: /* designator : identifier .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 164; {

} break;
case 935:
case 708: /* designator : operator_symbol .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 164; {

} break;
case 936:
case 532: /* operator_symbol : string_literal .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 167; {

} break;
case 937: /* formal_parameter_list : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 165; {

} break;
case 938:
case 563: /* formal_parameter_list : '(' interface_list ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 165; {

} break;
case 939:
case 605: /* subprogram_body : subprogram_specification 'IS' subprogram_declarative_part 'BEGIN' sequential_statements 'END' opt_subprogram_kind opt_designator ';' .*/
  yyStateStackPtr -=9; yyAttrStackPtr -=9; yyNonterminal = 126; {
/* line 602 "Parser.lalr" */
 ;
{  production_not_implemented("subprogram_body", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 940: /* opt_subprogram_kind : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 170; {

} break;
case 941:
case 603: /* opt_subprogram_kind : 'PROCEDURE' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 170; {

} break;
case 942:
case 604: /* opt_subprogram_kind : 'FUNCTION' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 170; {

} break;
case 943: /* opt_designator : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 171; {

} break;
case 944:
case 740: /* opt_designator : designator .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 171; {

} break;
case 945: /* subprogram_declarative_part : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 168; {

} break;
case 946:
case 767: /* subprogram_declarative_part : subprogram_declarative_part subprogram_declarative_item .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 168; {

} break;
case 947:
case 758: /* subprogram_declarative_item : subprogram_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 172; {

} break;
case 948:
case 759: /* subprogram_declarative_item : subprogram_body .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 172; {

} break;
case 949:
case 760: /* subprogram_declarative_item : type_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 172; {

} break;
case 950:
case 761: /* subprogram_declarative_item : subtype_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 172; {

} break;
case 951:
case 762: /* subprogram_declarative_item : constant_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 172; {

} break;
case 952:
case 768: /* subprogram_declarative_item : variable_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 172; {

} break;
case 953:
case 763: /* subprogram_declarative_item : alias_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 172; {

} break;
case 954:
case 764: /* subprogram_declarative_item : attribute_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 172; {

} break;
case 955:
case 765: /* subprogram_declarative_item : attribute_specification .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 172; {

} break;
case 956:
case 766: /* subprogram_declarative_item : use_clause .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 172; {

} break;
case 957:
case 655: /* package_declaration : 'PACKAGE' identifier 'IS' xx32 package_declarative_part xx33 'END' opt_package opt_identifier ';' .*/
  yyStateStackPtr -=10; yyAttrStackPtr -=10; yyNonterminal = 178; {
/* line 623 "Parser.lalr" */
 yySynAttribute.package_declaration = yyAttrStackPtr [6-1].package_declaration;

		  ;
{ 
		     remove_declarative_part();
		     check_end_id(yyAttrStackPtr [2-1].Scan.identifier.Id, yyAttrStackPtr [9-1].opt_identifier.Id,
                                  & yyErrorCount, yyAttrStackPtr [9-1].opt_identifier.Position);
		   } 
		yySynAttribute.package_declaration.Tree = package_declaration(yyAttrStackPtr [2-1].Scan.identifier.Id,
		                            yyAttrStackPtr [5-1].package_declarative_part.Tree,
                                            & yyErrorCount, 
		                            yyAttrStackPtr [9-1].opt_identifier.Position);

		;

} break;
case 958: /* xx32 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 174; {
/* line 638 "Parser.lalr" */

                  ;
{ 
                     default_context_clause(kPackageDeclaration, 
                                            yyAttrStackPtr [-1-1].Scan.identifier.Id,
                                            & yyErrorCount,
                                            yyAttrStackPtr [-1-1].Scan.Position);
                   }
		;

} break;
case 959: /* xx33 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 176; {
/* line 648 "Parser.lalr" */
 yySynAttribute.package_declaration = yyAttrStackPtr [-1-1].package_declaration;

		  ;
{ 
		     add_declarative_part(yyAttrStackPtr [0-1].package_declarative_part.Tree);
		   }
                ;

} break;
case 960: /* opt_package : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 177; {

} break;
case 961:
case 654: /* opt_package : 'PACKAGE' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 177; {

} break;
case 962: /* package_declarative_part : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 175; {
/* line 658 "Parser.lalr" */
 yySynAttribute.package_declarative_part.Tree = 0;
 ;

} break;
case 963:
case 829: /* package_declarative_part : package_declarative_part package_declarative_item .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 175; {
/* line 661 "Parser.lalr" */

		   yySynAttribute.package_declarative_part.Tree = append(yyAttrStackPtr [2-1].package_declarative_item.Tree,
		                  yyAttrStackPtr [1-1].package_declarative_part.Tree) ;

		;

} break;
case 964:
case 820: /* package_declarative_item : type_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 179; {
/* line 667 "Parser.lalr" */

		   yySynAttribute.package_declarative_item.Tree  =  yyAttrStackPtr [1-1].type_declaration.Tree;

		;

} break;
case 965:
case 821: /* package_declarative_item : subtype_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 179; {
/* line 672 "Parser.lalr" */

                   yySynAttribute.package_declarative_item.Tree  =  yyAttrStackPtr [1-1].subtype_declaration.Tree ;

                ;

} break;
case 966:
case 822: /* package_declarative_item : constant_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 179; {
/* line 677 "Parser.lalr" */

                   yySynAttribute.package_declarative_item.Tree  =  yyAttrStackPtr [1-1].constant_declaration.Tree;

                ;

} break;
case 967:
case 823: /* package_declarative_item : signal_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 179; {
/* line 682 "Parser.lalr" */

                   yySynAttribute.package_declarative_item.Tree  =  yyAttrStackPtr [1-1].signal_declaration.Tree;

                ;

} break;
case 968:
case 824: /* package_declarative_item : alias_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 179; {
/* line 689 "Parser.lalr" */

                   ;
{  production_not_implemented("alias_declaration",
					  & yyErrorCount, 
                                          yySynAttribute.Scan.Position) ;  }
                   yySynAttribute.package_declarative_item.Tree = 0 ;

                ;

} break;
case 969:
case 819: /* package_declarative_item : subprogram_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 179; {
/* line 698 "Parser.lalr" */

                   ;
{  production_not_implemented("subprogram_declaration",
					  & yyErrorCount, 
                                          yySynAttribute.Scan.Position) ;  }
                   yySynAttribute.package_declarative_item.Tree = 0 ;

                ;

} break;
case 970:
case 828: /* package_declarative_item : component_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 179; {
/* line 707 "Parser.lalr" */

                   ;
{  production_not_implemented("component_declaration",
					  & yyErrorCount, 
                                          yySynAttribute.Scan.Position) ;  }
                   yySynAttribute.package_declarative_item.Tree = 0 ;

                ;

} break;
case 971:
case 825: /* package_declarative_item : attribute_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 179; {
/* line 716 "Parser.lalr" */

                   ;
{  production_not_implemented("attribute_declaration",
					  & yyErrorCount, 
                                          yySynAttribute.Scan.Position) ;  }
                   yySynAttribute.package_declarative_item.Tree = 0 ;

                ;

} break;
case 972:
case 826: /* package_declarative_item : attribute_specification .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 179; {
/* line 725 "Parser.lalr" */

                   ;
{  production_not_implemented("attribute_declaration",
					  & yyErrorCount, 
                                          yySynAttribute.Scan.Position) ;  }
                   yySynAttribute.package_declarative_item.Tree = 0 ;

                ;

} break;
case 973:
case 827: /* package_declarative_item : use_clause .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 179; {
/* line 734 "Parser.lalr" */

                   ;
{  production_not_implemented("use_clause",
					  & yyErrorCount, 
                                          yySynAttribute.Scan.Position) ;  }
                   yySynAttribute.package_declarative_item.Tree = 0;

		;

} break;
case 974:
case 657: /* package_body : 'PACKAGE' 'BODY' simple_name 'IS' xx47 package_body_declarative_part xx48 'END' opt_package_body opt_identifier ';' .*/
  yyStateStackPtr -=11; yyAttrStackPtr -=11; yyNonterminal = 185; {
/* line 741 "Parser.lalr" */
 yySynAttribute.package_body = yyAttrStackPtr [7-1].package_body;
 ;
{  remove_declarative_part();
		       check_end_id(qName(yyAttrStackPtr [3-1].simple_name.Tree), yyAttrStackPtr [10-1].opt_identifier.Id,
		                    & yyErrorCount, yyAttrStackPtr [10-1].opt_identifier.Position) ;
		   }
		yySynAttribute.package_body.Tree = package_body(yyAttrStackPtr [3-1].simple_name.Tree,
		                     yyAttrStackPtr [6-1].package_body_declarative_part.Tree,
                                     & yyErrorCount, yyAttrStackPtr [3-1].simple_name.Position) ;

		;

} break;
case 975: /* xx47 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 181; {
/* line 759 "Parser.lalr" */
 ;
{ 
		     default_context_clause(kPackageBody, 
                                            qName(yyAttrStackPtr [-1-1].simple_name.Tree),
                                            & yyErrorCount,
                                            yyAttrStackPtr [-1-1].simple_name.Position);
		     set_primary(yyAttrStackPtr [-1-1].simple_name.Tree, "body",
                                 & yyErrorCount, yyAttrStackPtr [-1-1].simple_name.Position);
		   }
		;

} break;
case 976: /* xx48 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 183; {
/* line 764 "Parser.lalr" */
 yySynAttribute.package_body = yyAttrStackPtr [-1-1].package_body;
 ;
{ 
		     end_declarative_part();
		     add_declarative_part(yyAttrStackPtr [0-1].package_body_declarative_part.Tree);
		   }
		;

} break;
case 977: /* opt_package_body : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 184; {

} break;
case 978:
case 656: /* opt_package_body : 'PACKAGE' 'BODY' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 184; {

} break;
case 979: /* package_body_declarative_part : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 182; {
/* line 774 "Parser.lalr" */
 yySynAttribute.package_body_declarative_part.Tree = 0;
 ;

} break;
case 980:
case 837: /* package_body_declarative_part : package_body_declarative_part package_body_declarative_item .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 182; {
/* line 777 "Parser.lalr" */

		  yySynAttribute.package_body_declarative_part.Tree = append(yyAttrStackPtr [2-1].package_body_declarative_item.Tree,
		                 yyAttrStackPtr [1-1].package_body_declarative_part.Tree) ;

		;

} break;
case 981:
case 830: /* package_body_declarative_item : subprogram_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 186; {
/* line 783 "Parser.lalr" */

		  yySynAttribute.package_body_declarative_item.Tree = 0;

		;

} break;
case 982:
case 831: /* package_body_declarative_item : subprogram_body .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 186; {
/* line 788 "Parser.lalr" */

                  yySynAttribute.package_body_declarative_item.Tree = 0;

                ;

} break;
case 983:
case 832: /* package_body_declarative_item : type_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 186; {
/* line 793 "Parser.lalr" */

		  yySynAttribute.package_body_declarative_item.Tree  =  yyAttrStackPtr [1-1].type_declaration.Tree ;

		;

} break;
case 984:
case 833: /* package_body_declarative_item : subtype_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 186; {
/* line 798 "Parser.lalr" */

                  yySynAttribute.package_body_declarative_item.Tree  =  yyAttrStackPtr [1-1].subtype_declaration.Tree ;

                ;

} break;
case 985:
case 834: /* package_body_declarative_item : constant_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 186; {
/* line 803 "Parser.lalr" */

		  yySynAttribute.package_body_declarative_item.Tree  =  yyAttrStackPtr [1-1].constant_declaration.Tree ;

		;

} break;
case 986:
case 835: /* package_body_declarative_item : alias_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 186; {
/* line 808 "Parser.lalr" */

                  yySynAttribute.package_body_declarative_item.Tree = 0;

                ;

} break;
case 987:
case 836: /* package_body_declarative_item : use_clause .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 186; {
/* line 813 "Parser.lalr" */

		  yySynAttribute.package_body_declarative_item.Tree =0 ;

		;

} break;
case 988:
case 566: /* type_definition : '(' enumeration_list ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 188; {
/* line 818 "Parser.lalr" */

		yySynAttribute.type_definition.Tree= enumeration_type(yyAttrStackPtr [2-1].enumeration_list.Tree);

	;

} break;
case 989: /* type_definition : range_constraint .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 188; {
/* line 823 "Parser.lalr" */

		yySynAttribute.type_definition.Tree= integer_type_d(yyAttrStackPtr [1-1].range_constraint.Tree);

	;

} break;
case 990:
case 720: /* type_definition : range_constraint 'UNITS' base_unit_declaration secondary_unit_declarations 'END' 'UNITS' opt_identifier .*/
  yyStateStackPtr -=7; yyAttrStackPtr -=7; yyNonterminal = 188; {
/* line 828 "Parser.lalr" */

		yySynAttribute.type_definition.Tree=0;

	;

} break;
case 991:
case 713: /* type_definition : 'ARRAY' '(' index_subtype_definitions ')' 'OF' subtype_indication .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 188; {
/* line 833 "Parser.lalr" */

		yySynAttribute.type_definition.Tree=0;

	;

} break;
case 992:
case 718: /* type_definition : 'ARRAY' index_constraint 'OF' subtype_indication .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 188; {
/* line 838 "Parser.lalr" */

		yySynAttribute.type_definition.Tree=0;

	;

} break;
case 993:
case 570: /* type_definition : 'RECORD' element_declarations 'END' 'RECORD' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 188; {
/* line 843 "Parser.lalr" */

		yySynAttribute.type_definition.Tree=0;

	;

} break;
case 994:
case 676: /* range_constraint : 'RANGE' range .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 189; {
/* line 848 "Parser.lalr" */

	  yySynAttribute.range_constraint.Tree  =  yyAttrStackPtr [2-1].range.Tree;

        ;

} break;
case 995: /* range : attribute_name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 196; {
/* line 853 "Parser.lalr" */

			yySynAttribute.range.Tree = 0;

			;

} break;
case 996: /* range : simple_expression direction simple_expression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 196; {
/* line 858 "Parser.lalr" */

			yySynAttribute.range.Tree = mRange(0, yyAttrStackPtr [2-1].direction.Dir,
				       yyAttrStackPtr [1-1].relation.Tree, yyAttrStackPtr [3-1].relation.Tree);

			;

} break;
case 997: /* range_noname : simple_expression direction simple_expression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 200; {
/* line 864 "Parser.lalr" */

			yySynAttribute.range.Tree = mRange(0, yyAttrStackPtr [2-1].direction.Dir,
				       yyAttrStackPtr [1-1].relation.Tree, yyAttrStackPtr [3-1].relation.Tree);

			;

} break;
case 998:
case 534: /* direction : 'TO' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 199; {
/* line 870 "Parser.lalr" */
 yySynAttribute.direction.Dir = kTo;
 ;

} break;
case 999:
case 535: /* direction : 'DOWNTO' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 199; {
/* line 873 "Parser.lalr" */
 yySynAttribute.direction.Dir = kDownto;
 ;

} break;
case 1000:
case 711: /* enumeration_list : enumeration_literal .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 187; {
/* line 876 "Parser.lalr" */

				yySynAttribute.enumeration_list.Tree = mList(0, 0, 0,
                                              literal(yyAttrStackPtr [1-1].enumeration_literal.type, 
                                                      yyAttrStackPtr [1-1].enumeration_literal.Id, 
                                                      yyAttrStackPtr [1-1].enumeration_literal.Val));

							      
			;

} break;
case 1001:
case 710: /* enumeration_list : enumeration_list ',' enumeration_literal .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 187; {
/* line 885 "Parser.lalr" */

			yySynAttribute.enumeration_list.Tree = append(mList(0, 0, 0,
					     literal(yyAttrStackPtr [3-1].enumeration_literal.type, 
                                                     yyAttrStackPtr [3-1].enumeration_literal.Id, 
                                                     yyAttrStackPtr [3-1].enumeration_literal.Val)),
	                               yyAttrStackPtr [1-1].enumeration_list.Tree);

			;

} break;
case 1002:
case 564: /* enumeration_literal : xx72 identifier .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 201; {
/* line 894 "Parser.lalr" */
 yySynAttribute.enumeration_literal = yyAttrStackPtr [1-1].enumeration_literal;

			yySynAttribute.enumeration_literal.type = 0;

			yySynAttribute.enumeration_literal.Id  =  yyAttrStackPtr [2-1].Scan.identifier.Id ;

		;

} break;
case 1003: /* xx72 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 202; {
/* line 904 "Parser.lalr" */
yySynAttribute.enumeration_literal.type = 0 ;
 yySynAttribute.enumeration_literal.Id = 0 ;
 yySynAttribute.enumeration_literal.Val = '\0' ;
 ;

} break;
case 1004:
case 565: /* enumeration_literal : xx72 character_literal .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 201; {
/* line 907 "Parser.lalr" */
 yySynAttribute.enumeration_literal = yyAttrStackPtr [1-1].enumeration_literal;

			yySynAttribute.enumeration_literal.type = 1;
    
			yySynAttribute.enumeration_literal.Val  =  yyAttrStackPtr [2-1].Scan.character_literal.Val ;

		;

} break;
case 1005:
case 574: /* base_unit_declaration : identifier ';' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 190; {

} break;
case 1006: /* secondary_unit_declarations : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 191; {

} break;
case 1007:
case 721: /* secondary_unit_declarations : secondary_unit_declarations secondary_unit_declaration .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 191; {

} break;
case 1008:
case 575: /* secondary_unit_declaration : identifier '=' physical_literal ';' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 203; {

} break;
case 1009: /* physical_literal : abstract_literal pure_selected_name .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 204; {

} break;
case 1010:
case 568: /* index_subtype_definitions : pure_selected_name 'RANGE' '<>' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 192; {

} break;
case 1011:
case 712: /* index_subtype_definitions : index_subtype_definitions ',' index_subtype_definition .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 192; {

} break;
case 1012:
case 567: /* index_subtype_definition : pure_selected_name 'RANGE' '<>' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 207; {

} break;
case 1013:
case 569: /* index_constraint : '(' discrete_range_list ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 194; {

} break;
case 1014:
case 717: /* discrete_range_list : discrete_range .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 208; {

} break;
case 1015:
case 716: /* discrete_range_list : discrete_range_list ',' discrete_range .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 208; {

} break;
case 1016:
case 714: /* discrete_range : subtype_indication .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 209; {
/* line 926 "Parser.lalr" */
 yySynAttribute.discrete_range.Tree = 0;
 ;

} break;
case 1017:
case 715: /* discrete_range : range .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 209; {
/* line 929 "Parser.lalr" */
 yySynAttribute.discrete_range.Tree  =  yyAttrStackPtr [1-1].range.Tree;
 ;

} break;
case 1018:
case 572: /* element_declarations : identifier_list ':' subtype_indication ';' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 195; {

} break;
case 1019:
case 719: /* element_declarations : element_declarations element_declaration .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 195; {

} break;
case 1020:
case 571: /* element_declaration : identifier_list ':' subtype_indication ';' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 211; {

} break;
case 1021:
case 508: /* identifier_list : identifier .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 210; {
/* line 935 "Parser.lalr" */

		   yySynAttribute.identifier_list.value = new_identifier_list(yyAttrStackPtr [1-1].Scan.identifier.Id, 
                                                yyAttrStackPtr [1-1].Scan.Position);

                ;

} break;
case 1022:
case 509: /* identifier_list : identifier_list ',' identifier .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 210; {
/* line 941 "Parser.lalr" */

		   yySynAttribute.identifier_list.value = append_identifier_list(yyAttrStackPtr [1-1].identifier_list.value, yyAttrStackPtr [3-1].Scan.identifier.Id, 
                                                   yyAttrStackPtr [3-1].Scan.Position);

                ;

} break;
case 1023:
case 573: /* type_declaration : 'TYPE' identifier 'IS' type_definition ';' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 127; {
/* line 947 "Parser.lalr" */
 
		yySynAttribute.type_declaration.Tree = type_declaration(yyAttrStackPtr [2-1].Scan.identifier.Id, 
                                         & yyErrorCount, 
                                         yyAttrStackPtr [2-1].Scan.Position, 
                                         yyAttrStackPtr [4-1].type_definition.Tree) ;

	;

} break;
case 1024:
case 577: /* subtype_declaration : 'SUBTYPE' identifier 'IS' subtype_indication ';' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 128; {
/* line 955 "Parser.lalr" */
 yySynAttribute.subtype_declaration.Tree = subtype_declaration(yyAttrStackPtr [2-1].Scan.identifier.Id,
                                      & yyErrorCount, 
	                              yyAttrStackPtr [2-1].Scan.Position,
                                      yyAttrStackPtr [4-1].subtype_indication.Tree);
 ;

} break;
case 1025:
case 704: /* subtype_indication : pure_selected_name opt_range_constraint .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 193; {
/* line 961 "Parser.lalr" */

		   yySynAttribute.subtype_indication.Tree = subtype_indication(yyAttrStackPtr [1-1].pure_selected_name.Tree,
		                              yyAttrStackPtr [2-1].opt_range_constraint.Tree) ;

		;

} break;
case 1026:
case 703: /* subtype_indication : pure_selected_name pure_selected_name opt_range_constraint .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 193; {
/* line 969 "Parser.lalr" */
 
		   ;
{  production_not_implemented("subtype_indication2", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } 
		   yySynAttribute.subtype_indication.Tree = 0 ;

		;

} break;
case 1027: /* subtype_indication : parenthesis_name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 193; {
/* line 978 "Parser.lalr" */
 
		   ;
{  production_not_implemented("subtype_indication3", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } 
		   yySynAttribute.subtype_indication.Tree = 0 ;

		;

} break;
case 1028: /* subtype_indication : pure_selected_name parenthesis_name .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 193; {
/* line 987 "Parser.lalr" */
 
		   ;
{  production_not_implemented("subtype_indication4", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } 
		   yySynAttribute.subtype_indication.Tree = 0 ;

		;

} break;
case 1029: /* opt_range_constraint : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 212; {
/* line 994 "Parser.lalr" */
 yySynAttribute.opt_range_constraint.Tree = 0;
 ;

} break;
case 1030:
case 702: /* opt_range_constraint : range_constraint .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 212; {
/* line 997 "Parser.lalr" */
 yySynAttribute.opt_range_constraint.Tree  =  yyAttrStackPtr [1-1].range_constraint.Tree;
 ;

} break;
case 1031: /* type_mark : pure_selected_name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 166; {

} break;
case 1032:
case 560: /* constant_declaration : 'CONSTANT' identifier_list ':' subtype_indication opt_initial_value ';' .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 129; {
/* line 1001 "Parser.lalr" */
 
           yySynAttribute.constant_declaration.Tree = 
	      object_declarations(kConstant,
                                   yyAttrStackPtr [4-1].subtype_indication.Tree,
                                   yyAttrStackPtr [5-1].opt_initial_value.Tree,
                                   kInternal,
	                           yyAttrStackPtr [2-1].identifier_list.value,
                                   & yyErrorCount,
                                   yyAttrStackPtr [1-1].Scan.Position) ;

        ;

} break;
case 1033: /* opt_initial_value : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 214; {
/* line 1013 "Parser.lalr" */
 
		   yySynAttribute.opt_initial_value.Tree = 0 ;
 
		;

} break;
case 1034:
case 700: /* opt_initial_value : ':=' expression .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 214; {
/* line 1018 "Parser.lalr" */
 
		   yySynAttribute.opt_initial_value.Tree  =  yyAttrStackPtr [2-1].expression.Tree ;
 
		;

} break;
case 1035:
case 561: /* signal_declaration : 'SIGNAL' identifier_list ':' subtype_indication opt_initial_value ';' .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 130; {
/* line 1023 "Parser.lalr" */

           yySynAttribute.signal_declaration.Tree = 
	      object_declarations(kSignal,
                                   yyAttrStackPtr [4-1].subtype_indication.Tree,
                                   yyAttrStackPtr [5-1].opt_initial_value.Tree,
                                   kInternal,
	                           yyAttrStackPtr [2-1].identifier_list.value,
                                   & yyErrorCount,
                                   yyAttrStackPtr [1-1].Scan.Position) ;

        ;

} break;
case 1036:
case 600: /* variable_declaration : 'VARIABLE' identifier_list ':' subtype_indication opt_initial_value ';' .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 173; {
/* line 1035 "Parser.lalr" */

           yySynAttribute.variable_declaration.Tree = 
	      object_declarations(kVariable,
                                   yyAttrStackPtr [4-1].subtype_indication.Tree,
                                   yyAttrStackPtr [5-1].opt_initial_value.Tree,
                                   kInternal,
	                           yyAttrStackPtr [2-1].identifier_list.value,
                                   & yyErrorCount,
                                   yyAttrStackPtr [1-1].Scan.Position) ;

        ;

} break;
case 1037:
case 706: /* interface_list : class identifier_list ':' mode subtype_indication opt_initial_value .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 122; {
/* line 1047 "Parser.lalr" */
 
           	   yySynAttribute.interface_list.Tree = object_declarations(kSignal,
					       yyAttrStackPtr [5-1].subtype_indication.Tree,
					       yyAttrStackPtr [6-1].opt_initial_value.Tree,
					       yyAttrStackPtr [4-1].mode.Mode,
					       yyAttrStackPtr [2-1].identifier_list.value,
                                               & yyErrorCount,
                                               yyAttrStackPtr [1-1].Scan.Position) ;

        	;

} break;
case 1038:
case 705: /* interface_list : interface_list ';' interface_declaration .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 122; {
/* line 1058 "Parser.lalr" */
  
	   	   yySynAttribute.interface_list.Tree = append(yyAttrStackPtr [3-1].interface_list.Tree, yyAttrStackPtr [1-1].interface_list.Tree) ;
 
		;

} break;
case 1039:
case 701: /* interface_declaration : class identifier_list ':' mode subtype_indication opt_initial_value .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 218; {
/* line 1063 "Parser.lalr" */
 
           	   yySynAttribute.interface_list.Tree = object_declarations(kSignal,
					       yyAttrStackPtr [5-1].subtype_indication.Tree,
					       yyAttrStackPtr [6-1].opt_initial_value.Tree,
					       yyAttrStackPtr [4-1].mode.Mode,
					       yyAttrStackPtr [2-1].identifier_list.value,
                                               & yyErrorCount,
                                               yyAttrStackPtr [1-1].Scan.Position) ;

        	;

} break;
case 1040: /* class : xx94 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 216; {
/* line 1074 "Parser.lalr" */
 yySynAttribute.class = yyAttrStackPtr [1-1].class;
 yySynAttribute.class.Class = kDefaultClass;
 ;

} break;
case 1041: /* xx94 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 219; {
/* line 1078 "Parser.lalr" */
 yySynAttribute.class.Class = kDefaultClass ;
 ;

} break;
case 1042:
case 555: /* class : xx94 'CONSTANT' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 216; {
/* line 1081 "Parser.lalr" */
 yySynAttribute.class = yyAttrStackPtr [1-1].class;
 yySynAttribute.class.Class = kConstant;
 ;

} break;
case 1043:
case 556: /* class : xx94 'VARIABLE' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 216; {
/* line 1085 "Parser.lalr" */
 yySynAttribute.class = yyAttrStackPtr [1-1].class;
 yySynAttribute.class.Class = kVariable;
 ;

} break;
case 1044:
case 557: /* class : xx94 'SIGNAL' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 216; {
/* line 1089 "Parser.lalr" */
 yySynAttribute.class = yyAttrStackPtr [1-1].class;
 yySynAttribute.class.Class = kSignal;
 ;

} break;
case 1045: /* mode : xx99 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 217; {
/* line 1093 "Parser.lalr" */
 yySynAttribute.mode = yyAttrStackPtr [1-1].mode;
 yySynAttribute.mode.Mode = kDefaultMode;
 ;

} break;
case 1046: /* xx99 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 220; {
/* line 1097 "Parser.lalr" */
 yySynAttribute.mode.Mode = kDefaultMode ;
 ;

} break;
case 1047:
case 552: /* mode : xx99 'IN' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 217; {
/* line 1100 "Parser.lalr" */
 yySynAttribute.mode = yyAttrStackPtr [1-1].mode;
 yySynAttribute.mode.Mode = kIn;
 ;

} break;
case 1048:
case 553: /* mode : xx99 'OUT' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 217; {
/* line 1104 "Parser.lalr" */
 yySynAttribute.mode = yyAttrStackPtr [1-1].mode;
 yySynAttribute.mode.Mode = kOut;
 ;

} break;
case 1049:
case 554: /* mode : xx99 'INOUT' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 217; {
/* line 1108 "Parser.lalr" */
 yySynAttribute.mode = yyAttrStackPtr [1-1].mode;
 yySynAttribute.mode.Mode = kInout;
 ;

} break;
case 1050:
case 696: /* association_list : association_element .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 222; {

} break;
case 1051:
case 697: /* association_list : association_list ',' association_element .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 222; {

} break;
case 1052:
case 698: /* association_element : choices '=>' expression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 221; {

} break;
case 1053:
case 695: /* association_element : expression .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 221; {

} break;
case 1054:
case 580: /* alias_declaration : 'ALIAS' alias_designator opt_colon_subtype_indication 'IS' name ';' .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 131; {
/* line 1117 "Parser.lalr" */
 ;
{  production_not_implemented("alias_declaration", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 1055: /* opt_colon_subtype_indication : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 225; {

} break;
case 1056:
case 723: /* opt_colon_subtype_indication : ':' subtype_indication .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 225; {

} break;
case 1057:
case 578: /* alias_designator : identifier .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 224; {

} break;
case 1058:
case 579: /* alias_designator : character_literal .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 224; {

} break;
case 1059:
case 722: /* alias_designator : operator_symbol .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 224; {

} break;
case 1060:
case 581: /* attribute_declaration : 'ATTRIBUTE' identifier ':' type_mark ';' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 132; {
/* line 1127 "Parser.lalr" */
 ;
{  production_not_implemented("attribute_declaration", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 1061:
case 633: /* component_declaration : 'COMPONENT' identifier opt_is opt_generic_clause opt_port_clause 'END' 'COMPONENT' ';' .*/
  yyStateStackPtr -=8; yyAttrStackPtr -=8; yyNonterminal = 147; {
/* line 1132 "Parser.lalr" */
 ;
{  production_not_implemented("component_declaration", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 1062: /* opt_is : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 226; {

} break;
case 1063:
case 599: /* opt_is : 'IS' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 226; {

} break;
case 1064:
case 585: /* attribute_specification : 'ATTRIBUTE' simple_name 'OF' entity_specification 'IS' expression ';' .*/
  yyStateStackPtr -=7; yyAttrStackPtr -=7; yyNonterminal = 133; {
/* line 1139 "Parser.lalr" */
 ;
{  production_not_implemented("attribute_specification", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 1065:
case 726: /* entity_specification : entity_name_list ':' entity_class .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 227; {
/* line 1144 "Parser.lalr" */
 ;
{  production_not_implemented("entity_specification", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 1066:
case 586: /* entity_class : 'ENTITY' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 229; {

} break;
case 1067:
case 593: /* entity_class : 'ARCHITECTURE' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 229; {

} break;
case 1068:
case 590: /* entity_class : 'PROCEDURE' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 229; {

} break;
case 1069:
case 591: /* entity_class : 'FUNCTION' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 229; {

} break;
case 1070:
case 594: /* entity_class : 'PACKAGE' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 229; {

} break;
case 1071:
case 592: /* entity_class : 'TYPE' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 229; {

} break;
case 1072:
case 587: /* entity_class : 'CONSTANT' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 229; {

} break;
case 1073:
case 589: /* entity_class : 'SIGNAL' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 229; {

} break;
case 1074:
case 588: /* entity_class : 'VARIABLE' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 229; {

} break;
case 1075:
case 595: /* entity_class : 'LABEL' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 229; {

} break;
case 1076:
case 725: /* entity_tag : simple_name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 230; {

} break;
case 1077:
case 724: /* entity_tag : operator_symbol .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 230; {

} break;
case 1078:
case 582: /* entity_tag : character_literal .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 230; {

} break;
case 1079: /* entity_name_list : entity_tag .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 228; {

} break;
case 1080: /* entity_name_list : entity_tag_list ',' entity_tag .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 228; {

} break;
case 1081:
case 584: /* entity_name_list : 'OTHERS' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 228; {

} break;
case 1082:
case 583: /* entity_name_list : 'ALL' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 228; {

} break;
case 1083: /* entity_tag_list : entity_tag .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 231; {

} break;
case 1084: /* entity_tag_list : entity_tag_list ',' entity_tag .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 231; {

} break;
case 1085:
case 632: /* configuration_specification : 'FOR' component_specification binding_indication ';' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 148; {
/* line 1168 "Parser.lalr" */
 ;
{  production_not_implemented("configuration_specification", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 1086: /* component_specification : instantiation_list ':' pure_selected_name .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 161; {

} break;
case 1087: /* instantiation_list : instantiation_labels .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 233; {

} break;
case 1088:
case 625: /* instantiation_list : 'OTHERS' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 233; {

} break;
case 1089:
case 624: /* instantiation_list : 'ALL' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 233; {

} break;
case 1090:
case 791: /* instantiation_labels : label .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 234; {

} break;
case 1091:
case 790: /* instantiation_labels : instantiation_labels ',' label .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 234; {

} break;
case 1092:
case 789: /* binding_indication : 'USE' entity_aspect opt_port_map_aspect opt_generic_map_aspect .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 232; {
/* line 1179 "Parser.lalr" */
 ;
{  production_not_implemented("binding_indication", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 1093: /* opt_binding_indication : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 162; {

} break;
case 1094:
case 661: /* opt_binding_indication : binding_indication ';' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 162; {

} break;
case 1095: /* entity_aspect : 'ENTITY' entity_name .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 236; {
/* line 1186 "Parser.lalr" */
 ;
{ production_not_implemented("entity_aspect1", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 1096:
case 627: /* entity_aspect : 'ENTITY' entity_name xx111 '(' identifier ')' .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 236; {

} break;
case 1097: /* xx111 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 240; {
/* line 1192 "Parser.lalr" */
 ;
{ production_not_implemented("entity_aspect1", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 1098:
case 788: /* entity_aspect : 'CONFIGURATION' configuration_name .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 236; {
/* line 1197 "Parser.lalr" */
 ;
{  production_not_implemented("entity_aspect2", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 1099:
case 629: /* entity_aspect : 'OPEN' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 236; {
/* line 1202 "Parser.lalr" */
 ;
{  production_not_implemented("entity_aspect3", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);  } ;

} break;
case 1100: /* entity_name : identifier .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 239; {

} break;
case 1101:
case 626: /* entity_name : identifier '.' identifier .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 239; {

} break;
case 1102: /* configuration_name : identifier .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 241; {

} break;
case 1103:
case 628: /* configuration_name : identifier '.' identifier .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 241; {

} break;
case 1104: /* opt_generic_map_aspect : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 238; {

} break;
case 1105:
case 631: /* opt_generic_map_aspect : 'GENERIC' 'MAP' '(' association_list ')' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 238; {

} break;
case 1106: /* opt_port_map_aspect : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 237; {

} break;
case 1107:
case 630: /* opt_port_map_aspect : 'PORT' 'MAP' '(' association_list ')' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 237; {

} break;
case 1108: /* name : pure_selected_name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 139; {
/* line 1214 "Parser.lalr" */

		   yySynAttribute.name.Tree  =  yyAttrStackPtr [1-1].pure_selected_name.Tree ;
 
		   yySynAttribute.name.Position  =  yyAttrStackPtr [1-1].pure_selected_name.Position ;

		;

} break;
case 1109: /* name : other_name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 139; {
/* line 1223 "Parser.lalr" */

		   ;
{  production_not_implemented("other_name",
                                                   & yyErrorCount,
                                                   NoPosition);
		    }
		   yySynAttribute.name.Tree = 0 ;

		   yySynAttribute.name.Position  =  yyAttrStackPtr [1-1].other_name.Position ;

		;

} break;
case 1110:
case 669: /* pure_selected_name : simple_name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 206; {
/* line 1233 "Parser.lalr" */
 
		   yySynAttribute.pure_selected_name.Tree  =  yyAttrStackPtr [1-1].simple_name.Tree ;
 
		   yySynAttribute.pure_selected_name.Position  =  yyAttrStackPtr [1-1].simple_name.Position ;

		;

} break;
case 1111:
case 675: /* pure_selected_name : pure_selected_name '.' suffix .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 206; {
/* line 1242 "Parser.lalr" */
 
		   ;
{  production_not_implemented("pure_selected_name.suffix", 
					           & yyErrorCount, 
					  NoPosition);  } 
		   yySynAttribute.pure_selected_name.Tree = 0 ;

		   yySynAttribute.pure_selected_name.Position  =  yyAttrStackPtr [1-1].pure_selected_name.Position ;

		;

} break;
case 1112:
case 671: /* other_name : attribute_name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 242; {
/* line 1251 "Parser.lalr" */

		   yySynAttribute.other_name.Position  =  yyAttrStackPtr [1-1].attribute_name.Position ;

		;

} break;
case 1113:
case 677: /* other_name : parenthesis_name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 242; {
/* line 1256 "Parser.lalr" */

		   yySynAttribute.other_name.Position  =  yyAttrStackPtr [1-1].parenthesis_name.Position ;

		;

} break;
case 1114:
case 681: /* other_name : other_name xx120 '.' suffix .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 242; {

} break;
case 1115: /* xx120 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 244; {
/* line 1262 "Parser.lalr" */

		   yySynAttribute.other_name.Position  =  yyAttrStackPtr [0-1].other_name.Position ;

		;

} break;
case 1116:
case 510: /* simple_name : identifier .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 180; {
/* line 1267 "Parser.lalr" */

           yySynAttribute.simple_name.Tree = identifier_node(yyAttrStackPtr [1-1].Scan.identifier.Id) ;

	   yySynAttribute.simple_name.Position  =  yyAttrStackPtr [1-1].Scan.Position ;

        ;

} break;
case 1117:
case 674: /* suffix : simple_name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 243; {

} break;
case 1118:
case 531: /* suffix : character_literal .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 243; {

} break;
case 1119:
case 673: /* suffix : operator_symbol .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 243; {

} break;
case 1120:
case 533: /* suffix : 'ALL' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 243; {

} break;
case 1121:
case 688: /* parenthesis_name : pure_selected_name parenthesis_part .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 213; {
/* line 1278 "Parser.lalr" */

		   yySynAttribute.parenthesis_name.Position  =  yyAttrStackPtr [1-1].pure_selected_name.Position ;

		;

} break;
case 1122:
case 680: /* parenthesis_name : other_name parenthesis_part .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 213; {
/* line 1283 "Parser.lalr" */

		   yySynAttribute.parenthesis_name.Position  =  yyAttrStackPtr [1-1].other_name.Position ;

		;

} break;
case 1123:
case 547: /* parenthesis_part : '(' parenthesis_list ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 158; {

} break;
case 1124:
case 694: /* parenthesis_list : parenthesis_element .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 245; {

} break;
case 1125:
case 692: /* parenthesis_list : parenthesis_list ',' parenthesis_element .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 245; {

} break;
case 1126:
case 691: /* parenthesis_element : expression .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 246; {

} break;
case 1127:
case 693: /* parenthesis_element : discrete_range_noname .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 246; {

} break;
case 1128:
case 689: /* discrete_range_noname : type_mark range_constraint .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 247; {

} break;
case 1129:
case 690: /* discrete_range_noname : range_noname .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 247; {

} break;
case 1130:
case 687: /* attribute_name : pure_selected_name "'" attribute_designator .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 197; {
/* line 1295 "Parser.lalr" */

		   yySynAttribute.attribute_name.Position  =  yyAttrStackPtr [1-1].pure_selected_name.Position ;

		;

} break;
case 1131:
case 679: /* attribute_name : other_name "'" attribute_designator .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 197; {
/* line 1300 "Parser.lalr" */

		   yySynAttribute.attribute_name.Position  =  yyAttrStackPtr [1-1].other_name.Position ;

		;

} break;
case 1132:
case 678: /* attribute_designator : simple_name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 248; {

} break;
case 1133:
case 686: /* expression : relation binary_logical_operator relation .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 215; {
/* line 1306 "Parser.lalr" */

		  yySynAttribute.expression.Tree = binary_node(yyAttrStackPtr [2-1].binary_logical_operator.Op, yyAttrStackPtr [1-1].relation.Tree, yyAttrStackPtr [3-1].relation.Tree, 
                                      & yyErrorCount, yyAttrStackPtr [1-1].relation.Position) ;

		  yySynAttribute.expression.Position  =  yyAttrStackPtr [1-1].relation.Position;

                ;

} break;
case 1134: /* expression : relation .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 215; {
/* line 1314 "Parser.lalr" */

		  yySynAttribute.expression.Tree  =  yyAttrStackPtr [1-1].relation.Tree;

		  yySynAttribute.expression.Position  =  yyAttrStackPtr [1-1].relation.Position;

                ;

} break;
case 1135: /* expression : multiplying_expression multiplying_logical_operator relation .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 215; {
/* line 1321 "Parser.lalr" */

		  yySynAttribute.expression.Tree = binary_node(yyAttrStackPtr [2-1].multiplying_logical_operator.Op, yyAttrStackPtr [1-1].expression.Tree, yyAttrStackPtr [3-1].relation.Tree, 
                                      & yyErrorCount, yyAttrStackPtr [1-1].expression.Position);

		  yySynAttribute.expression.Position  =  yyAttrStackPtr [1-1].expression.Position;

                ;

} break;
case 1136: /* multiplying_expression : relation .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 251; {
/* line 1329 "Parser.lalr" */

		  yySynAttribute.expression.Tree  =  yyAttrStackPtr [1-1].relation.Tree;

		  yySynAttribute.expression.Position  =  yyAttrStackPtr [1-1].relation.Position;

                ;

} break;
case 1137: /* multiplying_expression : multiplying_expression multiplying_logical_operator relation .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 251; {
/* line 1336 "Parser.lalr" */

		  yySynAttribute.expression.Tree = binary_node(yyAttrStackPtr [2-1].multiplying_logical_operator.Op, yyAttrStackPtr [1-1].expression.Tree, yyAttrStackPtr [3-1].relation.Tree, 
                                      & yyErrorCount, yyAttrStackPtr [1-1].expression.Position);

		  yySynAttribute.expression.Position  =  yyAttrStackPtr [1-1].expression.Position;

                ;

} break;
case 1138: /* relation : term .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 249; {
/* line 1344 "Parser.lalr" */

		   yySynAttribute.relation.Tree  =  yyAttrStackPtr [1-1].term.Tree ;

		   yySynAttribute.relation.Position  =  yyAttrStackPtr [1-1].term.Position ;

                ;

} break;
case 1139: /* relation : sign term .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 249; {
/* line 1351 "Parser.lalr" */
	
		   yySynAttribute.relation.Tree = put_sign(yyAttrStackPtr [1-1].sign.Op, yyAttrStackPtr [2-1].term.Tree,
                                    & yyErrorCount, yyAttrStackPtr [2-1].term.Position);

		   yySynAttribute.relation.Position  =  yyAttrStackPtr [2-1].term.Position ;

		;

} break;
case 1140: /* relation : simple_expression adding_operator term .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 249; {
/* line 1359 "Parser.lalr" */

		  yySynAttribute.relation.Tree = binary_node(yyAttrStackPtr [2-1].adding_operator.Op, yyAttrStackPtr [1-1].relation.Tree, yyAttrStackPtr [3-1].term.Tree, 
                                      & yyErrorCount, yyAttrStackPtr [1-1].relation.Position) ;

		  yySynAttribute.relation.Position  =  yyAttrStackPtr [1-1].relation.Position;

                ;

} break;
case 1141: /* relation : simple_expression relational_operator simple_expression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 249; {
/* line 1367 "Parser.lalr" */

		  yySynAttribute.relation.Tree = binary_node(yyAttrStackPtr [2-1].relational_operator.Op, yyAttrStackPtr [1-1].relation.Tree, yyAttrStackPtr [3-1].relation.Tree, 
                                      & yyErrorCount, yyAttrStackPtr [1-1].relation.Position) ;

		  yySynAttribute.relation.Position  =  yyAttrStackPtr [1-1].relation.Position;

               	;

} break;
case 1142: /* simple_expression : term .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 198; {
/* line 1375 "Parser.lalr" */

		   yySynAttribute.relation.Tree  =  yyAttrStackPtr [1-1].term.Tree ;

		   yySynAttribute.relation.Position  =  yyAttrStackPtr [1-1].term.Position ;

                ;

} break;
case 1143: /* simple_expression : sign term .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 198; {
/* line 1382 "Parser.lalr" */
	
		   yySynAttribute.relation.Tree = put_sign(yyAttrStackPtr [1-1].sign.Op, yyAttrStackPtr [2-1].term.Tree,
                                    & yyErrorCount, yyAttrStackPtr [2-1].term.Position);

		   yySynAttribute.relation.Position  =  yyAttrStackPtr [2-1].term.Position ;

		;

} break;
case 1144: /* simple_expression : simple_expression adding_operator term .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 198; {
/* line 1390 "Parser.lalr" */

		  yySynAttribute.relation.Tree = binary_node(yyAttrStackPtr [2-1].adding_operator.Op, yyAttrStackPtr [1-1].relation.Tree, yyAttrStackPtr [3-1].term.Tree, 
                                      & yyErrorCount, yyAttrStackPtr [1-1].relation.Position) ;

		  yySynAttribute.relation.Position  =  yyAttrStackPtr [1-1].relation.Position;

                ;

} break;
case 1145:
case 685: /* term : factor .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 253; {
/* line 1398 "Parser.lalr" */
	
		  yySynAttribute.term.Tree  =  yyAttrStackPtr [1-1].factor.Tree ;

		  yySynAttribute.term.Position  =  yyAttrStackPtr [1-1].factor.Position ;

		;

} break;
case 1146:
case 682: /* term : term multiplying_operator factor .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 253; {
/* line 1405 "Parser.lalr" */
	
		  yySynAttribute.term.Tree = binary_node(yyAttrStackPtr [2-1].multiplying_operator.Op, yyAttrStackPtr [1-1].term.Tree, yyAttrStackPtr [3-1].factor.Tree, 
                                      & yyErrorCount, yyAttrStackPtr [1-1].term.Position) ;

		  yySynAttribute.term.Position  =  yyAttrStackPtr [1-1].term.Position;

                ;

} break;
case 1147: /* factor : primary .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 257; {
/* line 1413 "Parser.lalr" */
	
		  yySynAttribute.factor.Tree  =  yyAttrStackPtr [1-1].primary.Tree ;

		  yySynAttribute.factor.Position  =  yyAttrStackPtr [1-1].primary.Position ;

		;

} break;
case 1148:
case 683: /* factor : primary '**' primary .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 257; {
/* line 1423 "Parser.lalr" */
yySynAttribute.factor.Tree = yyAttrStackPtr [3-1].primary.Tree;
	
		   ;
{  production_not_implemented("factor2", 
					           & yyErrorCount, 
					           NoPosition) ;  }
		 yySynAttribute.factor.Position =  yyAttrStackPtr [1-1].primary.Position;

		;

} break;
case 1149:
case 684: /* factor : unary_operator primary .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 257; {
/* line 1430 "Parser.lalr" */

		  yySynAttribute.factor.Tree = unary_node(yyAttrStackPtr [1-1].unary_operator.Op, yyAttrStackPtr [2-1].primary.Tree, 
                                      & yyErrorCount, yyAttrStackPtr [2-1].primary.Position);

		  yySynAttribute.factor.Position  =  yyAttrStackPtr [2-1].primary.Position;

                ;

} break;
case 1150:
case 670: /* primary : name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 259; {
/* line 1438 "Parser.lalr" */

		  yySynAttribute.primary.Tree  =  yyAttrStackPtr [1-1].name.Tree ;

		  yySynAttribute.primary.Position  =  yyAttrStackPtr [1-1].name.Position ;

		;

} break;
case 1151: /* primary : abstract_literal .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 259; {
/* line 1445 "Parser.lalr" */

			  yySynAttribute.primary.Tree  =  yyAttrStackPtr [1-1].abstract_literal.Tree;

			  yySynAttribute.primary.Position  =  yyAttrStackPtr [1-1].abstract_literal.Position;

			;

} break;
case 1152:
case 672: /* primary : physical_literal .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 259; {
/* line 1452 "Parser.lalr" */

			  yySynAttribute.primary.Tree = 0 ;

			  yySynAttribute.primary.Position = NoPosition;

			;

} break;
case 1153:
case 513: /* primary : character_literal .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 259; {
/* line 1459 "Parser.lalr" */

			  yySynAttribute.primary.Tree = character_literal_node(yyAttrStackPtr [1-1].Scan.character_literal.Val, 
                                      & yyErrorCount, yyAttrStackPtr [1-1].Scan.Position) ;

			  yySynAttribute.primary.Position  =  yyAttrStackPtr [1-1].Scan.Position;

			;

} break;
case 1154:
case 514: /* primary : string_literal .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 259; {
/* line 1467 "Parser.lalr" */

			  yySynAttribute.primary.Tree = 0;

			  yySynAttribute.primary.Position = NoPosition;

			;

} break;
case 1155:
case 515: /* primary : bit_string_literal .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 259; {
/* line 1474 "Parser.lalr" */

			  yySynAttribute.primary.Tree = 0 ;

			  yySynAttribute.primary.Position = NoPosition;

			;

} break;
case 1156:
case 540: /* primary : pure_selected_name "'" '(' expression ')' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 259; {
/* line 1481 "Parser.lalr" */

			  yySynAttribute.primary.Tree = 0 ;

			  yySynAttribute.primary.Position  =  yyAttrStackPtr [1-1].pure_selected_name.Position;

			;

} break;
case 1157:
case 548: /* primary : '(' expression ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 259; {
/* line 1488 "Parser.lalr" */

			  yySynAttribute.primary.Tree  =  yyAttrStackPtr [2-1].expression.Tree ;

			  yySynAttribute.primary.Position  =  yyAttrStackPtr [2-1].expression.Position;

			;

} break;
case 1158:
case 551: /* primary : '(' aggregate ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 259; {
/* line 1495 "Parser.lalr" */

			  yySynAttribute.primary.Tree = 0;

			  yySynAttribute.primary.Position = NoPosition;

			;

} break;
case 1159:
case 541: /* binary_logical_operator : 'NAND' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 250; {
/* line 1502 "Parser.lalr" */
 yySynAttribute.binary_logical_operator.Op = kNand ;
 ;

} break;
case 1160:
case 542: /* binary_logical_operator : 'NOR' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 250; {
/* line 1505 "Parser.lalr" */
 yySynAttribute.binary_logical_operator.Op = kNor ;
 ;

} break;
case 1161:
case 543: /* multiplying_logical_operator : 'AND' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 252; {
/* line 1508 "Parser.lalr" */
 yySynAttribute.multiplying_logical_operator.Op = kAnd ;
 ;

} break;
case 1162:
case 544: /* multiplying_logical_operator : 'OR' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 252; {
/* line 1511 "Parser.lalr" */
 yySynAttribute.multiplying_logical_operator.Op = kOr ;
 ;

} break;
case 1163:
case 545: /* multiplying_logical_operator : 'XOR' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 252; {
/* line 1514 "Parser.lalr" */
 yySynAttribute.multiplying_logical_operator.Op = kXor ;
 ;

} break;
case 1164:
case 546: /* multiplying_logical_operator : 'XNOR' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 252; {
/* line 1517 "Parser.lalr" */
 yySynAttribute.multiplying_logical_operator.Op = kXnor ;
 ;

} break;
case 1165:
case 525: /* relational_operator : '=' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 256; {
/* line 1520 "Parser.lalr" */
 yySynAttribute.relational_operator.Op = kEq ;
 ;

} break;
case 1166:
case 526: /* relational_operator : '/=' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 256; {
/* line 1523 "Parser.lalr" */
 yySynAttribute.relational_operator.Op = kNeq ;
 ;

} break;
case 1167:
case 527: /* relational_operator : '<' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 256; {
/* line 1526 "Parser.lalr" */
 yySynAttribute.relational_operator.Op = kLt ;
 ;

} break;
case 1168:
case 528: /* relational_operator : '<=' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 256; {
/* line 1529 "Parser.lalr" */
 yySynAttribute.relational_operator.Op = kLe ;
 ;

} break;
case 1169:
case 529: /* relational_operator : '>' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 256; {
/* line 1532 "Parser.lalr" */
 yySynAttribute.relational_operator.Op = kGt ;
 ;

} break;
case 1170:
case 530: /* relational_operator : '>=' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 256; {
/* line 1535 "Parser.lalr" */
 yySynAttribute.relational_operator.Op = kGe ;
 ;

} break;
case 1171:
case 522: /* adding_operator : '+' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 255; {
/* line 1538 "Parser.lalr" */
 yySynAttribute.adding_operator.Op = kPlus ;
 ;

} break;
case 1172:
case 523: /* adding_operator : '-' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 255; {
/* line 1541 "Parser.lalr" */
 yySynAttribute.adding_operator.Op = kMinus ;
 ;

} break;
case 1173:
case 524: /* adding_operator : '&' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 255; {
/* line 1544 "Parser.lalr" */
 yySynAttribute.adding_operator.Op = kCatenate ;
 ;

} break;
case 1174:
case 520: /* sign : '+' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 254; {
/* line 1547 "Parser.lalr" */
 yySynAttribute.sign.Op = kPlus ;
 ;

} break;
case 1175:
case 521: /* sign : '-' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 254; {
/* line 1550 "Parser.lalr" */
 yySynAttribute.sign.Op = kMinus ;
 ;

} break;
case 1176:
case 536: /* multiplying_operator : '*' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 258; {
/* line 1553 "Parser.lalr" */
yySynAttribute.multiplying_operator.Op = kTimes ;
 ;

} break;
case 1177:
case 537: /* multiplying_operator : '/' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 258; {
/* line 1556 "Parser.lalr" */
yySynAttribute.multiplying_operator.Op = kDivide ;
 ;

} break;
case 1178:
case 538: /* multiplying_operator : 'MOD' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 258; {
/* line 1559 "Parser.lalr" */
yySynAttribute.multiplying_operator.Op = kMod ;
 ;

} break;
case 1179:
case 539: /* multiplying_operator : 'REM' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 258; {
/* line 1562 "Parser.lalr" */
yySynAttribute.multiplying_operator.Op = kRem ;
 ;

} break;
case 1180:
case 518: /* unary_operator : 'ABS' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
/* line 1565 "Parser.lalr" */
yySynAttribute.unary_operator.Op = kAbs ;
 ;

} break;
case 1181:
case 519: /* unary_operator : 'NOT' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 260; {
/* line 1568 "Parser.lalr" */
yySynAttribute.unary_operator.Op = kNot ;
 ;

} break;
case 1182: /* aggregate : choices '=>' expression .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 261; {

} break;
case 1183:
case 699: /* aggregate : association_element_l2 .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 261; {

} break;
case 1184: /* association_element_l2 : association_element ',' association_list .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 262; {

} break;
case 1185: /* sequential_statements : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 169; {
/* line 1574 "Parser.lalr" */

		   yySynAttribute.sequential_statements.Tree = 0 ;

		;

} break;
case 1186:
case 751: /* sequential_statements : sequential_statements sequential_statement .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 169; {
/* line 1579 "Parser.lalr" */
  
		   yySynAttribute.sequential_statements.Tree = append(yyAttrStackPtr [2-1].sequential_statement.Tree,
		                     yyAttrStackPtr [1-1].sequential_statements.Tree) ;

		;

} break;
case 1187:
case 749: /* sequential_statement : name_sequential_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 263; {
/* line 1585 "Parser.lalr" */

		   yySynAttribute.sequential_statement.Tree  =  yyAttrStackPtr [1-1].name_sequential_statement.Tree ;

		;

} break;
case 1188:
case 750: /* sequential_statement : no_name_sequential_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 263; {
/* line 1590 "Parser.lalr" */

		   yySynAttribute.sequential_statement.Tree  =  yyAttrStackPtr [1-1].no_name_sequential_statement.Tree ;

		;

} break;
case 1189:
case 748: /* name_sequential_statement : name ':' sequential_statement .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 264; {
/* line 1595 "Parser.lalr" */
 
		  yySynAttribute.name_sequential_statement.Tree = label_set(yyAttrStackPtr [3-1].sequential_statement.Tree,
				    qName(yyAttrStackPtr [1-1].name.Tree),
                                    yyAttrStackPtr [1-1].name.Position.Line) ;

                ;

} break;
case 1190:
case 616: /* name_sequential_statement : name '<=' opt_delay_mechanism waveform ';' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 264; {
/* line 1602 "Parser.lalr" */

		   yySynAttribute.name_sequential_statement.Tree = sig_asg_statement(yyAttrStackPtr [1-1].name.Tree, yyAttrStackPtr [4-1].waveform.Tree, 
                                             & yyErrorCount, yyAttrStackPtr [1-1].name.Position) ;

                ;

} break;
case 1191:
case 618: /* name_sequential_statement : name ':=' expression ';' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 264; {
/* line 1608 "Parser.lalr" */

		   yySynAttribute.name_sequential_statement.Tree = var_asg_statement(yyAttrStackPtr [1-1].name.Tree, yyAttrStackPtr [3-1].expression.Tree, 
                                             & yyErrorCount, yyAttrStackPtr [1-1].name.Position) ;

                ;

} break;
case 1192:
case 613: /* name_sequential_statement : name ';' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 264; {
/* line 1617 "Parser.lalr" */
yySynAttribute.name_sequential_statement.Tree = yyAttrStackPtr [1-1].name.Tree;
 
		   ;
{  production_not_implemented("procedure_call", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
                ;

} break;
case 1193: /* opt_delay_mechanism : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 266; {

} break;
case 1194:
case 615: /* opt_delay_mechanism : 'TRANSPORT' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 266; {
/* line 1626 "Parser.lalr" */

		   ;
{ 
                      production_not_implemented("transport delay mechanism", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;
                    }
		;

} break;
case 1195:
case 617: /* opt_delay_mechanism : opt_reject 'INERTIAL' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 266; {
/* line 1635 "Parser.lalr" */

		   ;
{ 
                      production_not_implemented("inertial delay mechanism", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;
                    }
		;

} break;
case 1196: /* opt_reject : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 268; {

} break;
case 1197:
case 752: /* opt_reject : 'REJECT' expression .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 268; {
/* line 1645 "Parser.lalr" */

		   ;
{ 
                      production_not_implemented("reject mode", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;
                    }
		;

} break;
case 1198:
case 606: /* no_name_sequential_statement : 'WAIT' opt_sensitivity_clause opt_condition_clause opt_timeout_clause ';' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 265; {
/* line 1651 "Parser.lalr" */
	
		   yySynAttribute.no_name_sequential_statement.Tree = 
                      wait_statement(yyAttrStackPtr [2-1].opt_sensitivity_clause.Tree,
                                     yyAttrStackPtr [3-1].opt_condition_clause.Tree,
                                     & yyErrorCount, yyAttrStackPtr [1-1].Scan.Position) ;

                ;

} break;
case 1199:
case 607: /* no_name_sequential_statement : 'ASSERT' condition opt_report opt_severity ';' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 265; {
/* line 1661 "Parser.lalr" */
 
		   ;
{  production_not_implemented("assertion_statement", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
		   yySynAttribute.no_name_sequential_statement.Tree = 0 ;

		;

} break;
case 1200:
case 608: /* no_name_sequential_statement : 'REPORT' expression opt_severity ';' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 265; {
/* line 1670 "Parser.lalr" */

		   ;
{  production_not_implemented("report_statement", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
		   yySynAttribute.no_name_sequential_statement.Tree = 0 ;

		;

} break;
case 1201:
case 620: /* no_name_sequential_statement : 'IF' then_part elsif_parts else_part 'END' 'IF' opt_label ';' .*/
  yyStateStackPtr -=8; yyAttrStackPtr -=8; yyNonterminal = 265; {
/* line 1677 "Parser.lalr" */

                   yySynAttribute.no_name_sequential_statement.Tree = 
                      if_statement(yyAttrStackPtr [2-1].then_part.Tree, yyAttrStackPtr [3-1].elsif_parts.Tree,
                                   yyAttrStackPtr [4-1].else_part.Tree, 
                                   & yyErrorCount, yyAttrStackPtr [1-1].Scan.Position) ;

                ;

} break;
case 1202:
case 619: /* no_name_sequential_statement : 'CASE' expression 'IS' case_alternatives 'END' 'CASE' opt_label ';' .*/
  yyStateStackPtr -=8; yyAttrStackPtr -=8; yyNonterminal = 265; {
/* line 1685 "Parser.lalr" */

		   yySynAttribute.no_name_sequential_statement.Tree = case_statement(yyAttrStackPtr [2-1].expression.Tree, yyAttrStackPtr [4-1].case_alternatives.Tree,
                                          & yyErrorCount, yyAttrStackPtr [1-1].Scan.Position);

		;

} break;
case 1203:
case 614: /* no_name_sequential_statement : iteration_scheme 'LOOP' sequential_statements 'END' 'LOOP' opt_label ';' .*/
  yyStateStackPtr -=7; yyAttrStackPtr -=7; yyNonterminal = 265; {
/* line 1691 "Parser.lalr" */

		   yySynAttribute.no_name_sequential_statement.Tree = loop_statement(yyAttrStackPtr [1-1].iteration_scheme.Tree,
					  yyAttrStackPtr [3-1].sequential_statements.Tree,
                                          & yyErrorCount,
					  yyAttrStackPtr [1-1].Scan.Position);

		;

} break;
case 1204:
case 610: /* no_name_sequential_statement : 'NEXT' opt_label when_part ';' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 265; {
/* line 1701 "Parser.lalr" */

		   ;
{  production_not_implemented("next_statement", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
		   yySynAttribute.no_name_sequential_statement.Tree = 0 ;

		;

} break;
case 1205:
case 611: /* no_name_sequential_statement : 'EXIT' opt_label when_part ';' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 265; {
/* line 1710 "Parser.lalr" */

		   ;
{  production_not_implemented("exit_statement", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
		   yySynAttribute.no_name_sequential_statement.Tree = 0 ;

		;

} break;
case 1206:
case 602: /* no_name_sequential_statement : 'RETURN' opt_expression ';' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 265; {
/* line 1719 "Parser.lalr" */

		   ;
{  production_not_implemented("return_statement", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
		   yySynAttribute.no_name_sequential_statement.Tree = 0 ;

		;

} break;
case 1207:
case 612: /* no_name_sequential_statement : 'NULL' ';' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 265; {
/* line 1726 "Parser.lalr" */

		   yySynAttribute.no_name_sequential_statement.Tree =  null_statement(& yyErrorCount, yyAttrStackPtr [1-1].Scan.Position);

		;

} break;
case 1208:
case 596: /* assertion_statement : 'ASSERT' condition opt_report opt_severity ';' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 283; {
/* line 1733 "Parser.lalr" */
 
		   ;
{  production_not_implemented("assertion_statement", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
		   yySynAttribute.no_name_sequential_statement.Tree = 0 ;

		;

} break;
case 1209: /* opt_sensitivity_clause : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 269; {
/* line 1740 "Parser.lalr" */

		   yySynAttribute.opt_sensitivity_clause.Tree = 0 ;

		;

} break;
case 1210: /* opt_sensitivity_clause : 'ON' sensitivity_list .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 269; {
/* line 1745 "Parser.lalr" */

		   yySynAttribute.opt_sensitivity_clause.Tree  =  yyAttrStackPtr [2-1].sensitivity_list.Tree ;

                ;

} break;
case 1211:
case 730: /* sensitivity_list : name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 284; {
/* line 1750 "Parser.lalr" */

                   yySynAttribute.sensitivity_list.Tree = mList(0, 0, 0, yyAttrStackPtr [1-1].name.Tree) ;

                ;

} break;
case 1212:
case 731: /* sensitivity_list : sensitivity_list ',' name .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 284; {
/* line 1755 "Parser.lalr" */

                   yySynAttribute.sensitivity_list.Tree = append(mList(0, 0, 0, yyAttrStackPtr [3-1].name.Tree),
                                  yyAttrStackPtr [1-1].sensitivity_list.Tree);

                ;

} break;
case 1213: /* opt_condition_clause : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 270; {
/* line 1761 "Parser.lalr" */

		   yySynAttribute.opt_condition_clause.Tree = 0 ;

		;

} break;
case 1214:
case 741: /* opt_condition_clause : 'UNTIL' condition .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 270; {
/* line 1766 "Parser.lalr" */

		   yySynAttribute.opt_condition_clause.Tree  =  yyAttrStackPtr [2-1].condition.Tree ;

                ;

} break;
case 1215:
case 727: /* condition : expression .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 272; {
/* line 1771 "Parser.lalr" */

   ;
{ 
     is_condition(yyAttrStackPtr [1-1].expression.Tree) ;
    }
   yySynAttribute.condition.Tree  =  yyAttrStackPtr [1-1].expression.Tree ;

;

} break;
case 1216: /* opt_timeout_clause : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 271; {

} break;
case 1217:
case 742: /* opt_timeout_clause : 'FOR' expression .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 271; {
/* line 1783 "Parser.lalr" */
 
		   ;
{  production_not_implemented("opt_timeout_clause2", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
		;

} break;
case 1218: /* opt_report : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 273; {

} break;
case 1219:
case 728: /* opt_report : 'REPORT' expression .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 273; {

} break;
case 1220: /* opt_severity : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 274; {

} break;
case 1221:
case 729: /* opt_severity : 'SEVERITY' expression .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 274; {

} break;
case 1222:
case 755: /* waveform : waveform_element .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 267; {
/* line 1792 "Parser.lalr" */

		   yySynAttribute.waveform.Tree = waveform(yyAttrStackPtr [1-1].waveform_element.Tree) ;

		;

} break;
case 1223:
case 754: /* waveform : waveform ',' waveform_element .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 267; {
/* line 1799 "Parser.lalr" */

		   ;
{  production_not_implemented("multiple transaction waveform", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
		   yySynAttribute.waveform.Tree  =  yyAttrStackPtr [1-1].waveform.Tree ;

		;

} break;
case 1224: /* waveform_element : expression xx201 .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 285; {
/* line 1806 "Parser.lalr" */
 yySynAttribute.waveform_element = yyAttrStackPtr [2-1].waveform_element;

		   yySynAttribute.waveform_element.Tree = transaction(yyAttrStackPtr [1-1].expression.Tree, 0) ;

		;

} break;
case 1225: /* xx201 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 286; {
/* line 1812 "Parser.lalr" */

	   yySynAttribute.waveform_element.Tree  =  yyAttrStackPtr [0-1].expression.Tree ;

	;

} break;
case 1226:
case 753: /* waveform_element : expression xx201 'AFTER' expression .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 285; {
/* line 1821 "Parser.lalr" */
 yySynAttribute.waveform_element = yyAttrStackPtr [2-1].waveform_element;

		   ;
{  
                      production_not_implemented("after clauses", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;
                    }
		   yySynAttribute.waveform_element.Tree = transaction(yyAttrStackPtr [1-1].expression.Tree, 0) ;

		;

} break;
case 1227: /* then_part : condition 'THEN' sequential_statements .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 275; {
/* line 1829 "Parser.lalr" */

	   yySynAttribute.then_part.Tree = branch(yyAttrStackPtr [1-1].condition.Tree, yyAttrStackPtr [3-1].sequential_statements.Tree) ;

	;

} break;
case 1228: /* elsif_parts : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 276; {
/* line 1834 "Parser.lalr" */

		   yySynAttribute.elsif_parts.Tree = 0 ;

		;

} break;
case 1229: /* elsif_parts : elsif_parts 'ELSIF' condition 'THEN' sequential_statements .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 276; {
/* line 1839 "Parser.lalr" */

	   	   yySynAttribute.elsif_parts.Tree = append(branch(yyAttrStackPtr [3-1].condition.Tree,
                                           yyAttrStackPtr [5-1].sequential_statements.Tree),
                                    yyAttrStackPtr [1-1].elsif_parts.Tree) ;

		;

} break;
case 1230: /* else_part : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 277; {
/* line 1846 "Parser.lalr" */

		   yySynAttribute.else_part.Tree = 0 ;

		;

} break;
case 1231: /* else_part : 'ELSE' sequential_statements .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 277; {
/* line 1851 "Parser.lalr" */

	   	   yySynAttribute.else_part.Tree = branch(0, yyAttrStackPtr [2-1].sequential_statements.Tree) ;

		;

} break;
case 1232:
case 757: /* case_alternatives : case_alternative .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 279; {
/* line 1856 "Parser.lalr" */

			yySynAttribute.case_alternatives.Tree  =  yyAttrStackPtr [1-1].case_alternative.Tree;

		;

} break;
case 1233:
case 756: /* case_alternatives : case_alternatives case_alternative .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 279; {
/* line 1861 "Parser.lalr" */

			yySynAttribute.case_alternatives.Tree = append(yyAttrStackPtr [2-1].case_alternative.Tree, yyAttrStackPtr [1-1].case_alternatives.Tree);

		;

} break;
case 1234: /* case_alternative : 'WHEN' choices '=>' sequential_statements .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 287; {
/* line 1866 "Parser.lalr" */

		yySynAttribute.case_alternative.Tree = case_alternative(yyAttrStackPtr [2-1].choices.Tree, 
                                         yyAttrStackPtr [4-1].sequential_statements.Tree);

	;

} break;
case 1235:
case 516: /* choices : 'OTHERS' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 223; {
/* line 1872 "Parser.lalr" */

			yySynAttribute.choices.Tree = 0;

		;

} break;
case 1236: /* choices : choice .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 223; {
/* line 1877 "Parser.lalr" */

				yySynAttribute.choices.Tree= mList(0, 0, 0, yyAttrStackPtr [1-1].choice.Tree);

			;

} break;
case 1237: /* choices : list_choices choice_separator choice .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 223; {
/* line 1882 "Parser.lalr" */

				yySynAttribute.choices.Tree=append(mList(0, 0, 0, yyAttrStackPtr [3-1].choice.Tree),
                                                   yyAttrStackPtr [1-1].choices.Tree);

			;

} break;
case 1238: /* list_choices : choice .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 289; {
/* line 1888 "Parser.lalr" */

				yySynAttribute.choices.Tree= mList(0, 0, 0, yyAttrStackPtr [1-1].choice.Tree);

			;

} break;
case 1239: /* list_choices : list_choices choice_separator choice .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 289; {
/* line 1893 "Parser.lalr" */

				yySynAttribute.choices.Tree=append(mList(0, 0, 0, yyAttrStackPtr [3-1].choice.Tree),
                                                   yyAttrStackPtr [1-1].choices.Tree);

			;

} break;
case 1240: /* choice : simple_expression .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 288; {
/* line 1899 "Parser.lalr" */

			yySynAttribute.choice.Tree = yyAttrStackPtr [1-1].relation.Tree;

		;

} break;
case 1241:
case 517: /* choice : discrete_range_no_name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 288; {
/* line 1907 "Parser.lalr" */

			;
{ 
			   production_not_implemented("discrete_range", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position);
			 }
			yySynAttribute.choice.Tree=0;

		;

} break;
case 1242:
case 549: /* choice_separator : '|' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 290; {

} break;
case 1243:
case 550: /* choice_separator : '!' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 290; {

} break;
case 1244:
case 745: /* iteration_scheme : 'WHILE' condition .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 280; {
/* line 1917 "Parser.lalr" */

			yySynAttribute.iteration_scheme.Tree = while_statement(yyAttrStackPtr [2-1].condition.Tree,
                                                & yyErrorCount,
						yyAttrStackPtr [1-1].Scan.Position);

		;

} break;
case 1245:
case 744: /* iteration_scheme : 'FOR' parameter_specification .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 280; {
/* line 1924 "Parser.lalr" */

			yySynAttribute.iteration_scheme.Tree  =  yyAttrStackPtr [2-1].parameter_specification.Tree;

		;

} break;
case 1246:
case 743: /* parameter_specification : simple_name 'IN' discrete_range .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 291; {
/* line 1929 "Parser.lalr" */

		yySynAttribute.parameter_specification.Tree = for_statement(yyAttrStackPtr [1-1].simple_name.Tree, yyAttrStackPtr [3-1].discrete_range.Tree,
                                      & yyErrorCount, yyAttrStackPtr [1-1].Scan.Position);

	;

} break;
case 1247: /* when_part : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 281; {

} break;
case 1248:
case 747: /* when_part : 'WHEN' condition .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 281; {

} break;
case 1249: /* opt_expression : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 282; {

} break;
case 1250:
case 739: /* opt_expression : expression .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 282; {

} break;
case 1251: /* opt_label : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 278; {

} break;
case 1252:
case 746: /* opt_label : label .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 278; {

} break;
case 1253: /* concurrent_statements : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 143; {
/* line 1941 "Parser.lalr" */

		   yySynAttribute.concurrent_statements.Tree = 0;
 
		;

} break;
case 1254:
case 812: /* concurrent_statements : concurrent_statements concurrent_statement .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 143; {
/* line 1946 "Parser.lalr" */
  
		   yySynAttribute.concurrent_statements.Tree = append(yyAttrStackPtr [2-1].concurrent_statement.Tree, yyAttrStackPtr [1-1].concurrent_statements.Tree) ;

		;

} break;
case 1255:
case 818: /* concurrent_statement : name name_concurrent_statement .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 292; {
/* line 1951 "Parser.lalr" */

		   yySynAttribute.concurrent_statement.Tree = 
                   name_conc_statement(yyAttrStackPtr [2-1].name_concurrent_statement.Tree, 
				       yyAttrStackPtr [1-1].name.Tree,
                                       & yyErrorCount, yyAttrStackPtr [1-1].name.Position) ;

		;

} break;
case 1256:
case 813: /* concurrent_statement : labeled_opt_concurrent_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 292; {
/* line 1959 "Parser.lalr" */

		   yySynAttribute.concurrent_statement.Tree  =  yyAttrStackPtr [1-1].labeled_opt_concurrent_statement.Tree ;

		;

} break;
case 1257:
case 816: /* name_concurrent_statement : ':' xx224 labeled_concurrent_statement .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 293; {
/* line 1964 "Parser.lalr" */
 yySynAttribute.name_concurrent_statement = yyAttrStackPtr [2-1].name_concurrent_statement;

		   yySynAttribute.name_concurrent_statement.Tree  =  yyAttrStackPtr [3-1].labeled_concurrent_statement.Tree ;

		;

} break;
case 1258: /* xx224 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 295; {
/* line 1970 "Parser.lalr" */

		   ;
{ 
                      name_is_label() ;
                    }
		;

} break;
case 1259:
case 653: /* name_concurrent_statement : '<=' xx226 options conditional_waveform xx227 ';' .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 293; {

} break;
case 1260: /* xx226 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 297; {
/* line 1978 "Parser.lalr" */

		   ;
{ 
                      name_is_target() ;
                    }
		;

} break;
case 1261: /* xx227 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 300; {
/* line 1985 "Parser.lalr" */
 yySynAttribute.name_concurrent_statement = yyAttrStackPtr [-2-1].name_concurrent_statement;

		   yySynAttribute.name_concurrent_statement.Tree  =  yyAttrStackPtr [0-1].conditional_waveform.Tree ;

		;

} break;
case 1262:
case 639: /* name_concurrent_statement : ';' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 293; {
/* line 1994 "Parser.lalr" */

		   ;
{ 
                      production_not_implemented("concurrent procedure call", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;
                    }
		   yySynAttribute.name_concurrent_statement.Tree = 0 ;

		;

} break;
case 1263:
case 805: /* options : opt_guarded opt_delay_mechanism .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 298; {

} break;
case 1264: /* opt_guarded : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 301; {

} break;
case 1265:
case 637: /* opt_guarded : 'GUARDED' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 301; {
/* line 2007 "Parser.lalr" */

		   ;
{ 
                      production_not_implemented("guarded signal assignments", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;
                    }
		;

} break;
case 1266:
case 815: /* labeled_concurrent_statement : labeled_opt_concurrent_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 296; {
/* line 2013 "Parser.lalr" */

  yySynAttribute.labeled_concurrent_statement.Tree  =  yyAttrStackPtr [1-1].labeled_opt_concurrent_statement.Tree;

;

} break;
case 1267:
case 817: /* labeled_concurrent_statement : labeled_req_concurrent_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 296; {
/* line 2018 "Parser.lalr" */

  yySynAttribute.labeled_concurrent_statement.Tree  =  yyAttrStackPtr [1-1].labeled_req_concurrent_statement.Tree;

;

} break;
case 1268:
case 636: /* labeled_opt_concurrent_statement : 'PROCESS' opt_sensitivity_list opt_is process_declarative_part xx232 'BEGIN' sequential_statements 'END' 'PROCESS' opt_identifier ';' .*/
  yyStateStackPtr -=11; yyAttrStackPtr -=11; yyNonterminal = 294; {
/* line 2023 "Parser.lalr" */
 yySynAttribute.labeled_opt_concurrent_statement = yyAttrStackPtr [5-1].labeled_opt_concurrent_statement;

		   ;
{ 
		      remove_declarative_part() ;
                    }
		   yySynAttribute.labeled_opt_concurrent_statement.Tree = process_statement(yyAttrStackPtr [2-1].opt_sensitivity_list.Tree,
				             yyAttrStackPtr [4-1].process_declarative_part.Tree,
		                             yyAttrStackPtr [7-1].sequential_statements.Tree,
                                             & yyErrorCount,
                                             yyAttrStackPtr [1-1].Scan.Position) ;

		;

} break;
case 1269: /* xx232 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 305; {
/* line 2037 "Parser.lalr" */

		   ;
{  
                      add_declarative_part(yyAttrStackPtr [0-1].process_declarative_part.Tree) ;
                    }
                ;

} break;
case 1270:
case 811: /* labeled_opt_concurrent_statement : assertion_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 294; {
/* line 2046 "Parser.lalr" */

		   ;
{  production_not_implemented("concurrent_assertion_statement", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
		   yySynAttribute.labeled_opt_concurrent_statement.Tree = 0 ;

		;

} break;
case 1271:
case 638: /* labeled_opt_concurrent_statement : 'WITH' expression 'SELECT' name '<=' options selected_waveforms ';' .*/
  yyStateStackPtr -=8; yyAttrStackPtr -=8; yyNonterminal = 294; {
/* line 2053 "Parser.lalr" */

		   yySynAttribute.labeled_opt_concurrent_statement.Tree=sel_sig_asg_statement(yyAttrStackPtr [2-1].expression.Tree, yyAttrStackPtr [4-1].name.Tree, 
                                               yyAttrStackPtr [7-1].selected_waveforms.Tree, 
                                               & yyErrorCount,
                                               yyAttrStackPtr [1-1].Scan.Position) ;

		;

} break;
case 1272:
case 621: /* process_statement : 'PROCESS' opt_sensitivity_list opt_is process_declarative_part xx232 'BEGIN' sequential_statements 'END' 'PROCESS' opt_identifier ';' .*/
  yyStateStackPtr -=11; yyAttrStackPtr -=11; yyNonterminal = 138; {
/* line 2061 "Parser.lalr" */
 yySynAttribute.labeled_opt_concurrent_statement = yyAttrStackPtr [5-1].labeled_opt_concurrent_statement;

		   ;
{ 
		      remove_declarative_part() ;
                    }
		   yySynAttribute.labeled_opt_concurrent_statement.Tree = process_statement(yyAttrStackPtr [2-1].opt_sensitivity_list.Tree,
				             yyAttrStackPtr [4-1].process_declarative_part.Tree,
		                             yyAttrStackPtr [7-1].sequential_statements.Tree,
                                             & yyErrorCount,
                                             yyAttrStackPtr [1-1].Scan.Position) ;

		;

} break;
case 1273:
case 774: /* concurrent_assertion_statement : assertion_statement .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 137; {
/* line 2077 "Parser.lalr" */

		   ;
{  production_not_implemented("concurrent_assertion_statement", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
		   yySynAttribute.labeled_opt_concurrent_statement.Tree = 0 ;

		;

} break;
case 1274:
case 646: /* labeled_req_concurrent_statement : 'BLOCK' opt_guard opt_block_header block_declarative_part xx236 'BEGIN' concurrent_statements 'END' 'BLOCK' opt_identifier ';' .*/
  yyStateStackPtr -=11; yyAttrStackPtr -=11; yyNonterminal = 302; {
/* line 2084 "Parser.lalr" */
 yySynAttribute.labeled_req_concurrent_statement = yyAttrStackPtr [5-1].labeled_req_concurrent_statement;

		   ;
{ 
                      remove_declarative_part() ;
                    }
		   yySynAttribute.labeled_req_concurrent_statement.Tree = block_statement(yyAttrStackPtr [4-1].block_declarative_part.Tree,
		                           yyAttrStackPtr [7-1].concurrent_statements.Tree,
                                           & yyErrorCount, 
                                           yyAttrStackPtr [1-1].Scan.Position) ;

		;

} break;
case 1275: /* xx236 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 309; {
/* line 2097 "Parser.lalr" */

		   ;
{ 
                      add_declarative_part(yyAttrStackPtr [0-1].block_declarative_part.Tree) ;
                    }
                ;

} break;
case 1276:
case 650: /* labeled_req_concurrent_statement : name opt_generic_map_aspect opt_port_map_aspect ';' .*/
  yyStateStackPtr -=4; yyAttrStackPtr -=4; yyNonterminal = 302; {
/* line 2106 "Parser.lalr" */

		   		   ;
{  production_not_implemented("component_instantiation_statement1", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
				   yySynAttribute.labeled_req_concurrent_statement.Tree = 0 ;

				;

} break;
case 1277:
case 643: /* labeled_req_concurrent_statement : 'COMPONENT' identifier opt_generic_map_aspect opt_port_map_aspect ';' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 302; {
/* line 2115 "Parser.lalr" */

		   		   ;
{  production_not_implemented("component_instantiation_statement2", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
				   yySynAttribute.labeled_req_concurrent_statement.Tree = 0 ;

				;

} break;
case 1278:
case 641: /* labeled_req_concurrent_statement : 'ENTITY' identifier opt_parenthesis_name opt_generic_map_aspect opt_port_map_aspect ';' .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 302; {
/* line 2124 "Parser.lalr" */

		   		   ;
{  production_not_implemented("component_instantiation_statement3", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
				   yySynAttribute.labeled_req_concurrent_statement.Tree = 0 ;

				;

} break;
case 1279:
case 642: /* labeled_req_concurrent_statement : 'CONFIGURATION' identifier opt_generic_map_aspect opt_port_map_aspect ';' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 302; {
/* line 2133 "Parser.lalr" */

		   		   ;
{  production_not_implemented("component_instantiation_statement4", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
				   yySynAttribute.labeled_req_concurrent_statement.Tree = 0 ;

				;

} break;
case 1280:
case 652: /* labeled_req_concurrent_statement : generate_scheme 'GENERATE' opt_generate_declaration concurrent_statements 'END' 'GENERATE' opt_identifier ';' .*/
  yyStateStackPtr -=8; yyAttrStackPtr -=8; yyNonterminal = 302; {
/* line 2142 "Parser.lalr" */

	   		   ;
{  production_not_implemented("generate_statement", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
			   yySynAttribute.labeled_req_concurrent_statement.Tree = 0 ;

			;

} break;
case 1281:
case 648: /* labeled_req_concurrent_statement : name '<=' options conditional_waveform xx243 ';' .*/
  yyStateStackPtr -=6; yyAttrStackPtr -=6; yyNonterminal = 302; {

} break;
case 1282: /* xx243 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 313; {
/* line 2150 "Parser.lalr" */

			  yySynAttribute.labeled_req_concurrent_statement.Tree = conc_sig_asg_statement(yyAttrStackPtr [-3-1].name.Tree,
						         yyAttrStackPtr [0-1].conditional_waveform.Tree,
                                                         & yyErrorCount, 
						         yyAttrStackPtr [-3-1].name.Position) ;

			;

} break;
case 1283:
case 806: /* generate_scheme : 'FOR' parameter_specification .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 311; {

} break;
case 1284:
case 807: /* generate_scheme : 'IF' condition .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 311; {

} break;
case 1285: /* opt_generate_declaration : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 312; {

} break;
case 1286:
case 651: /* opt_generate_declaration : block_declarative_part 'BEGIN' .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 312; {

} break;
case 1287: /* opt_guard : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 307; {

} break;
case 1288:
case 644: /* opt_guard : '(' condition ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 307; {

} break;
case 1289:
case 814: /* opt_block_header : opt_generic_header opt_port_header .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 308; {

} break;
case 1290: /* opt_generic_header : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 314; {

} break;
case 1291:
case 645: /* opt_generic_header : generic_clause opt_generic_map_aspect ';' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 314; {

} break;
case 1292: /* opt_port_header : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 315; {

} break;
case 1293:
case 647: /* opt_port_header : port_clause opt_port_map_aspect ';' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 315; {

} break;
case 1294: /* opt_sensitivity_list : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 303; {
/* line 2169 "Parser.lalr" */

		   yySynAttribute.opt_sensitivity_list.Tree = 0 ;

		;

} break;
case 1295:
case 598: /* opt_sensitivity_list : '(' sensitivity_list ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 303; {
/* line 2174 "Parser.lalr" */

		   ;
{  
			set_has_sensitivity_list();
		    }
		   yySynAttribute.opt_sensitivity_list.Tree  =  yyAttrStackPtr [2-1].sensitivity_list.Tree;

		;

} break;
case 1296: /* process_declarative_part : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 304; {
/* line 2183 "Parser.lalr" */

		   ;
{  
		      begin_declarative_part();
		    }
		   yySynAttribute.process_declarative_part.Tree = 0 ;

		;

} break;
case 1297:
case 770: /* process_declarative_part : process_declarative_part process_declarative_item .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 304; {
/* line 2192 "Parser.lalr" */
  
		   yySynAttribute.process_declarative_part.Tree = add_declarative_item(yyAttrStackPtr [2-1].process_declarative_item.Tree, & yyErrorCount,
                                                yyAttrStackPtr [2-1].Scan.Position);

		;

} break;
case 1298:
case 732: /* process_declarative_item : subprogram_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 316; {
/* line 2200 "Parser.lalr" */

		   ;
{  production_not_implemented("subprogram_declaration", 
					           & yyErrorCount, 
					           yySynAttribute.Scan.Position) ;  }
		   yySynAttribute.process_declarative_item.Tree = 0 ;

		;

} break;
case 1299:
case 733: /* process_declarative_item : subprogram_body .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 316; {
/* line 2209 "Parser.lalr" */

		   ;
{  production_not_implemented("subprogram_body", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
		   yySynAttribute.process_declarative_item.Tree = 0 ;

		;

} break;
case 1300:
case 734: /* process_declarative_item : type_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 316; {
/* line 2216 "Parser.lalr" */

		   yySynAttribute.process_declarative_item.Tree  =  yyAttrStackPtr [1-1].type_declaration.Tree;

		;

} break;
case 1301:
case 735: /* process_declarative_item : constant_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 316; {
/* line 2221 "Parser.lalr" */

		   yySynAttribute.process_declarative_item.Tree  =  yyAttrStackPtr [1-1].constant_declaration.Tree ;

		;

} break;
case 1302:
case 769: /* process_declarative_item : variable_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 316; {
/* line 2226 "Parser.lalr" */

		   yySynAttribute.process_declarative_item.Tree  =  yyAttrStackPtr [1-1].variable_declaration.Tree ;

		;

} break;
case 1303:
case 736: /* process_declarative_item : attribute_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 316; {
/* line 2233 "Parser.lalr" */

		   ;
{  production_not_implemented("attribute_declaration", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
		   yySynAttribute.process_declarative_item.Tree = 0 ;

		;

} break;
case 1304:
case 737: /* process_declarative_item : attribute_specification .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 316; {
/* line 2242 "Parser.lalr" */

		   ;
{  production_not_implemented("attribute_specification", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
		   yySynAttribute.process_declarative_item.Tree = 0 ;

		;

} break;
case 1305:
case 738: /* process_declarative_item : use_clause .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 316; {
/* line 2249 "Parser.lalr" */

		   yySynAttribute.process_declarative_item.Tree = 0 ;

		;

} break;
case 1306: /* conditional_waveform : conditional_waveform_parts waveform .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 299; {
/* line 2254 "Parser.lalr" */

	   yySynAttribute.conditional_waveform.Tree = conditional_waveform(yyAttrStackPtr [2-1].waveform.Tree, 0,
                                        yyAttrStackPtr [1-1].conditional_waveform_parts.Tree,
                                        & yyErrorCount, yyAttrStackPtr [2-1].Scan.Position) ;

	;

} break;
case 1307: /* conditional_waveform_parts : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 317; {
/* line 2261 "Parser.lalr" */

		   yySynAttribute.conditional_waveform_parts.Tree = 0 ;

		;

} break;
case 1308:
case 649: /* conditional_waveform_parts : conditional_waveform_parts waveform 'WHEN' condition 'ELSE' .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 317; {
/* line 2266 "Parser.lalr" */

		   yySynAttribute.conditional_waveform_parts.Tree = conditional_waveform(yyAttrStackPtr [2-1].waveform.Tree,
                                                yyAttrStackPtr [4-1].condition.Tree,
                                                yyAttrStackPtr [1-1].conditional_waveform_parts.Tree,
                                                & yyErrorCount,
                                                yyAttrStackPtr [2-1].Scan.Position) ;

		;

} break;
case 1309:
case 804: /* selected_waveforms : selected_waveform .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 306; {
/* line 2275 "Parser.lalr" */

			yySynAttribute.selected_waveforms.Tree = yyAttrStackPtr [1-1].selected_waveform.Tree;

		;

} break;
case 1310:
case 803: /* selected_waveforms : selected_waveforms ',' selected_waveform .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 306; {
/* line 2280 "Parser.lalr" */

			yySynAttribute.selected_waveforms.Tree=append(yyAttrStackPtr [3-1].selected_waveform.Tree, yyAttrStackPtr [1-1].selected_waveforms.Tree);

		;

} break;
case 1311:
case 802: /* selected_waveform : waveform 'WHEN' choices .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 318; {
/* line 2285 "Parser.lalr" */

		yySynAttribute.selected_waveform.Tree= selected_waveform(yyAttrStackPtr [1-1].waveform.Tree, yyAttrStackPtr [3-1].choices.Tree);

	;

} break;
case 1312: /* opt_parenthesis_name : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 310; {

} break;
case 1313:
case 640: /* opt_parenthesis_name : '(' identifier ')' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 310; {

} break;
case 1314:
case 609: /* label : identifier .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 235; {

} break;
case 1315:
case 507: /* use_clause : 'USE' use_selected_name_list ';' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 134; {
/* line 2293 "Parser.lalr" */

		  yySynAttribute.use_clause.Tree = mUseClause(0, 0, 0, yyAttrStackPtr [2-1].use_selected_name_list.Tree);

		;

} break;
case 1316:
case 668: /* use_selected_name_list : use_selected_name .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 319; {
/* line 2298 "Parser.lalr" */

		  yySynAttribute.use_selected_name_list.Tree = mList(0, 0, 0, yyAttrStackPtr [1-1].use_selected_name.Tree);

		;

} break;
case 1317:
case 667: /* use_selected_name_list : use_selected_name_list ',' use_selected_name .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 319; {
/* line 2303 "Parser.lalr" */
 
		  yySynAttribute.use_selected_name_list.Tree = append(yyAttrStackPtr [3-1].use_selected_name.Tree, yyAttrStackPtr [1-1].use_selected_name_list.Tree);

		;

} break;
case 1318:
case 666: /* use_selected_name : identifier '.' use_suffix .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 320; {
/* line 2308 "Parser.lalr" */

		  yySynAttribute.use_selected_name.Tree = 0;

		;

} break;
case 1319:
case 665: /* use_selected_name : identifier '.' identifier '.' use_suffix .*/
  yyStateStackPtr -=5; yyAttrStackPtr -=5; yyNonterminal = 320; {
/* line 2313 "Parser.lalr" */

                  yySynAttribute.use_selected_name.Tree = 
                    open_external_reference(yyAttrStackPtr [1-1].Scan.identifier.Id, yyAttrStackPtr [3-1].Scan.identifier.Id,
                                            & yyErrorCount, yyAttrStackPtr [1-1].Scan.Position);

		;

} break;
case 1320:
case 505: /* use_suffix : identifier .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 321; {
/* line 2320 "Parser.lalr" */

		  yySynAttribute.use_suffix.Id  =  yyAttrStackPtr [1-1].Scan.identifier.Id;

		  yySynAttribute.use_suffix.All = 0;

		;

} break;
case 1321:
case 506: /* use_suffix : 'ALL' .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 321; {
/* line 2328 "Parser.lalr" */

		  yySynAttribute.use_suffix.Id = (char *) strdup("");

		  yySynAttribute.use_suffix.All = 1;

		;

} break;
case 1322:
case 856: /* design_file : xx269 design_unit .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 110; {
/* line 2334 "Parser.lalr" */
 yySynAttribute.design_file = yyAttrStackPtr [1-1].design_file;

           ;
{ 
              unit_end(yyAttrStackPtr [2-1].design_unit.Tree, 
                       & yyErrorCount) ;
            }
	   yySynAttribute.design_file.Tree  =  yyAttrStackPtr [2-1].design_unit.Tree ;

	;

} break;
case 1323: /* xx269 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 322; {
/* line 2345 "Parser.lalr" */

	   ;
{ 
              unit_begin(& yyErrorCount) ;
            }
	;

} break;
case 1324:
case 664: /* design_file : design_file xx271 design_unit .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 110; {
/* line 2352 "Parser.lalr" */
 yySynAttribute.design_file = yyAttrStackPtr [2-1].design_file;
yySynAttribute.design_file.Tree = yyAttrStackPtr [3-1].design_unit.Tree;
  
           ;
{ 
              unit_end(yyAttrStackPtr [3-1].design_unit.Tree,
                       & yyErrorCount) ;
            }
	;

} break;
case 1325: /* xx271 : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 324; {
/* line 2362 "Parser.lalr" */

	   ;
{ 
              unit_begin(& yyErrorCount) ;
            }
	;

} break;
case 1326:
case 853: /* design_unit : context_clause library_unit .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 323; {
/* line 2369 "Parser.lalr" */

		   yySynAttribute.design_unit.Tree = add_context_clause(yyAttrStackPtr [2-1].library_unit.Tree, 
                                              yyAttrStackPtr [1-1].context_clause.Tree) ;

		;

} break;
case 1327:
case 847: /* library_unit : entity_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 326; {
/* line 2375 "Parser.lalr" */

		   yySynAttribute.library_unit.Tree  =  yyAttrStackPtr [1-1].entity_declaration.Tree ;

		;

} break;
case 1328:
case 850: /* library_unit : configuration_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 326; {
/* line 2382 "Parser.lalr" */

		   ;
{  production_not_implemented("primary_unit", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
		   yySynAttribute.library_unit.Tree = 0 ;

                ;

} break;
case 1329:
case 851: /* library_unit : package_declaration .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 326; {
/* line 2389 "Parser.lalr" */

		   yySynAttribute.library_unit.Tree  =  yyAttrStackPtr [1-1].package_declaration.Tree ;

                ;

} break;
case 1330:
case 849: /* library_unit : architecture_body .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 326; {
/* line 2394 "Parser.lalr" */

		   yySynAttribute.library_unit.Tree  =  yyAttrStackPtr [1-1].architecture_body.Tree ;

                ;

} break;
case 1331:
case 852: /* library_unit : package_body .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 326; {
/* line 2399 "Parser.lalr" */
  
		   yySynAttribute.library_unit.Tree  =  yyAttrStackPtr [1-1].package_body.Tree ;

                ;

} break;
case 1332:
case 504: /* library_clause : 'LIBRARY' logical_name_list ';' .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 328; {
/* line 2406 "Parser.lalr" */
  
		   ;
{  production_not_implemented("library_clause", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
                ;

} break;
case 1333:
case 502: /* logical_name_list : identifier .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 327; {

} break;
case 1334:
case 503: /* logical_name_list : logical_name_list ',' identifier .*/
  yyStateStackPtr -=3; yyAttrStackPtr -=3; yyNonterminal = 327; {

} break;
case 1335: /* context_clause : .*/
  yyStateStackPtr -=0; yyAttrStackPtr -=0; yyNonterminal = 325; {
/* line 2413 "Parser.lalr" */

		  yySynAttribute.context_clause.Tree = 0;

		;

} break;
case 1336:
case 855: /* context_clause : context_clause context_item .*/
  yyStateStackPtr -=2; yyAttrStackPtr -=2; yyNonterminal = 325; {
/* line 2418 "Parser.lalr" */

		  yySynAttribute.context_clause.Tree = append(yyAttrStackPtr [2-1].context_item.Tree, yyAttrStackPtr [1-1].context_clause.Tree);

		;

} break;
case 1337:
case 854: /* context_item : library_clause .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 329; {
/* line 2425 "Parser.lalr" */
  
		   ;
{  production_not_implemented("context_item", 
					  & yyErrorCount, 
					  yySynAttribute.Scan.Position) ;  }
		  yySynAttribute.context_item.Tree = 0;

                ;

} break;
case 1338:
case 848: /* context_item : use_clause .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 329; {
/* line 2432 "Parser.lalr" */

		  yySynAttribute.context_item.Tree =  yyAttrStackPtr [1-1].use_clause.Tree;

		;

} break;
case 1339:
case 511: /* abstract_literal : decimal_literal .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 205; {
/* line 2437 "Parser.lalr" */

		  yySynAttribute.abstract_literal.Tree = mIntegerValue(0, 0, yyAttrStackPtr [1-1].Scan.decimal_literal.Val);

		  yySynAttribute.abstract_literal.Position  =  yyAttrStackPtr [1-1].Scan.Position;

		;

} break;
case 1340:
case 512: /* abstract_literal : based_literal .*/
  yyStateStackPtr -=1; yyAttrStackPtr -=1; yyNonterminal = 205; {
/* line 2444 "Parser.lalr" */
yySynAttribute.abstract_literal.Position = yyAttrStackPtr [1-1].Scan.Position;
 
		  yySynAttribute.abstract_literal.Tree = 0;

		;

} break;
}

	       /* SPEC State = Next (Top (), Nonterminal); nonterminal transition */
	       yyState = * (yyNBasePtr [* yyStateStackPtr ++] + yyNonterminal);
	       * yyAttrStackPtr ++ = yySynAttribute;
	       if (yyState < yyFirstFinalState) goto ParseLoop; /* read nonterminal reduce ? */
	    } 

	 } else {					/* read */
	    yyStateStackPtr ++;
	    yyGetAttribute (yyAttrStackPtr ++, Attribute);
	    yyTerminal = GetToken ();
	    yyIsRepairing = false;
	 }
      }
   }

static void yyErrorRecovery
# if defined __STDC__ | defined __cplusplus
   (yySymbolRange * yyTerminal, yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr)
# else
   (yyTerminal, yyStateStack, yyStackSize, yyStackPtr)
   yySymbolRange *	yyTerminal	;
   yyStateRange *	yyStateStack	;
   unsigned long	yyStackSize	;
   short		yyStackPtr	;
# endif
   {
      bool	yyTokensSkipped	;
      tSet	yyContinueSet	;
      tSet	yyRestartSet	;
      int	yyLength = 0	;
      char	yyContinueString [256];

   /* 1. report an error */
      ErrorMessage (xxSyntaxError, xxError, Attribute.Position);

   /* 2. report the set of expected terminal symbols */
      MakeSet (& yyContinueSet, (short) yyLastTerminal);
      yyComputeContinuation (yyStateStack, yyStackSize, yyStackPtr, & yyContinueSet);
      yyContinueString [0] = '\0';
      while (! IsEmpty (& yyContinueSet)) {
	 char * yyTokenString = Parser_TokenName [Extract (& yyContinueSet)];
	 if ((yyLength += strlen (yyTokenString) + 1) >= 256) break;
	 (void) strcat (yyContinueString, yyTokenString);
	 (void) strcat (yyContinueString, " ");
      }
      ErrorMessageI (xxExpectedTokens, xxInformation, Attribute.Position,
	 xxString, yyContinueString);
      ReleaseSet (& yyContinueSet);

   /* 3. compute the set of terminal symbols for restart of the parse */
      MakeSet (& yyRestartSet, (short) yyLastTerminal);
      yyComputeRestartPoints (yyStateStack, yyStackSize, yyStackPtr, & yyRestartSet);

   /* 4. skip terminal symbols until a restart point is reached */
      yyTokensSkipped = false;
      while (! IsElement (* yyTerminal, & yyRestartSet)) {
	 * yyTerminal = GetToken ();
	 yyTokensSkipped = true;
      }
      ReleaseSet (& yyRestartSet);

   /* 5. report the restart point */
      if (yyTokensSkipped) {
	 ErrorMessage (xxRestartPoint, xxInformation, Attribute.Position);
      }
   }

/*
   compute the set of terminal symbols that can be accepted (read)
   in a given stack configuration (eventually after reduce actions)
*/

static void yyComputeContinuation
# if defined __STDC__ | defined __cplusplus
   (yyStateRange * yyStack, unsigned long yyStackSize, short yyStackPtr, tSet * yyContinueSet)
# else
   (yyStack, yyStackSize, yyStackPtr, yyContinueSet)
   yyStateRange *	yyStack		;
   unsigned long	yyStackSize	;
   short		yyStackPtr	;
   tSet *		yyContinueSet	;
# endif
   {
      register yySymbolRange	yyTerminal;
      register yyStateRange	yyState = yyStack [yyStackPtr];

      AssignEmpty (yyContinueSet);
      for (yyTerminal = yyFirstTerminal; yyTerminal <= yyLastTerminal; yyTerminal ++) {
	 if (yyNext (yyState, yyTerminal) != yyNoState &&
	    yyIsContinuation (yyTerminal, yyStack, yyStackSize, yyStackPtr)) {
	    Include (yyContinueSet, (short) yyTerminal);
	 }
      }
   }

/*
   check whether a given terminal symbol can be accepted (read)
   in a certain stack configuration (eventually after reduce actions)
*/

static bool yyIsContinuation
# if defined __STDC__ | defined __cplusplus
   (yySymbolRange yyTerminal, yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr)
# else
   (yyTerminal, yyStateStack, yyStackSize, yyStackPtr)
   yySymbolRange	yyTerminal	;
   yyStateRange *	yyStateStack	;
   unsigned long	yyStackSize	;
   short		yyStackPtr	;
# endif
   {
      register yyStateRange	yState		;
      register yySymbolRange	yyNonterminal	;
	       yyStateRange *	yyStack		;
   
      MakeArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));	/* pass Stack by value */
# ifdef BCOPY
      bcopy ((char *) yyStateStack, (char *) yyStack, (int) sizeof (yyStateRange) * (yyStackPtr + 1));
# else
      (void) memcpy ((char *) yyStack, (char *) yyStateStack, (int) sizeof (yyStateRange) * (yyStackPtr + 1));
# endif

      yState = yyStack [yyStackPtr];
      for (;;) {
	 yyStack [yyStackPtr] = yState;
	 yState = yyNext (yState, yyTerminal);
	 if (yState == yyNoState) {
	    ReleaseArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
	    return false;
	 }
	 if (yState <= yyLastReadTermState) {		/* read or read terminal reduce ? */
	    ReleaseArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
	    return true;
	 }

	 for (;;) {					/* reduce */
	    if (yState == yyStopState) {
	       ReleaseArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
	       return true;
	    } else { 
	       yyStackPtr -= yyLength [yState - yyFirstReduceState];
	       yyNonterminal = yyLeftHandSide [yState - yyFirstReduceState];
	    }

	    yState = yyNext (yyStack [yyStackPtr], yyNonterminal);
	    if (yyStackPtr >= yyStackSize) {
	       ExtendArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
	    }
	    yyStackPtr ++;
	    if (yState < yyFirstFinalState) break;	/* read nonterminal ? */
	    yState = yyFinalToProd [yState - yyFirstReadTermState];	/* read nonterminal reduce */
	 }
      }
   }

/*
   compute a set of terminal symbols that can be used to restart
   parsing in a given stack configuration. we simulate parsing until
   end of file using a suffix program synthesized by the function
   Continuation. All symbols acceptable in the states reached during
   the simulation can be used to restart parsing.
*/

static void yyComputeRestartPoints
# if defined __STDC__ | defined __cplusplus
   (yyStateRange * yyStateStack, unsigned long yyStackSize, short yyStackPtr, tSet * yyRestartSet)
# else
   (yyStateStack, yyStackSize, yyStackPtr, yyRestartSet)
   yyStateRange *	yyStateStack	;
   unsigned long	yyStackSize	;
   short		yyStackPtr	;
   tSet *		yyRestartSet	;
# endif
   {
      register yyStateRange	yState		;
      register yySymbolRange	yyNonterminal	;
	       yyStateRange *	yyStack		;
	       tSet		yyContinueSet	;
   
      MakeArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange)); /* pass Stack by value */
# ifdef BCOPY
      bcopy ((char *) yyStateStack, (char *) yyStack, (int) sizeof (yyStateRange) * (yyStackPtr + 1));
# else
      (void) memcpy ((char *) yyStack, (char *) yyStateStack, (int) sizeof (yyStateRange) * (yyStackPtr + 1));
# endif

      MakeSet (& yyContinueSet, (short) yyLastTerminal);
      AssignEmpty (yyRestartSet);
      yState = yyStack [yyStackPtr];

      for (;;) {
	 if (yyStackPtr >= yyStackSize) {
	    ExtendArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
	 }
	 yyStack [yyStackPtr] = yState;
	 yyComputeContinuation (yyStack, yyStackSize, yyStackPtr, & yyContinueSet);
	 Union (yyRestartSet, & yyContinueSet);
	 yState = yyNext (yState, yyContinuation [yState]);

	 if (yState >= yyFirstFinalState) {		/* final state ? */
	    if (yState <= yyLastReadTermState) {	/* read terminal reduce ? */
	       yyStackPtr ++;
	       yState = yyFinalToProd [yState - yyFirstReadTermState];
	    }

	    for (;;) {					/* reduce */
	       if (yState == yyStopState) {
		  ReleaseSet (& yyContinueSet);
		  ReleaseArray ((char * *) & yyStack, & yyStackSize, sizeof (yyStateRange));
		  return;
	       } else { 
		  yyStackPtr -= yyLength [yState - yyFirstReduceState];
		  yyNonterminal = yyLeftHandSide [yState - yyFirstReduceState];
	       }

	       yState = yyNext (yyStack [yyStackPtr], yyNonterminal);
	       yyStackPtr ++;
	       if (yState < yyFirstFinalState) break;	/* read nonterminal ? */
	       yState = yyFinalToProd [yState - yyFirstReadTermState]; /* read nonterminal reduce */
	    }
	 } else {					/* read */
	    yyStackPtr ++;
	 }
      }
   }

/* access the parse table:   Next : State x Symbol -> Action */

static yyStateRange yyNext
# if defined __STDC__ | defined __cplusplus
   (yyStateRange yyState, yySymbolRange yySymbol)
# else
   (yyState, yySymbol) yyStateRange yyState; yySymbolRange yySymbol;
# endif
   {
      register yyTCombType * yyTCombPtr;

      if (yySymbol <= yyLastTerminal) {
	 for (;;) {
	    yyTCombPtr = yyTBasePtr [yyState] + yySymbol;
	    if (yyTCombPtr->Check != yyState) {
	       if ((yyState = yyDefault [yyState]) == yyNoState) return yyNoState;
	    } else {
	       return yyTCombPtr->Next;
	    }
	 }
      } else {
	return * (yyNBasePtr [yyState] + yySymbol);
      }
   }

static void BeginParser ()
   {
/* line 211 "Parser.lalr" */


   }

void CloseParser ()
   {
/* line 214 "Parser.lalr" */


   }
