/**************************** CPPHeaderFile ***************************

* FileName [NFA.h]

* PackageName [sub]

* Synopsis [Header file for NFA class.]

* Description [This class encapsulates a non-deterministic finite
* automaton.]

* SeeAlso [NFA.cpp]

* Author [Nishant Sinha]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __NFA_H__
#define __NFA_H__

#include "FA.h"

namespace magic {

class NFA : public FA
{
public:
  NFA ();
  NFA (char * fname, int fileType);
  void showTransTable ();
  state getState (string label);
  void addInitState (string & initName);
  void new_trans (string const & id1, string const & id2, string const & a);
  void new_trans (state const & s1, state const & s2, string const & a);
  void computeActionClosure (string a, set <state> const & S, set <state> & SA);
  void computeActionClosure (string a, state const & s, set <state> & SA);
  void DeltaNFA (set <state> & s, string a, set <state> & sa);
  bool accepts (path & p);
  void doAccSeqDFS (state & s, set <path> & seqs);
  void getAccessSeq (set <path> & seqs);

  friend class FAUtils;
};

} //namespace magic

#endif //__NFA_H__

/*********************************************************************/
//end of NFA.h
/*********************************************************************/
