/******************************** CPPFile *****************************

* FileName [NFA.cpp]

* PackageName [sub]

* Synopsis [Method definitions of NFA class.]

* SeeAlso [NFA.h]

* Author [Nishant Sinha]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cassert>
#include <deque>
#include <fstream>
#include <sstream>
using namespace std;

#include "common.h"
#include "FA.h"
#include "NFA.h"
using namespace magic;

NFA::NFA () : FA (NFAt) {}

NFA::NFA (char * fname, int fileType)
  : FA (NFAt)
{
  ifstream fin(fname);

  /*if(type == DFAt && fileType ==0 ) { //alex's format
    string id1, id2, alphabet, line;
	
    int cnt=0;
    while(1) {
    cnt++;
    getline(fin,line);
    if(line == "end")
    break;
    istringstream ist(line);
    ist>>id1;
    state s1 =getState(id1);
    //if( id1[0] == '0') I->start = s1; // set the start state
    if(cnt == 1) I->start = s1; // first state is the start state

    while( ist>> alphabet ) {
    ist >> id2;
    assert( id2 != "");
    state s2 = getState(id2);
    new_trans(s1, s2,alphabet); //sets the language also
    }
    }

    assert(I->start != invalid);
    }
    //all nodes have a single label
	
    initialiseNgetAccessSequences();
  */
}

void NFA::showTransTable ()
{
  for( map<state, map<string,set<state> > >::iterator it = I->transRel.begin(); it != I->transRel.end(); it++) {
    state s = (*it).first;
    map<string, set<state> >& smap = (*it).second;
    for(map<string, set<state> >::iterator itB=smap.begin(); itB != smap.end(); itB++) {
      showState(s); cout<<" ("<<(*itB).first<<")  "; showStates( (*itB).second); 
      cout<<endl;
    }
  }
}

state NFA::getState (string label)
{
  if( I->label2State.find(label) == I->label2State.end() ) {
    ostringstream s; s<<"T"<<I->nameCnt++;
    string id = s.str();
    cout<<"***************************adding for "<<label<<": id="<<id<<endl;
    //node n = I->G.new_node();
	state n = getNewState();
    if(label != "") {
      I->new2OldName[label]= id;
      I->label2State[label]=n;
    }
    I->state2Name[n] = id;

    //DO NOT make epsilon trans to itself in DFAs: taken care in DeltaDFA
    I->transRel[n]["epsilon"].insert(n);
    // add to allStates
    I->allStates.insert(n);
    return n;
  }
  else return I->label2State[label];
}

void NFA::addInitState (string & initName)
{
  state s = getState(initName);
  FA::addInitState(s);
}

void NFA::new_trans (string const & id1, string const & id2, string const & a)
{
  FA::new_trans(id1, id2, a);
}

void NFA::new_trans (state const & s1, state const & s2, string const & a)
{
  //epsilon at same state is implicit in DFAs but not in NFAs
  //if(a == "epsilon" &&  s1 == s2 ) return;

  //cout<<"adding new trans "<<I->state2Name[s1]<<"("<<a<<")"<<I->state2Name[s2]<<endl;
  if( I->transRel[s1].find(a) != I->transRel[s1].end() ) {
    set<state>& opp = I->transRel[s1][a];
    opp.insert(s2);
  }
  else {
    set<state> opp; opp.insert(s2);
    I->transRel[s1][a] = opp;
  }

  //TODO: get rid of trans stuff
  //trans e = I->G.new_edge(s1,s2);
  //I->transLabel[e] = a;
  I->Sigma.insert(a);
}

void NFA::computeActionClosure (string a, set <state> const & S, set <state> & SA)
{
  if( a!="epsilon") assert(0);
  set<state> ret;
  for( set<state>::iterator itS = S.begin(); itS!= S.end(); itS++) {
    set<state> curr = I->transRel[*itS][a];
    curr.erase(*itS);
    if( !curr.empty() ) {
      computeActionClosure(a, curr, ret);
      set_union(ret.begin(), ret.end(), SA.begin(), SA.end(), inserter(SA, SA.begin()));
      ret.clear();
    }
    SA.insert(*itS);
  }
}

void NFA::computeActionClosure (string a, state const & s, set <state> & SA)
{
  set<state> tmp; tmp.insert(s);
  computeActionClosure(a, tmp, SA);

}

void NFA::DeltaNFA (set <state> & s, string a, set <state> & sa)
{
  //	assert(I->type == DFAt);
  //	if( a == "epsilon" ) return s;

  //set<state> sClosure = s;	
  //computeActionClosure("epsilon",s, sClosure);	
  set<state> opp;
  for(set<state>::iterator it = s.begin(); it!= s.end(); it++)  {
    state curr = *it;
    set<state>& oppIt = Delta(curr, a);
    if( oppIt.size() != 0)
      set_union(opp.begin(), opp.end(), oppIt.begin(), oppIt.end(), inserter(opp, opp.begin())); 
  }
  /*
    if( opp.size() == 0) {
    showTransTable();

    }

    cout<<"state=";
    showStates(s); cout<< ", a is "<<a<<" opp size ="<<opp.size()<<endl;
    cout<<endl;
  */

  computeActionClosure("epsilon",opp, sa);	

  /*	cout<<"-DeltaNFA: a is "<<a<<", states are ";
	showStates(opp);
	cout<<endl;*/
}

bool NFA::accepts (path & p)
{	
  //cout<<"begin: accepts NFA, path = $"<<p<<"$"<<endl;
  istringstream is(p);
  string s;
  set<state> inits= I->initStates;
  set<state> curr;
  computeActionClosure("epsilon", inits, curr);	
  bool flag = true;
  while( is >> s) {
    set<state> newCurr;
    DeltaNFA(curr,s,newCurr);
    if( newCurr.empty() ) { flag=false; break;}
    curr = newCurr;
  }
  /*	if( flag == true) {
	cout<<"accepts NFA:  path $"<<p<<"$ accepted.\n";
	}
	else cout<<"accepts NFA:   path $"<<p<<"$ rejected.\n";
  */
  return flag;
		
}

void NFA::doAccSeqDFS (state & s, set <path> & seqs)
{ 
  // s must be initial
  marked[s] = true;
  map<string, set<state> >& oppTrans = I->transRel[s];
  //for(state::out_edges_iterator it=s.out_edges_begin(); it!= s.out_edges_end(); it++) {
  for(map<string, set<state> >::iterator itS = oppTrans.begin(); itS!= oppTrans.end(); itS++) {
	set<state>& oppSet = (*itS).second;
 	string a = (*itS).first;
	for(set<state>::iterator it=oppSet.begin(); it!=oppSet.end(); it++) {
		//state opp = s.opposite(*it);
		state opp = *it;
		if(marked.find(opp) == marked.end() ) {
		 // string a = I->transLabel[*it];
		  if( a != "epsilon") {
		path acc;
		if( accessSeq[s] == "epsilon" )//|| accessSeq[s] == "")
		  acc = a;
		else acc = accessSeq[s] + " "+ a;
		accessSeq[opp] = acc;
		//			cout<<"acc is "<<acc<<endl;
		seqs.insert(accessSeq[opp]);
		  }
		  else accessSeq[opp] = accessSeq[s];

		  doAccSeqDFS(opp, seqs);
		}
	 }
  }
}


void NFA::getAccessSeq (set <path> & seqs)
{
  //spanning tree algo
  marked.clear();
  set<state> inits= I->initStates;
  for(set<state>::iterator it = inits.begin(); it!= inits.end(); it++) {
    state curr = *it;
    accessSeq[curr] = "epsilon";
    doAccSeqDFS(curr, seqs);
  }	
}

/*********************************************************************/
//end of NFA.cpp
/*********************************************************************/

