/**************************** CPPHeaderFile ***************************

* FileName [Teacher.h]

* PackageName [sub]

* Synopsis [Header file for Teacher class.]

* Description [This class encapsulates a minimal adequate teacher
* (MAT).]

* SeeAlso [Teacher.cpp]

* Author [Nishant Sinha]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __MATEACHER_H__
#define __MATEACHER_H__

namespace magic {

bool ReadCEFromFile(char*, path&);

class MATeacher
{
  typedef pair<NFA*,bool> NFAType;
 private:
  //FA * UnknownFA;
  set<string> Sigma;
  vector<NFAType> UnknownNFAList; //pairs of NFA and bool(accept or reject)

 public:  
  mcType MC;
  MATeacher(mcType _MC);
  void GetSigma(set<string>& S);
  void addUnknownNFA(NFA* U, bool tf);
  
  bool CheckIfUnknownAccepts (path & p);
  bool CheckIfCandidate(DFA& M, path& ce);
  bool CheckIfCandidate(const string& mcString, path& ce);  
};

} //namespace magic

#endif //__MATEACHER_H__

/*********************************************************************/
//end of Teacher.h
/*********************************************************************/
