/******************************** CPPFile *****************************

* FileName [MATeacher.cpp]

* PackageName [sub]

* Synopsis [Method definitions of MATeacher class.]

* SeeAlso [MATeacher.h]

* Author [Nishant Sinha]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cassert>
#include <deque>
#include <fstream>
#include <sstream>
using namespace std;

#include "common.h"
#include "FA.h"
#include "NFA.h"
#include "DFA.h"
#include "FAUtils.h"
#include "MATeacher.h"
using namespace magic;

MATeacher::MATeacher(mcType _MC)
{
  MC = _MC;
}

void MATeacher::GetSigma(set<string>& S) {
  S = Sigma;
}

void MATeacher::addUnknownNFA(NFA* U, bool tf) {
  NFAType uNFA(U,tf);
  UnknownNFAList.insert(UnknownNFAList.begin(),uNFA);
  set<string>& unknownSigma = U->I->Sigma;
  set_union(Sigma.begin(), Sigma.end(), unknownSigma.begin(), unknownSigma.end(), inserter(Sigma, Sigma.begin()));
}

bool MATeacher::CheckIfUnknownAccepts (path & p)
{ 
  bool ret=false;
  if(MC == OWN) {
    // a containment check for path p in union of UnknownFA n startFA
    //ret = UnknownFA->accepts(p);
    //if( ret == false && startFA!= NULL) ret = startFA->accepts(p);
    assert(!UnknownNFAList.empty());
    for(vector<NFAType>::iterator it = UnknownNFAList.begin(); it!= UnknownNFAList.end(); it++){
      ret = ((*it).first)->accepts(p);
      if( (*it).second == true) {if (ret == true) break;} 
      else {// *it is part of non-accepted lang
	if( ret == true) {ret=false; break;} 
      }		
    }	

  } else if( MC == MAGIC ) {		
    //write _tr.spec 
    // write _tr.c.pp before
    ofstream trFile("_tr.spec");
    trFile << "cproc do_tr {\n abstract {abs0, 1, DoTr};\n}\n";
    trFile << "DoTr = (";
    istringstream s(p);
    string token;
    s>>token; trFile << token;
    while( s>> token) {
      trFile << " -> "<< token;
    }
    trFile << " -> return{} -> STOP)+{";
    assert(Sigma.size() != 0);
    for(set<string>::iterator it = Sigma.begin(); ;) {
      trFile<<*it; ++it;
      if( it == Sigma.end()) break;
      trFile<<",";
    }
    trFile<<"}.\n";
    trFile.close();
    cout<<"checking path "<<p<<"for containment in UnknownFA"<<endl;
    system("magic --abstraction abs0 --trace _Mtr.spec _M.spec _tr.spec _M.c.pp _tr.c.pp --ceShowAct --dataComm");
    ifstream ceFile("ce.out");
    string line;
    getline(ceFile,line);
    if( line == "1") ret=true;
    else ret = false;
  } else assert(0);

  return ret;
}

bool MATeacher::CheckIfCandidate(DFA& M, path& ce) 
{
  //TODO: checkSuperset against the actual language (L(M') \union (L(M)\L(B)))
  bool CE;
  if(MC == OWN) {
    NFA* unknown = (*(UnknownNFAList.begin())).first;
    CE = FAUtils::checkSuperset(M,(*unknown),ce);
  }
  else assert(0);
  return CE;
}

bool MATeacher::CheckIfCandidate(const string& mcString, path& ce) 
{
  bool CE;
  if(MC == MAGIC) {
    assert(!mcString.empty());
    system(mcString.c_str());
    CE = ReadCEFromFile("ce.out",ce);
  }
  else assert(0);
  return CE;
}

/*********************************************************************/
//end of MATeacher.cpp
/*********************************************************************/
