/**************************** CPPHeaderFile ***************************

* FileName [FAUtils.h]

* PackageName [sub]

* Synopsis [Header file for FAUtils class.]

* Description [This class encapsulates a various utility routines.]

* SeeAlso [FAUtils.cpp]

* Author [Nishant Sinha]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __FAUTILS_H__
#define __FAUTILS_H__

namespace magic {

class FAUtils
{
 public:
  static set<state_pair> intersect_marked;

  static void Clear();
  static void complement (FA & A, FA & notA);
  static bool isMarked (state_pair & p, set < state_pair > & isDifferent);
  static void minimize (DFA & A);
  static bool checkSuperset (DFA & Candidate, NFA & Unknown, path & ce);
  static bool isSuperset (DFA & Candidate, NFA & Unknown, path & ce, state_pair ab);
  static bool checkSuperset (DFA & Candidate, DFA & Unknown, path & ce);
  static bool isSuperset (DFA & Candidate, DFA & Unknown, path & ce, state_pair ab);
};

} //namespace magic

#endif //__FAUTILS_H__

/*********************************************************************/
//end of FAUtils.h
/*********************************************************************/
