/******************************** CPPFile *****************************

* FileName [FAUtils.cpp]

* PackageName [sub]

* Synopsis [Method definitions of FAUtils class.]

* SeeAlso [FAUtils.h]

* Author [Nishant Sinha]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cassert>
#include <deque>
#include <fstream>
#include <sstream>
using namespace std;

#include "common.h"
#include "FA.h"
#include "DFA.h"
#include "NFA.h"
#include "FAUtils.h"
using namespace magic;

/*********************************************************************/
//define static fields
/*********************************************************************/
set<state_pair> FAUtils::intersect_marked;

void FAUtils::Clear() 
{
  intersect_marked.clear();
}

void FAUtils::complement(FA & A, FA & notA)
{ 
  //TODO: need to do a copy operator	
  notA.I = A.I;
  set<state> prevFinal = A.I->final;
  set_difference(A.I->allStates.begin(), A.I->allStates.end(), prevFinal.begin(), prevFinal.end(),
		 inserter(notA.I->final, notA.I->final.begin()) );

}

bool FAUtils::isMarked (state_pair & p, set < state_pair > & isDifferent)
{
  if(isDifferent.find(p) != isDifferent.end() ) return true;
  state_pair p1;
  p1.first=p.second; p1.second=p.first;
  if(isDifferent.find(p1) != isDifferent.end()) return true;
  return false;
}

void FAUtils::minimize (DFA & A)
{
  assert( A.I->type == DFAt );
  deque<state_pair> frontier;
  /*set<state>& final = A.I->final;
  graph& G = A.I->G;
	
  // insert pairs of final states with all non-final states
  set<state_pair> isDifferent;
  for(set<state>::iterator it=final.begin(); it!= final.end(); it++)
    for(graph::node_iterator itN=G.nodes_begin(); itN!= G.nodes_end(); itN++) {
      if( final.find(*itN) != final.end() ) continue;
      state_pair p(*it,*itN);
      frontier.push_back(p);
      isDifferent.insert(p);
    }

  while( !frontier.empty() ) {
    state_pair curr = frontier.front();
    frontier.pop_front();
    state s1= curr.first, s2=curr.second;
    state& invalid = FA::invalid;
    map<string, state_pair> inMap; //cleared everytime

    //get mapping to opp state for s1 for each alpha
    for(state::in_edges_iterator it=s1.in_edges_begin(); it!= s1.in_edges_end(); it++) {
      state opp = s1.opposite(*it);
      string& alpha = A.I->transLabel[*it];
      state_pair p(opp,invalid);
      inMap[alpha]=p;	
    }
    //get mapping to opp state for s2 for each alpha
    //and insert distinguished pairs at the same time into frontier
    for(state::in_edges_iterator it=s2.in_edges_begin(); it!= s2.in_edges_end(); it++) {
      state opp = s2.opposite(*it);
      string alpha = A.I->transLabel[*it];
      if(inMap.find(alpha) != inMap.end() ) {
	(inMap[alpha]).second=opp;
	state_pair& p = inMap[alpha];
	if( p.first!= invalid &&!isMarked(p,isDifferent) ) {
	  frontier.push_back(p);
	  isDifferent.insert(p);
	}
      }
      else {
	state_pair p(invalid,opp);
	inMap[alpha]=p;
      }
    }
		
  }*/
}

bool FAUtils::checkSuperset (DFA & Candidate, NFA & Unknown, path & ce)
{
  intersect_marked.clear();
  set<state>& inits = Unknown.getStart();
  cout<<"start states of unknown="<<endl;
  Unknown.showStates(inits);
  cout<<endl;
  bool retval=true;
  for(set<state>::iterator itI = inits.begin(); itI != inits.end(); itI++) {
    state_pair new_ab( *((Candidate.getStart()).begin()), *itI);
    retval = isSuperset(Candidate,Unknown,ce,new_ab);
    if( retval == false ) { //reverse ce
      //	reverse(ce.begin(),ce.end() );
      break;
    }
  }
  return retval;
}

bool FAUtils::isSuperset (DFA & Candidate, NFA & Unknown, path & ce, state_pair ab)
{
  //assert( Candidate.getType() == DFAt && Unknown.getType() == NFAt);
  //get successor maps
  state& A = ab.first;
  state& B = ab.second;
  intersect_marked.insert(ab);
  map<string, set<state> >& ASuccMap = Candidate.I->transRel[A];	
  state cstart = *((Candidate.getStart()).begin());
  set<state> ustart = Unknown.getStart();
  bool isStartC = (A == cstart);
  bool isStartU = (ustart.find(B) != ustart.end());

  cout<<"{{"<<endl;
  cout<<"isSuperset: ";Candidate.showState(A); Unknown.showState(B); cout<<endl;
  if( !(isStartC && isStartU) ) //except the first case
    if( !Candidate.isFinal(A) ) {cout<<"}}f-not final"<<endl; return false;}
	
  state A_;
  set<state> SB ;
  Unknown.computeActionClosure("epsilon", B, SB); 
  cout<<"SB_ is ";
  Unknown.showStates(SB);
  cout<<endl;
  for(set<state>::iterator itS = SB.begin(); itS!= SB.end(); itS++) {
    bool ret = true;
    const state& B2 = (*itS);
    map<string, set<state> >& BSuccMap = Unknown.I->transRel[B2];	
    for(map<string, set<state> >::iterator itB=BSuccMap.begin(); itB != BSuccMap.end(); itB++) {
      if( (*itB).second.size() ==0 ) continue;
      string b = (*itB).first;
      const set<state>& currB = (*itB).second;
      if( b == "epsilon") continue;
      if(ASuccMap.find(b) != ASuccMap.end() ) 
	A_ = *(ASuccMap[b].begin());
      else  {
	if(ce.size() != 0) ce.insert(0,b+ " ");
	else ce = b;
	cout<<"}}f-no such action from A"<<endl;
	return false;
      }
      //cout<<"size = "<<(*itB).second.size()<<" :"; Unknown.showStates((*itB).second);
      //cout<<endl;
      //NOT TRUE assert( (*itB).second.size() == 1);  //imp assumption: magic only has non-dete epsilons
      cout<<"isSuperset:trying for "<<(*itB).first<<": size="<<(*itB).second.size()<<endl;
      //	cout<<"isSuperset:trying for "<<(*itB).first<<": ";
      //cout<<Candidate.I->state2Label[s1]<<", ";
      //cout<<Unknown.I->state2Label[s2]<< endl;

      for(set<state>::iterator itB2 = currB.begin(); itB2 != currB.end(); itB2++) { 
	//const state& B_ = *((*itB).second.begin());
	const state& B_ = (*itB2);
	//pick first elements from both sides for next step
	state_pair new_ab( A_, B_ );
	if(intersect_marked.find(new_ab) == intersect_marked.end() ) {//fixed pair order: ab
	  ret = isSuperset(Candidate, Unknown, ce, new_ab );
	  if (ret == false)  {
	    //				if( b != "epsilon") {
	    if(ce.size() != 0) ce.insert(0,b+ " ");
	    else ce = b;
	    //				}
	    cout<<"}}f-retval false"<<endl;
	    return false;
	  }
	}
      }
    }
  }

  cout<<"}}t"<<endl;
  return true;
}

bool FAUtils::checkSuperset (DFA & Candidate, DFA & Unknown, path & ce)
{
  intersect_marked.clear();
  bool retval = isSuperset(Candidate,Unknown,ce,state_pair(*(Candidate.getStart().begin()), *(Unknown.getStart().begin()) ) );
  if( retval == false ) { //reverse ce
    //	reverse(ce.begin(),ce.end() );
	
  }
  return retval;

}

bool FAUtils::isSuperset (DFA & Candidate, DFA & Unknown, path & ce, state_pair ab)
{
  assert( Candidate.getType() == DFAt && Unknown.getType() == DFAt);
  //get successor maps
  map<string, set<state> >& ASuccMap = Candidate.I->transRel[ab.first];	
  map<string, set<state> >& BSuccMap = Unknown.I->transRel[ab.second];	

  intersect_marked.insert(ab);
  state cstart = *((Candidate.getStart()).begin());
  state ustart = *(Unknown.getStart().begin());
  bool isStartC = (ab.first == cstart);
  bool isStartU = (ab.second == ustart);
  //cout<<"{{"<<endl;
  if( !(isStartC && isStartU)) //except the first case
    if( !Candidate.isFinal(ab.first) ) return false;
	
  for(map<string, set<state> >::iterator itB=BSuccMap.begin(); itB != BSuccMap.end(); itB++) {
    if( (*itB).first == "epsilon") continue; //dont match epsilon actions
    //cout<<"isSuperset:trying for "<<(*itB).first<<": size="<<(*itB).second.size()<<endl;
    if( (*itB).second.size() ==0 ) continue;
    if(ASuccMap.find( (*itB).first ) != ASuccMap.end() ) {
      state s1 = *(ASuccMap[(*itB).first].begin());
      state s2 = *((*itB).second.begin());
				
      //cout<<"isSuperset:trying for "<<(*itB).first<<": ";
      //cout<<Candidate.I->state2Label[s1]<<", ";
      //cout<<Unknown.I->state2Label[s2]<< endl;
			
      //pick first elements from both sides for next step
      state_pair new_ab( s1, s2 );

      if(intersect_marked.find(new_ab) == intersect_marked.end() ) {//fixed pair order: ab
	bool isPath = isSuperset(Candidate,Unknown,ce, new_ab);
	if(isPath == false) {
	  ce.insert(0,(*itB).first+" " ); // append the paths
	  return false;
	}
      }
    }
    else {
      if(ce.size() != 0) ce.insert(0,(*itB).first+ " ");
      else ce = (*itB).first;
      return false;
    }

  }
  //cout<<"}}"<<endl;
  return true;
}

/*********************************************************************/
//end of FAUtils.cpp
/*********************************************************************/


