/**************************** CPPHeaderFile ***************************

* FileName [FA.h]

* PackageName [sub]

* Synopsis [Header file for FA class.]

* Description [This class encapsulates a finite automaton.]

* SeeAlso [FA.cpp]

* Author [Nishant Sinha]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __FA_H__
#define __FA_H__

#include <deque>
#include <fstream>
#include <sstream>
using namespace std;

#include "common.h"
using namespace magic;

namespace magic {

class FA
{
public:
  static state invalid;
  struct infoType
  {
//    graph G;
	int stateCnt;
    FAtype type;
    set <state> initStates;
    set <state> allStates;
    set <state> final;
    set <string> Sigma;
 //   node_map <string> state2Name;
    map<state,string> state2Name;
    int nameCnt;
    map <string, state> label2State;
    map <trans, string> transLabel;
    map <string,string> new2OldName;
    map <state, map<string,set<state> > > transRel;
  };
  typedef struct infoType info;
  info * I;
  void showState (state & s);
  void showStates (set <state> & s);
  void initFA (FAtype type);
  FA (FAtype type);
  virtual ~ FA ();
  state getNewState();
  void clear ();
  FAtype getType ();
  set <state> & getStart ();
  void addInitState (state & s);
  bool isInitState (state & s);
  state new_state (string name = "");
  virtual void new_trans (state const & s1, state const & s2, string const & a) = 0;
  void new_trans (string const & id1, string const & id2, string const & a);
  set <state> & Delta (state const & s, string const & a);
  bool isFinal (state & s);
  bool isDFA ();
  virtual bool accepts (path & p) = 0;
  virtual void getAccessSeq (set <path> & seqs) = 0;
  string getDotName (string t);
  void writeToDot (string fname);
  void show (bool nonFinal = true);
  int size ();

protected:
  map <state, bool> marked;
  map <state, path> accessSeq;
  virtual state getState (string label) = 0;

  friend class FAUtils;
};

} //namespace magic

#endif //__FA_H__

/*********************************************************************/
//end of FA.h
/*********************************************************************/

