/******************************** CPPFile *****************************

* FileName [FA.cpp]

* PackageName [sub]

* Synopsis [Method definitions of FA class.]

* SeeAlso [FA.h]

* Author [Nishant Sinha]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <deque>
#include <fstream>
#include <sstream>
using namespace std;

#include "common.h"
#include "FA.h"
using namespace magic;

state FA::invalid;

void FA::showState (state & s)
{
  cout<<I->state2Name[s] << " ";
}

void FA::showStates (set <state> & s)
{
  set<state>::iterator it = s.begin();
  set<state>::iterator end = s.end();
  while( it != end) {
    cout<<I->state2Name[*it] << " ";
    it++;
  }
}

void FA::initFA (FAtype type)
{ // simple constructor
  I = new info();
  //I->initStates.insert(invalid);
  I->type = type;
  I->nameCnt = 0;
  I->stateCnt=0;
  //initialise Sigma
  I->Sigma.insert("epsilon"); //include epsilon
  //I->state2Label.init(I->G,"noLab");
  //I->state2Name.init(I->G,"noName");
}

FA::FA (FAtype type) { initFA(type); }

FA::~ FA ()
{
  delete I;
}

state FA::getNewState() {
 I->stateCnt++;
 return I->stateCnt;
}

void FA::new_trans (string const & id1, string const & id2, string const & a)
{
  state s1 = getState(id1);
  state s2 = getState(id2);
  new_trans(s1,s2,a);
}

bool FA::isDFA ()
{
  for(set<state>:: iterator it= I->allStates.begin(); it!= I->allStates.end() ;it++) {
    map<string, set<state> >& tMap = I->transRel[*it];
    for(map<string, set<state> >::iterator itS = tMap.begin(); itS!= tMap.end(); itS++ ) {
      if( (*itS).second.size() > 1) {
	I->type = NFAt; return false;
      }
    }
  }
  return true;
}

string FA::getDotName (string t)
{
  string s= (t);
  //cerr<<"Warning: getDotName only prints first label of each state"<<endl;
  int n= s.find('.');
  if( n != -1) s[n]='_';
  n= s.find('@');
  if( n != -1) s[n]='_';
  if( isdigit(s[0]) ) s.insert(0,"_");
  return s;
}

void FA::writeToDot (string fname)
{
	cout<<"doNothing"<<endl;
	/*
  node n;
  edge out;
  set<int> tmp;
  ofstream os;
  os.open(fname.c_str(), ofstream::out);	

  os<<"digraph G {"<<endl;
  forall_nodes (n,I-> G) {
    os << getDotName(I->state2Name[n]) << " [label =\""<<getDotName(I->state2Name[n])<<" :\\n " <<"\"];"<<endl;

    forall_adj_edges (out, n) {
      node opp = n.opposite (out);
      os << getDotName(I->state2Name[n]) <<" -> " << getDotName(I->state2Name[opp]) <<" [label =\" "<<I->transLabel[out]<<"\" ]; "<<endl;
    }
  }
  os<<"}"<<endl;

  os.close();
  */

}

void FA::show (bool nonFinal)
{ //show non-accept states
  cout<<"***NOTE: not showing transitions to NON-Accepting(INITIAL) states"<<endl;
  cout<<"initial: ";
  showStates(I->initStates);
  cout<<endl;
  cout<<"FA::show:TODO"<<endl;
  /*
  node n;edge out;
  forall_nodes(n, I->G) {
    //	cout<<getDotName(I->state2Name[n]) <<":";
    forall_out_edges(out,n) {
      node opp = n.opposite(out);
      if( !nonFinal && I->initStates.find(opp) != I->initStates.end() ) continue;
      cout<<getDotName(I->state2Name[n])<<" -> ("<<I->transLabel[out]<<") "<<getDotName(I->state2Name[opp]) <<endl;
    }
  }*/

}

void FA::clear () { FAtype t=I->type;delete I; initFA(t); }

FAtype FA::getType () { return I->type; }

set <state> & FA::getStart () { return I->initStates;}

void FA::addInitState (state & s)
{ 
  I->initStates.insert(s);
  //I->state2Label[I->start] = I->state2Label[s];
}

bool FA::isInitState (state & s)
{
  return (I->initStates.find(s) != I->initStates.end());
}

state FA::new_state (string name)
{ 	
  string label;
  //if( name != "") {
  ostringstream s; s<<"T"<<I->nameCnt++;
  label = s.str();
  if(name != "")
    I->new2OldName[label]= name;
  //}
  return getState(label);
}

set <state> & FA::Delta (state const & s, string const & a)
{
  return I->transRel[s][a];
}

bool FA::isFinal (state & s)
{
  bool val= (I->final.find(s) != I->final.end() );
  //	cout<<"testing for final: "<<I->state2Name[s]<<": "<<val<<endl;
  return val;
}

int FA::size () { return I->stateCnt;//return (I->G.number_of_nodes()); 
}

/*********************************************************************/
//end of FA.cpp
/*********************************************************************/
