/**************************** CPPHeaderFile ***************************

* FileName [DFA.h]

* PackageName [sub]

* Synopsis [Header file for DFA class.]

* Description [This class encapsulates a deterministic finite
* automaton.]

* SeeAlso [DFA.cpp]

* Author [Nishant Sinha]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __DFA_H__
#define __DFA_H__

#include "FA.h"

namespace magic {

class DFA : public FA
{
public:
  DFA ();
  DFA (char * fname, int fileType);
  void getAccessSeq (set <path> & seqs);
  state getState (string label);
  void new_trans (state const & s1, state const & s2, string const & a);
  state const & DeltaDFA (state const & s, string a);
  bool accepts (path & p);
  void writeToMagicFiles (string prefix);

  friend class FAUtils;
};

} //namespace magic

#endif //__DFA_H__

/*********************************************************************/
//end of DFA.h
/*********************************************************************/
