/******************************** CPPFile *****************************

* FileName [DFA.cpp]

* PackageName [sub]

* Synopsis [Method definitions of DFA class.]

* SeeAlso [DFA.h]

* Author [Nishant Sinha]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cassert>
#include <deque>
#include <fstream>
#include <sstream>
using namespace std;

#include "common.h"
#include "FA.h"
#include "DFA.h"
using namespace magic;

DFA::DFA () : FA (DFAt) {}

DFA::DFA (char * fname, int fileType)
  : FA (DFAt)
{	
  ifstream fin(fname);

  //	if(type == DFAt && fileType ==0 ) { //alex's format
  if( fileType ==0 ) { //alex's format
    string id1, id2, alphabet, line;
	
    int cnt=0;
    while(1) {
      cnt++;
      getline(fin,line);
      if(line == "end")
	break;
      istringstream ist(line);
      ist>>id1;
      state s1 =getState(id1);
      //if( id1[0] == '0') I->start = s1; // set the start state
      if(cnt == 1) FA::addInitState(s1); // first state is the start state

      while( ist>> alphabet ) {
	ist >> id2;
	assert( id2 != "");
	state s2 = getState(id2);
	new_trans(s1, s2,alphabet); //sets the language also
      }
    }

    assert( I->initStates.size() != 0);
  }
  //all nodes have a single label
	
  //initialiseNgetAccessSequences();
}

void DFA::getAccessSeq (set <path> & seqs) { assert(0);}

state DFA::getState (string label)
{
  if( I->label2State.find(label) == I->label2State.end() ) {
    ostringstream s; s<<"T"<<I->nameCnt++;
    string id = s.str();
    //node n = I->G.new_node();
    state n = getNewState();
    if(label != "") {
      I->new2OldName[label]= id;
      I->label2State[label]=n;
    }
    I->state2Name[n] = id;

    //DO NOT make epsilon trans to itself in DFAs: taken care in DeltaDFA
    // add to allStates
    I->allStates.insert(n);
    return n;
  }
  else return I->label2State[label];
}

void DFA::new_trans (state const & s1, state const & s2, string const & a)
{
  //epsilon at same state is implicit in DFAs
  if(a == "epsilon" && I->type == DFAt && s1 == s2 ) return;

  //cout<<"adding new trans "<<I->state2Name[s1]<<"("<<a<<")"<<I->state2Name[s2]<<endl;
  set<state>& opp = I->transRel[s1][a];
  if( I->type == DFAt && opp.size() !=0)
    if( *(opp.begin()) == s2) return;
    else assert(0);

  opp.insert(s2);

  //TODO: get rid of trans stuff
//  trans e = I->G.new_edge(s1,s2);
//  I->transLabel[e] = a;

  I->Sigma.insert(a);
}

state const & DFA::DeltaDFA (state const & s, string a)
{
  //	assert(I->type == DFAt);
  if( a == "epsilon" ) return s;
	
  set<state>& opp = Delta(s,a);
  //cout<<"state="<<*(I->state2Name[s].begin())<< " a is "<<a<<" size ="<<opp.size()<<endl;
  //TODO: check!!	assert(opp.size() == 1);
	
  return *(opp.begin());
}

bool DFA::accepts (path & p)
{
  istringstream is(p);
  string s;
  state curr= *((I->initStates).begin());
  bool flag = true;
  while( is >> s) {
    curr = DeltaDFA(curr,s);
    if( curr == invalid) { flag=false; break;}
  }
  if( flag == true)
    cout<<"path "<<p<<" accepted.\n";
  else cout<<"path "<<p<<" rejected.\n";
	
  return flag;
}

void DFA::writeToMagicFiles (string prefix)
{ 
  //prefix = _A, writes .c.pp and .spec files
  string cname = prefix +".c.pp";
  const char* pre = prefix.c_str();
  FILE* fp = fopen(cname.c_str(),"w");
  fprintf(fp,"int main%s() {\n do%s();\n}",pre,pre);
  fclose(fp);

  string specName = prefix +".spec";
  fp = fopen(specName.c_str(),"w");
  assert(I->initStates.size() != 0);
  fprintf(fp, "cproc do%s {\n abstract {abs0, 1, Do%s};\n}\n",pre,pre);

  fprintf(fp, "Do%s = (epsilon -> %s).\n",pre,I->state2Name[*((I->initStates).begin())].c_str());

int i;
	for(map<state, map<string,set<state> > >::iterator itN = I->transRel.begin(); itN!= I->transRel.end(); itN++) {

  fprintf(fp,"%s = (",I->state2Name[(*itN).first].c_str()); 
  i=0;
  map<string, set<state> >& oppTrans = (*itN).second;
  for(map<string, set<state> >::iterator itS = oppTrans.begin(); itS!= oppTrans.end(); itS++) {
		set<state>& oppSet = (*itS).second;
 		string a = (*itS).first;
		for(set<state>::iterator it=oppSet.begin(); it!=oppSet.end(); it++) {
      state opp = *it;
      //ASSUME: the first state is always the non-accepting state.
      //so only consider transitions not going to the first state
      if( (I->initStates).find(opp) == (I->initStates).end() ) {
				if( i!= 0) fprintf(fp," | ");
				fprintf(fp, "%s -> %s",a.c_str(),(I->state2Name[opp]).c_str());
				i++;
      }
    }
  }
 if(i==0) fprintf(fp,"return {} -> STOP");
 fprintf(fp," ).\n");
}

  /*node n;edge out;
  int i;
  forall_nodes(n, I->G) {
    fprintf(fp,"%s = (",I->state2Name[n].c_str()); 
    i=0;
    forall_out_edges(out,n) {
      node opp = n.opposite(out);
      //ASSUME: the first state is always the non-accepting state.
      //so only consider transitions not going to the first state
      if( (I->initStates).find(opp) == (I->initStates).end() ) {
	if( i!= 0) fprintf(fp," | ");
	fprintf(fp, "%s -> %s",I->transLabel[out].c_str(),(I->state2Name[opp]).c_str());
	i++;
      }
    }
    if(i==0) fprintf(fp,"return {} -> STOP");
    fprintf(fp," ).\n");
  }
*/
  fclose(fp);
  //fprintf(fp, "return {} -> STOP).");
}

/*********************************************************************/
//end of DFA.cpp
/*********************************************************************/
