/**************************** CPPHeaderFile ***************************

* FileName [AngluinLearn.h]

* PackageName [sub]

* Synopsis [Header file for AngluinLearn class.]

* Description [This class encapsulates a weakest assumption learner
* that employs Angluin's algorithm.]

* SeeAlso [AngluinLearn.cpp]

* Author [Nishant Sinha]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __ANGLUINLEARN_H__
#define __ANGLUINLEARN_H__

#include "MATeacher.h"

namespace magic {

bool ReadCEFromFile(char*, path & ce);
void LearnAngluin(NFA * start, NFA * toLearn);


class AngluinLearn
{
typedef map <path, string> rowType;
 private:
	MATeacher& T;
  DFA * candidate;
  FA * startFA;
  rowType rowS;
  rowType rowSA;
  vector <path> cols;
  set <string> Sigma;
	mcType MC;

 public:
  AngluinLearn (FA* initFA, MATeacher& T);
  void ShowTable ();
  void LearnCE (path ce, bool positive);
  void ComputeConsistentClosure ();
  void AddRowByMembershipQuery (rowType & RowSorSA, path access);
  bool CheckClosedChange ();
  void AddColByMembershipQuery (path distinguish);
  int CheckConsistencyChange ();
  void GetPrefixes (path const & s, set <string> & prefixes);
  void ComputeCandidate ();
  DFA *GetNewCandidate ();
  DFA *GetPrevCandidate ();
};

} //namespace magic

#endif //__ANGLUINLEARN_H__

/*********************************************************************/
//end of AngluinLearn.h
/*********************************************************************/
