/******************************** CPPFile *****************************

* FileName [AngluinLearn.cpp]

* PackageName [sub]

* Synopsis [Method definitions of AngluinLearn class.]

* SeeAlso [AngluinLearn.h]

* Author [Nishant Sinha]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cassert>
#include <deque>
#include <fstream>
#include <sstream>
using namespace std;

#include "common.h"
#include "FA.h"
#include "NFA.h"
#include "DFA.h"
#include "FAUtils.h"
#include "AngluinLearn.h"
using namespace magic;

bool magic::ReadCEFromFile (char* fname, path & ce)
{
  ifstream ceFile(fname);
  assert(ceFile != 0);
  string s,token; int i=0;
  //getline(ceFile,s);	
  //assert( s != "1");
  while(1 ) {
    if (ceFile.eof() ) break;
    getline(ceFile,s);
    if( s == "1" && i==0) return false;
    string newS=s,a;
    if( s[0] == 'P' ) {
      uint pos = s.rfind(':');     
      ++pos;  newS = s.substr(pos);
      // cout<<"newS is "<<newS<<endl;
      if( newS[newS.size() -1] == '}')
        newS.insert(0,1,'{');
    }
    if( newS == "STUTTER") {++i; continue;}
    if( newS == "epsilon") {++i; continue;}

    istringstream tokenizer(newS);
    while( tokenizer >> token)  a+=token;
    //     cout<<"a is "<<a<<endl;
    if(ce.size() == 0) ce = a;
    else ce += " "+ a;
    ++i;
  }
  cout<<"ce readFromFile is "<<ce<<endl;
  return true;
}

AngluinLearn::AngluinLearn(FA *initFA, MATeacher& _T)
  : T(_T), candidate (NULL)
{
  //assert(targetFA != NULL);
  //UnknownFA= targetFA;
  startFA = initFA;
  //Sigma = UnknownFA->I->Sigma;
  T.GetSigma(Sigma);
  //TODO: should be done by teacher
  MC = T.MC;

  if( MC == MAGIC) {
    //change send to receive and vice-versa
    set<string> newSigma;
    for(set<string>::const_iterator itS=Sigma.begin(); itS!=Sigma.end();++itS) {
      string a = (*itS);
      size_t pos = a.find('?');
      if( pos != string::npos) a[pos]='!';
      else {
	pos = a.find('!');
	if( pos != string::npos) a[pos]='?';
      }
      newSigma.insert(a);
    }
    Sigma = newSigma;
  }
  if(initFA != NULL) {
    //first learn from itself
    //UnknownFA = initFA;
    cols.push_back("epsilon");
    rowS["epsilon"]=string("0"); //initial state is not accepting
    //make a table out of the given DFA
    set<path> seqs;
    initFA->getAccessSeq(seqs);
    for(set<path>::iterator it = seqs.begin();it!= seqs.end();++it) {
      if( rowS.find( *it ) == rowS.end() ) {
	cout<<"accessString: $"<<(*it)<<"$"<<endl;
	AddRowByMembershipQuery(rowS,*it); 
	//add to rowSA too
	for(set<string>::iterator itS=Sigma.begin();itS!=Sigma.end();++itS) {
	  const string& a=(*itS);
	  if((*it == "epsilon") || (*itS == "epsilon")) continue;
	  path sa = (*it) + " " + a;
	  AddRowByMembershipQuery(rowSA,sa);
	}
	ComputeConsistentClosure();
      }
    }
    //now learn from target
    //UnknownFA= targetFA;
  } else { 
    //initialise with null row
    cols.push_back("epsilon");
    //TODO: could use addRowByMembershipQuery
    rowS["epsilon"]=string("0"); //initial state is not accepting			
    for(set<string>::iterator itS=Sigma.begin(); itS!=Sigma.end();++itS) {
      if(*itS == "epsilon") continue;
      AddRowByMembershipQuery(rowSA,*itS);
    }			
    ComputeConsistentClosure();
  }  
}

void AngluinLearn::ShowTable ()
{
  cout<<"*********************************"<<endl;
  for(vector<string>::iterator it = cols.begin(); it!= cols.end();++it) 
    cout<<"   "<<(*it);
  cout<<"\n";

  for(rowType::iterator it = rowS.begin(); it!= rowS.end();++it) {
    cout<<(*it).first<<"    :"<<(*it).second<<endl;
  }
  cout<<endl<<"-------------------------"<<endl;
  for(rowType::iterator it = rowSA.begin(); it!= rowSA.end();++it) {
    cout<<(*it).first<<"    :"<<(*it).second<<endl;
  }
  cout<<"*********************************"<<endl;
}

void AngluinLearn::LearnCE (path ce, bool positive)
{
  set<string> prefixes;
  GetPrefixes(ce, prefixes);
  bool flag=false;
  for( set<path>::iterator it= prefixes.begin(); it != prefixes.end();++it) {
    cout<<"prefix: "<<(*it)<<endl;
    if(rowS.find( *it ) == rowS.end()) {
      AddRowByMembershipQuery(rowS,*it); 
      //add to rowSA too
      for(set<string>::iterator itS=Sigma.begin(); itS!=Sigma.end();++itS) {
	if((*it)=="epsilon" ) continue;
	path sa = (*itS =="epsilon") ? (*it) : ((*it) + " " + *itS);
	AddRowByMembershipQuery(rowSA,sa);
      }
      flag=true;
    }
  }
  if(flag == false) {
    fprintf(stderr," error in learnCE: wrong CE\n"); exit(1);
  }
  ComputeConsistentClosure();
  cout<<"end learnCE"<<endl;
}

void AngluinLearn::ComputeConsistentClosure ()
{
  int consistentChanged;
  bool closedChanged, flag = true;
  cout<<"start:computeConsistentClosure"<<endl; //showTable();
  while(flag) {
    flag = false;
    consistentChanged = CheckConsistencyChange();
    while(consistentChanged != 0) {
      consistentChanged = CheckConsistencyChange();
      flag = true;
    }		
    closedChanged = CheckClosedChange();
    while(closedChanged) {
      closedChanged = CheckClosedChange();
      flag = true;
    }
  }
  cout<<"end:computeConsistentClosure"<<endl; //showTable();
}

void AngluinLearn::AddRowByMembershipQuery(rowType & RowSorSA, path access)
{
  //string row_bv(cols.size(),'0');
  if((access == "epsilon") && (rowS.size() !=0)) return;
  //if( RowSorSA.find(access) != RowSorSA.end() ) return;
  string row_bv;
  //cout<<"init row is "<<row_bv<<endl;
  string member;
  for(size_t i=0;i< cols.size();++i) {
    if(access == "epsilon" && cols[i]=="epsilon") {
      row_bv.push_back('1'); 
      continue;
    }
    if( access == "epsilon") member = cols[i];
    else if(cols[i] == "epsilon") member = access;
    else member = access+" "+cols[i];
    //bool flag =(*UnknownFA).accepts(member);	//cols[i] is the distinguising seq
    bool flag = T.CheckIfUnknownAccepts(member);	
    if( flag==true) row_bv.push_back('1');
    else row_bv.push_back('0');
  }
  RowSorSA[access]=row_bv;
  //cout<<"added row for $"<<access<<"$"<<endl;
}

bool AngluinLearn::CheckClosedChange ()
{
  bool flag=false; //flag=true shows change has occurred
  cout<<"beginClosedChange:"<<endl; //showTable();
  list<string> toErase;
  for(map<path,string>::iterator itR=rowSA.begin(); itR!=rowSA.end();++itR) {	
    path SA = (*itR).first;
    string bv = (*itR).second;
    bool isClosed=false;
    for(rowType::iterator it1 = rowS.begin(); it1!=rowS.end();++it1) {
      if( (*it1).second == bv ) isClosed = true;
    }
    //this row "bv" does not exist in rowS 
    if( !isClosed ) { 
      cout<<"checkClosedChange:rowS["<<SA<<"] = "<<bv<<" does not exist"<<endl;
      rowS[SA]= bv;
      toErase.push_front(SA);
      for(set<string>::iterator it=Sigma.begin(); it!=Sigma.end();++it) {
	const string& a=(*it);
	if(a == "epsilon") continue;
	path SAa= SA+" "+a;
	AddRowByMembershipQuery(rowSA,SAa);
	flag=true;
	isClosed=true;
      }				
    }       	
  }		
  for(list<string>::iterator it=toErase.begin(); it!= toErase.end();++it) rowSA.erase(*it);
  cout<<"endClosedChange:"<<endl; //showTable();
  return flag;
}

void AngluinLearn::AddColByMembershipQuery (path distinguish)
{
  cout<<"\n*******distinguish is "<<distinguish<<endl;
  assert(find(cols.begin(),cols.end(),distinguish) == cols.end() );	
  //	if( find(cols.begin(), cols.end(), distinguish) != cols.end() ) return;
  cols.push_back(distinguish);	
  //add in rowS
  for(rowType::iterator it=rowS.begin(); it!= rowS.end();++it) {
    path p =  (*it).first + " " + distinguish;
    //bool flag= (UnknownFA)->accepts(p);
    (*it).second.push_back(T.CheckIfUnknownAccepts(p) ? '1' : '0');
  }
  //add in rowSA
  for(rowType::iterator it=rowSA.begin(); it!= rowSA.end();++it) {
    path p =(*it).first + " " + distinguish;
    //bool flag= (UnknownFA)->accepts(p);
    (*it).second.push_back(T.CheckIfUnknownAccepts(p) ? '1' : '0');
  }
}

int AngluinLearn::CheckConsistencyChange ()
{ 
  int flag=0;
  cout<<"begin:checkConsistencyChange"<<endl;
  while(1) {
    bool isConsistent=true;
    size_type colPos=string::npos;
    string a=""; //alphabet that produces the difference
    string s1, s2;
    for(rowType::iterator it1 = rowSA.begin(); it1!=rowSA.end();++it1) {
      for(rowType::iterator it2 = rowSA.begin(); it2 != rowSA.end();++it2) {
	if( it1 == it2) continue;
	const string& SA1 = (*it1).first;
	const string& SA2 = (*it2).first;
	if(rowSA[SA1] == rowSA[SA2]) continue;
	size_type pos1 = SA1.rfind(' ');
	if(pos1 == string::npos) pos1 =0;
	else pos1+=1;
	size_type pos2 = SA2.rfind(' ');
	if(pos2 == string::npos) pos2 =0;
	else pos2+=1;
	//last symbol in the row string should be same
	if( SA1.substr(pos1) != SA2.substr(pos2) ) continue;
	a = SA1.substr(pos1); // get the last symbol
	pos1--;
	pos2--;
	if( pos1 == string::npos) s1="epsilon";
	else s1=SA1.substr(0,pos1);
	if( pos2 == string::npos) s2="epsilon";
	else s2=SA2.substr(0,pos2);
	if(rowS[s1] != rowS[s2] ) continue; // s1,s2 are different; so are SA1, SA2
	//find the first position from the "end" where s1,s2 differ
	//assert(s1.size() == s2.size() );
	cout<<"s1="<<s1<<endl;
	cout<<"s2="<<s2<<"\n differ on "<<a<<endl;
	string& rS1=rowSA[SA1];
	string& rS2=rowSA[SA2];
	cout<<"before addCol: rowSA are "<<rS1<<" "<<rS2<<endl;
	for(size_type i=rS1.size()-1; i>=0; i--) {
	  if( rS1[i] != rS2[i]) {
	    colPos= i; isConsistent=false; 
	    flag=1; // a row must be added now: change
	    break;
	  }
	}
	assert(colPos!=string::npos);
	///* WRONG: who knows?
	//TODO: imp. addition for case of learning from non-empty automaton
	//check if the strings are really distinguished?
	string test1 = SA1 + " " + cols[colPos];
	string test2 = SA2 + " " + cols[colPos];
	bool acc1 = T.CheckIfUnknownAccepts(test1);
	bool acc2 = T.CheckIfUnknownAccepts(test2);
	if(acc1 == 1 && acc1 == acc2) {  //are not distinguised actually
	  //if( rS1[colPos] != acc1 ) ; 
	  //if( rS2[colPos] != acc2 ) ; 
	  rS1[colPos] = '1';	
	  rS2[colPos] = '1';
	  flag = 2; isConsistent = true;
	}
	//*/
	if(isConsistent==false || flag != 0)
	  break;
      }
      if( isConsistent== false || flag != 0)
	break;
    }
    if( isConsistent == true) break;
    assert(a != "");
    cout<<"heloo: a="<<a<<", cols[colPos]="<<cols[colPos]<<endl;
    string colToAdd;
    if(cols[colPos] == "epsilon") colToAdd = a;
    else colToAdd= a+" "+cols[colPos];
    cout<<"before addCol: rowS are "<<rowS[s1]<<" "<<rowS[s2]<<endl;
    AddColByMembershipQuery(colToAdd);
    cout<<"after addCol: cols are "<<rowS[s1]<<" "<<rowS[s2]<<endl; 
  }
  cout<<"end:checkConsistencyChange"<<endl;
  return flag;
}

void AngluinLearn::GetPrefixes (path const & s, set <string> & prefixes)
{ 
  size_type pos = string::npos;
  prefixes.insert(s);
  while( (pos=s.rfind(' ', pos)) != string::npos) {
    //	cout<<"adding prefix:"<<s.substr(0,pos)<<endl;
    prefixes.insert(s.substr(0,pos)); //substr starting from pos 0 upto pos-1
    --pos;
  }
  //add first symbol if path consists of a single symbol
  pos=s.find(' '); //first instance
  if(pos == string::npos)
    prefixes.insert(s.substr(0));
}

void AngluinLearn::ComputeCandidate ()
{
  //TODO: remove
  if(CheckClosedChange()) assert(false);
  if (CheckConsistencyChange() != 0) assert(false);
  ShowTable();
  cout<<"begin:computingCandidate"<<endl;
  if( candidate != NULL) delete candidate;
  candidate = new DFA();
  //candidate->I->Sigma = UnknownFA->I->Sigma;
  candidate->I->Sigma = Sigma;
  map<string, state> row2State;
  //make states in DFA corr to rows
  for(map<path,string>::iterator it=rowS.begin();it!=rowS.end();++it) {
    const string& currRow = (*it).second;
    if( row2State.find(currRow) == row2State.end() ) {
      state s = candidate->new_state();
      row2State[currRow]=s;
    }
    //final states
    if( currRow[0] == '1') 
      candidate->I->final.insert(row2State[currRow] );
  }
  //start state
  candidate->addInitState(row2State[rowS["epsilon"]]);
  string currPath,bv;	
  //transitions
  for(map<path,string>::iterator itR=rowS.begin(); itR!=rowS.end();++itR) {
    const string& s= (*itR).first;
    const state& state1= row2State[(*itR).second];
    for(set<string>::iterator it=Sigma.begin(); it!=Sigma.end();++it) {
      const string& a= (*it);
      if(a == "epsilon") continue;
      if(s=="epsilon") currPath=a;
      else currPath = s+" "+a;		
      //cout<<"computeCandidate:currPath is "<<currPath<<endl;
      if(rowSA.find(currPath) != rowSA.end() ) {
	bv=rowSA[currPath];
	const state& state2 = row2State[bv];
	//cout<<"computing candidate: Adding transition from ("<<s<<") to ("<< currPath<<") "<<endl;
	//cout<<"computing candidate: Adding transition  "<<state1<<" ("<< a<<") "<<state2<<endl;
	candidate->new_trans(state1,state2,a);
      } else if( rowS.find(currPath) != rowS.end() ) {
	bv=rowS[currPath];
	const state& state2 = row2State[bv];
	//cout<<"computing candidate: Adding transition from ("<<s<<") to ("<< currPath<<") "<<endl;
	//cout<<"computing candidate: Adding transition  "<<state1<<" ("<< a<<") "<<state2<<endl;
	candidate->new_trans(state1,state2,a);
      }
      //TODO: is this correct? since we didnt add all elements in Sigma to rowS in beginning and since the system
      //is prefix-closed, do not care if there is no transition
      else { cout<<currPath<<" not found in rowS or rowSA\n";}
    }
  }
  cout<<"New candidate is"<<endl; candidate->show(false);
  cout<<"End:computingCandidate"<<endl;
}

DFA *AngluinLearn::GetNewCandidate ()
{
  ComputeCandidate();
  return candidate;
}

DFA * AngluinLearn::GetPrevCandidate ()
{
  return candidate;
}

//main func for comp subst: begin with start NFA and learn union of "start"
//and "toLearn" finally
void magic::LearnAngluin(NFA * start, NFA * toLearn)
{
  path ce;
  bool CE;
  FAUtils::Clear();
  vector<pair<NFA*,bool> > NFAList;
  MATeacher T1(OWN);
  if( start!= NULL) {
    //CONVENTION:(cf MATeacher::checkIfCandidate) first add start then add others
    T1.addUnknownNFA(start,true);
  }
  AngluinLearn L1(start,T1);
  T1.addUnknownNFA(toLearn,true);
	
  //A.showTable();
  while(1) { 
    ce.clear();
    //CE = FAUtils::checkSuperset(*(L.GetNewCandidate()),(*toLearn),ce);
    CE = T1.CheckIfCandidate(*(L1.GetNewCandidate()),ce);
    if( !CE) break;
    cout<<"***learning from ce=$"<<ce<<"$"<<endl;
    L1.LearnCE(ce, true);
  }
  cout<<"ce is EPSILON. Learning finished.\n";

  //cout<<"writing final DFA _M to spec file"<<endl;
  //(L.GetPrevCandidate())->writeToMagicFiles("_M");
  //writeComposedSpec(): compose A n L.getPrevCandidate and provide spec
  cout<<"***********************************************************\n"
    "****************Compatibility check starts***********\n"
    "*********************************************************"<<endl;
  
  DFA A; //to be learnt next
  //start is NULL, hack:toLearn aut is set to M. CHECK constructor code!!
  //MATeacher T2(L.GetPrevCandidate(), MAGIC); 
  MATeacher T2(MAGIC); 
	//TODO: remove this hack: getActions from ProcManager
  T2.addUnknownNFA(toLearn,true);
	
  AngluinLearn L2(NULL, T2);

  while(1) {
    string mcString("magic --abstraction abs0 --trace _MA.spec _M.spec _A.spec _M.c.pp _A.c.pp --ceShowAct --dataComm");

    while(1) {
      cout<<"writing DFA _A to magic files"<<endl;
      (L2.GetNewCandidate())->writeToMagicFiles("_A");
      ce.clear();
      CE = T2.CheckIfCandidate(mcString,ce);
      if( !CE) break;
      cout<<"***learning from ce=$"<<ce<<"$"<<endl;
      L2.LearnCE(ce, false);
    }
    cout<<"Finished learning Assumptions"<<endl;

    //check rest against A
    (L2.GetPrevCandidate())->writeToMagicFiles("_A");
    system("magic --abstraction abs0 --trace _Mrest.spec _A.spec read_msg_queue.c.pp ipc_queue.c.pp critical_section.c.pp read_msg_queue.spec ipc_queue.spec critical_section.spec	--ceShowAct --dataComm");   //dont need A.c.pp, put link in _Mrest.spec
    CE = ReadCEFromFile("ce.out",ce);
    if(!CE) {
      cout<<"New component is substitutable. Compositional verification over."<<endl;
      break;
    }

    //otherwise check if ce is correct or not, ie M || ce falsifies P
    ofstream trFile("_tr.spec");
    trFile << "cproc do_tr {\n abstract {abs0, 1, DoTr};\n}\n";
    trFile << "DoTr = (";
    istringstream s(ce);
    string token;
    s>>token; trFile << token;
    while( s>> token) {
      trFile << " -> "<< token;
    }
    trFile << " -> return{} -> STOP)";
    trFile<<"}.\n";
    trFile.close();
    cout<<"checking if ["<<ce<<"] is correct"<<endl;
    system("magic --abstraction abs0 --trace _Mtr.spec _M.spec _tr.spec _M.c.pp _tr.c.pp --ceShowAct --dataComm");
    ifstream ceFile("ce.out");
    string line;
    getline(ceFile,line);
    //if true return ERROR
    if( line != "1") { cout<<"counterexample ["<<ce<<"] found"<<endl; break;}
    //if false add it to A and repeat.
    else  {
      L2.LearnCE(ce, false);
      ce.clear();
    }
  } 
}

/*********************************************************************/
//end of AngluinLearn.cpp
/*********************************************************************/
