/******************************** CPPFile *****************************

* FileName [Stmt.cpp]

* PackageName [parser]

* Synopsis [Method definitions of various statement AST node class.]

* SeeAlso [Stmt.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cassert>
#include <string>
#include <list>
#include <set>
#include <map>
using namespace std;

#include "Node.h"
#include "DFSAdapter.h"
using namespace magic;

/*********************************************************************/
//methods for class StmtList
/*********************************************************************/
void StmtList::Apply(DFSAdapter &a) const 
{ 
  a.caseStmtList(*this); 
}

/*********************************************************************/
//methods for class LabelStmt
/*********************************************************************/
void LabelStmt::Apply(DFSAdapter &a) const 
{ 
  a.caseLabelStmt(*this); 
}

/*********************************************************************/
//methods for class CaseStmt
/*********************************************************************/
void CaseStmt::Apply(DFSAdapter &a) const 
{ 
  a.caseCaseStmt(*this); 
}

/*********************************************************************/
//methods for class DefaultStmt
/*********************************************************************/
void DefaultStmt::Apply(DFSAdapter &a) const 
{ 
  a.caseDefaultStmt(*this); 
}

/*********************************************************************/
//methods for class CompStmt
/*********************************************************************/
void CompStmt::Apply(DFSAdapter &a) const 
{ 
  a.caseCompStmt(*this); 
}

/*********************************************************************/
//methods for class ExprStmt
/*********************************************************************/
void ExprStmt::Apply(DFSAdapter &a) const 
{ 
  a.caseExprStmt(*this); 
}

/*********************************************************************/
//methods for class EmptyStmt
/*********************************************************************/
void EmptyStmt::Apply(DFSAdapter &a) const 
{ 
  a.caseEmptyStmt(*this); 
}

/*********************************************************************/
//methods for class IfStmt
/*********************************************************************/
void IfStmt::Apply(DFSAdapter &a) const 
{ 
  a.caseIfStmt(*this); 
}

/*********************************************************************/
//methods for class SwitchStmt
/*********************************************************************/
void SwitchStmt::Apply(DFSAdapter &a) const 
{ 
  a.caseSwitchStmt(*this); 
}

/*********************************************************************/
//methods for class WhileStmt
/*********************************************************************/
void WhileStmt::Apply(DFSAdapter &a) const 
{ 
  a.caseWhileStmt(*this); 
}

/*********************************************************************/
//methods for class DoStmt
/*********************************************************************/
void DoStmt::Apply(DFSAdapter &a) const 
{ 
  a.caseDoStmt(*this); 
}

/*********************************************************************/
//methods for class ForStmt
/*********************************************************************/
void ForStmt::Apply(DFSAdapter &a) const 
{ 
  a.caseForStmt(*this); 
}

/*********************************************************************/
//methods for class GotoStmt
/*********************************************************************/
void GotoStmt::Apply(DFSAdapter &a) const 
{ 
  a.caseGotoStmt(*this); 
}

/*********************************************************************/
//methods for class ContinueStmt
/*********************************************************************/
void ContinueStmt::Apply(DFSAdapter &a) const 
{ 
  a.caseContinueStmt(*this); 
}

/*********************************************************************/
//methods for class BreakStmt
/*********************************************************************/
void BreakStmt::Apply(DFSAdapter &a) const 
{ 
  a.caseBreakStmt(*this); 
}

/*********************************************************************/
//methods for class ReturnStmt
/*********************************************************************/
void ReturnStmt::Apply(DFSAdapter &a) const 
{ 
  a.caseReturnStmt(*this); 
}

/*********************************************************************/
//end of Stmt.cpp
/*********************************************************************/
