D			[0-9]
L			[a-zA-Z_]
UL                      [A-Z_]
LL                      [a-z_]
H			[a-fA-F0-9]
E			[Ee][+-]?{D}+
FS			(f|F|l|L)
IS			(u|U|l|L)*

%{
#include <cstdio>
#include <cassert>
#include <string>
#include <set>
#include <list>
#include <map>
#include <vector>
using namespace std;

#include "CSymbolTable.h"
#include "Database.h"
#define YYSTYPE int
#include "StdcParser.h"
using namespace magic;

/*********************************************************************/
//global shutdown method defined in arc.cpp needed
/*********************************************************************/
__attribute__ ((noreturn)) void GlobalShutdown(int sig);

void count(const char *message);
int check_type();
void alias();
void attribute();

//counters
int asmCount;
int commentCount;
%}

%option noyywrap
%x STDC SPEC ASM COMMENT

%%
         /* set the appropriate start condition */ 
         if(CSymbolTable::fileType == CSymbolTable::STDC_FILE) BEGIN(STDC);
	 else if(CSymbolTable::fileType == CSymbolTable::SPEC_FILE) BEGIN(SPEC); 
	 else { printf("unknown file type : %d\n",CSymbolTable::fileType); GlobalShutdown(-1); }

<STDC,SPEC,COMMENT>"/*" {
  if((YY_START == STDC) || (YY_START == SPEC)) {
    BEGIN(COMMENT);
    commentCount = 1;
  } else if(YY_START == COMMENT) {
    ++commentCount;
  } else assert(false);
}
<COMMENT>"*/" {
  --commentCount;
  if(commentCount == 0) {
    BEGIN((CSymbolTable::fileType == CSymbolTable::STDC_FILE) ? STDC : SPEC);
  }
}
<COMMENT>[^/*]*                                     { /* comment body - ignore */ }

<STDC,SPEC>"//"(.*)                                 { /* CPP comment - ignore */ }
<STDC>^("#"(.*))                                    { /* line beginning with '#' - ignore */ }

<STDC>"auto"			                    { count("AUTO"); return(MAGIC_AUTO); }
<STDC>"break"			                    { count("BREAK"); return(MAGIC_BREAK); }
<STDC>"__builtin_va_list"                           { count("VOID"); return(MAGIC_VOID); }
<STDC>"case"			                    { count("CASE"); return(MAGIC_CASE); }
<STDC>"char"			                    { count("CHAR"); return(MAGIC_CHAR); }
<STDC>"const"|"__const"|"__const__"                 { count("CONST"); return(MAGIC_CONST); }
<STDC>"continue"		                    { count("CONTINUE"); return(MAGIC_CONTINUE); }
<STDC>"default"		                            { count("DEFAULT"); return(MAGIC_DEFAULT); }
<STDC>"do"			                    { count("DO"); return(MAGIC_DO); }
<STDC>"double"		                            { count("DOUBLE"); return(MAGIC_DOUBLE); }
<STDC>"else"			                    { count("ELSE"); return(MAGIC_ELSE); }
<STDC>"enum"			                    { count("ENUM"); return(MAGIC_ENUM); }
<STDC>"__extension__"                               { /* ignore */ }
<STDC>"extern"		                            { count("EXTERN"); return(MAGIC_EXTERN); }
<STDC>"float"			                    { count("FLOAT"); return(MAGIC_FLOAT); }
<STDC>"for"			                    { count("FOR"); return(MAGIC_FOR); }
<STDC>"goto"			                    { count("GOTO"); return(MAGIC_GOTO); }
<STDC>"if"			                    { count("IF"); return(MAGIC_IF); }
<STDC>"inline"|"__inline"|"__inline__"              { /* ignore */ }
<STDC>"int"			                    { count("INT"); return(MAGIC_INT); }
<STDC>"long"			                    { count("LONG"); return(MAGIC_LONG); }
<STDC>"register"		                    { count("REGISTER"); return(MAGIC_REGISTER); }
<STDC,SPEC>"return"		                    { count("RETURN"); return(MAGIC_RETURN); }
<STDC>"short"			                    { count("SHORT"); return(MAGIC_SHORT); }
<STDC>"signed"|"__signed__"	                    { count("SIGNED"); return(MAGIC_SIGNED); }
<STDC>"sizeof"		                            { count("SIZEOF"); return(MAGIC_SIZEOF); }
<STDC>"static"		                            { count("STATIC"); return(MAGIC_STATIC); }
<STDC>"struct"		                            { count("STRUCT"); return(MAGIC_STRUCT); }
<STDC>"switch"		                            { count("SWITCH"); return(MAGIC_SWITCH); }
<STDC>"typedef"		                            { count("TYPEDEF"); CSymbolTable::inTypedef = true; return(MAGIC_TYPEDEF); }
<STDC>"typeof"|"__typeof"|"__typeof__"              { count("TYPEOF"); return(MAGIC_TYPEOF); }
<STDC>"union"			                    { count("UNION"); return(MAGIC_UNION); }
<STDC>"unsigned"		                    { count("UNSIGNED"); return(MAGIC_UNSIGNED); }
<STDC>"void"			                    { count("VOID"); return(MAGIC_VOID); }
<STDC>"volatile"|"__volatile"|"__volatile__"        { count("VOLATILE"); return(MAGIC_VOLATILE); }
<STDC>"while"			                    { count("WHILE"); return(MAGIC_WHILE); }

<STDC>"__attribute__"[ \t\v\n\f]*"("[ \t\v\n\f]*"(" { attribute(); }

<STDC>"asm"|"__asm"|"__asm__"                       { count("ASM_BEGIN"); BEGIN(ASM); asmCount = 0; }
<ASM>[^;\"()]+                                      { count("ASM_BODY"); /* argument of asm directive - ignore */ }

<STDC>"#pragma"(.*)                                 { /* ignore */ }
<STDC>"__restrict"                                  { /* ignore */ }
<STDC>"internal_function"                           { /* ignore */ }
<STDC>"strong_alias"                                { alias(); }
<STDC>"weak_alias"                                  { alias(); }

<SPEC>"predicate"                                   { count("PREDICATE"); return(MAGIC_PREDICATE); }
<SPEC>"fair_loop"                                   { count("FAIR_LOOP"); return(MAGIC_FAIR_LOOP); }
<SPEC>"auxiliary"                                   { count("AUXILIARY"); return(MAGIC_AUXILIARY); }
<SPEC>"inline"                                      { count("INLINE"); return(MAGIC_INLINE); }
<SPEC>"alias"                                       { count("ALIAS"); return(MAGIC_ALIAS); }
<SPEC>"abstract"                                    { count("ABSTRACT"); return(MAGIC_ABSTRACT); }
<SPEC>".."                                          { count("DOT_DOT"); return(MAGIC_DOT_DOT); }
<SPEC>"range"                                       { count("RANGE"); return(MAGIC_RANGE); }
<SPEC>"set"                                         { count("SET"); return(MAGIC_SET); }
<SPEC>"STOP"                                        { count("STOP"); return(MAGIC_STOP); }
<SPEC>"when"                                        { count("WHEN"); return(MAGIC_WHEN); }
<SPEC>"property"                                    { count("PROPERTY"); return(MAGIC_PROPERTY); }
<SPEC>"cprog"                                       { count("CPROG"); return(MAGIC_CPROG); }
<SPEC>"cproc"                                       { count("CPROC"); return(MAGIC_CPROC); }
<SPEC>"context"                                     { count("CONTEXT"); return(MAGIC_CONTEXT); }
<SPEC>"X"                                           { count("NEXT_TIME"); return(MAGIC_NEXT_TIME); }
<SPEC>"G"                                           { count("GLOBALLY"); return(MAGIC_GLOBALLY); }
<SPEC>"F"                                           { count("FUTURE"); return(MAGIC_FUTURE); }
<SPEC>"U"                                           { count("UNTIL"); return(MAGIC_UNTIL); }
<SPEC>"R"                                           { count("RELEASE"); return(MAGIC_RELEASE); }
<SPEC>"<A>"                                         { count("ALL_PATHS"); return(MAGIC_ALL_PATHS); }

<STDC>{L}({L}|{D})*     		{ count("ID_OR_TYPE_NAME"); CSymbolTable::buffer = Stdctext; return(check_type()); }
<SPEC>[$]{D}+                           { count("DUMMY_VAR"); CSymbolTable::buffer = Stdctext; return(MAGIC_DUMMY_VAR); }
<SPEC>[$]({L}|{D})*     		{ count("IDENTIFIER"); CSymbolTable::buffer = Stdctext; return(MAGIC_IDENTIFIER); }
<SPEC>"OP::"({L}|{D})+                  { count("OMEGA_OP_NAME"); CSymbolTable::buffer = Stdctext; return(MAGIC_OMEGA_OP_NAME); }
<SPEC>"AW::"({L}|{D})+                  { count("SEAW_NAME"); CSymbolTable::buffer = Stdctext; return(MAGIC_SEAW_NAME); }
<SPEC>({L}({L}|{D})+(#({D}+))?::)*{UL}({L}|{D})*     { count("UPPER_ID"); CSymbolTable::buffer = Stdctext; return(MAGIC_UPPER_ID); }
<SPEC>({L}({L}|{D})+(#({D}+))?::)*{LL}({L}|{D})*     { count("LOWER_ID"); CSymbolTable::buffer = Stdctext; return(MAGIC_LOWER_ID); }


<STDC,SPEC>0[xX]{H}+{IS}?		{ count("INT_CONSTANT"); CSymbolTable::longbuf = strtol(Stdctext,NULL,0); return(MAGIC_INT_CONSTANT); }
<STDC,SPEC>0{D}+{IS}?		        { count("INT_CONSTANT"); CSymbolTable::longbuf = strtol(Stdctext,NULL,0); return(MAGIC_INT_CONSTANT); }
<STDC,SPEC>{D}+{IS}?	        	{ count("INT_CONSTANT"); CSymbolTable::longbuf = strtol(Stdctext,NULL,0); return(MAGIC_INT_CONSTANT); }
<STDC,SPEC>L?'(\\.|[^\\'])+' 	        { count("CONSTANT"); CSymbolTable::buffer = Stdctext; return(MAGIC_CONSTANT); }

<STDC,SPEC>{D}+{E}{FS}?		        { count("CONSTANT"); CSymbolTable::buffer = Stdctext; return(MAGIC_CONSTANT); }
<STDC,SPEC>{D}*"."{D}+({E})?{FS}?	{ count("CONSTANT"); CSymbolTable::buffer = Stdctext; return(MAGIC_CONSTANT); }
<STDC,SPEC>{D}+"."{D}*({E})?{FS}?	{ count("CONSTANT"); CSymbolTable::buffer = Stdctext; return(MAGIC_CONSTANT); }

<STDC,SPEC,ASM>L?\"(\\.|[^\\"])*\"   { 
                                       count("STRING"); 
                                       if((YY_START == STDC) || (YY_START == SPEC)) {
                                         CSymbolTable::buffer = Stdctext; 
                                         return(MAGIC_STRING_LITERAL);
                                       } else if(YY_START == ASM) {}
                                       else assert(false);
                                     }

<STDC>"..."			{ count("ELLIPSIS"); return(MAGIC_ELLIPSIS); }
<STDC>">>="			{ count("RIGHT_ASSIGN"); return(MAGIC_RIGHT_ASSIGN); }
<STDC>"<<="			{ count("LEFT_ASSIGN"); return(MAGIC_LEFT_ASSIGN); }
<STDC>"+="			{ count("ADD_ASSIGN"); return(MAGIC_ADD_ASSIGN); }
<STDC>"-="			{ count("SUB_ASSIGN"); return(MAGIC_SUB_ASSIGN); }
<STDC>"*="			{ count("MUL_ASSIGN"); return(MAGIC_MUL_ASSIGN); }
<STDC>"/="			{ count("DIV_ASSIGN"); return(MAGIC_DIV_ASSIGN); }
<STDC>"%="			{ count("MOD_ASSIGN"); return(MAGIC_MOD_ASSIGN); }
<STDC>"&="			{ count("AND_ASSIGN"); return(MAGIC_AND_ASSIGN); }
<STDC>"^="			{ count("XOR_ASSIGN"); return(MAGIC_XOR_ASSIGN); }
<STDC>"|="			{ count("OR_ASSIGN"); return(MAGIC_OR_ASSIGN); }
<STDC,SPEC>">>"			{ count("RIGHT_OP"); return(MAGIC_RIGHT_OP); }
<STDC,SPEC>"<<"			{ count("LEFT_OP"); return(MAGIC_LEFT_OP); }
<STDC>"++"			{ count("INC_OP"); return(MAGIC_INC_OP); }
<STDC>"--"			{ count("DEC_OP"); return(MAGIC_DEC_OP); }
<STDC,SPEC>"->"			{ count("PTR_OP"); return(MAGIC_PTR_OP); }
<STDC,SPEC>"&&"			{ count("AND_OP"); return(MAGIC_AND_OP); }
<STDC,SPEC>"||"			{ count("OR_OP"); return(MAGIC_OR_OP); }
<STDC,SPEC>"<="			{ count("LE_OP"); return(MAGIC_LE_OP); }
<STDC,SPEC>">="			{ count("GE_OP"); return(MAGIC_GE_OP); }
<STDC,SPEC>"=="			{ count("EQ_OP"); return(MAGIC_EQ_OP); }
<STDC,SPEC>"!="			{ count("NE_OP"); return(MAGIC_NE_OP); }
<SPEC>"=>"                      { count("IMPLIES"); return(MAGIC_IMPLIES); }
<STDC,SPEC,ASM>";"	        {
                                  count(";"); 
                                  if((YY_START == STDC) || (YY_START == SPEC)) return(';');
                                  else if(YY_START == ASM) {
                                    if(asmCount == 0) { 
                                      BEGIN((CSymbolTable::fileType == CSymbolTable::STDC_FILE) ? STDC : SPEC); 
                                      return(';'); 
                                    } 
                                  } else assert(false);
                                }
<STDC,SPEC>("{"|"<%")	        { count("{"); CSymbolTable::PushScope(); return('{'); }
<STDC,SPEC>("}"|"%>")	        { count("}"); CSymbolTable::PopScope(); return('}'); }
<STDC,SPEC>","		        { count(","); return(','); }
<STDC,SPEC>":"		        { count(":"); return(':'); }
<STDC,SPEC>"="		        { count("="); return('='); }
<STDC,SPEC,ASM>"("              {
                                  count("("); 
			          if((YY_START == STDC) || (YY_START == SPEC)) return('(');
			          else if(YY_START == ASM) ++asmCount;
			          else assert(false);
			        } 
<STDC,SPEC,ASM>")"              { 
                                  count(")"); 
			          if((YY_START == STDC) || (YY_START == SPEC)) return(')');
			          else if(YY_START == ASM) --asmCount; 
			          else assert(false);
			        }
<STDC,SPEC>("["|"<:")	        { count("["); return('['); }
<STDC,SPEC>("]"|":>")	        { count("]"); return(']'); }
<STDC,SPEC>"."	        	{ count("."); return('.'); }
<STDC,SPEC>"&"		        { count("&"); return('&'); }
<STDC,SPEC>"!"		        { count("!"); return('!'); }
<STDC,SPEC>"~"		        { count("~"); return('~'); }
<STDC,SPEC>"-"			{ count("-"); return('-'); }
<STDC,SPEC>"+"		        { count("+"); return('+'); }
<STDC,SPEC,COMMENT>"*"          { count("*"); if((YY_START == STDC) || (YY_START == SPEC)) { return('*'); } }
<STDC,SPEC,COMMENT>"/"       	{ count("/"); if((YY_START == STDC) || (YY_START == SPEC)) { return('/'); } }
<STDC,SPEC>"%"		        { count("%"); return('%'); }
<STDC,SPEC>"<"		        { count("<"); return('<'); }
<STDC,SPEC>">"		        { count(">"); return('>'); }
<STDC,SPEC>"^"			{ count("^"); return('^'); }
<STDC,SPEC>"|"		        { count("|"); return('|'); }
<STDC,SPEC>"?"			{ count("?"); return('?'); }
<SPEC>"!!"			{ count("BANG_BANG"); return(MAGIC_BANG_BANG); }

<STDC,SPEC>[ \t\v\n\f\r]	{ count("WHITE_SPACE"); }
<*>.    			{ printf("unknown character ...\n"); GlobalShutdown(-1); }
%%

void alias()
{
  char c;
  while ((c = yyinput()) != ')' && c != 0);
}

void attribute()
{
  char c;
  int count = 2;
  while(true) {
    c = yyinput();
    if(c == 0) break;
    if(c == '(') ++count;
    if(c == ')') {
      --count;
      if(count == 0) break;
    }
  }
}

int lineNum = 1,column = 0;

void count(const char *message)
{
  int i;  
  for(i = 0; Stdctext[i] != '\0'; ++i)
    if(Stdctext[i] == '\n') {
      ++lineNum;
      column = 0;
    } else if(Stdctext[i] == '\t') column += 8 - (column % 8);
    else ++column;
  if(Database::PARSE_ECHO) ECHO;
}

int check_type()
{
  if(CSymbolTable::NameInScope(Stdctext)) {
    return MAGIC_TYPE_NAME;
  } else {
    return MAGIC_IDENTIFIER;
  } 
}

//to prevent the warning message that yyunput() is unused
void StdcDummy() { yyunput(0,NULL); }

/*********************************************************************/
//end of StdcLexer.cpp
/*********************************************************************/

